/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.export.WorldLineToShapeFile;
import hec.export.WorldPointToShapefile;
import hec.export.WorldRegionToShapefile;
import hec.io.Identifier;
import hec.lang.UserId;
import hec.map.WorldLineHolder;
import hec.map.WorldPointHolder;
import hec.map.WorldRegionHolder;
import hec.map.crs.CoordinateReferenceSystem;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.CommonDataList;
import hec.watershed.client.WatershedConfigMode;
import hec.watershed.model.ChannelMod;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ComputationPointDataList;
import hec.watershed.model.Condition;
import hec.watershed.model.Diversion;
import hec.watershed.model.ImpactArea;
import hec.watershed.model.Levee;
import hec.watershed.model.OtherProject;
import hec.watershed.model.Reservoir;
import hec.watershed.model.StoragePool;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import mil.army.usace.hec.rmi.client.RmiFileChooserField;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.list.RmaListModel;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;

public class ExportStudyProjectsDialog
extends RmaJDialog {
    static String[] projectTypes = new String[]{"Computation Points", "Diversions", "Reserviors - Pool", "Reservoirs - Reach", "Channel Modifications", "Levees", "Off Channel Storage", "Other Projects", "Impact Areas"};
    private RmaJTable _exportTable;
    private ButtonCmdPanel _cmdPanel;
    private RmaJComboBox<Condition> _conditionCombo;

    public ExportStudyProjectsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
        this.addListeners();
        this.setSizeAndLocation();
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        String title = "Export Configuration Elements";
        this.setTitle(title);
        JLabel label = new JLabel("Configuraton:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._conditionCombo = new RmaJComboBox();
        label.setLabelFor((Component)this._conditionCombo);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._conditionCombo, gbc);
        Object[] headers = new String[]{"Export", "Sublayer", "Export To Shapefile"};
        this._exportTable = new RmaJTable((Component)((Object)this), headers){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 150;
                return d;
            }

            public void setValueAt(Object value, int row, int col) {
                super.setValueAt(value, row, col);
                if (col == 0) {
                    this.repaint();
                }
                if (col == 2) {
                    if (value != null && value.toString().length() > 0) {
                        this.setValueAt(Boolean.TRUE, row, 0);
                    } else {
                        this.setValueAt(Boolean.FALSE, row, 0);
                    }
                }
            }

            public boolean isCellEditable(int row, int col) {
                if (ExportStudyProjectsDialog.this._conditionCombo.getSelectedItem() == null) {
                    return false;
                }
                switch (col) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return false;
                    }
                    case 2: {
                        Object val = this.getValueAt(row, 0);
                        return Boolean.parseBoolean(val.toString());
                    }
                }
                return false;
            }
        };
        this._exportTable.setCheckBoxCellEditor(0);
        this._exportTable.setColumnEnabled(false, 1);
        this._exportTable.setColumnWidths(new int[]{60, 135, 255});
        this._exportTable.setRowHeight(this._exportTable.getRowHeight() + 5);
        RMAFilenameFilter filter = new RMAFilenameFilter("shp", "Shape Files");
        this.setFileChooserEditor(this._exportTable, 2, filter);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._exportTable.getScrollPane(), gbc);
        this._cmdPanel = new ButtonCmdPanel(12);
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._cmdPanel, gbc);
        this.initializeDialog();
    }

    private void initializeDialog() {
        this._exportTable.deleteCells();
        for (int i = 0; i < projectTypes.length; ++i) {
            Vector<Object> row = new Vector<Object>(3);
            row.add(Boolean.FALSE);
            row.add(projectTypes[i]);
            row.add("");
            this._exportTable.appendRow(row);
        }
        ClientWorkspace wksp = ClientApp.Workspace();
        CommonDataList dlList = wksp.getCommonDataList(Condition.class.getName(), "");
        Object[] conditions = dlList.getObjectArray();
        RmaListModel newModel = new RmaListModel(true, conditions);
        this._conditionCombo.setModel((ComboBoxModel)newModel);
        if (newModel.getSize() == 1) {
            this._conditionCombo.setSelectedIndex(0);
        }
    }

    protected void addListeners() {
        this._conditionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportStudyProjectsDialog.this._exportTable.repaint();
            }
        });
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        if (!ExportStudyProjectsDialog.this.exportData()) break;
                        ExportStudyProjectsDialog.this.setVisible(false);
                        break;
                    }
                    case 4: {
                        ExportStudyProjectsDialog.this.setVisible(false);
                    }
                }
            }
        });
    }

    protected boolean exportData() {
        String path;
        Object obj;
        int r;
        if (this._conditionCombo.getSelectedIndex() == -1) {
            String msg = "Please Select a Configuration";
            String title = "No Configuration Selected";
            JOptionPane.showMessageDialog((Component)((Object)this), msg, title, 0);
            return false;
        }
        this._exportTable.commitEdit(true);
        int rowCnt = this._exportTable.getRowCount();
        boolean exported = true;
        RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        int cnt = 0;
        int total = 0;
        StringBuilder builder = new StringBuilder("<html>Please select a file for:");
        boolean hasMissingFile = false;
        for (r = 0; r < rowCnt; ++r) {
            obj = this._exportTable.getValueAt(r, 0);
            if (!Boolean.parseBoolean(obj.toString()) || (path = (String)this._exportTable.getValueAt(r, 2)) != null && path.length() != 0) continue;
            builder.append("<br>");
            builder.append(this._exportTable.getValueAt(r, 1));
            hasMissingFile = true;
        }
        if (hasMissingFile) {
            String title = "Missing File";
            JOptionPane.showMessageDialog((Component)((Object)this), builder.toString(), title, 0);
            return false;
        }
        for (r = 0; r < rowCnt; ++r) {
            block10: {
                obj = this._exportTable.getValueAt(r, 0);
                if (!Boolean.parseBoolean(obj.toString())) continue;
                path = (String)this._exportTable.getValueAt(r, 2);
                ++total;
                try {
                    if (!fm.isDirectory(path)) break block10;
                    path = RMAIO.concatPath((String)path, (String)RMAIO.userNameToFileName((String)((String)this._exportTable.getValueAt(r, 1))));
                }
                catch (RemoteException e) {
                    continue;
                }
            }
            if (!path.endsWith(".shp")) {
                path = path.concat(".shp");
            }
            if (!this.exportData(r, path)) {
                exported = false;
                continue;
            }
            ++cnt;
        }
        if (total == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No Configuration Elements were selected to export", "Export Results", 1);
            return false;
        }
        JOptionPane.showMessageDialog((Component)((Object)this), "Successfully exported " + cnt + " out of " + total + " Configuration Elements.", "Export Results", 1);
        if (!exported) {
            // empty if block
        }
        return exported;
    }

    private boolean exportData(int r, String path) {
        Condition cond = (Condition)this._conditionCombo.getSelectedItem();
        if (cond == null) {
            return false;
        }
        Vector projectsToExport = null;
        boolean resReaches = false;
        ClientWorkspace wksp = ClientApp.Workspace();
        switch (r) {
            case 0: {
                if (wksp == null) break;
                ComputationPointDataList compPtDl = (ComputationPointDataList)wksp.getCommonDataList(ComputationPoint.class.getName(), "");
                return this.saveWorldPoints(compPtDl, path, null);
            }
            case 1: {
                projectsToExport = cond.getProjects(Diversion.class.getName());
                break;
            }
            case 2: {
                projectsToExport = cond.getProjects(Reservoir.class.getName());
                resReaches = false;
                break;
            }
            case 3: {
                projectsToExport = cond.getProjects(Reservoir.class.getName());
                resReaches = true;
                break;
            }
            case 4: {
                projectsToExport = cond.getProjects(ChannelMod.class.getName());
                break;
            }
            case 5: {
                projectsToExport = cond.getProjects(Levee.class.getName());
                break;
            }
            case 6: {
                projectsToExport = cond.getProjects(StoragePool.class.getName());
                break;
            }
            case 7: {
                projectsToExport = cond.getProjects(OtherProject.class.getName());
                break;
            }
            case 8: {
                projectsToExport = cond.getProjects(ImpactArea.class.getName());
            }
        }
        if (r > 0 && (projectsToExport == null || projectsToExport.size() == 0)) {
            String msg = "The Configuration " + cond.getName() + " has no " + this._exportTable.getValueAt(r, 1) + " selected for it.";
            String title = "Nothing to Export";
            JOptionPane.showMessageDialog((Component)((Object)this), msg, title, 1);
            return false;
        }
        return this.exportProjects(projectsToExport, path, resReaches);
    }

    private boolean exportProjects(List projectsToExport, String path, boolean lines) {
        Object obj;
        if (projectsToExport == null) {
            return false;
        }
        Identifier id = new Identifier(path);
        Identifier id2 = null;
        RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        try {
            id2 = fm.openFile(UserId.getUserId(), id);
            if (id2 == null) {
                id2 = fm.newFile(UserId.getUserId(), id);
            }
        }
        catch (RemoteException re) {
            System.out.println("exportProjects:error opening file " + path + " exception:" + re);
            return false;
        }
        Condition cond = (Condition)this._conditionCombo.getSelectedItem();
        StreamAlignmentIfc align = cond.getStreamAlignment();
        if (align == null) {
            align = this.getStreamAlignment();
        }
        for (int i = 0; i < projectsToExport.size(); ++i) {
            obj = projectsToExport.get(i);
            if (!(obj instanceof Reservoir)) continue;
            Reservoir res = (Reservoir)obj;
            res.setStreamAlignment(align);
        }
        obj = projectsToExport.get(0);
        CoordinateReferenceSystem crs = null;
        if (obj instanceof WorldRegionHolder && !lines) {
            WorldRegionToShapefile exporter = new WorldRegionToShapefile();
            return WorldRegionToShapefile.exportToShapefile((Component)((Object)this), (List)projectsToExport, (Identifier)id, crs);
        }
        if (obj instanceof WorldLineHolder) {
            WorldLineToShapeFile exporter = new WorldLineToShapeFile();
            return WorldLineToShapeFile.exportToShapefile((Component)((Object)this), (List)projectsToExport, (Identifier)id, crs);
        }
        return false;
    }

    private StreamAlignmentIfc getStreamAlignment() {
        WatershedConfigMode wcMode = (WatershedConfigMode)ClientApp.frame().getModeByClass(WatershedConfigMode.class);
        return wcMode.getAlignment();
    }

    private boolean saveWorldPoints(ComputationPointDataList ccpDl, String path, CoordinateReferenceSystem crs) {
        WorldPointToShapefile exporter = new WorldPointToShapefile();
        Identifier id = new Identifier(path);
        RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        Identifier id2 = null;
        try {
            id2 = fm.openFile(UserId.getUserId(), id);
            if (id2 == null) {
                id2 = fm.newFile(UserId.getUserId(), id);
            }
        }
        catch (RemoteException re) {
            System.out.println("saveWorldPoints:error opening file " + path + " Exception:" + re);
            return false;
        }
        return exporter.exportToShapefile((Component)((Object)this), (WorldPointHolder)ccpDl, id2, crs);
    }

    protected void setSizeAndLocation() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public RmiFileChooserField setFileChooserEditor(RmaJTable table, int col, RMAFilenameFilter filter) {
        TableColumnModel tcm = table.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = table.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        RmiFileChooserField df = new RmiFileChooserField(){

            public String getChooserTitle() {
                int row = ExportStudyProjectsDialog.this._exportTable.getSelectedRow();
                if (row == -1) {
                    return null;
                }
                String projType = (String)ExportStudyProjectsDialog.this._exportTable.getValueAt(row, 1);
                return "Export " + projType + " to";
            }
        };
        df.setSaving();
        Vector<RMAFilenameFilter> v = new Vector<RMAFilenameFilter>(1);
        v.add(filter);
        df.setFilters(v);
        df.addMouseListener((MouseListener)table);
        RmaCellEditor dcf = new RmaCellEditor((JTextField)df);
        dcf.setClickCountToStart(table.getClickCountToStart());
        tc.setCellEditor((TableCellEditor)dcf);
        if (table.getModel() instanceof RmaTableModelInterface) {
            ((RmaTableModelInterface)table.getModel()).setColumnClass(col, Number.class);
        }
        table.setHorizontalAlignment(2, col);
        return df;
    }

    public void fillForm(Condition condition) {
        this._conditionCombo.setSelectedItem((Object)condition);
    }
}

