/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.map.MapLabelItem;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.StreamElement;
import hec.watershed.model.Project;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.EditableComponent;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJTextField;
import rma.swing.text.IntegerDocument;

public class GenericProjectPanel
extends AbstractEditorPanel
implements EditableComponent {
    private RmaJDecimalField eastingTxt;
    private RmaJDecimalField northingTxt;
    private RmaJIntegerField yearInServiceTxt;
    private RmaJTextField streamTxt;
    private RmaJComboBox labelPosition;
    private RmaJCheckBox existingProject;
    private RmaJCheckBox isCorpsProject;
    protected Project _project;
    private boolean _streamListEnabled = true;

    public GenericProjectPanel() {
        this.buildControls();
    }

    protected void buildControls() {
        this.setLayout(new GridBagLayout());
        JPanel panel1 = new JPanel(new GridBagLayout());
        JPanel panel2 = new JPanel(new GridBagLayout());
        JPanel panel3 = new JPanel(new GridBagLayout());
        this.add(panel1, new GridBagConstraints(0, 0, 2, 2, 0.0, 1.0, 18, 3, RmaInsets.INSETS0000, 0, 0));
        this.add(panel2, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS0000, 0, 0));
        this.add(panel3, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 18, 2, RmaInsets.INSETS0000, 0, 0));
        this.existingProject = new RmaJCheckBox("Existing Project");
        this.existingProject.setMnemonic('e');
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        panel2.add((Component)this.existingProject, gbc);
        this.existingProject.setMargin(RmaInsets.INSETS0000);
        this.isCorpsProject = new RmaJCheckBox("Corps Project");
        this.isCorpsProject.setMnemonic('c');
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        panel2.add((Component)this.isCorpsProject, gbc);
        this.isCorpsProject.setMargin(RmaInsets.INSETS0000);
        JLabel label = new JLabel("Stream Name:", 4);
        label.setDisplayedMnemonic('s');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        panel1.add((Component)label, gbc);
        this.streamTxt = new RmaJTextField();
        label.setLabelFor((Component)this.streamTxt);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.ipadx = 40;
        panel1.add((Component)this.streamTxt, gbc);
        label = new JLabel("Label Position:", 4);
        label.setDisplayedMnemonic('l');
        panel1.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, RmaInsets.INSETS5550, 0, 0));
        this.labelPosition = new RmaJComboBox((Object[])MapLabelItem.POSITION_STRINGS);
        this.labelPosition.setModifiable(true);
        panel1.add((Component)this.labelPosition, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 18, 0, RmaInsets.INSETS5555, 0, 0));
        label = new JLabel("Year in Service:", 4);
        label.setDisplayedMnemonic('y');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)0);
        panel3.add((Component)label, gbc);
        this.yearInServiceTxt = new RmaJIntegerField(0, 5);
        ((IntegerDocument)this.yearInServiceTxt.getDocument()).setLength(4);
        label.setLabelFor((Component)this.yearInServiceTxt);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.ipadx = 75;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        panel3.add((Component)this.yearInServiceTxt, gbc);
    }

    public boolean savePanel() {
        return this.savePanel((NamedType)this._project);
    }

    public boolean savePanel(NamedType dobj) {
        Project project = null;
        if (dobj == null) {
            project = this._project;
        } else if (dobj instanceof Project) {
            project = (Project)dobj;
        }
        if (project == null) {
            return true;
        }
        project.setLabelPosition(this.labelPosition.getSelectedIndex());
        project.setIsExisting(this.existingProject.isSelected());
        project.setIsCorpsProject(this.isCorpsProject.isSelected());
        project.setYearInService((short)this.yearInServiceTxt.getValue());
        Project fproject = project;
        EventQueue.invokeLater(() -> ((Project)fproject).save());
        return true;
    }

    public void setStreamAlignment(StreamAlignmentIfc alignment) {
        super.setStreamAlignment(alignment);
        if (this._alignment != null) {
            // empty if block
        }
    }

    public void fillPanel(NamedType dobj) {
        if (dobj instanceof Project) {
            this.fillPanel((Project)dobj);
        }
    }

    public void fillPanel(Project proj) {
        this._project = proj;
        if (proj == null) {
            return;
        }
        this.yearInServiceTxt.setValue((int)this._project.getYearInService());
        this.labelPosition.setSelectedIndex(this._project.getLabelPosition());
        if (this._alignment != null) {
            StreamElement elem = this._alignment.findReach(this._project.getStreamId());
            if (elem != null) {
                this.streamTxt.setText(elem.getName());
            } else {
                this.streamTxt.setText("");
            }
        } else {
            this.streamTxt.setText("");
        }
        this.existingProject.setSelected(this._project.isExisting());
        this.isCorpsProject.setSelected(this._project.isCorpsProject());
    }

    public String getTabname() {
        return "Project";
    }

    public void setStreamListEnabled(boolean b) {
        this.streamTxt.setEditable(b);
        this._streamListEnabled = b;
    }

    public void setIsEditable(boolean b) {
        this.setComponentsEditable(this.getComponents(), b);
        this.streamTxt.setEditable(this._streamListEnabled);
    }

    public void setComponentsEditable(Component[] comps, boolean editable) {
        if (comps == null) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            Component c = comps[i];
            if (c instanceof EditableComponent) {
                ((EditableComponent)c).setIsEditable(editable);
                continue;
            }
            if (!(c instanceof Container)) continue;
            this.setComponentsEditable(((Container)c).getComponents(), editable);
        }
    }
}

