/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.appInterface.AppDaddy;
import hec.map.LayerSymbol;
import hec.map.appInterface.MapApplicationFrame;
import hec.watershed.client.StudyChannelModDPData;
import hec.watershed.client.StudyCompPtDPData;
import hec.watershed.client.StudyDiversionDPData;
import hec.watershed.client.StudyLeveeDPData;
import hec.watershed.client.StudyReservoirDPData;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import rma.swing.RmaImage;

public class HecLayerSymbol
extends LayerSymbol {
    public static final int RES_JUNCTION_SYMBOL = 3;
    public static final int RES_REACH_SYMBOL = 4;
    public static final int RES_RESERVOIR_SYMBOL = 5;
    public static final int RES_DIVERSION_SYMBOL = 6;
    public static final int IMPACT_AREA_SYMBOL = 7;
    public static final int RAS_STREAM_STATION_SYMBOL = 8;
    public static final int RAS_STRUCTURE_SYMBOL = 9;
    public static final int RAS_CROSS_SECTION_SYMBOL = 10;
    public static final int RAS_REACH_SYMBOL = 11;
    public static final int STUDY_RESERVOIR_SYMBOL = 12;
    public static final int STUDY_DIVERSION_SYMBOL = 13;
    public static final int STUDY_CHANNEL_MOD_SYMBOL = 14;
    public static final int STUDY_LEVEE_SYMBOL = 15;
    public static final int STUDY_OTHER_PROJ_SYMBOL = 16;
    public static final int STUDY_IMPACTAREA_SYMBOL = 17;
    public static final int STUDY_COMP_PT_SYMBOL = 18;
    public static final int STUDY_STORAGE_SYMBOL = 19;
    public static final int RAS_STORAGE_AREA_SYMBOL = 20;
    static StudyReservoirDPData _studyResDPData = StudyReservoirDPData.getData();
    static StudyDiversionDPData _studyDiversionData = StudyDiversionDPData.getData();
    static StudyLeveeDPData _studyLeveeData = StudyLeveeDPData.getData();
    static StudyChannelModDPData _studyChannelModData = StudyChannelModDPData.getData();
    static StudyCompPtDPData _studyCompPtData = StudyCompPtDPData.getData();
    private static HecLayerSymbol _hecSymbol = new HecLayerSymbol();

    private HecLayerSymbol() {
    }

    public static void init() {
    }

    static {
        HecLayerSymbol.addLayerSymbol((int)7, (LayerSymbol.LayerSymbolShape)new ImpactAreaSymbol());
        HecLayerSymbol.addLayerSymbol((int)8, (LayerSymbol.LayerSymbolShape)new RasStreamStationSymbol());
        HecLayerSymbol.addLayerSymbol((int)9, (LayerSymbol.LayerSymbolShape)new RasStructureSymbol());
        HecLayerSymbol.addLayerSymbol((int)10, (LayerSymbol.LayerSymbolShape)new RasCrossSectionSymbol());
        HecLayerSymbol.addLayerSymbol((int)11, (LayerSymbol.LayerSymbolShape)new RasReachSymbol());
        HecLayerSymbol.addLayerSymbol((int)12, (LayerSymbol.LayerSymbolShape)new StudyReservoirSymbol());
        HecLayerSymbol.addLayerSymbol((int)13, (LayerSymbol.LayerSymbolShape)new StudyDiversionSymbol());
        HecLayerSymbol.addLayerSymbol((int)14, (LayerSymbol.LayerSymbolShape)new StudyChannelModSymbol());
        HecLayerSymbol.addLayerSymbol((int)15, (LayerSymbol.LayerSymbolShape)new StudyLeveeSymbol());
        HecLayerSymbol.addLayerSymbol((int)16, (LayerSymbol.LayerSymbolShape)new StudyOtherProjSymbol());
        HecLayerSymbol.addLayerSymbol((int)17, (LayerSymbol.LayerSymbolShape)new StudyImpactAreaSymbol());
        HecLayerSymbol.addLayerSymbol((int)18, (LayerSymbol.LayerSymbolShape)new StudyCompPtSymbol());
        HecLayerSymbol.addLayerSymbol((int)19, (LayerSymbol.LayerSymbolShape)new StudyStorageSymbol());
        HecLayerSymbol.addLayerSymbol((int)20, (LayerSymbol.LayerSymbolShape)new RasStorageAreaSymbol());
    }

    protected static class ImpactAreaSymbol
    extends LayerSymbol.Triangle1Symbol {
        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            super.draw(g, x, y, size, Color.red, Color.green);
        }
    }

    static class RasStreamStationSymbol
    extends LayerSymbol.LayerSymbolShape {
        RasStreamStationSymbol() {
        }

        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            Font f = g.getFont();
            g.setFont(new Font("SansSerif", 0, 10));
            g.setColor(Color.black);
            g.drawString("1.0", 0, 10);
            g.setFont(f);
        }
    }

    static class RasStructureSymbol
    extends LayerSymbol.LayerSymbolShape {
        RasStructureSymbol() {
        }

        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            g.setColor(Color.lightGray);
            g.fillRect(0, 0, 10, 20);
            g.setColor(Color.black);
            g.drawRect(0, 0, 10, 20);
        }
    }

    static class RasCrossSectionSymbol
    extends LayerSymbol.LayerSymbolShape {
        RasCrossSectionSymbol() {
        }

        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            RasCrossSectionSymbol.xcoord[0] = x + 0;
            RasCrossSectionSymbol.ycoord[0] = y + 0;
            RasCrossSectionSymbol.xcoord[1] = x + 20;
            RasCrossSectionSymbol.ycoord[1] = y + 0;
            RasCrossSectionSymbol.xcoord[2] = x + 20;
            RasCrossSectionSymbol.ycoord[2] = y + 2;
            RasCrossSectionSymbol.xcoord[3] = x + 0;
            RasCrossSectionSymbol.ycoord[3] = y + 2;
            g.setColor(Color.green.darker());
            g.fillPolygon(xcoord, ycoord, 4);
        }
    }

    static class RasReachSymbol
    extends LayerSymbol.LayerSymbolShape {
        RasReachSymbol() {
        }

        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            RasReachSymbol.xcoord[0] = x + 0;
            RasReachSymbol.ycoord[0] = y + 0;
            RasReachSymbol.xcoord[1] = x + 20;
            RasReachSymbol.ycoord[1] = y + 0;
            RasReachSymbol.xcoord[2] = x + 20;
            RasReachSymbol.ycoord[2] = y + 4;
            RasReachSymbol.xcoord[3] = x + 0;
            RasReachSymbol.ycoord[3] = y + 4;
            g.setColor(Color.blue.darker());
            g.fillPolygon(xcoord, ycoord, 4);
        }
    }

    static class StudyReservoirSymbol
    extends LayerSymbol.Triangle1Symbol {
        StudyReservoirSymbol() {
        }

        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            System.out.println("StudyReservoirSymbol.draw:x=" + x + " y=" + y);
            super.draw(g, x, y, size, HecLayerSymbol._studyResDPData.triangleOutlineColor, HecLayerSymbol._studyResDPData.triangleFillColor);
        }
    }

    static class StudyDiversionSymbol
    extends LayerSymbol.DiversionSymbol {
        StudyDiversionSymbol() {
        }

        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            super.draw(g, x, y, size, HecLayerSymbol._studyDiversionData.fillColor, HecLayerSymbol._studyDiversionData.fillColor);
        }
    }

    static class StudyChannelModSymbol
    extends LayerSymbol.LayerSymbolShape {
        StudyChannelModSymbol() {
        }

        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            StudyChannelModSymbol.xcoord[0] = x + 0;
            StudyChannelModSymbol.ycoord[0] = y + 0;
            StudyChannelModSymbol.xcoord[1] = x + 20;
            StudyChannelModSymbol.ycoord[1] = y + 0;
            StudyChannelModSymbol.xcoord[2] = x + 20;
            StudyChannelModSymbol.ycoord[2] = y + 5;
            StudyChannelModSymbol.xcoord[3] = x + 0;
            StudyChannelModSymbol.ycoord[3] = y + 5;
            g.setColor(HecLayerSymbol._studyChannelModData.fillColor);
            g.fillPolygon(xcoord, ycoord, 4);
            g.setColor(HecLayerSymbol._studyChannelModData.fillColor);
            g.drawPolygon(xcoord, ycoord, 4);
        }
    }

    static class StudyLeveeSymbol
    extends LayerSymbol.LayerSymbolShape {
        StudyLeveeSymbol() {
        }

        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            StudyLeveeSymbol.xcoord[0] = x + 0;
            StudyLeveeSymbol.ycoord[0] = y + 0;
            StudyLeveeSymbol.xcoord[1] = x + 20;
            StudyLeveeSymbol.ycoord[1] = y + 0;
            StudyLeveeSymbol.xcoord[2] = x + 20;
            StudyLeveeSymbol.ycoord[2] = y + 5;
            StudyLeveeSymbol.xcoord[3] = x + 0;
            StudyLeveeSymbol.ycoord[3] = y + 5;
            g.setColor(HecLayerSymbol._studyLeveeData.fillColor);
            g.fillPolygon(xcoord, ycoord, 4);
        }
    }

    static class StudyOtherProjSymbol
    extends LayerSymbol.LayerSymbolShape {
        final Image _otherProjImage = RmaImage.loadURLImage((String)"Images/OtherProjUp.gif");

        StudyOtherProjSymbol() {
        }

        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            if (this._otherProjImage == null) {
                return;
            }
            MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
            g.drawImage(this._otherProjImage, 0, 0, (ImageObserver)frame.getMapPanel());
        }
    }

    static class StudyImpactAreaSymbol
    extends LayerSymbol.Triangle1Symbol {
        StudyImpactAreaSymbol() {
        }

        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            super.draw(g, x, y, size, Color.red, Color.green);
        }
    }

    static class StudyCompPtSymbol
    extends LayerSymbol.LayerSymbolShape {
        StudyCompPtSymbol() {
        }

        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            int width = HecLayerSymbol._studyCompPtData.compPtWidth;
            int halfwidth = (int)((double)width / 2.0);
            g.setColor(HecLayerSymbol._studyCompPtData.fillColor);
            g.fillOval(x - halfwidth, y - halfwidth, width, width);
        }
    }

    static class StudyStorageSymbol
    extends LayerSymbol.Triangle1Symbol {
        StudyStorageSymbol() {
        }

        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            System.out.println("StudyStorageSymbol.draw:x=" + x + " y=" + y);
            super.draw(g, x, y, size, Color.black, Color.blue);
        }
    }

    static class RasStorageAreaSymbol
    extends LayerSymbol.Triangle1Symbol {
        Color blue = new Color(0, 174, 206);

        RasStorageAreaSymbol() {
        }

        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            super.draw(g, x, y, size, Color.BLUE, this.blue);
        }
    }
}

