/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.appInterface.AppDaddy;
import hec.appInterface.ApplicationModule;
import hec.lang.ClientAppCheck;
import hec.lang.NamedType;
import hec.map.appInterface.MapApplicationFrame;
import hec.model.CommonDataList;
import hec.model.DataListLoader;
import hec.watershed.client.ConditionNotesEditor;
import hec.watershed.client.ImpactAreaLocationPanel;
import hec.watershed.client.ImpactAreaLocationsEditor;
import hec.watershed.client.ImpactAreaPanel;
import hec.watershed.client.StudyMapSelectionEditor;
import hec.watershed.client.StudySystemGlyph;
import hec.watershed.client.WatershedConfigMode;
import hec.watershed.model.ImpactArea;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import rma.swing.DefaultJPanel;

public class ImpactAreaEditor
extends StudyMapSelectionEditor {
    private ImpactAreaLocationPanel locationsTab;
    private CommonDataList _impactAreaDataList;
    private JMenuItem undoMenuItem;
    private WatershedConfigMode _mode;
    private JMenuItem _editInTableMenuItem;
    private JMenuItem _notesMenuItem;

    public ImpactAreaEditor(Frame parent, boolean modal) {
        super(parent, modal);
        ApplicationModule mode;
        this.setSize(400, 300);
        this.setTitle("Edit Impact Area");
        this.setLocation();
        this.selectorPanel.setNameLabel("ImpactArea:");
        this.selectorPanel.setNameLabelMnemonic('i');
        if (ClientAppCheck.haveClientApp() && AppDaddy.getFrame() != null && (mode = AppDaddy.getFrame().getCurrentModule()) instanceof WatershedConfigMode) {
            this._mode = (WatershedConfigMode)mode;
        }
        this._impactAreaDataList = DataListLoader.getDataListLoader().getCommonDataList("hec.watershed.model.ImpactArea");
        this.buildMenus();
        this.locationsTab = new ImpactAreaLocationPanel(this);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this.addPanel(this.locationsTab);
        this.pack();
    }

    private void buildMenus() {
        JMenuBar mb = new JMenuBar();
        JMenu menu = new JMenu("ImpactArea");
        menu.setMnemonic('i');
        mb.add(menu);
        JMenuItem menuitem = new JMenuItem("Close", 99);
        menuitem.setAccelerator(KeyStroke.getKeyStroke(87, 2, false));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpactAreaEditor.this.windowClosing();
                ImpactAreaEditor.this.setVisible(false);
            }
        });
        menu.add(menuitem);
        menu = new JMenu("Edit");
        menu.setMnemonic('e');
        mb.add(menu);
        this.undoMenuItem = new JMenuItem("Undo All Changes", 117);
        this.undoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpactAreaEditor.this.undoAllChanges();
            }
        });
        menu.add(this.undoMenuItem);
        this._notesMenuItem = new JMenuItem("Notes"){

            @Override
            public void setEnabled(boolean enabled) {
                if (ImpactAreaEditor.this._mode == null && enabled) {
                    return;
                }
                super.setEnabled(enabled);
            }
        };
        if (this._mode == null) {
            this._notesMenuItem.setEnabled(false);
        }
        this._notesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpactAreaEditor.this.editNotes();
            }
        });
        menu.add(this._notesMenuItem);
        this._editInTableMenuItem = new JMenuItem("Edit in Table", 101);
        this._editInTableMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpactAreaEditor.this.editInTable();
            }
        });
        menu.add(this._editInTableMenuItem);
        this.setJMenuBar(mb);
    }

    public void fillForm() {
        Object[] objs = this._impactAreaDataList.getObjectArray();
        this.setSelectionList(objs);
    }

    @Override
    public void fillForm(NamedType nt) {
        super.fillForm(nt);
        if (nt instanceof ImpactArea) {
            this.setSelectedImpactArea((ImpactArea)nt);
            this.selectImpactAreaOnMap((ImpactArea)nt);
        }
    }

    public void fillForm(ImpactArea area) {
        this.clearForm();
        if (area == null) {
            return;
        }
        for (int i = 0; i < this._panelList.size(); ++i) {
            Object tab = this._panelList.elementAt(i);
            if (tab instanceof ImpactAreaPanel) {
                ((ImpactAreaPanel)tab).fillPanel(area);
                continue;
            }
            if (!(tab instanceof DefaultJPanel)) continue;
            ((DefaultJPanel)tab).fillPanel();
        }
        this.setSelectedImpactArea(area);
        this.selectImpactAreaOnMap(area);
        this.setModified(false);
    }

    public void refreshForm() {
        this.fillForm((ImpactArea)this.selectorPanel.getSelectedItem());
    }

    public boolean saveForm() {
        MapApplicationFrame frame;
        ImpactArea area = (ImpactArea)this.selectorPanel.getSelectedItem();
        if (area == null) {
            return true;
        }
        area.setDescription(this.selectorPanel.getDescription());
        for (int i = 0; i < this._panelList.size(); ++i) {
            Object tab = this._panelList.elementAt(i);
            if (tab instanceof ImpactAreaPanel && !((ImpactAreaPanel)tab).savePanel(area)) {
                return false;
            }
            if (!(tab instanceof DefaultJPanel)) continue;
            ((DefaultJPanel)tab).savePanel();
        }
        area.save();
        if (AppDaddy.getFrame() != null && (frame = (MapApplicationFrame)AppDaddy.getFrame()).getMapPanel() != null) {
            frame.getMapPanel().paintMap();
        }
        this.setModified(false);
        return true;
    }

    public void editInTable() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        ImpactAreaLocationsEditor iae = new ImpactAreaLocationsEditor((Dialog)((Object)this), true, this._impactAreaDataList);
        iae.fillForm();
        this.setCursor(Cursor.getDefaultCursor());
        iae.setVisible(true);
        this.repaint();
    }

    public void setSelectedImpactArea(ImpactArea ia) {
        if (ia == null) {
            return;
        }
        this.selectorPanel.setSelectedItem((Object)ia);
    }

    public ImpactArea getSelectedImpactArea() {
        return (ImpactArea)this.selectorPanel.getSelectedItem();
    }

    public void setModified(boolean b) {
        super.setModified(b);
        this.undoMenuItem.setEnabled(b);
    }

    public void selectImpactAreaOnMap(ImpactArea ia) {
        if (ia == null) {
            return;
        }
        if (ClientAppCheck.haveClientApp()) {
            MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
            StudySystemGlyph glyph = (StudySystemGlyph)frame.getMapPanel().findGlyphOfClass("ressim.hec.watershed.client.StudySystemGlyph");
            glyph.clearSelection();
            glyph.selectImpactArea(ia, true, false);
            frame.getMapPanel().paintMap();
        }
    }

    public void editNotes() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            ConditionNotesEditor cne = new ConditionNotesEditor((Dialog)((Object)this), true);
            cne.setCurrentCondition(this._mode.getSelectedCondition());
            cne.fillForm();
            cne.setSelectedImpactArea((ImpactArea)this.selectorPanel.getSelectedItem());
            cne.setVisible(true);
            this.repaint();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static ImpactAreaEditor[] getOpenImpactAreaEditors() {
        Vector v = ImpactAreaEditor.getOpenWindows();
        Vector temp = new Vector();
        for (int i = 0; v != null && i < v.size(); ++i) {
            if (!(v.elementAt(i) instanceof ImpactAreaEditor)) continue;
            temp.addElement(v.elementAt(i));
        }
        ImpactAreaEditor[] windowList = new ImpactAreaEditor[temp.size()];
        if (windowList.length == 0) {
            return windowList;
        }
        temp.copyInto((Object[])windowList);
        return windowList;
    }

    public void setEditable(boolean b) {
        super.setEditable(b);
        this._editInTableMenuItem.setEnabled(b);
        this._notesMenuItem.setEnabled(b);
    }

    public void setImpactAreaDataList(CommonDataList iaDataList) {
        this._impactAreaDataList = iaDataList;
        this.setCommonDataListContainer(iaDataList.getCommonDataListContainer());
    }
}

