/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.appInterface.AppDaddy;
import hec.gui.AbstractEditorPanel;
import hec.gui.SelectorPanelEditor;
import hec.lang.NamedType;
import hec.map.MapLabelItem;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.DataListLoader;
import hec.model.StreamElement;
import hec.watershed.client.ImpactAreaEditor;
import hec.watershed.client.ImpactAreaPanel;
import hec.watershed.model.ImpactArea;
import hec.watershed.model.Study;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import rma.swing.EditableComponent;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJRadioButton;
import rma.swing.list.RmaListModel;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ImpactAreaLocationPanel
extends AbstractEditorPanel
implements ImpactAreaPanel,
EditableComponent {
    RmaJComboBox streamNameList;
    RmaJRadioButton leftBankRB;
    RmaJRadioButton rightBankRB;
    RmaJRadioButton bothBanksRB;
    RmaJCheckBox autoBank;
    RmaJColorComboBox colorList;
    RmaJComboBox labelPositionList;
    RmaJDecimalField indexStationFld;
    RmaJCheckBox autoIndexStation;
    RmaJCheckBox generateCompPt;
    RmaJCheckBox autoStream;
    RmaJCheckBox autoLabel;
    RmaJDecimalField downstreamStationFld;
    RmaJCheckBox autoDownstreamStation;
    RmaJDecimalField upstreamStationFld;
    RmaJCheckBox autoUpstreamStation;
    SelectorPanelEditor _parent;
    private Boolean _removeAutoCheckBoxes;
    private Boolean _generateCompPt;

    public ImpactAreaLocationPanel(SelectorPanelEditor parent) {
        this._parent = parent;
        this.setLayout(new GridBagLayout());
        JPanel streamPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 1.0;
        gbc.ipady = 0;
        this.add(streamPanel, gbc);
        JLabel label = new JLabel("Stream Name:");
        label.setDisplayedMnemonic('s');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        streamPanel.add((Component)label, gbc);
        this.streamNameList = new RmaJComboBox((ComboBoxModel)new RmaListModel(true));
        this.streamNameList.setModifiable(true);
        label.setLabelFor((Component)this.streamNameList);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        gbc.weightx = 1.0;
        streamPanel.add((Component)this.streamNameList, gbc);
        this.autoStream = new RmaJCheckBox("Auto");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        streamPanel.add((Component)this.autoStream, gbc);
        JPanel bankPanel = new JPanel(new GridBagLayout());
        bankPanel.setBorder(new TitledBorder("Bank"));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 1.0;
        this.add(bankPanel, gbc);
        this.leftBankRB = new RmaJRadioButton("Left");
        this.leftBankRB.setMnemonic('l');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.weightx = 1.0;
        bankPanel.add((Component)this.leftBankRB, gbc);
        this.rightBankRB = new RmaJRadioButton("Right");
        this.rightBankRB.setMnemonic('r');
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.weightx = 1.0;
        bankPanel.add((Component)this.rightBankRB, gbc);
        this.bothBanksRB = new RmaJRadioButton("Both");
        this.bothBanksRB.setMnemonic('o');
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        bankPanel.add((Component)this.bothBanksRB, gbc);
        this.autoBank = new RmaJCheckBox("Auto");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)7, (int)5, (int)0, (int)0);
        bankPanel.add((Component)this.autoBank, gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.leftBankRB);
        bg.add((AbstractButton)this.rightBankRB);
        bg.add((AbstractButton)this.bothBanksRB);
        JPanel streamStationPanel = new JPanel(new GridBagLayout());
        streamStationPanel.setBorder(BorderFactory.createTitledBorder("Stream Stations:"));
        this.add(streamStationPanel, new GridBagConstraints(0, 1, 2, 4, 1.0, 0.0, 18, 2, RmaInsets.INSETS5500, 50, 0));
        label = new JLabel("Index:", 4);
        label.setDisplayedMnemonic('i');
        gbc = new GridBagConstraints();
        streamStationPanel.add((Component)label, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0));
        this.indexStationFld = new RmaJDecimalField();
        label.setLabelFor((Component)this.indexStationFld);
        streamStationPanel.add((Component)this.indexStationFld, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS5500, 50, 0));
        this.autoIndexStation = new RmaJCheckBox("Auto");
        streamStationPanel.add((Component)this.autoIndexStation, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 12, 0, RmaInsets.INSETS5505, 0, 0));
        label = new JLabel("Upstream:", 4);
        label.setDisplayedMnemonic('b');
        streamStationPanel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0));
        this.upstreamStationFld = new RmaJDecimalField();
        label.setLabelFor((Component)this.upstreamStationFld);
        streamStationPanel.add((Component)this.upstreamStationFld, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS5500, 50, 0));
        this.autoUpstreamStation = new RmaJCheckBox("Auto");
        streamStationPanel.add((Component)this.autoUpstreamStation, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 12, 0, RmaInsets.INSETS5505, 0, 0));
        label = new JLabel("Downstream:", 4);
        label.setDisplayedMnemonic('b');
        streamStationPanel.add((Component)label, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0));
        this.downstreamStationFld = new RmaJDecimalField();
        label.setLabelFor((Component)this.downstreamStationFld);
        streamStationPanel.add((Component)this.downstreamStationFld, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS5500, 50, 0));
        this.autoDownstreamStation = new RmaJCheckBox("Auto");
        streamStationPanel.add((Component)this.autoDownstreamStation, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 12, 0, RmaInsets.INSETS5505, 0, 0));
        label = new JLabel("Color of Impact Area:", 4);
        label.setDisplayedMnemonic('c');
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.add(label, gbc);
        this.colorList = new RmaJColorComboBox();
        this.colorList.setModifiable(true);
        label.setLabelFor((Component)this.colorList);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add((Component)this.colorList, gbc);
        label = new JLabel("Label Position:", 4);
        label.setDisplayedMnemonic('L');
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.add(label, gbc);
        this.labelPositionList = new RmaJComboBox((Object[])MapLabelItem.POSITION_STRINGS);
        this.labelPositionList.setModifiable(true);
        label.setLabelFor((Component)this.labelPositionList);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add((Component)this.labelPositionList, gbc);
        this.autoLabel = new RmaJCheckBox("Automatically Position Label");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.add((Component)this.autoLabel, gbc);
        this.generateCompPt = new RmaJCheckBox("Generate computation point");
        this.generateCompPt.setMnemonic('d');
        this.generateCompPt.setMargin(RmaInsets.INSETS0000);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.generateCompPt, gbc);
        this.autoBank.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ImpactAreaLocationPanel.this.autoBankChanged();
            }
        });
        this.autoIndexStation.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ImpactAreaLocationPanel.this.autoIndexStationChanged();
            }
        });
        this.autoStream.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ImpactAreaLocationPanel.this.autoStreamChanged();
            }
        });
        this.autoDownstreamStation.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ImpactAreaLocationPanel.this.autoDownstreamStationChanged();
            }
        });
        this.autoUpstreamStation.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ImpactAreaLocationPanel.this.autoUpstreamStationChanged();
            }
        });
        StreamAlignmentIfc alignment = null;
        if (AppDaddy.getApp() != null && AppDaddy.getWorkspace() != null) {
            alignment = DataListLoader.getDataListLoader().getStreamAlignment();
        }
        if (alignment != null) {
            Vector v = alignment.getElementVector();
            RmaListModel streamModel = new RmaListModel(true, (Collection)v);
            this.streamNameList.setModel((ComboBoxModel)streamModel);
        }
        this.streamNameList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                ImpactAreaLocationPanel.this.updateStations();
            }
        });
    }

    void autoUpstreamStationChanged() {
        if (this._parent.isEditable()) {
            this.upstreamStationFld.setEditable(!this.autoUpstreamStation.isSelected());
        }
    }

    void autoDownstreamStationChanged() {
        if (this._parent.isEditable()) {
            this.downstreamStationFld.setEditable(!this.autoDownstreamStation.isSelected());
        }
    }

    void autoStreamChanged() {
        if (this._parent.isEditable()) {
            this.streamNameList.setEnabled(!this.autoStream.isSelected());
        }
    }

    void autoBankChanged() {
        if (this._parent.isEditable()) {
            this.leftBankRB.setEnabled(!this.autoBank.isSelected());
            this.rightBankRB.setEnabled(!this.autoBank.isSelected());
            this.bothBanksRB.setEnabled(!this.autoBank.isSelected());
        }
    }

    void autoIndexStationChanged() {
        if (this._parent.isEditable()) {
            this.indexStationFld.setEditable(!this.autoIndexStation.isSelected());
        }
    }

    public void fillPanel() {
    }

    public void clearPanel() {
        this.colorList.setSelectedColor(Color.green);
        this.indexStationFld.setText("");
        this.downstreamStationFld.setText("");
        this.upstreamStationFld.setText("");
    }

    public void fillPanel(NamedType obj) {
        if (obj instanceof ImpactArea) {
            this.fillPanel((ImpactArea)obj);
        }
    }

    @Override
    public void fillPanel(ImpactArea ia) {
        this.clearPanel();
        if (ia == null) {
            return;
        }
        if (this._removeAutoCheckBoxes != null && this._removeAutoCheckBoxes.booleanValue()) {
            this.autoBank.setSelected(false);
            this.autoBank.setVisible(false);
            this.autoStream.setSelected(false);
            this.autoStream.setVisible(false);
            this.autoIndexStation.setSelected(false);
            this.autoIndexStation.setVisible(false);
            this.autoDownstreamStation.setSelected(false);
            this.autoDownstreamStation.setVisible(false);
            this.autoUpstreamStation.setSelected(false);
            this.autoUpstreamStation.setVisible(false);
        } else {
            this.autoBank.setSelected(ia.getAutoBank());
            this.autoStream.setSelected(ia.getAutoStream());
            this.autoIndexStation.setSelected(ia.getAutoIndexStation());
            this.autoDownstreamStation.setSelected(ia.getAutoBeginStation());
            this.autoUpstreamStation.setSelected(ia.getAutoEndStation());
        }
        if (this._generateCompPt != null && this._generateCompPt.booleanValue()) {
            this.generateCompPt.setSelected(true);
        } else {
            this.generateCompPt.setSelected(ia.getGenerateCompPt());
        }
        switch (ia.getBank()) {
            case 1: {
                this.leftBankRB.setSelected(true);
                break;
            }
            case 2: {
                this.rightBankRB.setSelected(true);
                break;
            }
            case 3: {
                this.bothBanksRB.setSelected(true);
            }
        }
        int index = ia.getStreamId();
        Vector v = ((RmaListModel)this.streamNameList.getModel()).getVector();
        for (int i = 0; i < v.size(); ++i) {
            StreamElement elem = (StreamElement)v.elementAt(i);
            if (elem == null || elem.getIndex() != index) continue;
            this.streamNameList.setSelectedIndex(i);
            break;
        }
        this.labelPositionList.setSelectedIndex(ia.getLabelPosition());
        this.colorList.setSelectedColor(ia.getColor());
        this.indexStationFld.setValue(ia.getIndexStation());
        this.downstreamStationFld.setValue(ia.getBeginStation());
        this.upstreamStationFld.setValue(ia.getEndStation());
        this.autoLabel.setSelected(ia.getAutoLabelPosition());
        this._parent.setModified(false);
        this.autoBankChanged();
        this.autoIndexStationChanged();
        this.autoUpstreamStationChanged();
        this.autoDownstreamStationChanged();
        this.autoStreamChanged();
    }

    private boolean validateForm() {
        double indexStation = this.indexStationFld.getValueUndefined();
        double upstreamStation = this.upstreamStationFld.getValueUndefined();
        double downstreamStation = this.downstreamStationFld.getValueUndefined();
        if (!RMAConst.isValidValue((double)indexStation)) {
            RMAIO.postError((Component)((Object)this), (String)"An invalid Index Station has been entered!");
            return false;
        }
        if (!RMAConst.isValidValue((double)upstreamStation) || upstreamStation < 0.0) {
            RMAIO.postError((Component)((Object)this), (String)"An invalid Upstream Station has been entered!");
            return false;
        }
        if (!RMAConst.isValidValue((double)downstreamStation) || downstreamStation < 0.0) {
            RMAIO.postError((Component)((Object)this), (String)"An invalid Downstream Station has been entered!");
            return false;
        }
        if (upstreamStation < downstreamStation) {
            RMAIO.postError((Component)((Object)this), (String)"The Downstream Station value cannot be greater than the Upstream Station value!");
            return false;
        }
        if (indexStation < downstreamStation || indexStation > upstreamStation) {
            RMAIO.postError((Component)((Object)this), (String)"The index station must be within the bounds\nof the Upstream and Downstream Stations");
            return false;
        }
        return true;
    }

    @Override
    public boolean savePanel(ImpactArea ia) {
        if (ia == null) {
            return false;
        }
        if (!this.validateForm()) {
            return false;
        }
        ia.setColor(this.colorList.getSelectedColor());
        ia.setAutoBank(this.autoBank.isSelected());
        if (this.leftBankRB.isSelected()) {
            ia.setBank(1);
        } else if (this.rightBankRB.isSelected()) {
            ia.setBank(2);
        } else if (this.bothBanksRB.isSelected()) {
            ia.setBank(3);
        }
        ia.setAutoIndexStation(this.autoIndexStation.isSelected());
        ia.setIndexStation(this.indexStationFld.getValueUndefined());
        ia.setAutoStream(this.autoStream.isSelected());
        StreamElement elem = (StreamElement)this.streamNameList.getSelectedItem();
        if (elem != null) {
            ia.setStreamId(elem.getIndex());
        }
        boolean updateCompPt = false;
        if (this.generateCompPt.isSelected() != ia.getGenerateCompPt()) {
            updateCompPt = true;
        }
        ia.setGenerateCompPt(this.generateCompPt.isSelected());
        ia.setAutoBeginStation(this.autoDownstreamStation.isSelected());
        ia.setBeginStation(this.downstreamStationFld.getValueUndefined());
        ia.setAutoEndStation(this.autoUpstreamStation.isSelected());
        ia.setEndStation(this.upstreamStationFld.getValueUndefined());
        ia.setLabelPosition(this.labelPositionList.getSelectedIndex());
        if (updateCompPt) {
            ia.updateComputationPoint();
        }
        ia.setAutoLabelPosition(this.autoLabel.isSelected());
        return true;
    }

    public void refresh() {
    }

    public boolean savePanel(NamedType dobj) {
        return true;
    }

    public void updateStations() {
        StreamElement elem = (StreamElement)this.streamNameList.getSelectedItem();
        NamedType nt = (NamedType)this._parent.getSelectorPanel().getSelectedItem();
        if (!(nt instanceof ImpactArea)) {
            return;
        }
        ImpactArea ia = (ImpactArea)nt;
        if (elem == null || ia == null) {
            return;
        }
        double[] stations = Study.getStations(elem, ia);
        if (this.autoIndexStation.isSelected()) {
            this.indexStationFld.setValue(stations[0]);
        }
        if (this.autoDownstreamStation.isSelected()) {
            this.downstreamStationFld.setValue(stations[1]);
        }
        if (this.autoUpstreamStation.isSelected()) {
            this.upstreamStationFld.setValue(stations[2]);
        }
    }

    public boolean removeAllAutoCheckBoxOptions(boolean removeAutoCheckBoxes) {
        this._removeAutoCheckBoxes = removeAutoCheckBoxes;
        return this._removeAutoCheckBoxes;
    }

    public boolean generateComputationPoint(boolean generateCompPt) {
        this._generateCompPt = generateCompPt;
        return this._generateCompPt;
    }

    public void setIsEditable(boolean editable) {
        Component[] comps = this.getComponents();
        this.setIsEditable(comps, editable);
    }

    private void setIsEditable(Component[] comps, boolean editable) {
        if (comps == null || comps.length == 0) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] == this.streamNameList) {
                this.streamNameList.setEnabled(editable & !this.autoStream.isSelected());
                continue;
            }
            if (comps[i] == this.upstreamStationFld) {
                this.upstreamStationFld.setEditable(editable & !this.autoUpstreamStation.isSelected());
                continue;
            }
            if (comps[i] == this.downstreamStationFld) {
                this.downstreamStationFld.setEditable(editable & !this.autoDownstreamStation.isSelected());
                continue;
            }
            if (comps[i] == this.indexStationFld) {
                this.indexStationFld.setEditable(editable & !this.autoIndexStation.isSelected());
                continue;
            }
            if (comps[i] == this.leftBankRB || comps[i] == this.rightBankRB || comps[i] == this.bothBanksRB) {
                this.leftBankRB.setEnabled(editable & !this.autoBank.isSelected());
                this.rightBankRB.setEnabled(editable & !this.autoBank.isSelected());
                this.bothBanksRB.setEnabled(editable & !this.autoBank.isSelected());
                continue;
            }
            if (comps[i] instanceof EditableComponent) {
                ((EditableComponent)comps[i]).setIsEditable(editable);
                continue;
            }
            if (!(comps[i] instanceof Container)) continue;
            this.setIsEditable(((Container)comps[i]).getComponents(), editable);
        }
    }

    public String getTabname() {
        return "Locations";
    }

    public static void main(String[] args) {
        ImpactAreaEditor editor = new ImpactAreaEditor((Frame)null, true);
        editor.setLocation(500, 500);
        editor.setVisible(true);
    }
}

