/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.appInterface.AppDaddy;
import hec.clientapp.client.MapLabelItemEditor;
import hec.clientapp.client.MapLabelItemRenderer;
import hec.event.DataListEvent;
import hec.event.DataListListener;
import hec.map.MapLabelItem;
import hec.map.appInterface.MapApplicationFrame;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.CommonDataList;
import hec.model.DataListLoader;
import hec.model.StreamElement;
import hec.watershed.client.StudySystemMapGlyph;
import hec.watershed.model.ImpactArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTable;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableSorter;
import rma.text.ColorFormatter;
import rma.util.IntVector;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ImpactAreaLocationsEditor
extends RmaJFrame
implements DataListListener {
    private static final int TABLE_PRECISION = 3;
    private static final int ID_COL = 0;
    private static final int NAME_COL = 1;
    private static final int STREAM_COL = 2;
    private static final int AUTO_STREAM_COL = 3;
    private static final int BANK_COL = 4;
    private static final int AUTO_BANK = 5;
    private static final int INDEX_STATION_COL = 6;
    private static final int AUTO_INDEX_STATION_COL = 7;
    private static final int UPSTREAM_STATION_COL = 8;
    private static final int AUTO_UPSTREAM_STATION_COL = 9;
    private static final int DOWNSTREAM_STATION_COL = 10;
    private static final int AUTO_DOWNSTREAM_STATION_COL = 11;
    private static final int GENERATE_COMPPOINT_COL = 12;
    private static final int COLOR_COL = 13;
    private static final int LABEL_POS_COL = 14;
    private static final int DESC_COL = 15;
    private RmaJTable impactAreas;
    private ButtonCmdPanel cmdPanel;
    private IntVector _modifiedRows = new IntVector();
    private StreamAlignmentIfc _alignment;
    private Vector _streamList = new Vector();
    private RmaTableModel nameTableModel;
    private RmaTableModel dataTableModel;
    private TableSorter nameSortingTableModel;
    private TableSorter dataSortingTableModel;
    private boolean _saving = false;
    private CommonDataList _impactAreaList;

    public ImpactAreaLocationsEditor(Frame parent, boolean modal, CommonDataList impactAreaList) {
        this._impactAreaList = impactAreaList;
        this.buildControls();
    }

    public ImpactAreaLocationsEditor(Dialog parent, boolean modal, CommonDataList impactAreaList) {
        this._impactAreaList = impactAreaList;
        this.buildControls();
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        String wtshdName = AppDaddy.getWorkspace().getTitleName();
        this.setTitle(wtshdName + " - Impact Areas Editor");
        this.setSize(640, 300);
        this.setLocation();
        this.nameTableModel = new RmaTableModel(new String[]{" \nImpact Area"}, new Object[0][0], new boolean[0]);
        this.impactAreas = new RmaJTable((Component)((Object)this), (Object[])new String[]{"", "", "Stream\nName", " \nAuto", "Stream\nBank", " \nAuto", "Index", "Auto", "Upstream", "Auto", "Downstream", "Auto", "Generate\nComputation Point", "Color of\nImpact Area", "Label\nPosition", " \nDescription"});
        JLabel headerLabel = new JLabel("Impact Area");
        headerLabel.setHorizontalAlignment(0);
        headerLabel.setBorder(new BevelBorder(0));
        this.nameSortingTableModel = new TableSorter((TableModel)this.nameTableModel);
        this.impactAreas.setViewportRowHeader((TableModel)((Object)this.nameSortingTableModel), null, null, 100);
        GroupableTableHeader tableHeader = new GroupableTableHeader(this.impactAreas.getColumnModel());
        this.impactAreas.setTableHeader((JTableHeader)tableHeader);
        this.dataTableModel = (RmaTableModel)this.impactAreas.getModel();
        this.dataSortingTableModel = new TableSorter((TableModel)this.dataTableModel, 0);
        this.impactAreas.setModel((TableModel)((Object)this.dataSortingTableModel));
        this.impactAreas.setMlHeaderRenderer();
        ColumnGroup cg = new ColumnGroup("Stream Station Information");
        for (int i = 6; i <= 11; ++i) {
            cg.add((Object)this.impactAreas.getColumnModel().getColumn(i));
        }
        tableHeader.addColumnGroup(cg);
        this.impactAreas.setAutoResizeMode(0);
        this.impactAreas.setAddRemoveEnabled(false);
        this.impactAreas.setPrecision(3);
        Vector<String> banks = new Vector<String>(3);
        banks.add("Left");
        banks.add("Right");
        banks.add("Both");
        Vector<String> colors = new Vector<String>();
        String[] colorNames = ColorFormatter.colorNames;
        for (int i = 0; i < colorNames.length; ++i) {
            colors.add(colorNames[i]);
        }
        this.impactAreas.setCheckBoxCellEditor(3).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpactAreaLocationsEditor.this.updateCBRelatedCols(2, 3);
            }
        });
        this.impactAreas.setComboBoxEditor(4, banks);
        this.impactAreas.setCheckBoxCellEditor(5).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpactAreaLocationsEditor.this.updateBankdCols();
            }
        });
        this.impactAreas.setPrecision(3);
        this.impactAreas.setComboBoxEditor(13, colors);
        this.impactAreas.setComboBoxEditor(2, this._streamList);
        RmaJDecimalField field = this.impactAreas.setDoubleCellEditor(6, true);
        this.impactAreas.getColumnModel().getColumn(6).setCellEditor((TableCellEditor)((Object)new ImpactAreaTableCellEditor()));
        JCheckBox cb = this.impactAreas.setCheckBoxCellEditor(7);
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpactAreaLocationsEditor.this.updateIndexStationCols();
            }
        });
        field = this.impactAreas.setDoubleCellEditor(8, true);
        this.impactAreas.getColumnModel().getColumn(8).setCellEditor((TableCellEditor)((Object)new ImpactAreaTableCellEditor()));
        cb = this.impactAreas.setCheckBoxCellEditor(9);
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpactAreaLocationsEditor.this.updateUpstreamStationCols();
            }
        });
        field = this.impactAreas.setDoubleCellEditor(10, true);
        this.impactAreas.getColumnModel().getColumn(10).setCellEditor((TableCellEditor)((Object)new ImpactAreaTableCellEditor()));
        cb = this.impactAreas.setCheckBoxCellEditor(11);
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpactAreaLocationsEditor.this.updateDownstreamStationCols();
            }
        });
        this.impactAreas.setCheckBoxCellEditor(12);
        this.impactAreas.getColumnModel().getColumn(14).setCellRenderer((TableCellRenderer)new MapLabelItemRenderer());
        JComboBox<String> comboBox = new JComboBox<String>(MapLabelItem.POSITION_STRINGS);
        this.impactAreas.getColumnModel().getColumn(14).setCellEditor((TableCellEditor)new MapLabelItemEditor(comboBox));
        for (int i = 0; i <= 1; ++i) {
            this.impactAreas.setColumnVisible(0, false, 0);
        }
        this.impactAreas.setColumnWidth(7, 50);
        this.impactAreas.setColumnWidth(11, 50);
        this.impactAreas.setColumnWidth(9, 50);
        this.impactAreas.setColumnWidth(5, 50);
        this.impactAreas.setColumnWidth(3, 50);
        this.impactAreas.setPopupMenuEnabled(false);
        this.impactAreas.setCellSelectionEnabled(false);
        this.impactAreas.setColumnSelectionAllowed(false);
        this.impactAreas.setRowSelectionAllowed(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.impactAreas.getScrollPane(), gbc);
        this.cmdPanel = new ButtonCmdPanel(14);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 16;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gbc.fill = 2;
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.buildMenuBar();
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                int id = e.getID();
                switch (id) {
                    case 8: {
                        if (ImpactAreaLocationsEditor.this.isModified() && !ImpactAreaLocationsEditor.this.saveForm()) {
                            return;
                        }
                        ImpactAreaLocationsEditor.this.setVisible(false);
                        break;
                    }
                    case 2: {
                        ImpactAreaLocationsEditor.this.saveForm();
                        break;
                    }
                    case 4: {
                        if (!ImpactAreaLocationsEditor.this.windowClosing()) {
                            return;
                        }
                        ImpactAreaLocationsEditor.this.setVisible(false);
                    }
                }
            }
        });
        this.impactAreas.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (evt.getValueIsAdjusting()) {
                    return;
                }
                int[] rows = ImpactAreaLocationsEditor.this.impactAreas.getSelectedRows();
                if (rows.length == 0) {
                    return;
                }
                ImpactAreaLocationsEditor.this.selectImpactArea(rows);
            }
        });
        this.impactAreas.addCellEditorListener((CellEditorListener)new CellEditorListener2());
        ((RmaJTable)this.impactAreas.getScrollPane().getRowHeader().getView()).addCellEditorListener((CellEditorListener)new CellEditorListener2());
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                int[] rows = ImpactAreaLocationsEditor.this.impactAreas.getSelectedRows();
                if (rows.length == 0) {
                    return;
                }
                ImpactAreaLocationsEditor.this.selectImpactArea(rows);
            }
        });
        if (this._impactAreaList == null) {
            this._impactAreaList = DataListLoader.getDataListLoader().getCommonDataList("hec.watershed.model.ImpactArea");
        }
        if (this._impactAreaList == null) {
            return;
        }
        this._impactAreaList.addDataListListener((DataListListener)this);
    }

    private void buildMenuBar() {
        JMenuBar mb = new JMenuBar();
        JMenu menu = new JMenu("Impact Areas");
        mb.add(menu);
        menu.addSeparator();
        JMenuItem menuitem = new JMenuItem("Close");
        menuitem.setAccelerator(KeyStroke.getKeyStroke(87, 2, false));
        menu.add(menuitem);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ImpactAreaLocationsEditor.this.windowClosing()) {
                    ImpactAreaLocationsEditor.this.setVisible(false);
                }
            }
        });
        menu = new JMenu("Sort");
        mb.add(menu);
        menuitem = new JMenuItem("Ascending");
        menu.add(menuitem);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpactAreaLocationsEditor.this.impactAreas.commitEdit(true);
                ((RmaJTable)ImpactAreaLocationsEditor.this.impactAreas.getScrollPane().getRowHeader().getView()).commitEdit(true);
                ImpactAreaLocationsEditor.this.nameSortingTableModel.setSortingType(0);
                ImpactAreaLocationsEditor.this.nameSortingTableModel.sortByColumn(0, ImpactAreaLocationsEditor.this.nameSortingTableModel.ascending());
                ImpactAreaLocationsEditor.this.dataSortingTableModel.setSortingType(0);
                ImpactAreaLocationsEditor.this.dataSortingTableModel.sortByColumn(1, ImpactAreaLocationsEditor.this.nameSortingTableModel.ascending());
            }
        });
        menuitem = new JMenuItem("Descending");
        menu.add(menuitem);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpactAreaLocationsEditor.this.impactAreas.commitEdit(true);
                ((RmaJTable)ImpactAreaLocationsEditor.this.impactAreas.getScrollPane().getRowHeader().getView()).commitEdit(true);
                ImpactAreaLocationsEditor.this.nameSortingTableModel.setSortingType(1);
                ImpactAreaLocationsEditor.this.nameSortingTableModel.sortByColumn(0, ImpactAreaLocationsEditor.this.nameSortingTableModel.ascending());
                ImpactAreaLocationsEditor.this.dataSortingTableModel.setSortingType(1);
                ImpactAreaLocationsEditor.this.dataSortingTableModel.sortByColumn(1, ImpactAreaLocationsEditor.this.dataSortingTableModel.ascending());
            }
        });
        this.setJMenuBar(mb);
    }

    public boolean windowClosing() {
        int opt;
        return !this.isModified() || (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Data has changed. Save Changes?", "Confirm Changes", 0)) != 0 || this.saveForm();
    }

    public void setAlignment(StreamAlignmentIfc alignment) {
        this._alignment = alignment;
        if (this._alignment != null) {
            this._streamList.addAll(this._alignment.getElementVector());
        }
    }

    private boolean validateTable() {
        this.impactAreas.commitEdit(true);
        for (int row = 0; row < this.impactAreas.getRowCount(); ++row) {
            String name = this.impactAreas.getCell(row, 1).toString();
            double indexStation = RMAIO.parseDouble((Object)this.impactAreas.getCell(row, 6));
            double upstreamStation = RMAIO.parseDouble((Object)this.impactAreas.getCell(row, 8));
            double downstreamStation = RMAIO.parseDouble((Object)this.impactAreas.getCell(row, 10));
            if (!RMAConst.isValidValue((double)indexStation)) {
                RMAIO.postError((Component)((Object)this), (String)("An invalid Index Station has been entered on row " + (row + 1) + "!"));
                return false;
            }
            if (!RMAConst.isValidValue((double)upstreamStation) || upstreamStation < 0.0 || upstreamStation > 999999.999) {
                RMAIO.postError((Component)((Object)this), (String)("An invalid Upstream Station has been entered on row " + (row + 1) + "!"));
                return false;
            }
            if (!RMAConst.isValidValue((double)downstreamStation) || downstreamStation < 0.0 || downstreamStation > 999999.999) {
                RMAIO.postError((Component)((Object)this), (String)("An invalid Downstream Station has been entered on row " + (row + 1) + "!"));
                return false;
            }
            if (upstreamStation < downstreamStation) {
                RMAIO.postError((Component)((Object)this), (String)("The Downstream Station value cannot be greater than the Upstream Station value on row " + (row + 1) + "!"));
                return false;
            }
            if (!(indexStation < downstreamStation) && !(indexStation > upstreamStation)) continue;
            RMAIO.postError((Component)((Object)this), (String)("The index station must be within the bounds\nof the Upstream and Downstream Stations on row " + (row + 1)));
            return false;
        }
        return true;
    }

    private boolean saveForm() {
        this.impactAreas.commitEdit(true);
        if (!this.validateTable()) {
            return false;
        }
        ((RmaJTable)this.impactAreas.getScrollPane().getRowHeader().getView()).commitEdit(true);
        int size = this._modifiedRows.size();
        if (this._impactAreaList == null) {
            return true;
        }
        this._saving = true;
        for (int i = 0; i < size; ++i) {
            int row = this._modifiedRows.elementAt(i);
            Long id = (Long)this.impactAreas.getCell(row, 0);
            ImpactArea area = (ImpactArea)this._impactAreaList.getObject(id.longValue());
            if (area == null) continue;
            String name = (String)this.nameTableModel.getValueAt(row, 0);
            area.setName(name != null ? name : "");
            area.setDescription(this.impactAreas.getCell(row, 15).toString());
            Object obj = this.impactAreas.getCell(row, 2);
            if (obj instanceof StreamElement) {
                area.setStreamId(((StreamElement)obj).getIndex());
            }
            area.setAutoStream(this.impactAreas.getCell(row, 3).toString().equals("true"));
            area.setAutoBank(this.impactAreas.getCell(row, 5).toString().equals("true"));
            area.setBankString(this.impactAreas.getCell(row, 4).toString());
            area.setColor(ColorFormatter.colorForName((String)this.impactAreas.getCell(row, 13).toString()));
            area.setAutoIndexStation(this.impactAreas.getCell(row, 7).toString().equals("true"));
            area.setIndexStation(RMAIO.parseDouble((String)this.impactAreas.getCell(row, 6).toString(), (double)0.0));
            area.setAutoBeginStation(this.impactAreas.getCell(row, 11).toString().equals("true"));
            area.setBeginStation(RMAIO.parseDouble((String)this.impactAreas.getCell(row, 10).toString(), (double)0.0));
            area.setAutoEndStation(this.impactAreas.getCell(row, 9).toString().equals("true"));
            area.setEndStation(RMAIO.parseDouble((String)this.impactAreas.getCell(row, 8).toString(), (double)0.0));
            area.setGenerateCompPt(this.impactAreas.getCell(row, 12).toString().equals("true"));
            area.setLabelPosition((Integer)this.impactAreas.getCell(row, 14));
            area.save();
        }
        this.impactAreas.setModified(false);
        this._modifiedRows.clear();
        MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
        if (frame != null && frame.getMapPanel() != null) {
            frame.getMapPanel().paintMap();
        }
        this.setModified(false);
        this._saving = false;
        return true;
    }

    public void fillForm() {
        if (this._impactAreaList == null) {
            return;
        }
        Object[] iareas = this._impactAreaList.getObjectArray();
        this.dataTableModel.clearAll();
        this.nameTableModel.clearAll();
        String wtshdName = AppDaddy.getWorkspace().getTitleName();
        this.setTitle(wtshdName + " - Impact Areas Editor");
        Arrays.sort(iareas);
        for (int i = 0; i < iareas.length; ++i) {
            ImpactArea area = (ImpactArea)iareas[i];
            if (area == null) continue;
            Vector<Object> row = new Vector<Object>(1);
            row.add(area.getName());
            this.nameTableModel.addRow(row);
            row = new Vector(15);
            row.add(new Long(area.getId()));
            row.add(area.getName());
            if (this._alignment != null) {
                row.add(this._alignment.findReach(area.getStreamId()));
            } else {
                row.add("Unknown. Id=" + area.getStreamId());
            }
            row.add(area.getAutoStream());
            row.add(area.getBankString());
            row.add(area.getAutoBank());
            row.add(new Double(area.getIndexStation()));
            row.add(area.getAutoIndexStation());
            row.add(new Double(area.getEndStation()));
            row.add(area.getAutoEndStation());
            row.add(new Double(area.getBeginStation()));
            row.add(area.getAutoBeginStation());
            row.add(area.getGenerateCompPt());
            row.add(ColorFormatter.nameForColor((Color)area.getColor()));
            row.add(new Integer(area.getLabelPosition()));
            row.add(area.getDescription());
            this.dataTableModel.addRow(row);
            this.dataTableModel.setCellEnabled(!area.getAutoStream(), i, 2);
        }
        this.dataSortingTableModel.reallocateIndexes();
        this.nameSortingTableModel.reallocateIndexes();
        this.updateUpstreamStationCols();
        this.updateDownstreamStationCols();
        this.updateIndexStationCols();
        this.updateBankdCols();
        this.updateCBRelatedCols(2, 3);
        this.setModified(false);
    }

    private void selectImpactArea(int[] rows) {
        if (AppDaddy.getFrame() == null) {
            return;
        }
        MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
        StudySystemMapGlyph glyph = (StudySystemMapGlyph)frame.getMapPanel().findGlyphOfClass("ressim.hec.watershed.client.StudySystemMapGlyph");
        if (glyph == null) {
            return;
        }
        glyph.clearSelection();
        if (rows.length == 0) {
            return;
        }
        CommonDataList dl = DataListLoader.getDataListLoader().getCommonDataList("hec.watershed.model.ImpactArea");
        if (dl == null) {
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            long id;
            ImpactArea area;
            if (rows[i] < 0 || (area = (ImpactArea)dl.getObject(id = ((Long)this.impactAreas.getCell(rows[i], 0)).longValue())) == null) continue;
            glyph.selectImpactArea(area, true, false);
        }
        frame.getMapPanel().paintMap();
    }

    private void updateBankdCols() {
        this.updateCBRelatedCols(4, 5);
    }

    private void updateUpstreamStationCols() {
        this.updateCBRelatedCols(8, 9);
    }

    private void updateDownstreamStationCols() {
        this.updateCBRelatedCols(10, 11);
    }

    private void updateIndexStationCols() {
        this.updateCBRelatedCols(6, 7);
    }

    private void updateCBRelatedCols(int textCol, int cbCol) {
        this.impactAreas.commitEdit(true);
        int rows = this.impactAreas.getRowCount();
        for (int i = 0; i < rows; ++i) {
            String selected = this.impactAreas.getCell(i, cbCol).toString();
            boolean enabled = !selected.equalsIgnoreCase("true");
            this.dataTableModel.setCellEnabled(enabled, this.dataSortingTableModel.getMappedRow(i), textCol);
            this.impactAreas.setCellBackground(i, textCol - 1, enabled ? Color.white : Color.lightGray);
        }
    }

    public void dataListChanged(DataListEvent dle) {
        if (!this._saving) {
            this.windowClosing();
            this.fillForm();
        }
    }

    private class TableSorter
    extends RmaTableSorter {
        public TableSorter(TableModel tm, int asc) {
            super(tm, asc);
        }

        public TableSorter(TableModel tm) {
            super(tm);
        }

        public void tableChanged(TableModelEvent e) {
            this.fireTableChanged(e);
        }
    }

    private class ImpactAreaTableCellEditor
    extends RmaCellEditor {
        public ImpactAreaTableCellEditor() {
            this(new RmaJDecimalField(0, 5));
            RmaJDecimalField cfr_ignored_0 = (RmaJDecimalField)this.editorComponent;
            ((RmaJDecimalField)this.editorComponent).setHorizontalAlignment(4);
            ((RmaJDecimalField)this.editorComponent).setPrecision(3);
        }

        public ImpactAreaTableCellEditor(final RmaJDecimalField textField) {
            this.editorComponent = textField;
            this.clickCountToStart = 2;
            this.delegate = new RmaCellEditor.EditorDelegate(){

                public void setValue(Object value) {
                    double dvalue = RMAIO.parseDouble((Object)value);
                    if (RMAConst.isValidValue((double)dvalue)) {
                        textField.setValue(dvalue);
                    } else {
                        textField.setText("");
                    }
                }

                public Object getCellEditorValue() {
                    return textField.getText();
                }
            };
            textField.addActionListener((ActionListener)this.delegate);
        }
    }

    private class CellEditorListener2
    implements CellEditorListener {
        private CellEditorListener2() {
        }

        @Override
        public void editingStopped(ChangeEvent ce) {
            Object obj = ce.getSource();
            int rowNum = -1;
            Component comp = null;
            if (obj instanceof RmaCellEditor) {
                RmaCellEditor rce = (RmaCellEditor)obj;
                comp = rce.getComponent();
            } else if (obj instanceof DefaultCellEditor) {
                DefaultCellEditor dce = (DefaultCellEditor)obj;
                comp = dce.getComponent();
            } else {
                System.out.println("editor is a " + obj.getClass());
                return;
            }
            if (comp == null) {
                return;
            }
            Point p = comp.getLocation();
            rowNum = ImpactAreaLocationsEditor.this.impactAreas.rowAtPoint(p);
            if (rowNum > -1) {
                ImpactAreaLocationsEditor.this.setModified(true);
                if (!ImpactAreaLocationsEditor.this._modifiedRows.contains(rowNum)) {
                    ImpactAreaLocationsEditor.this._modifiedRows.add(rowNum);
                }
            }
        }

        @Override
        public void editingCanceled(ChangeEvent ce) {
        }
    }
}

