/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.appInterface.AppDaddy;
import hec.gui.AbstractEditorPanel;
import hec.lang.ClientAppCheck;
import hec.lang.NamedType;
import hec.map.appInterface.MapApplicationFrame;
import hec.model.StreamElement;
import hec.model.StreamSegmentIdentifier;
import hec.watershed.model.Levee;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJTable;
import rma.swing.text.IntegerDocument;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class LeveePanel
extends AbstractEditorPanel
implements ActionListener {
    private RmaJComboBox bankSelector;
    private RmaJDecimalField startStationTxt;
    private RmaJDecimalField endStationTxt;
    private RmaJIntegerField avgOffsetTxt;
    private RmaJCheckBox followsStreamCB;
    private RmaJTable leveeTable;
    private RmaJCheckBox existingProjectCB;
    private RmaJCheckBox isCorpsProjectCB;
    private RmaJIntegerField yearInServiceTxt;
    private RmaJDecimalField breachElevationTxt;
    private Levee _levee;

    public LeveePanel() {
        this.buildControls();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        this.leveeTable = new RmaJTable((Component)((Object)this), new String[]{" \nStream", "Start\nStation", "End\nStation", "Start\nElevation", "End\nElevation"}){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 100;
                return d;
            }
        };
        this.leveeTable.setMlHeaderRenderer();
        this.leveeTable.setPrecision(3);
        this.leveeTable.setColumnEnabled(false, 0);
        this.leveeTable.setDoubleCellEditor(1, true);
        this.leveeTable.setDoubleCellEditor(2, true);
        this.leveeTable.setDoubleCellEditor(3, true);
        this.leveeTable.setDoubleCellEditor(4, true);
        this.leveeTable.setCellSelectionEnabled(false);
        this.leveeTable.setColumnSelectionAllowed(false);
        this.leveeTable.setRowSelectionAllowed(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 4;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add(this.leveeTable.getScrollPane(), gbc);
        JPanel failurePanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 4;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.add(failurePanel, gbc);
        JLabel breachElevation = new JLabel("Most likely breach elevation (from top of levee):");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)0);
        failurePanel.add((Component)breachElevation, gbc);
        this.breachElevationTxt = new RmaJDecimalField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        failurePanel.add((Component)this.breachElevationTxt, gbc);
        JPanel cbPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 4;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.add(cbPanel, gbc);
        this.followsStreamCB = new RmaJCheckBox("Follows Stream");
        this.followsStreamCB.setMnemonic('f');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        cbPanel.add((Component)this.followsStreamCB, gbc);
        this.existingProjectCB = new RmaJCheckBox("Existing Project");
        this.existingProjectCB.setMnemonic('e');
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        cbPanel.add((Component)this.existingProjectCB, gbc);
        this.isCorpsProjectCB = new RmaJCheckBox("Corps Project");
        this.isCorpsProjectCB.setMnemonic('c');
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        cbPanel.add((Component)this.isCorpsProjectCB, gbc);
        JLabel label = new JLabel("Bank:", 4);
        label.setDisplayedMnemonic('b');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)10, (int)0, (int)0);
        this.add(label, gbc);
        this.bankSelector = new RmaJComboBox((Object[])new String[]{"Left", "Right"});
        this.bankSelector.setModifiable(true);
        label.setLabelFor((Component)this.bankSelector);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.add((Component)this.bankSelector, gbc);
        label = new JLabel("Average Offset:", 4);
        label.setDisplayedMnemonic('a');
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 6;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.add(label, gbc);
        this.avgOffsetTxt = new RmaJIntegerField();
        label.setLabelFor((Component)this.avgOffsetTxt);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 6;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add((Component)this.avgOffsetTxt, gbc);
        JPanel yearInServicePanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridwidth = 4;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        this.add(yearInServicePanel, gbc);
        label = new JLabel("Year In Service:", 4);
        label.setDisplayedMnemonic('y');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        yearInServicePanel.add((Component)label, gbc);
        this.yearInServiceTxt = new RmaJIntegerField(0, 5);
        ((IntegerDocument)this.yearInServiceTxt.getDocument()).setLength(4);
        label.setLabelFor((Component)this.yearInServiceTxt);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.ipadx = 20;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        yearInServicePanel.add((Component)this.yearInServiceTxt, gbc);
        this.followsStreamCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LeveePanel.this.setFollowsStreamState(LeveePanel.this.followsStreamCB.isSelected());
            }
        });
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Copy");
        menuItem.addActionListener(this);
        popup.add(menuItem);
        menuItem = new JMenuItem("Delete Stream Entry");
        menuItem.addActionListener(this);
        popup.add(menuItem);
        popup.addSeparator();
        menuItem = new JMenuItem("Select All");
        menuItem.addActionListener(this);
        popup.add(menuItem);
        popup.addSeparator();
        menuItem = new JMenuItem("Print...");
        menuItem.addActionListener(this);
        popup.add(menuItem);
        menuItem = new JMenuItem("Print Preview...");
        menuItem.addActionListener(this);
        popup.add(menuItem);
        menuItem = new JMenuItem("Export...");
        menuItem.addActionListener(this);
        popup.add(menuItem);
        this.leveeTable.setPopupMenu(popup);
    }

    public boolean savePanel() {
        return this.savePanel((NamedType)this._levee);
    }

    public boolean savePanel(NamedType dobj) {
        Levee levee = null;
        if (dobj == null) {
            levee = this._levee;
        } else if (dobj instanceof Levee) {
            levee = (Levee)dobj;
        }
        if (levee == null) {
            return true;
        }
        String bankStr = this.bankSelector.getSelectedItem().toString();
        if (bankStr.equals("Left")) {
            levee.setBank(-1);
        } else if (bankStr.equals("Right")) {
            levee.setBank(1);
        }
        int i = this.avgOffsetTxt.getValue();
        if (!RMAConst.isUndefinedValue((int)i)) {
            levee.setAveOffset(i);
        }
        if (levee.getFollowsStream() && this.followsStreamCB.isSelected()) {
            levee.setLine(null);
        }
        levee.setFollowsStream(this.followsStreamCB.isSelected());
        levee.setIsExisting(this.existingProjectCB.isSelected());
        levee.setIsCorpsProject(this.isCorpsProjectCB.isSelected());
        levee.setYearInService((short)this.yearInServiceTxt.getValue());
        int rows = this.leveeTable.getRowCount();
        this.leveeTable.commitEdit(true);
        Vector<StreamSegmentIdentifier> ssiList = new Vector<StreamSegmentIdentifier>(rows);
        for (i = 0; i < rows; ++i) {
            double d;
            StreamSegmentIdentifier ssi = new StreamSegmentIdentifier();
            StreamElement elem = (StreamElement)this.leveeTable.getCell(i, 0);
            if (elem == null) continue;
            ssi.streamId = elem.getIndex();
            ssi.startStation = d = RMAIO.parseDouble((String)this.leveeTable.getCell(i, 1).toString());
            ssi.endStation = d = RMAIO.parseDouble((String)this.leveeTable.getCell(i, 2).toString());
            d = RMAIO.parseDouble((String)this.leveeTable.getCell(i, 3).toString());
            ssi.setStartElevation(d);
            d = RMAIO.parseDouble((String)this.leveeTable.getCell(i, 4).toString());
            ssi.setEndElevation(d);
            ssiList.addElement(ssi);
        }
        levee.setStreamSegmentList(ssiList);
        levee.setBreachElevation(this.breachElevationTxt.getValueUndefined());
        if (ClientAppCheck.haveClientApp()) {
            MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
            frame.getMapPanel().paintMap();
        }
        return true;
    }

    public void fillPanel(NamedType dobj) {
        if (dobj instanceof Levee) {
            this.fillPanel((Levee)dobj);
        }
    }

    public void fillPanel(Levee levee) {
        this._levee = levee;
        if (this._levee == null) {
            return;
        }
        switch (this._levee.getBank()) {
            case -1: {
                this.bankSelector.setSelectedItem((Object)"Left");
                break;
            }
            case 1: {
                this.bankSelector.setSelectedItem((Object)"Right");
                break;
            }
            default: {
                this.bankSelector.setSelectedItem((Object)"");
            }
        }
        this.existingProjectCB.setSelected(this._levee.isExisting());
        this.isCorpsProjectCB.setSelected(this._levee.isCorpsProject());
        this.avgOffsetTxt.setValue(this._levee.getAveOffset());
        this.followsStreamCB.setSelected(this._levee.getFollowsStream());
        this.setFollowsStreamState(this.followsStreamCB.isSelected());
        this.yearInServiceTxt.setValue((int)this._levee.getYearInService());
        this.breachElevationTxt.setValue(this._levee.getBreachElevation());
        List<StreamSegmentIdentifier> ssiList = this._levee.getStreamSegmentList();
        int size = ssiList.size();
        this.leveeTable.deleteCells();
        for (int i = 0; i < size; ++i) {
            StreamSegmentIdentifier ssi = ssiList.get(i);
            Vector<Object> row = new Vector<Object>(5);
            if (this._alignment != null) {
                StreamElement elem = this._alignment.findReach(ssi.streamId);
                if (elem != null) {
                    row.addElement(elem);
                } else {
                    row.add("");
                }
            } else {
                row.add("");
            }
            row.addElement(new Double(ssi.startStation));
            row.addElement(new Double(ssi.endStation));
            Object value = RMAConst.isValidValue((double)ssi.getStartElevation()) ? new Double(ssi.getStartElevation()) : "";
            row.addElement(value);
            value = RMAConst.isValidValue((double)ssi.getEndElevation()) ? new Double(ssi.getEndElevation()) : "";
            row.addElement(value);
            this.leveeTable.appendRow(row);
        }
    }

    private void setFollowsStreamState(boolean enabled) {
        this.bankSelector.setEnabled(enabled);
        this.avgOffsetTxt.setEnabled(enabled);
    }

    public String getTabname() {
        return "Levee";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)obj;
            String label = mi.getText();
            if (label.equals("Copy")) {
                this.leveeTable.copy();
            } else if (label.equals("Delete Stream Entry")) {
                this.leveeTable.deleteRow();
            } else if (label.equals("Select All")) {
                this.leveeTable.selectAll();
            } else if (label.equals("Print...")) {
                this.leveeTable.printData();
            } else if (label.equals("Print Preview...")) {
                this.leveeTable.printPreview();
            } else if (label.equals("Export...")) {
                this.leveeTable.exportData();
            }
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)((Object)new LeveePanel()), "Center");
        frame.setLocation(250, 250);
        frame.pack();
        frame.setVisible(true);
    }
}

