/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.model.CommonDataList;
import hec.model.DataListLoader;
import hec.model.DataStruct;
import hec.model.StreamElement;
import hec.model.StreamSegmentIdentifier;
import hec.watershed.client.ProjectTablePanel;
import hec.watershed.model.Levee;
import hec.watershed.model.StudyIfc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.table.TableCellEditor;
import rma.swing.RmaJIntegerField;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAIO;

public class LeveeTablePanel
extends ProjectTablePanel {
    private static final String TABNAME = "Levees";
    private static final int NAME_COL = 0;
    private static final int STREAM_COL = 1;
    private static final int BANK_COL = 2;
    private static final int UPSTREAM_COL = 3;
    private static final int DOWNSTREAM_COL = 4;
    private static final int EXISTING_COL = 5;
    private static final int CORPS_COL = 6;
    private static final int YEAR_SERV_COL = 7;
    private static final int FOLLOW_STRM_COL = 8;
    private static final int STRM_OFFSET_COL = 9;
    private static final int DESC_COL = 10;

    public LeveeTablePanel() {
        this.buildControls();
    }

    public void buildControls() {
        boolean[] editable = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, false};
        String[] colNames = new String[]{" \nName", "Stream\nName", "Stream\nBank", "Upstream\nStation", "Downstream\nStation", "Existing\nProject", "Corps\nProject", "Year in\nService", "Follows\nStream", "Offset from\nStream", "Description", ""};
        RmaTableModel tableModel = new RmaTableModel(colNames, new Object[0][0], editable);
        this.setTableModel((RmaTableModelInterface)tableModel);
        this.m_projectTable.setMlHeaderRenderer();
        this.m_projectTable.setPrecision(3);
        this.m_projectTable.setColumnEnabled(false, 1);
        this.m_projectTable.setCheckBoxCellEditor(5);
        this.m_projectTable.setCheckBoxCellEditor(6);
        final JCheckBox checkBox = this.m_projectTable.setCheckBoxCellEditor(8);
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int editingRow = LeveeTablePanel.this.m_projectTable.getEditingRow();
                if (editingRow < 0) {
                    return;
                }
                LeveeTablePanel.this.m_projectTable.setCellEnabled(checkBox.isSelected(), editingRow, 9);
                LeveeTablePanel.this.m_projectTable.repaint();
            }
        });
        Vector<String> banks = new Vector<String>(3);
        banks.add("Left");
        banks.add("Right");
        this.m_projectTable.setComboBoxEditor(2, banks);
        this.m_projectTable.setDoubleCellEditor(3, true);
        this.m_projectTable.getColumnModel().getColumn(3).setCellEditor((TableCellEditor)((Object)new ProjectTablePanel.ProjectDoubleCellEditor(this)));
        this.m_projectTable.setDoubleCellEditor(4, true);
        this.m_projectTable.getColumnModel().getColumn(4).setCellEditor((TableCellEditor)((Object)new ProjectTablePanel.ProjectDoubleCellEditor(this)));
        this.m_projectTable.getColumnModel().getColumn(7).setCellEditor((TableCellEditor)new RmaCellEditor(new RmaJIntegerField()));
        this.m_projectTable.setHorizontalAlignment(4, 7);
        this.m_projectTable.setColumnWidth(0, 150);
        this.m_projectTable.setColumnWidth(colNames.length - 2, 250);
        this.m_projectTable.setColumnVisible(colNames.length - 1, false, 0);
    }

    @Override
    public String getTabname() {
        return TABNAME;
    }

    public boolean savePanel() {
        this.m_projectTable.commitEdit(true);
        for (int row = 0; row < this.m_modifiedRows.size(); ++row) {
            Vector rowData = this.m_projectTable.getRow(this.m_modifiedRows.elementAt(row));
            Levee levee = (Levee)rowData.elementAt(this.m_projectTable.getModel().getColumnCount() - 1);
            levee.setName((String)rowData.elementAt(0));
            String bank = (String)rowData.elementAt(2);
            if (bank != null) {
                if (bank.equals("Left")) {
                    levee.setBank(-1);
                } else if (bank.equals("Right")) {
                    levee.setBank(1);
                } else if (bank.equals("Both")) {
                    levee.setBank(0);
                }
            }
            List<StreamSegmentIdentifier> streamSegmentList = levee.getStreamSegmentList();
            StreamSegmentIdentifier ssid = null;
            if (streamSegmentList != null && streamSegmentList.size() != 0) {
                ssid = streamSegmentList.get(0);
            }
            if (ssid != null) {
                ssid.endStation = RMAIO.parseDouble(rowData.elementAt(3));
                ssid.startStation = RMAIO.parseDouble(rowData.elementAt(4));
            }
            levee.setIsExisting((Boolean)rowData.elementAt(5));
            levee.setIsCorpsProject((Boolean)rowData.elementAt(6));
            levee.setYearInService((short)RMAIO.parseInt(rowData.elementAt(7)));
            levee.setFollowsStream((Boolean)rowData.elementAt(8));
            levee.setAveOffset(RMAIO.parseInt(rowData.elementAt(9)));
            levee.setDescription((String)rowData.elementAt(10));
        }
        this.m_modifiedRows.removeAllElements();
        return true;
    }

    @Override
    public void fillPanel() {
        this.m_projectTable.deleteCells();
        StudyIfc study = super.getOpenStudy();
        if (study == null) {
            return;
        }
        CommonDataList dl = DataListLoader.getDataListLoader().getCommonDataList("hec.watershed.model.Levee");
        if (dl == null) {
            return;
        }
        DataStruct[] dataObjList = dl.getObjectArray();
        int rowCntr = 0;
        for (int row = 0; dataObjList != null && row < dataObjList.length; ++row) {
            Levee levee = (Levee)dataObjList[row];
            if (levee == null) continue;
            Vector<Object> rowData = new Vector<Object>();
            rowData.addElement(levee.getName());
            List<StreamSegmentIdentifier> streamSegmentList = levee.getStreamSegmentList();
            StreamSegmentIdentifier ssid = null;
            if (streamSegmentList == null || streamSegmentList.size() == 0) {
                rowData.addElement(null);
            } else {
                ssid = streamSegmentList.get(0);
                StreamElement elem = this.getStreamElement(ssid.streamId);
                rowData.addElement(elem);
            }
            int bank = levee.getBank();
            if (bank == -1) {
                rowData.addElement("Left");
            } else if (bank == 1) {
                rowData.addElement("Right");
            } else if (bank == 0) {
                rowData.addElement("Both");
            }
            if (ssid == null) {
                rowData.addElement("");
                rowData.addElement("");
            } else {
                rowData.addElement(RMAIO.toTable((double)ssid.endStation));
                rowData.addElement(RMAIO.toTable((double)ssid.startStation));
            }
            rowData.addElement(levee.isExisting());
            rowData.addElement(levee.isCorpsProject());
            rowData.addElement(Short.toString(levee.getYearInService()));
            rowData.addElement(levee.getFollowsStream());
            rowData.addElement(new Integer(levee.getAveOffset()));
            rowData.addElement(levee.getDescription());
            rowData.addElement(levee);
            this.m_projectTable.appendRow(rowData);
            ++rowCntr;
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)((Object)new LeveeTablePanel()), "Center");
        frame.pack();
        frame.setLocation(200, 200);
        frame.setVisible(true);
    }
}

