/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.gui.NameDialog;
import hec.model.CommonDataList;
import hec.watershed.model.ComputationPointLayer;
import hec.watershed.model.ComputationPointLayerContainer;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.list.RmaListModel;

public class NewCompPtDialog
extends NameDialog {
    private JPanel _layerPanel;
    private RmaJComboBox _layerCombo;

    public NewCompPtDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    protected void buildControls() {
        this.setTitle("Name New Computation Point");
        this._layerPanel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("Select Computation Point Layer:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)0, (int)0, (int)5);
        this._layerPanel.add((Component)label, gbc);
        this._layerCombo = new RmaJComboBox();
        this._layerCombo.setToolTipText(null);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)0, (int)0, (int)5);
        this._layerPanel.add((Component)this._layerCombo, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this._layerPanel, gbc);
    }

    public ComputationPointLayer getComputationPointLayout() {
        return (ComputationPointLayer)((Object)this._layerCombo.getSelectedItem());
    }

    public void setComputationPointLayers(CommonDataList cdl) {
        if (cdl == null) {
            return;
        }
        Object[] objs = cdl.getObjectArray();
        RmaListModel newModel = new RmaListModel(true, objs);
        this._layerCombo.setModel((ComboBoxModel)newModel);
        Object defaultLayer = null;
        if (cdl instanceof ComputationPointLayerContainer) {
            defaultLayer = ((ComputationPointLayerContainer)cdl).getDefaultLayer();
        } else if (newModel.getSize() > 0) {
            defaultLayer = objs[0];
        }
        this.setSelectedLayer(defaultLayer);
    }

    protected void setSelectedLayer(Object defaultLayer) {
        if (defaultLayer != null) {
            EventQueue.invokeLater(() -> this._layerCombo.setSelectedItem(defaultLayer));
        }
    }

    public void setSelectedComputationPointLayer(ComputationPointLayer cpl) {
        if (cpl == null) {
            return;
        }
        this._layerCombo.setSelectedItem((Object)cpl);
    }
}

