/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.map.LocalPt;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;

public final class ObsStationSnapPoint {
    private Point[] _dots = new Point[4];
    private int _dotSize;
    private LocalPt _snapToStreamPoint;

    public ObsStationSnapPoint(int dotSize) {
        this._dotSize = dotSize;
    }

    public void draw(Graphics g, LocalPt snapToStreamPoint) {
        this.updatePoints(snapToStreamPoint);
        for (Point dot : this._dots) {
            g.fillOval(dot.x - this._dotSize / 2, dot.y - this._dotSize / 2, this._dotSize, this._dotSize);
        }
    }

    private void updatePoints(LocalPt snapToStreamPoint) {
        this._snapToStreamPoint = snapToStreamPoint;
        this._dots[0] = new Point(snapToStreamPoint.x + this._dotSize, snapToStreamPoint.y + this._dotSize);
        this._dots[1] = new Point(snapToStreamPoint.x - this._dotSize, snapToStreamPoint.y - this._dotSize);
        this._dots[2] = new Point(snapToStreamPoint.x + this._dotSize, snapToStreamPoint.y - this._dotSize);
        this._dots[3] = new Point(snapToStreamPoint.x - this._dotSize, snapToStreamPoint.y + this._dotSize);
    }

    public boolean isClicked(MouseEvent e) {
        for (Point dot : this._dots) {
            if (dot == null) continue;
            return this.isPointInsideRectangle(this._dots, e.getPoint());
        }
        return false;
    }

    public LocalPt getSnapToStreamPoint() {
        return this._snapToStreamPoint;
    }

    private boolean isPointInsideRectangle(Point[] rectangle, Point point) {
        if (rectangle.length != 4) {
            return false;
        }
        int minX = rectangle[0].x;
        int maxX = rectangle[0].x;
        int minY = rectangle[0].y;
        int maxY = rectangle[0].y;
        for (Point p : rectangle) {
            minX = Math.min(minX, p.x);
            maxX = Math.max(maxX, p.x);
            minY = Math.min(minY, p.y);
            maxY = Math.max(maxY, p.y);
        }
        return point.x >= minX && point.x <= maxX && point.y >= minY && point.y <= maxY;
    }

    void setSnapToStreamPoint(LocalPt snapPoint) {
        this.updatePoints(snapPoint);
    }
}

