/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.model.CommonDataList;
import hec.model.DataListLoader;
import hec.model.DataStruct;
import hec.model.StreamElement;
import hec.watershed.client.ProjectTablePanel;
import hec.watershed.model.StoragePool;
import hec.watershed.model.StudyIfc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.table.TableCellEditor;
import rma.swing.RmaJIntegerField;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAIO;

public class OffChannelStorageTablePanel
extends ProjectTablePanel {
    private static final String TABNAME = "Off Channel Storage Area";

    public OffChannelStorageTablePanel() {
        this.buildControls();
    }

    private void buildControls() {
        boolean[] editable = new boolean[]{true, true, true, true, true, true, true, false};
        String[] colNames = new String[]{" \nName", "Stream\nName", "Existing\nProject", "Corps\nProject", "Year in\nService", "Label\nPosition", "Description", ""};
        RmaTableModel tableModel = new RmaTableModel(colNames, new Object[0][0], editable);
        this.setTableModel((RmaTableModelInterface)tableModel);
        this.m_projectTable.setMlHeaderRenderer();
        this.setMapLabelItemColumn(5);
        this.m_projectTable.setCheckBoxCellEditor(2);
        this.m_projectTable.setCheckBoxCellEditor(3);
        this.m_projectTable.getColumnModel().getColumn(4).setCellEditor((TableCellEditor)new RmaCellEditor(new RmaJIntegerField()));
        this.m_projectTable.setComboBoxEditor(5, new Object[0]);
        this.setMapLabelItemColumn(5);
        this.m_projectTable.setColumnWidth(0, 150);
        this.m_projectTable.setColumnWidth(editable.length - 2, 250);
        this.m_projectTable.setColumnVisible(editable.length - 1, false, 0);
    }

    @Override
    public String getTabname() {
        return TABNAME;
    }

    @Override
    public void fillPanel() {
        super.fillPanel();
        this.m_projectTable.deleteCells();
        StudyIfc study = super.getOpenStudy();
        if (study == null) {
            return;
        }
        CommonDataList dl = DataListLoader.getDataListLoader().getCommonDataList("hec.watershed.model.StoragePool");
        if (dl == null) {
            return;
        }
        this.setStreamElementColumn(1);
        DataStruct[] objects = dl.getObjectArray();
        for (int i = 0; i < objects.length; ++i) {
            StoragePool pool = (StoragePool)objects[i];
            Vector<Object> rowData = new Vector<Object>();
            rowData.addElement(pool.getName());
            rowData.addElement(this.getStreamElement(pool.getStreamId()));
            rowData.addElement(pool.isExisting());
            rowData.addElement(pool.isCorpsProject());
            rowData.addElement(new Integer(pool.getYearInService()));
            rowData.addElement(new Integer(pool.getLabelPosition()));
            rowData.addElement(pool.getDescription());
            rowData.addElement(pool);
            this.m_projectTable.appendRow(rowData);
        }
    }

    public boolean savePanel() {
        this.m_projectTable.commitEdit(true);
        for (int i = 0; i < this.m_modifiedRows.size(); ++i) {
            int row = this.m_modifiedRows.elementAt(i);
            Vector rowData = this.m_projectTable.getRow(row);
            if (rowData == null) continue;
            StoragePool pool = (StoragePool)rowData.elementAt(this.m_projectTable.getModel().getColumnCount() - 1);
            pool.setName((String)rowData.elementAt(0));
            StreamElement elem = (StreamElement)rowData.elementAt(1);
            pool.setStreamId(elem != null ? elem.getIndex() : -1);
            pool.setIsExisting((Boolean)rowData.elementAt(2));
            pool.setIsCorpsProject((Boolean)rowData.elementAt(3));
            pool.setYearInService((short)RMAIO.parseInt(rowData.elementAt(4)));
            pool.setLabelPosition((Integer)rowData.elementAt(5));
            pool.setDescription((String)rowData.elementAt(6));
        }
        this.m_modifiedRows.removeAllElements();
        return true;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)((Object)new OffChannelStorageTablePanel()), "Center");
        frame.setLocation(200, 200);
        frame.setSize(200, 200);
        frame.setVisible(true);
    }
}

