/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.clientapp.client.ClientApp;
import hec.gui.AbstractEditorPanel;
import hec.lang.ClientAppCheck;
import hec.lang.NamedType;
import hec.map.MapLabelItem;
import hec.map.WorldPt;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.StreamElement;
import hec.watershed.model.OtherProject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.swing.list.RmaListModel;
import rma.swing.text.IntegerDocument;

public class OtherProjectsPanel
extends AbstractEditorPanel {
    private RmaJDecimalField northingFld;
    private RmaJDecimalField eastingFld;
    private RmaJDecimalField streamStationFld;
    private RmaJIntegerField yearInServiceFld;
    private RmaJCheckBox connectToStreamCB;
    private RmaJCheckBox doNotGenerateCompPt;
    private RmaJComboBox streamList;
    private RmaJCheckBox existingProject;
    private RmaJCheckBox isCorpsProject;
    private RmaJComboBox labelPositionList;
    private RmaJComboBox iconPositionList;
    private OtherProject _project;

    public OtherProjectsPanel() {
        this.buildControls();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        JPanel locationPanel = new JPanel(new GridBagLayout());
        locationPanel.setBorder(new TitledBorder("Computation Point Information:"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(locationPanel, gbc);
        JLabel label = new JLabel("Stream Station:", 2);
        label.setDisplayedMnemonic('s');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 0.0;
        locationPanel.add((Component)label, gbc);
        this.streamStationFld = new RmaJDecimalField();
        label.setLabelFor((Component)this.streamStationFld);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)200);
        gbc.weightx = 1.0;
        locationPanel.add((Component)this.streamStationFld, gbc);
        label = new JLabel("Easting:", 2);
        label.setDisplayedMnemonic('e');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 0.0;
        locationPanel.add((Component)label, gbc);
        this.eastingFld = new RmaJDecimalField();
        label.setLabelFor((Component)this.eastingFld);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)200);
        gbc.weightx = 1.0;
        locationPanel.add((Component)this.eastingFld, gbc);
        label = new JLabel("Northing:", 2);
        label.setDisplayedMnemonic('o');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 0.0;
        locationPanel.add((Component)label, gbc);
        this.northingFld = new RmaJDecimalField();
        label.setLabelFor((Component)this.northingFld);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)200);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        locationPanel.add((Component)this.northingFld, gbc);
        label = new JLabel("Label Position:", 2);
        label.setDisplayedMnemonic('L');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 0.0;
        locationPanel.add((Component)label, gbc);
        this.labelPositionList = new RmaJComboBox((Object[])MapLabelItem.POSITION_STRINGS);
        this.labelPositionList.setModifiable(true);
        label.setLabelFor((Component)this.labelPositionList);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)200);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        locationPanel.add((Component)this.labelPositionList, gbc);
        this.doNotGenerateCompPt = new RmaJCheckBox("Do Not Generate Computation Point");
        this.doNotGenerateCompPt.setMnemonic('g');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        locationPanel.add((Component)this.doNotGenerateCompPt, gbc);
        JPanel cbPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        gbc.weightx = 1.0;
        this.add(cbPanel, gbc);
        label = new JLabel("Stream Name:", 2);
        label.setDisplayedMnemonic('s');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 0.0;
        cbPanel.add((Component)label, gbc);
        this.streamList = new RmaJComboBox((ComboBoxModel)new RmaListModel(true));
        this.streamList.setModifiable(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        cbPanel.add((Component)this.streamList, gbc);
        this.connectToStreamCB = new RmaJCheckBox("Connect to Stream");
        this.connectToStreamCB.setMnemonic('c');
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 1.0;
        cbPanel.add((Component)this.connectToStreamCB, gbc);
        label = new JLabel("Year in Service:", 2);
        label.setDisplayedMnemonic('y');
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 1.0;
        cbPanel.add((Component)label, gbc);
        this.yearInServiceFld = new RmaJIntegerField(0, 5);
        ((IntegerDocument)this.yearInServiceFld.getDocument()).setLength(4);
        label.setLabelFor((Component)this.yearInServiceFld);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 1.0;
        cbPanel.add((Component)this.yearInServiceFld, gbc);
        label = new JLabel("Icon Position:", 2);
        label.setDisplayedMnemonic('I');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 0.0;
        cbPanel.add((Component)label, gbc);
        this.iconPositionList = new RmaJComboBox((Object[])MapLabelItem.POSITION_STRINGS);
        this.iconPositionList.setModifiable(true);
        label.setLabelFor((Component)this.iconPositionList);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        cbPanel.add((Component)this.iconPositionList, gbc);
        this.existingProject = new RmaJCheckBox("Existing Project");
        this.existingProject.setMnemonic('e');
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 0.0;
        cbPanel.add((Component)this.existingProject, gbc);
        this.isCorpsProject = new RmaJCheckBox("Corps Project");
        this.isCorpsProject.setMnemonic('c');
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 0.0;
        cbPanel.add((Component)this.isCorpsProject, gbc);
        this.connectToStreamCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OtherProjectsPanel.this.connectToStreamAction();
            }
        });
    }

    public String getTabname() {
        return "Project";
    }

    public void setStreamAlignment(StreamAlignmentIfc alignment) {
        super.setStreamAlignment(alignment);
        this.fillStreamList(this._alignment);
    }

    protected void connectToStreamAction() {
        this.streamList.setEnabled(this.connectToStreamCB.isSelected());
        this.updateCoordinates();
        this.updateSnapToStream();
    }

    public void fillPanel(NamedType obj) {
        if (obj instanceof OtherProject) {
            this.fillPanel((OtherProject)obj);
        }
    }

    public void fillPanel(OtherProject proj) {
        StreamElement elem;
        this._project = proj;
        if (proj == null) {
            return;
        }
        this.streamStationFld.setValue(proj.getStreamStation());
        WorldPt pt = proj.getReferencePt();
        this.northingFld.setValue(pt.n);
        this.eastingFld.setValue(pt.e);
        boolean b = proj.isConnectedToStream();
        this.connectToStreamCB.setSelected(b);
        this.doNotGenerateCompPt.setSelected(!proj.getGenerateCompPt());
        this.existingProject.setSelected(proj.isExisting());
        this.isCorpsProject.setSelected(proj.isCorpsProject());
        this.yearInServiceFld.setValue((int)proj.getYearInService());
        this.labelPositionList.setSelectedIndex(proj.getLabelPosition());
        this.iconPositionList.setSelectedIndex(proj.getIconPosition());
        int id = proj.getStreamId();
        if (this._alignment != null && (elem = this._alignment.findReach(id)) != null) {
            this.streamList.setSelectedItem((Object)elem);
        }
        this.updateSnapToStream();
    }

    protected void fillStreamList(StreamAlignmentIfc alignment) {
        Vector list = alignment.getElementVector();
        this.streamList.setModel((ComboBoxModel)new RmaListModel(true, (Collection)list));
    }

    public boolean savePanel() {
        return this.savePanel((NamedType)this._project);
    }

    public boolean savePanel(NamedType dobj) {
        StreamElement elem;
        OtherProject project = null;
        if (dobj == null) {
            project = this._project;
        } else if (dobj instanceof OtherProject) {
            project = (OtherProject)dobj;
        }
        if (project == null) {
            return true;
        }
        WorldPt pt = new WorldPt(this.eastingFld.getValueUndefined(), this.northingFld.getValueUndefined());
        project.setReferencePt(pt);
        project.setGenerateCompPt(!this.doNotGenerateCompPt.isSelected());
        project.setConnectedtoStream(this.connectToStreamCB.isSelected());
        project.setIsExisting(this.existingProject.isSelected());
        project.setIsCorpsProject(this.isCorpsProject.isSelected());
        project.setYearInService((short)this.yearInServiceFld.getValue());
        project.setLabelPosition(this.labelPositionList.getSelectedIndex());
        project.setIconPosition(this.iconPositionList.getSelectedIndex());
        if (this.connectToStreamCB.isSelected() && (elem = (StreamElement)this.streamList.getSelectedItem()) != null) {
            project.setStreamId(elem.getIndex());
        }
        if (ClientAppCheck.haveClientApp()) {
            ClientApp.app();
            ClientApp.frame().getMapPanel().paintMap();
        }
        return true;
    }

    private void updateCoordinates() {
        StreamElement reach = (StreamElement)this.streamList.getSelectedItem();
        if (this.connectToStreamCB.isSelected() && this._project != null) {
            WorldPt wpt = new WorldPt(this.eastingFld.getValueUndefined(), this.northingFld.getValueUndefined());
            if (!wpt.isValid()) {
                return;
            }
            double station = reach.getStationByLocation(wpt);
            WorldPt pt = reach.getLocationByStation(station);
            if (pt.isValid()) {
                this.eastingFld.setValue(pt.e);
                this.northingFld.setValue(pt.n);
            }
        }
    }

    private void updateSnapToStream() {
        boolean b = this.connectToStreamCB.isSelected();
        this.eastingFld.setEditable(!b);
        this.northingFld.setEditable(!b);
    }
}

