/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.map.WorldPt;
import hec.model.CommonDataList;
import hec.model.DataListLoader;
import hec.model.DataStruct;
import hec.model.StreamElement;
import hec.watershed.client.ProjectTablePanel;
import hec.watershed.model.OtherProject;
import hec.watershed.model.StudyIfc;
import java.util.Vector;
import javax.swing.table.JTableHeader;
import rma.swing.RmaJIntegerField;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAIO;

public class OtherProjectsTablePanel
extends ProjectTablePanel {
    private static final String TABNAME = "Other Projects";
    private static final int YEAR_IN_SERVICE_COL = 5;

    public OtherProjectsTablePanel() {
        this.buildControls();
    }

    private void buildControls() {
        boolean[] editable = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, false};
        String[] colNames = new String[]{" \n \nName", " \nStream\nName", " \nConnect\nto Stream", " \nExisting\nProject", " \nCorps\nProject", " \nYear in\nService", " \nLabel\nPosition", "Stream\nStation", " \nEasting", " \nNorthing", "Label\nPosition", "Do Not Generate\nComputation Point", " \n \nDescription", ""};
        RmaTableModel tableModel = new RmaTableModel(colNames, new Object[0][0], editable);
        this.setTableModel((RmaTableModelInterface)tableModel);
        this.m_projectTable.setMlHeaderRenderer();
        GroupableTableHeader header = new GroupableTableHeader(this.m_projectTable.getColumnModel());
        this.m_projectTable.setTableHeader((JTableHeader)header);
        ColumnGroup cg = new ColumnGroup("Common Computation Point Information");
        for (int i = 7; i <= 11; ++i) {
            cg.add((Object)this.m_projectTable.getColumnModel().getColumn(i));
        }
        header.addColumnGroup(cg);
        this.m_projectTable.setColumnEditor(5, new RmaCellEditor(new RmaJIntegerField()));
        this.m_projectTable.setHorizontalAlignment(4, 5);
        this.m_projectTable.setCheckBoxCellEditor(2);
        this.m_projectTable.setCheckBoxCellEditor(3);
        this.m_projectTable.setCheckBoxCellEditor(4);
        this.m_projectTable.setCheckBoxCellEditor(11);
        this.m_projectTable.setDoubleCellEditor(7, 9, true);
        this.setMapLabelItemColumn(6);
        this.setMapLabelItemColumn(10);
        this.m_projectTable.setColumnWidth(editable.length - 2, 250);
        this.m_projectTable.setColumnVisible(editable.length - 1, false, 0);
    }

    @Override
    public String getTabname() {
        return TABNAME;
    }

    public boolean savePanel() {
        this.m_projectTable.commitEdit(true);
        for (int row = 0; row < this.m_modifiedRows.size(); ++row) {
            Vector rowData = this.m_projectTable.getRow(this.m_modifiedRows.elementAt(row));
            OtherProject op = (OtherProject)rowData.elementAt(this.m_projectTable.getModel().getColumnCount() - 1);
            op.setName((String)rowData.elementAt(0));
            StreamElement stream = (StreamElement)rowData.elementAt(1);
            op.setStreamId(stream != null ? stream.getIndex() : -1);
            op.setConnectedtoStream((Boolean)rowData.elementAt(2));
            op.setIsExisting((Boolean)rowData.elementAt(3));
            op.setIsCorpsProject((Boolean)rowData.elementAt(4));
            op.setYearInService((short)RMAIO.parseInt(rowData.elementAt(10)));
            op.setLabelPosition((Integer)rowData.elementAt(6));
            op.setStreamStation(RMAIO.parseDouble(rowData.elementAt(7)));
            double easting = RMAIO.parseDouble(rowData.elementAt(8));
            double northing = RMAIO.parseDouble(rowData.elementAt(9));
            op.setLabelPosition((Integer)rowData.elementAt(10));
            WorldPt pt = new WorldPt(easting, northing);
            op.setReferencePt(pt);
            op.setGenerateCompPt((Boolean)rowData.elementAt(11) == false);
            op.setDescription((String)rowData.elementAt(12));
        }
        this.m_modifiedRows.removeAllElements();
        return true;
    }

    @Override
    public void fillPanel() {
        super.fillPanel();
        this.setStreamElementColumn(1);
        this.m_projectTable.deleteCells();
        StudyIfc study = super.getOpenStudy();
        if (study == null) {
            return;
        }
        CommonDataList dl = DataListLoader.getDataListLoader().getCommonDataList("hec.watershed.model.OtherProject");
        if (dl == null) {
            return;
        }
        DataStruct[] dataObjList = dl.getObjectArray();
        for (int i = 0; dataObjList != null && i < dataObjList.length; ++i) {
            OtherProject op = (OtherProject)dataObjList[i];
            if (op == null) continue;
            Vector<Object> rowData = new Vector<Object>();
            rowData.addElement(op.getName());
            rowData.addElement(this.getStreamElement(op.getStreamId()));
            rowData.addElement(op.isConnectedToStream());
            rowData.addElement(op.isExisting());
            rowData.addElement(op.isCorpsProject());
            rowData.addElement(new Integer(op.getYearInService()));
            rowData.addElement(new Integer(op.getLabelPosition()));
            rowData.addElement(new Double(op.getStreamStation()));
            rowData.addElement(new Double(op.getReferencePt().e));
            rowData.addElement(new Double(op.getReferencePt().n));
            rowData.addElement(new Integer(op.getLabelPosition()));
            rowData.addElement(!op.getGenerateCompPt());
            rowData.addElement(op.getDescription());
            rowData.addElement(op);
            this.m_projectTable.appendRow(rowData);
        }
        this.m_projectTable.setColumnEnabled(false, 8);
        this.m_projectTable.setColumnEnabled(false, 9);
    }
}

