/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.model.StreamElement;
import hec.model.StreamJunction;
import hec.watershed.client.NewCompPtDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.list.RmaListModel;

public class PlaceCompPtDialog
extends NewCompPtDialog {
    private static final String NONE_OF_THE_ABOVE = "None of the above";
    private static final String AT_THE_JUNCTION = "At the Stream Junction";
    private RmaJComboBox _locationCombo;
    private StreamJunction _junction;
    private JPanel _locationPanel;

    public PlaceCompPtDialog(Frame parent, boolean modal) {
        super(parent, modal);
    }

    @Override
    protected void buildControls() {
        super.buildControls();
        this.setTitle("Name new Computation Point");
        this._locationPanel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("Select the placement of the Computation Point:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)0, (int)0, (int)5);
        this._locationPanel.add((Component)label, gbc);
        this._locationCombo = new RmaJComboBox();
        this._locationCombo.setToolTipText(null);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)0, (int)0, (int)5);
        this._locationPanel.add((Component)this._locationCombo, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this._locationPanel, gbc);
        this.pack();
        this.setLocation();
    }

    public void setJunction(StreamJunction junction) {
        this._junction = junction;
        if (junction == null) {
            this._locationCombo.setModel((ComboBoxModel)new RmaListModel(true));
            return;
        }
        RmaListModel model = new RmaListModel(false);
        model.addElement((Object)AT_THE_JUNCTION);
        Vector streams = new Vector();
        int cnt = junction.getInflowingStreams(streams);
        for (int i = 0; i < streams.size(); ++i) {
            model.addElement(streams.get(i));
        }
        streams.clear();
        cnt = junction.getOutflowingStreams(streams);
        for (int i = 0; i < streams.size(); ++i) {
            Object obj = streams.get(i);
            if (model.contains(obj)) continue;
            model.addElement(obj);
        }
        model.addElement((Object)NONE_OF_THE_ABOVE);
        this._locationCombo.setModel((ComboBoxModel)model);
    }

    public Object getSelectedObject() {
        Object obj = this._locationCombo.getSelectedItem();
        if (obj instanceof StreamElement) {
            return obj;
        }
        if (AT_THE_JUNCTION.equals(obj)) {
            return this._junction;
        }
        return null;
    }
}

