/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.appInterface.AppDaddy;
import hec.appInterface.ApplicationModule;
import hec.watershed.client.ConditionListContainer;
import hec.watershed.client.ProjectNotesJDialog;
import hec.watershed.client.StudyMapSelectionEditor;
import hec.watershed.event.ConditionEvent;
import hec.watershed.event.ConditionListener;
import hec.watershed.model.Condition;
import hec.watershed.model.Project;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class ProjectEditor
extends StudyMapSelectionEditor
implements ItemListener,
ConditionListener {
    protected ConditionListContainer _mode;
    protected String _title;

    public ProjectEditor(Frame parent, boolean modal) {
        super(parent, modal);
        this.init();
    }

    public ProjectEditor(Dialog parent, boolean modal) {
        super(parent, modal);
        this.init();
    }

    private void init() {
        this.buildMenus();
        if (this._mode == null) {
            return;
        }
        this._mode.addConditionListListener(this);
        Condition c = this._mode.getSelectedCondition();
        if (c != null) {
            c.addConditionListener(this);
        }
    }

    private void buildMenus() {
        JMenuBar mb = new JMenuBar();
        JMenu menu = new JMenu("Project");
        menu.setMnemonic('p');
        mb.add(menu);
        JMenuItem menuItem = new JMenuItem("Close", 99);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectEditor.this.windowClosing();
                ProjectEditor.this.setVisible(false);
            }
        });
        menu.add(menuItem);
        ApplicationModule ap = AppDaddy.getFrame().getCurrentModule();
        if (!(ap instanceof ConditionListContainer)) {
            return;
        }
        this._mode = (ConditionListContainer)ap;
        menu = new JMenu("Edit");
        menu.setMnemonic('e');
        mb.add(menu);
        menuItem = new JMenuItem("Notes...", 110);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectEditor.this.editNotes();
            }
        });
        menu.add(menuItem);
        this.setJMenuBar(mb);
    }

    public void editNotes() {
        if (this._mode == null) {
            return;
        }
        ProjectNotesJDialog notesDialog = new ProjectNotesJDialog((Dialog)((Object)this), true);
        Condition c = this._mode.getSelectedCondition();
        notesDialog.fillForm(c);
        if (c == null || c.isStudyCondition()) {
            notesDialog.setNotesVisible(false);
        } else {
            notesDialog.setNotesVisible(true);
        }
        notesDialog.setSelectedProject((Project)this.selectorPanel.getSelectedItem());
        notesDialog.setVisible(true);
        this.repaint();
    }

    @Override
    protected void updateSelectionList() {
        if (this._mode == null) {
            return;
        }
        Condition c = this._mode.getSelectedCondition();
        if (c == null) {
            return;
        }
        Vector v = c.getProjects(this._objectType);
        this.windowClosing();
        this.setSelectionList(v);
    }

    @Override
    public void conditionChanged(ConditionEvent e) {
        if (!e.getProject().getType().equals(this._objectType)) {
            return;
        }
        if (e.getType() == 0 || e.getType() == 1) {
            this.updateSelectionList();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Condition c;
        if (e.getStateChange() == 2) {
            Object obj = e.getItem();
            if (obj instanceof Condition) {
                ((Condition)obj).removeConditionListener(this);
            }
            return;
        }
        if (this._mode != null && (c = this._mode.getSelectedCondition()) != null) {
            c.addConditionListener(this);
            this.setTitle(this._title);
        }
        this.updateSelectionList();
    }

    public void setTitle(String title) {
        Condition c;
        this._title = title;
        if (this._mode != null && (c = this._mode.getSelectedCondition()) != null) {
            super.setTitle(title);
            return;
        }
        super.setTitle(title);
    }
}

