/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.gui.AbstractEditorPanel;
import hec.model.DataObject;
import hec.watershed.client.ChannelModificationPanel;
import hec.watershed.client.ComputationPointPanel;
import hec.watershed.client.DiversionProjectPanel;
import hec.watershed.client.GenericProjectPanel;
import hec.watershed.client.LeveePanel;
import hec.watershed.client.OtherProjectsPanel;
import hec.watershed.client.ProjectEditor;
import hec.watershed.model.ChannelMod;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.Diversion;
import hec.watershed.model.Levee;
import hec.watershed.model.OtherProject;
import hec.watershed.model.Project;
import hec.watershed.model.Reservoir;
import javax.swing.JDialog;

public class ProjectEditorPanelFactory {
    public static AbstractEditorPanel getPanelForObject(DataObject dobj, ProjectEditor pe) {
        if (dobj == null) {
            return null;
        }
        if (dobj instanceof Levee) {
            return new LeveePanel();
        }
        if (dobj instanceof ComputationPoint) {
            return new ComputationPointPanel((JDialog)((Object)pe));
        }
        if (dobj instanceof OtherProject) {
            return new OtherProjectsPanel();
        }
        if (dobj instanceof Diversion) {
            DiversionProjectPanel dpp = new DiversionProjectPanel();
            dpp.setStreamListEnabled(false);
            return dpp;
        }
        if (dobj instanceof Reservoir) {
            GenericProjectPanel gpp = new GenericProjectPanel();
            gpp.setStreamListEnabled(false);
            return gpp;
        }
        if (dobj instanceof ChannelMod) {
            return new ChannelModificationPanel();
        }
        if (dobj instanceof Project) {
            return new GenericProjectPanel();
        }
        return null;
    }
}

