/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.watershed.model.Condition;
import hec.watershed.model.Project;
import hec.watershed.model.ProjectRef;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTextArea;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;

public class ProjectNotesJDialog
extends RmaJDialog {
    private Condition _condition;
    private RmaJComboBox projectsList;
    private RmaJTextArea projectDescription;
    private RmaJTextArea projectNotes;
    private ButtonCmdPanel cmdPanel;
    private RmaJTextField configurationText;
    private JLabel notesLabel;
    JScrollPane notesSP;

    public ProjectNotesJDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    public ProjectNotesJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Notes:");
        this.setSize(400, 250);
        this.setLocation();
        JLabel label = new JLabel("Configuration:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        this.configurationText = new RmaJTextField();
        this.configurationText.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 12;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.fill = 2;
        this.getContentPane().add((Component)this.configurationText, gbc);
        label = new JLabel("Project Name:", 4);
        label.setDisplayedMnemonic('p');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        this.projectsList = new RmaJComboBox((ComboBoxModel)new RmaListModel(true));
        label.setLabelFor((Component)this.projectsList);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 2.0;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.fill = 2;
        this.getContentPane().add((Component)this.projectsList, gbc);
        this.notesLabel = new JLabel("Configuration Notes:");
        this.notesLabel.setDisplayedMnemonic('n');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.fill = 0;
        this.getContentPane().add((Component)this.notesLabel, gbc);
        this.projectNotes = new RmaJTextArea(4, 40);
        this.projectNotes.setWrapStyleWord(true);
        this.projectNotes.setLineWrap(true);
        this.notesLabel.setLabelFor((Component)this.projectNotes);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 2.0;
        gbc.weighty = 5.0;
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.fill = 1;
        this.notesSP = new JScrollPane((Component)this.projectNotes);
        this.getContentPane().add((Component)this.notesSP, gbc);
        this.cmdPanel = new ButtonCmdPanel(14);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.weightx = 2.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 3;
        gbc.anchor = 16;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gbc.fill = 2;
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.projectsList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                ProjectNotesJDialog.this.fillForm((Project)ProjectNotesJDialog.this.projectsList.getSelectedItem());
            }
        });
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                int id = e.getID();
                switch (e.getID()) {
                    case 8: {
                        if (ProjectNotesJDialog.this.isModified()) {
                            ProjectNotesJDialog.this.saveForm();
                        }
                        ProjectNotesJDialog.this.setVisible(false);
                        break;
                    }
                    case 2: {
                        ProjectNotesJDialog.this.saveForm();
                        break;
                    }
                    case 4: {
                        ProjectNotesJDialog.this.windowClosing();
                        ProjectNotesJDialog.this.setVisible(false);
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProjectNotesJDialog.this.windowClosing();
            }
        });
    }

    public void setNotesVisible(boolean b) {
        this.projectNotes.setVisible(b);
        this.notesLabel.setVisible(b);
        this.notesSP.setVisible(b);
        this.pack();
    }

    public void fillForm(Condition c) {
        if (c == null) {
            return;
        }
        this._condition = c;
        Vector projects = c.getProjects();
        RmaListModel newModel = projects == null ? new RmaListModel(true, new Vector()) : new RmaListModel(true, (Collection)projects);
        this.projectsList.setModel((ComboBoxModel)newModel);
        this.fillForm((Project)this.projectsList.getSelectedItem());
    }

    private void fillForm(Project proj) {
        this.clearForm();
        if (proj == null) {
            return;
        }
        ProjectRef ref = this._condition.findProjectRef(proj);
        this.configurationText.setText(this._condition.getName());
        if (ref != null) {
            this.projectNotes.setText(ref.getNotes());
        }
        this.setModified(false);
    }

    public void setSelectedProject(Project proj) {
        if (proj == null) {
            return;
        }
        Project selProj = (Project)this.projectsList.getSelectedItem();
        if (proj == selProj) {
            this.fillForm(proj);
            return;
        }
        this.projectsList.setSelectedItem((Object)proj);
    }

    private void windowClosing() {
        int opt;
        if (this.isModified() && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Data has changed. Save Changes?", "Confirm Changes", 0)) == 0) {
            this.saveForm();
        }
    }

    private void saveForm() {
        Project proj = (Project)this.projectsList.getSelectedItem();
        if (proj == null) {
            return;
        }
        ProjectRef ref = this._condition.findProjectRef(proj);
        if (ref != null) {
            ref.setNotes(this.projectNotes.getText());
        }
        proj.save();
        this._condition.save();
        this.setModified(false);
    }

    public static void main(String[] args) {
        ProjectNotesJDialog jdlg = new ProjectNotesJDialog(new JFrame(), true);
        jdlg.setLocation(200, 200);
        jdlg.setVisible(true);
    }
}

