/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.clientapp.client.MapLabelItemEditor;
import hec.clientapp.client.MapLabelItemRenderer;
import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.map.MapLabelItem;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.CommonDataList;
import hec.model.DataListLoader;
import hec.model.StreamElement;
import hec.watershed.model.StudyContainer;
import hec.watershed.model.StudyIfc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJTable;
import rma.swing.RmaJTableSorter;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaTableModelInterface;
import rma.util.IntVector;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ProjectTablePanel
extends AbstractEditorPanel {
    protected RmaJTable m_projectTable;
    protected IntVector m_modifiedRows;
    RmaJTableSorter m_sortingTableModel = null;
    protected static final int TABLE_PRECISION = 3;

    public ProjectTablePanel() {
        this.buildControls();
        this.m_modifiedRows = new IntVector();
    }

    private void buildControls() {
        this.m_projectTable = new RmaJTable((Component)((Object)this)){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(600, 250);
            }
        };
        this.m_projectTable.setAutoResizeMode(0);
        this.m_projectTable.setMlHeaderRenderer();
        this.addPopupMenu(this.m_projectTable);
        this.setLayout(new GridBagLayout());
        this.add(this.m_projectTable.getScrollPane(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.m_projectTable.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent ce) {
                Object obj = ce.getSource();
                int rowNum = -1;
                Component comp = null;
                if (obj instanceof RmaCellEditor) {
                    RmaCellEditor rce = (RmaCellEditor)obj;
                    comp = rce.getComponent();
                } else if (obj instanceof DefaultCellEditor) {
                    DefaultCellEditor dce = (DefaultCellEditor)obj;
                    comp = dce.getComponent();
                } else {
                    System.out.println("editor is a " + obj.getClass());
                    return;
                }
                if (comp == null) {
                    return;
                }
                Point p = comp.getLocation();
                rowNum = ProjectTablePanel.this.m_projectTable.rowAtPoint(p);
                if (rowNum > -1) {
                    if (ProjectTablePanel.this.m_sortingTableModel != null) {
                        rowNum = ProjectTablePanel.this.m_sortingTableModel.getMappedRow(rowNum);
                    }
                    if (!ProjectTablePanel.this.m_modifiedRows.contains(rowNum)) {
                        ProjectTablePanel.this.m_modifiedRows.add(rowNum);
                    }
                }
            }

            @Override
            public void editingCanceled(ChangeEvent ce) {
            }
        });
    }

    private void addPopupMenu(RmaJTable table) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem mi = new JMenuItem("Print...");
        mi.setActionCommand("print");
        mi.addActionListener((ActionListener)table);
        popupMenu.add(mi);
        mi = new JMenuItem("Print Preview...");
        mi.setActionCommand("printPreview");
        mi.addActionListener((ActionListener)table);
        popupMenu.add(mi);
        mi = new JMenuItem("Export...");
        mi.setActionCommand("export");
        mi.addActionListener((ActionListener)table);
        popupMenu.add(mi);
        table.setPopupMenu(popupMenu);
    }

    protected void setStreamElementColumn(int column) {
        Vector elements = this.getStreamElements();
        this.m_projectTable.setComboBoxEditor(column, elements != null ? elements : new Vector());
    }

    protected void setMapLabelItemColumn(int column) {
        JComboBox<String> comboBox = new JComboBox<String>(MapLabelItem.POSITION_STRINGS);
        this.m_projectTable.getColumnModel().getColumn(column).setCellRenderer((TableCellRenderer)new MapLabelItemRenderer());
        this.m_projectTable.getColumnModel().getColumn(column).setCellEditor((TableCellEditor)new MapLabelItemEditor(comboBox));
    }

    protected void setTableModel(RmaTableModelInterface model) {
        this.m_sortingTableModel = new RmaJTableSorter(model, 0){

            public void tableChanged(TableModelEvent e) {
                this.fireTableChanged(e);
            }
        };
        this.m_projectTable.setModel((TableModel)this.m_sortingTableModel);
    }

    public String getTabname() {
        return "";
    }

    public boolean savePanel(NamedType dobj) {
        return true;
    }

    public void fillPanel(NamedType dobj) {
    }

    public void fillPanel() {
    }

    public void print() {
        this.m_projectTable.printData();
    }

    protected StudyIfc getOpenStudy() {
        CommonDataList cdl = DataListLoader.getDataListLoader().getCommonDataList("ressim.hec.watershed.model.Study", "");
        if (!(cdl instanceof StudyContainer)) {
            return null;
        }
        StudyContainer sdl = (StudyContainer)cdl;
        return sdl.getOpenStudy();
    }

    protected StreamElement getStreamElement(int streamId) {
        StreamAlignmentIfc alignment = DataListLoader.getDataListLoader().getStreamAlignment();
        if (alignment == null) {
            return null;
        }
        StreamElement elem = alignment.getReach(streamId);
        return elem;
    }

    protected Vector getStreamElements() {
        StreamAlignmentIfc alignment = DataListLoader.getDataListLoader().getStreamAlignment();
        if (alignment == null) {
            return null;
        }
        Vector elements = alignment.getElementVector();
        return elements;
    }

    public Vector getPanelMenus() {
        Vector<JMenu> v = new Vector<JMenu>();
        JMenu menu = new JMenu("Sort");
        JMenuItem menuItem = new JMenuItem("Alphabetic");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectTablePanel.this.sortTableAlphabetically();
            }
        });
        v.addElement(menu);
        return v;
    }

    protected void sortTableAlphabetically() {
        if (this.m_sortingTableModel == null) {
            return;
        }
        this.m_sortingTableModel.sortByColumn(0, true);
    }

    protected class ProjectDoubleCellEditor
    extends RmaCellEditor {
        public ProjectDoubleCellEditor() {
            this(new RmaJDecimalField(0, 5));
            RmaJDecimalField cfr_ignored_0 = (RmaJDecimalField)this.editorComponent;
            ((RmaJDecimalField)this.editorComponent).setHorizontalAlignment(4);
            ((RmaJDecimalField)this.editorComponent).setPrecision(3);
        }

        public ProjectDoubleCellEditor(final RmaJDecimalField textField) {
            this.editorComponent = textField;
            this.clickCountToStart = 2;
            this.delegate = new RmaCellEditor.EditorDelegate(){

                public void setValue(Object value) {
                    double dvalue = RMAIO.parseDouble((Object)value);
                    if (RMAConst.isValidValue((double)dvalue)) {
                        textField.setValue(dvalue);
                    } else {
                        textField.setText("");
                    }
                }

                public Object getCellEditorValue() {
                    return textField.getText();
                }
            };
            textField.addActionListener((ActionListener)this.delegate);
        }
    }
}

