/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.appInterface.AppDaddy;
import hec.gui.AbstractEditorPanel;
import hec.gui.PanelEditor;
import hec.lang.NamedType;
import hec.map.appInterface.MapApplicationFrame;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.watershed.client.ChannelModificationTablePanel;
import hec.watershed.client.DiversionTablePanel;
import hec.watershed.client.LeveeTablePanel;
import hec.watershed.client.OffChannelStorageTablePanel;
import hec.watershed.client.OtherProjectsTablePanel;
import hec.watershed.client.ProjectTablePanel;
import hec.watershed.client.ReservoirTablePanel;
import hec.watershed.client.StudySystemMapGlyph;
import hec.watershed.model.Project;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.ButtonCmdPanel;
import rma.swing.RmaJTable;

public class ProjectsListEditor
extends PanelEditor {
    RmaJTable projectTable;
    ButtonCmdPanel cmdPanel;
    StreamAlignmentIfc _alignment;

    public ProjectsListEditor(Frame parent, boolean modal) {
        super(parent, modal);
        this.setTitle(AppDaddy.getWorkspace().getTitleName() + "- Projects Editor");
        this.buildControls();
    }

    private void buildControls() {
        this.addPanel(new ReservoirTablePanel());
        this.addPanel(new LeveeTablePanel());
        this.addPanel(new DiversionTablePanel());
        this.addPanel(new ChannelModificationTablePanel());
        this.addPanel(new OffChannelStorageTablePanel());
        this.addPanel(new OtherProjectsTablePanel());
        this.buildMenus();
        this.updateMenuBar();
        this.getTabbedPane().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ProjectsListEditor.this.updateMenuBar();
            }
        });
        this.pack();
    }

    private void updateMenuBar() {
        for (int i = 1; i < this.getJMenuBar().getMenuCount(); ++i) {
            this.getJMenuBar().remove(i);
        }
        Vector menus = ((AbstractEditorPanel)this.getTabbedPane().getSelectedComponent()).getPanelMenus();
        if (menus != null) {
            for (int i = 0; i < menus.size(); ++i) {
                this.getJMenuBar().add((JMenu)menus.elementAt(i));
            }
        }
        this.getJMenuBar().repaint();
    }

    private void buildMenus() {
        JMenuBar mb = new JMenuBar();
        JMenu menu = new JMenu("Project");
        mb.add(menu);
        menu.setMnemonic('p');
        JMenuItem menuItem = new JMenuItem("Close", 99);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2, false));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectsListEditor.this.windowClosing();
            }
        });
        menu.add(menuItem);
        this.setJMenuBar(mb);
    }

    public void setAlignment(StreamAlignmentIfc alignment) {
        this._alignment = alignment;
    }

    private void configureProjectsTable() {
    }

    public void fillForm() {
        for (int i = 0; i < this._panelList.size(); ++i) {
            ProjectTablePanel tab = (ProjectTablePanel)((Object)this._panelList.elementAt(i));
            tab.fillPanel();
        }
        this.setModified(false);
    }

    public boolean saveForm(NamedType dobj) {
        int count = this._panelList.size();
        for (int i = 0; i < count; ++i) {
            Object obj = this._panelList.elementAt(i);
            if (!(obj instanceof AbstractEditorPanel)) continue;
            ((AbstractEditorPanel)obj).savePanel();
        }
        this.setModified(false);
        if (AppDaddy.getFrame() != null) {
            MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
            frame.getMapPanel().paintMap();
        }
        return true;
    }

    public void deleteProject() {
        MapApplicationFrame frame;
        StudySystemMapGlyph glyph;
        int selRow = this.projectTable.getSelectedRow();
        if (selRow < 0) {
            return;
        }
        Project project = (Project)this.projectTable.getCell(selRow, 0);
        if (project == null) {
            return;
        }
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Ok to Delete " + project.getUserDisplayedType() + " " + project.getName() + "?", "Confirm Delete", 0);
        if (opt == 1) {
            return;
        }
        if (project.getDataList().removeObject(project.getId())) {
            this.projectTable.deleteRow();
        }
        if ((glyph = (StudySystemMapGlyph)(frame = (MapApplicationFrame)AppDaddy.getFrame()).getMapPanel().findGlyphOfClass("ressim.hec.watershed.client.StudySystemMapGlyph")) != null) {
            glyph.clearSelection();
        }
        frame.getMapPanel().paintMap();
    }

    public static void runTest() {
        ProjectsListEditor _ple = new ProjectsListEditor(new JFrame(), true);
        _ple.setLocation(200, 200);
        _ple.fillForm();
        _ple.setVisible(true);
    }
}

