/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.map.appInterface.MapApplicationFrame;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.CommonDataList;
import hec.model.DataListLoader;
import hec.model.DataStruct;
import hec.watershed.client.AbstractReportsFrame;
import hec.watershed.client.StudySystemMapGlyph;
import hec.watershed.client.WatershedConfigMode;
import hec.watershed.model.Condition;
import hec.watershed.model.ConditionDataList;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.table.TableModel;
import rma.swing.table.RmaTableModel;

public class ReportsFrame
extends AbstractReportsFrame {
    private boolean _reportForAllConditions = true;

    public ReportsFrame(Frame parent) {
    }

    @Override
    protected ActionListener getAboutMenuListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientApp.app();
                ClientApp.frame().helpAbout();
            }
        };
    }

    @Override
    public StreamAlignmentIfc getStreamAlignment() {
        ClientApp.app();
        return (StreamAlignmentIfc)ClientApp.Workspace().openManager("stream.align");
    }

    @Override
    public void makeReserviorReport() {
        super.makeReserviorReport();
    }

    @Override
    protected Condition getCondition() {
        ClientMode mode = ClientApp.frame().getCurrentMode();
        if (!this._reportForAllConditions && mode instanceof WatershedConfigMode) {
            WatershedConfigMode wcMode = (WatershedConfigMode)mode;
            return wcMode.getSelectedCondition();
        }
        ConditionDataList dl = (ConditionDataList)ClientApp.Workspace().getDataListContainer().getDataList("hec.watershed.model.Condition");
        if (dl == null) {
            return null;
        }
        return dl.getStudyCondition();
    }

    @Override
    public void makeLeveeReport() {
        super.makeLeveeReport();
    }

    public void makeConditionReport() {
        this.setTitle("List of Configurations");
        RmaTableModel model = new RmaTableModel(new String[]{" \nName", "Base\nDate", "Time\nStep", " \nDescription"}, (Object[][])new Object[0][], new boolean[]{false, false, false, false});
        this.reportTable.setModel((TableModel)model);
        this.buildTable(this.reportTable);
        this.reportTable.deleteCells();
        CommonDataList dl = DataListLoader.getDataListLoader().getCommonDataList("hec.watershed.model.Condition");
        if (dl == null) {
            return;
        }
        DataStruct[] conditionList = dl.getObjectArray();
        for (int i = 0; i < conditionList.length; ++i) {
            Condition c = (Condition)conditionList[i];
            if (c == null || c.isStudyCondition()) continue;
            Vector<Object> row = new Vector<Object>(4);
            row.addElement(c);
            row.addElement(c.getConditionDate());
            row.addElement(c.getDescription());
            this.reportTable.appendRow(row);
        }
        this.sortTable();
        this.reportTable.setAutoResizeMode(4);
        this.pack();
    }

    @Override
    protected StudySystemMapGlyph getStudySystemMapGlyph() {
        MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
        return (StudySystemMapGlyph)frame.getMapPanel().findGlyphOfClass("hec.watershed.client.StudySystemGlyph");
    }

    public boolean isReportForAllConditions() {
        return this._reportForAllConditions;
    }

    public void setReportForAllConditions(boolean reportForAllConditions) {
        this._reportForAllConditions = reportForAllConditions;
    }
}

