/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.lang.NamedType;
import hec.model.StreamElement;
import hec.watershed.client.ProjectTablePanel;
import hec.watershed.model.Reservoir;
import hec.watershed.model.StudyIfc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import rma.swing.RmaJIntegerField;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaCellRenderer;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAIO;

public class ReservoirTablePanel
extends ProjectTablePanel {
    private static final String TABNAME = "Reservoirs";

    public ReservoirTablePanel() {
        this.buildControls();
    }

    public void buildControls() {
        boolean[] editable = new boolean[]{true, true, true, true, true, true, true, false};
        String[] colNames = new String[]{"Name", "Stream\nName", "Existing\nProject", "Corps\nProject", "Year in\nService", "Label\nPosition", "Description", ""};
        RmaTableModel tableModel = new RmaTableModel(colNames, new Object[0][0], editable);
        this.setTableModel((RmaTableModelInterface)tableModel);
        this.m_projectTable.setColumnEnabled(false, 1);
        this.m_projectTable.setCheckBoxCellEditor(2);
        this.m_projectTable.setCheckBoxCellEditor(3);
        RmaCellRenderer rightAlignedLabel = new RmaCellRenderer(new JLabel());
        rightAlignedLabel.setHorizontalAlignment(4);
        this.m_projectTable.getColumnModel().getColumn(4).setCellRenderer((TableCellRenderer)rightAlignedLabel);
        RmaJIntegerField field = new RmaJIntegerField();
        field.setHorizontalAlignment(4);
        RmaCellEditor editor = new RmaCellEditor(field);
        this.m_projectTable.getColumnModel().getColumn(4).setCellEditor((TableCellEditor)editor);
        this.setMapLabelItemColumn(5);
        this.m_projectTable.setMlHeaderRenderer();
        this.m_projectTable.setColumnWidths(new int[]{150, 75, 75, 75, 75, 75, 250, 0});
        this.m_projectTable.setColumnVisible(editable.length - 1, false, 0);
    }

    @Override
    public String getTabname() {
        return TABNAME;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)((Object)new ReservoirTablePanel()), "Center");
        frame.pack();
        frame.setLocation(200, 200);
        frame.setVisible(true);
    }

    @Override
    public boolean savePanel(NamedType dobj) {
        return this.savePanel();
    }

    public boolean savePanel() {
        this.m_projectTable.commitEdit(true);
        for (int row = 0; row < this.m_modifiedRows.size(); ++row) {
            Vector rowData = this.m_projectTable.getRow(this.m_modifiedRows.elementAt(row));
            Reservoir res = (Reservoir)rowData.elementAt(this.m_projectTable.getModel().getColumnCount() - 1);
            res.setName((String)rowData.elementAt(0));
            StreamElement s = (StreamElement)rowData.elementAt(1);
            res.setStreamId(s != null ? s.getIndex() : -1);
            res.setIsExisting((Boolean)rowData.elementAt(2));
            res.setIsCorpsProject((Boolean)rowData.elementAt(3));
            res.setYearInService((short)RMAIO.parseInt(rowData.elementAt(4)));
            res.setLabelPosition(RMAIO.parseInt(rowData.elementAt(5)));
            res.setDescription((String)rowData.elementAt(6));
        }
        this.m_modifiedRows.removeAllElements();
        return true;
    }

    @Override
    public void fillPanel() {
        this.m_projectTable.deleteCells();
        StudyIfc study = super.getOpenStudy();
        if (study == null) {
            return;
        }
        Object[] dataObjList = study.getReservoirList();
        for (int row = 0; dataObjList != null && row < dataObjList.length; ++row) {
            Reservoir res = (Reservoir)dataObjList[row];
            if (res == null) continue;
            Vector<Object> rowData = new Vector<Object>();
            rowData.addElement(res.getName());
            StreamElement elem = this.getStreamElement(res.getStreamId());
            rowData.addElement(elem);
            rowData.addElement(res.isExisting());
            rowData.addElement(res.isCorpsProject());
            rowData.addElement(Short.toString(res.getYearInService()));
            rowData.addElement(new Integer(res.getLabelPosition()));
            rowData.addElement(res.getDescription());
            rowData.addElement(res);
            this.m_projectTable.appendRow(rowData);
        }
    }
}

