/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.map.WorldPt;
import hec.watershed.client.StationEditorPanel;
import hec.watershed.model.Station;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import rma.services.ServiceLookup;

public class StationEditorDialog
extends JDialog {
    StationEditorPanel _editorPanel;
    private JButton _applyButton;
    private JButton _cancelButton;
    private JPanel _containerPanel;
    private JButton _okButton;

    public StationEditorDialog(Window parent, Dialog.ModalityType mt) {
        super(parent, mt);
        this.initComponents();
        this._editorPanel = new StationEditorPanel();
        this._editorPanel.setStreamCoordinateProvider(new DefaultCoordinateProvider());
        this._editorPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equalsIgnoreCase("MODIFIED")) {
                    StationEditorDialog.this.setModified((Boolean)evt.getNewValue());
                }
            }
        });
        this._containerPanel.setLayout(new BorderLayout());
        this._containerPanel.add((Component)this._editorPanel, "Center");
        this.setModified(false);
    }

    private void initComponents() {
        this._applyButton = new JButton();
        this._cancelButton = new JButton();
        this._okButton = new JButton();
        this._containerPanel = new JPanel();
        this.setDefaultCloseOperation(2);
        this._applyButton.setText("Apply");
        this._applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationEditorDialog.this._applyButtonActionPerformed(evt);
            }
        });
        this._cancelButton.setText("Cancel");
        this._cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationEditorDialog.this._cancelButtonActionPerformed(evt);
            }
        });
        this._okButton.setText("OK");
        this._okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationEditorDialog.this._okButtonActionPerformed(evt);
            }
        });
        GroupLayout _containerPanelLayout = new GroupLayout(this._containerPanel);
        this._containerPanel.setLayout(_containerPanelLayout);
        _containerPanelLayout.setHorizontalGroup(_containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        _containerPanelLayout.setVerticalGroup(_containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 271, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(172, Short.MAX_VALUE).addComponent(this._okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._applyButton).addContainerGap()).addComponent(this._containerPanel, -1, -1, Short.MAX_VALUE));
        layout.linkSize(0, this._applyButton, this._cancelButton, this._okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this._containerPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._applyButton).addComponent(this._cancelButton).addComponent(this._okButton)).addGap(8, 8, 8)));
        this.pack();
    }

    private void _okButtonActionPerformed(ActionEvent evt) {
        try {
            this._editorPanel.savePanel();
            this.setVisible(false);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
        }
    }

    private void _cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void _applyButtonActionPerformed(ActionEvent evt) {
        try {
            this._editorPanel.savePanel();
            this.setModified(false);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
        }
    }

    public void setEditable(boolean editable) {
        this._editorPanel.setEditable(editable);
        this.setModified(false);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(StationEditorDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(StationEditorDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(StationEditorDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(StationEditorDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                StationEditorDialog dialog = new StationEditorDialog((Window)new JFrame(), Dialog.ModalityType.APPLICATION_MODAL);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                Station st = new Station();
                st.setElevation(10.0);
                dialog.fillPanel(Collections.singletonList(st), st, 1);
                dialog.pack();
                dialog.setMinimumSize(dialog.getPreferredSize());
                dialog.setLocation(500, 500);
                dialog.setSize(500, 500);
                dialog.setVisible(true);
            }
        });
    }

    public void fillPanel(List<Station> stations, Station selectedStation, int unitSystem) {
        this._editorPanel.fillPanel(stations, selectedStation, unitSystem);
        ServiceLookup.getUnitsDisplayService().updateUnitSystem(this.getContentPane());
        this.setModified(false);
    }

    private void setModified(boolean modified) {
        this._applyButton.setEnabled(modified);
    }

    public void setStreamCoordinateProvider(StreamCoordinateProvider provider) {
        this._editorPanel.setStreamCoordinateProvider(provider);
    }

    private static class DefaultCoordinateProvider
    implements StreamCoordinateProvider {
        private DefaultCoordinateProvider() {
        }

        @Override
        public Object[] computeStreamInformation(WorldPt pt) {
            return new Object[]{0.0, "", new WorldPt()};
        }
    }

    public static interface StreamCoordinateProvider {
        public Object[] computeStreamInformation(WorldPt var1);
    }
}

