/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import hec.clientapp.model.StreamAlignment;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.gui.SelectorPanel;
import hec.map.MapLabelItem;
import hec.map.WorldPt;
import hec.watershed.client.StationEditorDialog;
import hec.watershed.model.Station;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.Document;
import rma.lang.Modifiable;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;
import rma.swing.text.DecimalNumberDocument;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class StationEditorPanel
extends JPanel
implements Modifiable {
    SelectorPanel _selectionPanel;
    private StationEditorDialog.StreamCoordinateProvider _streamCoordianteProvider;
    private int _unitSystem;
    Map<String, String[]> indexMap = new HashMap<String, String[]>();
    private static final String[][] MERIDIANS = new String[][]{{"-165", "165W Zone X (-11 hours)"}, {"-150", "150W Zone W (-10 hours) "}, {"-135", "135W Zone V (-9 hours)"}, {"-120", "120W Zone U (-8 hours) HEC, Davis CA"}, {"-105", "105W Zone T (-7 hours)"}, {"-90", " 90W Zone S (-6 hours)"}, {"-75", " 75W Zone R (-5 hours)"}, {"-60", " 60W Zone Q (-4 hours)"}, {"-45", " 45W Zone P (-3 hours)"}, {"-30", " 30W Zone O (-2 hours)"}, {"-15", " 15W Zone N (-1 hours)"}, {"0", "  0W Zone Z (0 hours) Greenwich Mean Time"}, {"15", " 15E Zone A (1 hours)"}, {"30", " 30E Zone B (2 hours)"}, {"45", " 45E Zone C (3 hours)"}, {"60", " 60E Zone D (4 hours)"}, {"75", " 75E Zone E (5 hours) Karachi"}, {"90", " 90E Zone F (6 hours) Dhaka"}, {"105", "105E Zone G (7 hours) Bangkok"}, {"120", "120E Zone H (8 hours) Hong Kong"}, {"135", "135E Zone I (9 hours) Tokyo"}, {"150", "150E Zone K (10 hours) AU Eastern Standard"}, {"165", "165E Zone L (11 hours)"}, {"180", "180E Zone M (12 hours) Wellington"}};
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel3;
    private JScrollPane jScrollPane2;
    private JTextPane mErrorTextPane;
    private RmaJComboBox<String> mLabelPositionComboBox;
    private RmaJTextField mLatitudeTxt;
    private RmaJTextField mLocationIdTxt;
    private RmaJTextField mLongitudeTxt;
    private RmaJCheckBox mMetStationCheckBox;
    private RmaJComboBox<String[]> mNearestMeridianComboBox;
    private RmaJCheckBox mObservedStationCheckBox;
    private JPanel mPanelEditorContainer;
    private RmaJLabel mReferenceElevationLabel;
    private RmaJDecimalField mReferenceElevationTxt;
    private RmaJCheckBox _isProfileCheckBox;
    private RmaJTextField mStreamNameTxt;
    private RmaJDecimalField mStreamStationTxt;
    Station mSelectedStation;
    StreamAlignment streamAlignment = null;
    double snapToStreamEasting = Double.NEGATIVE_INFINITY;
    double snapToStreamNorthing = Double.NEGATIVE_INFINITY;
    private boolean enabled = true;

    public StationEditorPanel() {
        this.initComponents();
        this.mPanelEditorContainer.setLayout(new GridBagLayout());
        this._selectionPanel = new SelectorPanel();
        this._selectionPanel.getComboBox().setRenderer((ListCellRenderer)new StationCellRenderer());
        this.mPanelEditorContainer.add((Component)this._selectionPanel, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.mReferenceElevationTxt.setDocument((Document)new DecimalNumberDocument());
        this.mLatitudeTxt.setDocument((Document)new DecimalNumberDocument());
        this.mLongitudeTxt.setDocument((Document)new DecimalNumberDocument());
        this.mStreamStationTxt.setDocument((Document)new DecimalNumberDocument());
        this.mLongitudeTxt.setHorizontalAlignment(4);
        this.mLatitudeTxt.setHorizontalAlignment(4);
        DefaultComboBoxModel model = new DefaultComboBoxModel((E[])MERIDIANS);
        this.mNearestMeridianComboBox.setModel(model);
        this.mNearestMeridianComboBox.setRenderer((ListCellRenderer)new MeridianCellRenderer());
        Font f = this.mNearestMeridianComboBox.getFont();
        this.mNearestMeridianComboBox.setFont(new Font("courier new", f.getStyle(), f.getSize()));
        this._selectionPanel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                int returnValue;
                if (arg0.getStateChange() == 2) {
                    return;
                }
                if (StationEditorPanel.this.isModified() && (returnValue = RMAIO.postYesNoMessage((Component)StationEditorPanel.this, (String)"Data has Changed. Save/Apply Changes?", (String)"Confirm Changes")) == 0) {
                    try {
                        StationEditorPanel.this.savePanel();
                    }
                    catch (IOException ex) {
                        RMAIO.postError((Component)StationEditorPanel.this, (String)ex.getMessage());
                        return;
                    }
                }
                StationEditorPanel.this.fillPanel((Station)((Object)arg0.getItem()));
            }
        });
        for (String[] strings : MERIDIANS) {
            this.indexMap.put(strings[0], strings);
        }
        this.mLabelPositionComboBox.setModel(new DefaultComboBoxModel<String>(MapLabelItem.POSITION_STRINGS));
    }

    void setStreamCoordinateProvider(StationEditorDialog.StreamCoordinateProvider streamCoordianteProvider) {
        this._streamCoordianteProvider = streamCoordianteProvider;
    }

    public void setModified(boolean bool) {
        this.firePropertyChange("Modified", !bool, bool);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.mStreamNameTxt = new RmaJTextField();
        this.jLabel2 = new JLabel();
        this.mLabelPositionComboBox = new RmaJComboBox();
        this.jLabel3 = new JLabel();
        this.mStreamStationTxt = new RmaJDecimalField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.mLongitudeTxt = new RmaJTextField();
        this.mLatitudeTxt = new RmaJTextField();
        this.mNearestMeridianComboBox = new RmaJComboBox(){

            public String getToolTipText(MouseEvent e) {
                String[] itemArray;
                Object item = this.getSelectedItem();
                if (item instanceof String[] && (itemArray = (String[])item).length > 1) {
                    return itemArray[1];
                }
                return super.getToolTipText(e);
            }
        };
        this.mPanelEditorContainer = new JPanel();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.mErrorTextPane = new JTextPane();
        this._isProfileCheckBox = new RmaJCheckBox();
        this.mLocationIdTxt = new RmaJTextField();
        this.mObservedStationCheckBox = new RmaJCheckBox();
        this.mMetStationCheckBox = new RmaJCheckBox();
        this.jLabel8 = new JLabel();
        this.mReferenceElevationTxt = new RmaJDecimalField();
        this.mReferenceElevationLabel = new RmaJLabel();
        this.jLabel1.setText("Stream Name:");
        this.mStreamNameTxt.setEditable(false);
        this.mStreamNameTxt.setEnabled(false);
        this.jLabel2.setText("Label Position:");
        this.mLabelPositionComboBox.setModifiable(true);
        this.jLabel3.setText("Stream Station: ");
        this.mStreamStationTxt.setEditable(false);
        this.jLabel5.setText("Latitude (fractional degrees):");
        this.jLabel6.setText("Longitude  (fractional degrees):");
        this.jLabel7.setText("Nearest Standard Meridian:");
        this.mLongitudeTxt.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StationEditorPanel.this.longitudeKeyReleasedListener(evt);
            }
        });
        this.mNearestMeridianComboBox.setModifiable(true);
        this.mNearestMeridianComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationEditorPanel.this.mNearestMeridianComboBoxActionPerformed(evt);
            }
        });
        GroupLayout mPanelEditorContainerLayout = new GroupLayout(this.mPanelEditorContainer);
        this.mPanelEditorContainer.setLayout(mPanelEditorContainerLayout);
        mPanelEditorContainerLayout.setHorizontalGroup(mPanelEditorContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        mPanelEditorContainerLayout.setVerticalGroup(mPanelEditorContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 73, Short.MAX_VALUE));
        this.jScrollPane2.setBorder(null);
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setToolTipText("");
        this.jScrollPane2.setVerticalScrollBarPolicy(21);
        this.mErrorTextPane.setEditable(false);
        this.mErrorTextPane.setBackground(SystemColor.control);
        this.mErrorTextPane.setBorder(null);
        this.mErrorTextPane.setForeground(new Color(255, 0, 51));
        this.mErrorTextPane.setText("Note: The difference between longitude and nearest standard meridian exceeds 15 degrees.");
        this.jScrollPane2.setViewportView(this.mErrorTextPane);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jScrollPane2, -2, 47, -2)));
        this._isProfileCheckBox.setText("Profile Station");
        this._isProfileCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this._isProfileCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationEditorPanel.this.isProfileCheckBoxActionPerformed(evt);
            }
        });
        this.mObservedStationCheckBox.setText("Observed Station");
        this.mObservedStationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationEditorPanel.this.mObservedStationCheckBoxActionPerformed(evt);
            }
        });
        this.mMetStationCheckBox.setText("Met Station");
        this.mMetStationCheckBox.addActionListener(e -> this._isProfileCheckBox.setEnabled(this.mObservedStationCheckBox.isSelected()));
        this.jLabel8.setText("Location ID:");
        this.mReferenceElevationLabel.setLabelFor((Component)this.mReferenceElevationTxt);
        this.mReferenceElevationLabel.setText("Reference Elevation (%S):");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mPanelEditorContainer, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel1)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.mStreamNameTxt, -1, -1, Short.MAX_VALUE).addComponent((Component)this.mStreamStationTxt, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.mLabelPositionComboBox, -2, 132, -2).addGap(50, 50, 50)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel7).addComponent((Component)this.mReferenceElevationLabel, -2, 142, -2)).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.mNearestMeridianComboBox, -1, 172, Short.MAX_VALUE).addComponent((Component)this.mLongitudeTxt, -1, -1, Short.MAX_VALUE).addComponent((Component)this.mLatitudeTxt, -1, -1, Short.MAX_VALUE).addComponent((Component)this.mReferenceElevationTxt, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._isProfileCheckBox, -2, -1, -2).addComponent(this.jLabel8)).addGap(18, 18, 18).addComponent((Component)this.mLocationIdTxt, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.mObservedStationCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.mMetStationCheckBox, -2, -1, -2).addGap(0, 63, Short.MAX_VALUE)).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.mPanelEditorContainer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.mStreamNameTxt, -2, -1, -2).addComponent(this.jLabel1)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.mLabelPositionComboBox, -2, -1, -2).addComponent(this.jLabel2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.mStreamStationTxt, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.mReferenceElevationTxt, -2, -1, -2).addComponent((Component)this.mReferenceElevationLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.mLatitudeTxt, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.mLongitudeTxt, -2, -1, -2).addComponent(this.jLabel6))).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.mNearestMeridianComboBox, -2, -1, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.mLocationIdTxt, -2, -1, -2).addComponent((Component)this.mMetStationCheckBox, -2, -1, -2).addComponent((Component)this.mObservedStationCheckBox, -2, -1, -2).addComponent(this.jLabel8, -2, 23, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this._isProfileCheckBox, -2, -1, -2).addGap(0, 0, 0)));
    }

    private void mObservedStationCheckBoxActionPerformed(ActionEvent evt) {
        if (!this.mObservedStationCheckBox.isSelected()) {
            this._isProfileCheckBox.setSelected(false);
        }
        this._isProfileCheckBox.setEnabled(this.mObservedStationCheckBox.isSelected());
        this.updateSnapToStream();
    }

    private void longitudeKeyReleasedListener(KeyEvent evt) {
        this.updateErrorStatus(RMAIO.parseDouble((String)this.mLongitudeTxt.getText(), (double)0.0));
    }

    private void mNearestMeridianComboBoxActionPerformed(ActionEvent evt) {
        this.updateErrorStatus(RMAIO.parseDouble((String)this.mLongitudeTxt.getText(), (double)0.0));
    }

    private void isProfileCheckBoxActionPerformed(ActionEvent evt) {
        this.updateSnapToStream();
    }

    public static void main(String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        ArrayList<Station> stations = new ArrayList<Station>();
        Station station = new Station();
        station.setName("Station Name 1");
        station.setStreamName("Stream Name");
        station.setStreamStation(112345.5);
        station.setNearestMeridian(150);
        station.setGeometry((Geometry)new GeometryFactory().createPoint(new Coordinate(140.0, 38.0)));
        stations.add(station);
        station = new Station();
        station.setName("Station Name 2");
        station.setElevation(200.0);
        station.setStreamName("Stream Name 2");
        station.setStreamStation(112345.5);
        station.setNearestMeridian(165);
        station.setGeometry((Geometry)new GeometryFactory().createPoint(new Coordinate(120.0, 30.0)));
        station.setIsObservedStation(true);
        station.setIsMetStation(true);
        station.setLocationId("Location ID");
        stations.add(station);
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        JFrame frame = new JFrame();
        frame.setLocation(200, 200);
        StationEditorPanel stationEditorPanel = new StationEditorPanel();
        stationEditorPanel.fillPanel(stations, null, 0);
        frame.getContentPane().add((Component)stationEditorPanel, "Center");
        frame.pack();
        frame.setVisible(true);
    }

    private void fillPanel(Station station) {
        this.clearPanel();
        this.mSelectedStation = station;
        if (this.mSelectedStation == null) {
            return;
        }
        boolean snapToStream = this.mSelectedStation.isObservedStation();
        this.mStreamStationTxt.setEnabled(this.enabled && snapToStream);
        this.mStreamStationTxt.setEditable(this.enabled && snapToStream);
        this.mSelectedStation = station;
        this._selectionPanel.setDescription(this.mSelectedStation.getDescription());
        this.mStreamNameTxt.setText(snapToStream ? station.getStreamName() : "");
        this.mStreamStationTxt.setText(snapToStream ? Double.toString(station.getStreamStation()) : "");
        if (this.enabled) {
            // empty if block
        }
        this.mStreamNameTxt.setEditable(false);
        if (this.enabled) {
            // empty if block
        }
        this.mStreamNameTxt.setEnabled(false);
        ParamDouble pd = new ParamDouble(station.getElevation(), Parameter.PARAMID_ELEV, this._unitSystem);
        this.mReferenceElevationTxt.setValue(pd);
        Geometry point = station.getGeometry();
        String latitude = Double.toString(station.getLatitude());
        this.mLatitudeTxt.setText(latitude);
        int meridian = station.getNearestMeridian();
        String[] value = this.indexMap.get(Integer.toString(meridian));
        if (value != null) {
            this.mNearestMeridianComboBox.setSelectedItem((Object)value);
        }
        String longitude = Double.toString(station.getLongitude());
        this.mLongitudeTxt.setText(longitude);
        this.mLocationIdTxt.setText(station.getLocationId());
        this.mObservedStationCheckBox.setSelected(station.isObservedStation());
        this.mMetStationCheckBox.setSelected(station.isMetStation());
        this._isProfileCheckBox.setSelected(station.isProfileStation());
        String labelPos = station.getLabelPosition();
        if (labelPos == null || labelPos.isEmpty()) {
            this.mLabelPositionComboBox.setSelectedIndex(0);
        } else {
            this.mLabelPositionComboBox.setSelectedItem((Object)labelPos);
        }
        this.updateErrorStatus(longitude);
        this.setUnmodified();
    }

    private void clearPanel() {
        this.mStreamNameTxt.setText("");
        this.mStreamStationTxt.setText("");
        this.mReferenceElevationTxt.setText("");
        this.mLatitudeTxt.setText("");
        this.mLongitudeTxt.setText("");
        this.mNearestMeridianComboBox.setSelectedIndex(-1);
        this.mLocationIdTxt.setText("");
        this.mObservedStationCheckBox.setSelected(false);
        this.mMetStationCheckBox.setSelected(false);
        this._isProfileCheckBox.setSelected(false);
        this.mLabelPositionComboBox.setSelectedIndex(0);
    }

    private void updateErrorStatus(String stationMeridianValue) {
        try {
            this.updateErrorStatus(Double.parseDouble(stationMeridianValue));
        }
        catch (NumberFormatException e) {
            this.mErrorTextPane.setVisible(true);
        }
    }

    private void updateErrorStatus(double stationMeridianValue) {
        double currentMeridian;
        double diff;
        boolean errorVisible = false;
        String[] selectedItem = (String[])this.mNearestMeridianComboBox.getSelectedItem();
        if (selectedItem != null && (diff = Math.abs(stationMeridianValue - (currentMeridian = RMAIO.parseDouble((String)selectedItem[0], (double)0.0)))) > 15.0) {
            errorVisible = true;
        }
        this.mErrorTextPane.setVisible(errorVisible);
    }

    public void savePanel() throws IOException {
        if (this.mSelectedStation == null) {
            return;
        }
        this.mSelectedStation.setDescription(this._selectionPanel.getDescription());
        this.mSelectedStation.setStreamName(this.mStreamNameTxt.getText());
        this.mSelectedStation.setStreamStation(RMAIO.parseDouble((String)this.mStreamStationTxt.getText(), (double)0.0));
        this.mSelectedStation.setIsProfileStation(this._isProfileCheckBox.isSelected());
        this.mSelectedStation.setElevation(this.mReferenceElevationTxt.getValue());
        if (RMAConst.isValidValue((double)this.snapToStreamEasting)) {
            this.mSelectedStation.setGeometry((Geometry)new GeometryFactory().createPoint(new Coordinate(RMAIO.parseDouble((Object)this.snapToStreamEasting, (double)0.0), RMAIO.parseDouble((Object)this.snapToStreamNorthing, (double)0.0))));
        }
        this.mSelectedStation.setLongitude(RMAIO.parseDouble((String)this.mLongitudeTxt.getText(), (double)0.0));
        this.mSelectedStation.setLatitude(RMAIO.parseDouble((String)this.mLatitudeTxt.getText(), (double)0.0));
        String[] meridianValue = (String[])this.mNearestMeridianComboBox.getSelectedItem();
        if (meridianValue != null) {
            this.mSelectedStation.setNearestMeridian(RMAIO.parseInt((String)meridianValue[0], (int)0));
        } else {
            this.mSelectedStation.setNearestMeridian(0);
        }
        this.mSelectedStation.setLocationId(this.mLocationIdTxt.getText());
        this.mSelectedStation.setIsObservedStation(this.mObservedStationCheckBox.isSelected());
        this.mSelectedStation.setIsMetStation(this.mMetStationCheckBox.isSelected());
        Object labelPos = this.mLabelPositionComboBox.getSelectedItem();
        this.mSelectedStation.setLabelPosition(labelPos != null ? labelPos.toString() : MapLabelItem.POSITION_STRINGS[0]);
        this.setUnmodified();
    }

    public void fillPanel(List<Station> stations, Station selectedStation, int unitSystem) {
        this._unitSystem = unitSystem;
        this._selectionPanel.getComboBox().setModel((ComboBoxModel)new RmaListModel(true, stations));
        if (selectedStation != null) {
            this._selectionPanel.getComboBox().setSelectedItem((Object)selectedStation);
        } else {
            this._selectionPanel.getComboBox().setSelectedIndex(-1);
        }
        this.setUnmodified();
    }

    public boolean isModified() {
        return this.isModified(this);
    }

    private boolean isModified(Container parentComponent) {
        Component[] components;
        for (Component component : components = parentComponent.getComponents()) {
            boolean modified;
            if (component instanceof Modifiable && (modified = ((Modifiable)component).isModified())) {
                return true;
            }
            if (!(component instanceof Container) || !(modified = this.isModified((Container)component))) continue;
            return true;
        }
        return false;
    }

    private void setUnmodified() {
        this.setUnmodified(this);
        this.firePropertyChange("Modified", true, false);
    }

    private void setUnmodified(Container parentComponent) {
        Component[] components;
        for (Component component : components = parentComponent.getComponents()) {
            if (component instanceof Modifiable) {
                ((Modifiable)component).setModified(false);
            }
            if (!(component instanceof Container)) continue;
            this.setUnmodified((Container)component);
        }
    }

    private void updateSnapToStream() {
        boolean snapToStream = this.mObservedStationCheckBox.isSelected();
        if (this._streamCoordianteProvider != null && snapToStream && this.mSelectedStation != null) {
            Geometry geometry = this.mSelectedStation.getGeometry();
            Point p = geometry.getCentroid();
            WorldPt wpt = new WorldPt(p.getX(), p.getY());
            Object[] computeStreamInformation = this._streamCoordianteProvider.computeStreamInformation(wpt);
            if (computeStreamInformation == null) {
                this.mStreamStationTxt.setText("");
                this.mStreamNameTxt.setText("");
                this.snapToStreamEasting = Double.NEGATIVE_INFINITY;
                this.snapToStreamNorthing = Double.NEGATIVE_INFINITY;
            } else {
                Double streamStation = (Double)computeStreamInformation[0];
                if (RMAConst.isValidValue((double)this.mSelectedStation.getStreamStation())) {
                    streamStation = this.mSelectedStation.getStreamStation();
                }
                this.mStreamStationTxt.setText(Double.toString(streamStation));
                this.mStreamNameTxt.setText(computeStreamInformation[1].toString());
                wpt = (WorldPt)computeStreamInformation[2];
                if (wpt.isValid()) {
                    this.snapToStreamEasting = wpt.e;
                    this.snapToStreamNorthing = wpt.n;
                }
            }
        }
        this.mStreamStationTxt.setEnabled(this.enabled && snapToStream);
        this.mStreamStationTxt.setEditable(this.enabled && snapToStream);
        if (!snapToStream) {
            this.mStreamStationTxt.setText("");
            this.mStreamNameTxt.setText("");
        }
    }

    public void setEditable(boolean enabled) {
        this.enabled = enabled;
        boolean snapToStream = this.mObservedStationCheckBox.isSelected();
        this.mStreamStationTxt.setEnabled(enabled && snapToStream);
        this.mStreamStationTxt.setEditable(enabled && snapToStream);
        this.mStreamNameTxt.setEditable(false);
        this.mStreamNameTxt.setEnabled(false);
        this.mReferenceElevationTxt.setEnabled(enabled);
        this.mReferenceElevationTxt.setEditable(enabled);
        this.mLatitudeTxt.setEnabled(enabled);
        this.mLatitudeTxt.setEditable(enabled);
        this.mLongitudeTxt.setEnabled(enabled);
        this.mLongitudeTxt.setEditable(enabled);
        this.mNearestMeridianComboBox.setEnabled(enabled);
        this.mLocationIdTxt.setEnabled(enabled);
        this.mLocationIdTxt.setEditable(enabled);
        this.mLabelPositionComboBox.setEnabled(enabled);
        this.mObservedStationCheckBox.setEnabled(enabled);
        this.mMetStationCheckBox.setEnabled(enabled);
        this._isProfileCheckBox.setEnabled(enabled);
    }

    private static class StationCellRenderer
    extends DefaultListCellRenderer {
        private StationCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> arg0, Object arg1, int arg2, boolean arg3, boolean arg4) {
            String name = arg1 != null ? ((Station)((Object)arg1)).getName() : "";
            return super.getListCellRendererComponent(arg0, name, arg2, arg3, arg4);
        }
    }

    private static class MeridianCellRenderer
    extends DefaultListCellRenderer {
        private MeridianCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> arg0, Object arg1, int arg2, boolean arg3, boolean arg4) {
            String value = arg1 != null ? ((String[])arg1)[1] : "";
            return super.getListCellRendererComponent(arg0, value, arg2, arg3, arg4);
        }
    }
}

