/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.MapCanvas;
import hec.map.MapGlyph;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.model.StreamElement;
import hec.model.StreamNode;
import hec.watershed.client.ObsStationSnapPoint;
import hec.watershed.client.StudySystemGlyph;
import hec.watershed.model.Station;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.List;

public class StationMouseAdapter
extends MapMouseAdapter {
    private LocalPt _snapToStreamPoint;
    private ObsStationSnapPoint _snapDrawPoint;
    private boolean _snapPointClicked;
    private Station _prevStation;
    StreamAlignmentGlyph _alignmentGlyph = null;
    StreamElement _stream = null;
    Station _station = null;
    boolean _editingStation = false;
    boolean _moving = false;
    LocalPt _dragPt = new LocalPt();
    StudySystemGlyph _ssGlyph = null;

    public StationMouseAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
    }

    public void mouseClicked(MouseEvent e) {
        Geometry geometry;
        if (!this.findStationSetGlyph()) {
            return;
        }
        LocalPt pt = new LocalPt();
        pt.init(e.getX(), e.getY());
        Station station = null;
        if (e.getClickCount() == 2) {
            station = this._ssGlyph.selectStation(pt, false, true);
            this._editingStation = true;
            this._station = station;
            if (this._station != null && this._prevStation != this._station) {
                this._snapDrawPoint = new ObsStationSnapPoint(5);
                geometry = this._station.getGeometry();
                this._snapDrawPoint.setSnapToStreamPoint(this._mapPanel.scale().wp2lp(new WorldPt(geometry.getCoordinate().x, geometry.getCoordinate().y)));
            }
        } else {
            if (!this.findStationSetGlyph()) {
                return;
            }
            station = this._ssGlyph.selectStation(pt, false, false);
            this._editingStation = false;
            this._station = station;
        }
        if (station == null) {
            this._editingStation = false;
            this._stream = null;
        } else {
            if (this._station.getStationIconLocation() == null && this._station.getGeometry() != null) {
                geometry = station.getGeometry();
                this._station.setStationIconLocation(new WorldPt(geometry.getCoordinate().x, geometry.getCoordinate().y));
            }
            this._alignmentGlyph = (StreamAlignmentGlyph)this._mapPanel.findGlyphOfClass(StreamAlignmentGlyph.class.getName());
            if (this._alignmentGlyph != null) {
                geometry = station.getGeometry();
                Point centroid = geometry.getCentroid();
                this._stream = this._alignmentGlyph.findReach(new WorldPt(centroid.getX(), centroid.getY()));
                if (this._stream == null) {
                    this._stream = this._alignmentGlyph.findNearestReach(new WorldPt(centroid.getX(), centroid.getY()));
                }
            }
        }
        this._mapPanel.paintMap();
    }

    public void mousePressed(MouseEvent e) {
        if (this._editingStation && this._station != null) {
            if (!this.findStationSetGlyph()) {
                return;
            }
            LocalPt pt = new LocalPt();
            pt.init(e.getX(), e.getY());
            WorldPt wpt = this._station.getStationIconLocation();
            LocalRect localRect = new LocalRect();
            LocalPt stationLocalPt = new LocalPt();
            if (wpt == null) {
                return;
            }
            this._mapPanel.scale().wp2lp(wpt, stationLocalPt);
            localRect.init(stationLocalPt.x - 8, stationLocalPt.y - 8, stationLocalPt.x + 8, stationLocalPt.y + 8);
            if (!localRect.contains(pt)) {
                boolean bl = this._snapPointClicked = this._station.getSnapPoint() != null && this._station.getSnapPoint().isClicked(e);
                if (!this._snapPointClicked) {
                    return;
                }
            }
            this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(13));
            Graphics g = this._mapCanvas.getGraphics();
            g.setXORMode(new Color(255, 255, 255));
            g.fillRect(pt.x - 5, pt.y - 5, 10, 10);
            g.setPaintMode();
            g.dispose();
            this._moving = true;
        }
    }

    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        LocalPt pt = new LocalPt();
        pt.init(e.getX(), e.getY());
        if (!this.findStationSetGlyph()) {
            return;
        }
        MapScale scl = this._mapPanel.scale((MapGlyph)this._ssGlyph);
        Graphics g = this._mapCanvas.getGraphics();
        if (this._station != null && this._editingStation && this._moving) {
            if (this._dragPt != null) {
                g.setXORMode(new Color(255, 255, 255));
                g.fillRect(this._dragPt.x - 5, this._dragPt.y - 5, 10, 10);
                this.drawStation(scl, g);
            } else {
                this._dragPt = new LocalPt();
            }
            if (this._station.isObservedStation() && this._stream != null) {
                double stationByLocation = this._stream.getStationByLocation(scl.lp2wp(pt));
                WorldPt wp = this._stream.getLocationByStation(stationByLocation);
                if (this._station.getGeometry() == null) {
                    this._station.setGeometry((Geometry)new GeometryFactory().createPoint(new Coordinate(wp.e, wp.n)));
                }
                if (this._snapPointClicked) {
                    if (this._snapToStreamPoint == null) {
                        this._snapToStreamPoint = new LocalPt();
                    }
                    this._station.setGeometry((Geometry)new GeometryFactory().createPoint(new Coordinate(wp.e, wp.n)));
                    this._snapToStreamPoint.init(pt);
                    this._dragPt.init(scl.wp2lp(wp));
                } else {
                    this._station.setStationIconLocation(scl.lp2wp(pt));
                    this._dragPt.init(pt);
                    this._snapToStreamPoint = this._station.getSnapPoint() != null && this._station.getSnapPoint().getSnapToStreamPoint() != null ? this._station.getSnapPoint().getSnapToStreamPoint() : null;
                }
            } else {
                this._dragPt.init(pt);
                this._snapToStreamPoint = null;
            }
            g.fillRect(this._dragPt.x - 5, this._dragPt.y - 5, 10, 10);
            this.drawStation(scl, g);
        }
    }

    private void drawStation(MapScale scl, Graphics g) {
        if (this._stream != null && this._station.isObservedStation() && this._station.getGeometry() != null && this._station.getStationIconLocation() != null) {
            LocalPt stationIconPt = scl.wp2lp(this._station.getStationIconLocation());
            Point geoPoint = this._station.getGeometry().getCentroid();
            LocalPt streamPt = scl.wp2lp(new WorldPt(geoPoint.getX(), geoPoint.getY()));
            Color color = this._ssGlyph._stationSetData.getObservedStationColor();
            if (color != null) {
                g.setColor(color);
            }
            g.drawLine(stationIconPt.x, stationIconPt.y, streamPt.x, streamPt.y);
            g.setColor(Color.BLACK);
            this._snapDrawPoint = new ObsStationSnapPoint(5);
            this._snapDrawPoint.draw(g, streamPt);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.findStationSetGlyph()) {
            return;
        }
        boolean newStation = false;
        LocalPt pt = new LocalPt();
        pt.init(e.getX(), e.getY());
        if (e.isControlDown()) {
            Station station = this._ssGlyph.findStation(pt);
            if (station != null) {
                return;
            }
            this._station = this._ssGlyph.createStation(pt);
            newStation = true;
        } else if (e.isPopupTrigger()) {
            this._ssGlyph.stationPopupMenu(pt);
        } else if (this._moving) {
            double stationByLocation;
            boolean ignoreGeometrySet;
            WorldPt lp2wp = new WorldPt();
            StreamElement reach = this._alignmentGlyph.findNearestReach(pt);
            if (reach == null) {
                return;
            }
            reach.getLine().getNearestLocation(this._mapPanel.scale((MapGlyph)this._ssGlyph).lp2wp(pt), lp2wp);
            String streamName = "";
            if (this._station == null) {
                this._station = this._ssGlyph.findStation(pt);
            }
            if (this._station == null) {
                return;
            }
            boolean bl = ignoreGeometrySet = this._station == this._prevStation && this._station.isObservedStation() != this._prevStation.isObservedStation();
            if (!this._snapPointClicked) {
                ignoreGeometrySet = true;
            }
            if (!ignoreGeometrySet) {
                this._station.setGeometry((Geometry)new GeometryFactory().createPoint(new Coordinate(lp2wp.e, lp2wp.n)));
            }
            this._prevStation = this._station;
            if (this._dragPt != null && (this._dragPt.x != 0 || this._dragPt.y != 0)) {
                WorldPt wp = null;
                if (!this._station.isObservedStation() || !this._snapPointClicked) {
                    this._station.setStationIconLocation(this._mapPanel.scale((MapGlyph)this._ssGlyph).lp2wp(this._dragPt));
                    LocalPt lp = this._snapDrawPoint.getSnapToStreamPoint();
                    if (!this._station.isObservedStation()) {
                        lp = this._dragPt;
                    }
                    wp = this._mapPanel.scale((MapGlyph)this._ssGlyph).lp2wp(lp);
                    if (!ignoreGeometrySet) {
                        this._station.setGeometry((Geometry)new GeometryFactory().createPoint(new Coordinate(wp.e, wp.n)));
                    }
                } else if (this._station.isObservedStation()) {
                    this._station.setSnapPoint(this._snapDrawPoint);
                    wp = this._mapPanel.scale((MapGlyph)this._ssGlyph).lp2wp(this._dragPt);
                    if (!ignoreGeometrySet) {
                        this._station.setGeometry((Geometry)new GeometryFactory().createPoint(new Coordinate(wp.e, wp.n)));
                    }
                }
                if (this._stream != null && wp != null) {
                    stationByLocation = this._stream.getStationByLocation(wp);
                    streamName = this._stream.getName();
                    this._station.setStreamStation(stationByLocation);
                    this._station.setStreamName(streamName);
                }
            } else if (this._snapDrawPoint != null && this._snapDrawPoint.getSnapToStreamPoint() != null) {
                this._station.setSnapPoint(this._snapDrawPoint);
                WorldPt wp = this._mapPanel.scale((MapGlyph)this._ssGlyph).lp2wp(this._snapDrawPoint.getSnapToStreamPoint());
                if (!ignoreGeometrySet) {
                    this._station.setGeometry((Geometry)new GeometryFactory().createPoint(new Coordinate(wp.e, wp.n)));
                }
                if (this._stream != null && this._snapPointClicked) {
                    stationByLocation = this._stream.getStationByLocation(lp2wp);
                    streamName = this._stream.getName();
                    this._station.setStreamStation(stationByLocation);
                    this._station.setStreamName(streamName);
                }
            }
            this._moving = false;
            this._dragPt = null;
            this._snapPointClicked = false;
            this._mapPanel.paintMap();
        }
        if (newStation) {
            this._moving = true;
            this._dragPt = new LocalPt();
            this._dragPt.init(pt);
            this._snapDrawPoint = new ObsStationSnapPoint(5);
            this._snapDrawPoint.setSnapToStreamPoint(this._dragPt);
            MapScale scale = this._mapPanel.scale((MapGlyph)this._ssGlyph);
            WorldPt wp = scale.lp2wp(this._dragPt);
            this._alignmentGlyph = (StreamAlignmentGlyph)this._mapPanel.findGlyphOfClass(StreamAlignmentGlyph.class.getName());
            if (this._alignmentGlyph != null) {
                StreamElement elem = this._alignmentGlyph.getStreamAlignment().findNearestReach(wp, new WorldPt());
                if (elem != null) {
                    StreamNode streamNode = elem.getDownstreamNode();
                    if (streamNode == null) {
                        streamNode = elem.getUpstreamNode();
                    }
                    if (streamNode != null) {
                        this._stream = streamNode.getStream();
                    }
                }
                MouseEvent newE = new MouseEvent((Component)this._mapPanel.viewport(), 502, System.currentTimeMillis(), 0, pt.x, pt.y, 1, false);
                this.mouseReleased(newE);
            }
        }
        this._mapPanel.viewport().setCursor(this.getCursor());
    }

    protected boolean findStationSetGlyph() {
        this._ssGlyph = null;
        List gvec = this._mapPanel.cloneCombinedGlyphList();
        for (int i = 0; i < gvec.size(); ++i) {
            MapGlyph g = (MapGlyph)gvec.get(i);
            if (g == null || !(g instanceof StudySystemGlyph)) continue;
            this._ssGlyph = (StudySystemGlyph)g;
            break;
        }
        if (this._ssGlyph == null) {
            System.out.println("StationMouseAdapter:failed to find StudySystemGlyph");
            return false;
        }
        return true;
    }
}

