/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.watershed.client.StationSetDrawPropData;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJFontButton;
import rma.swing.RmaJPanel;

public class StationSetPropPanel
extends RmaJPanel {
    RmaJCheckBox drawNameCB;
    RmaJFontButton nameFontBtn;
    RmaJColorComboBox metStationColorCombo;
    RmaJColorComboBox obsStationColorCombo;
    StationSetDrawPropData m_data = null;

    public StationSetPropPanel(StationSetDrawPropData data) {
        this.m_data = data;
        this.buildControls();
        this.fillPanel();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        JLabel metStationLabel = new JLabel("Met Station Color:");
        this.add(metStationLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0));
        this.metStationColorCombo = new RmaJColorComboBox();
        this.metStationColorCombo.setAllowsCustomColor(true);
        this.metStationColorCombo.setModifiable(true);
        this.add((Component)this.metStationColorCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5505, 0, 0));
        JLabel obsStationlabel = new JLabel("Observed Station Color:");
        this.add(obsStationlabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0));
        this.obsStationColorCombo = new RmaJColorComboBox();
        this.obsStationColorCombo.setAllowsCustomColor(true);
        this.obsStationColorCombo.setModifiable(true);
        this.add((Component)this.obsStationColorCombo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5505, 0, 0));
        JPanel tempPanel = new JPanel(new GridBagLayout());
        tempPanel.setBorder(BorderFactory.createEtchedBorder());
        this.add(tempPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 18, 0, RmaInsets.INSETS5555, 0, 0));
        this.drawNameCB = new RmaJCheckBox("Draw Station Name");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = RmaInsets.INSETS5550;
        tempPanel.add((Component)this.drawNameCB, gbc);
        this.nameFontBtn = new RmaJFontButton("Font...");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.INSETS5555;
        tempPanel.add((Component)this.nameFontBtn, gbc);
    }

    public void fillPanel() {
        if (this.m_data == null) {
            return;
        }
        this.drawNameCB.setSelected(this.m_data.isDrawName());
        this.nameFontBtn.setFont(this.m_data.getNameFont());
        this.metStationColorCombo.setSelectedColor(this.m_data.getMetStationColor());
        this.obsStationColorCombo.setSelectedColor(this.m_data.getObservedStationColor());
    }

    public void savePanel() {
        if (this.m_data != null) {
            this.m_data.setDrawName(this.drawNameCB.isSelected());
            this.m_data.setNameFont(this.nameFontBtn.getFont());
            this.m_data.setMetStationColor(this.metStationColorCombo.getSelectedColor());
            this.m_data.setObservedStationColor(this.obsStationColorCombo.getSelectedColor());
            this.m_data.save();
        }
    }
}

