/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.watershed.client.ChannelModDrawPropData;
import hec.watershed.client.StudyDPData;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import rma.util.RMAIO;

public class StudyChannelModDPData
extends StudyDPData
implements ChannelModDrawPropData {
    private static final String FILL_COLOR_STR = "StudyChannelModDPData.fillColor";
    private static final String DRAW_NAME_STR = "StudyChannelModDPData.drawName";
    private static final String NAME_FONT_STR = "StudyChannelModDPData.nameFont";
    private static final String CHANNEL_MOD_WIDTH_STR = "StudyChannelModDPData.channelModWidth";
    public Color fillColor;
    public boolean drawName;
    public Font nameFont;
    public int channelModWidth;
    Hashtable _properties = new Hashtable();
    static StudyChannelModDPData _channelModData = new StudyChannelModDPData();

    protected StudyChannelModDPData() {
        this.load();
    }

    private void load() {
        if (_props == null) {
            return;
        }
        String s = _props.getProp(FILL_COLOR_STR, "-16777216");
        this.fillColor = Color.decode(s);
        s = _props.getProp(DRAW_NAME_STR, "true");
        this.drawName = Boolean.valueOf(s);
        s = _props.getProp(NAME_FONT_STR, "SansSerif-plain-10");
        this.nameFont = Font.decode(s);
        if (this.nameFont == null) {
            this.nameFont = new Font("SansSerif", 0, 10);
        }
        s = _props.getProp(CHANNEL_MOD_WIDTH_STR, "8");
        this.channelModWidth = RMAIO.parseInt((String)s);
    }

    @Override
    public void save() {
        if (_props == null) {
            return;
        }
        _props.setProp(FILL_COLOR_STR, "" + this.fillColor.getRGB());
        _props.setProp(DRAW_NAME_STR, "" + this.drawName);
        _props.setProp(NAME_FONT_STR, this.nameFont.getName() + "-" + this.getFontStyleString(this.nameFont) + "-" + this.nameFont.getSize());
        _props.setProp(CHANNEL_MOD_WIDTH_STR, "" + this.channelModWidth);
        _props.saveProperties();
    }

    @Override
    public void setDefaults() {
        this.channelModWidth = 8;
        this.fillColor = Color.black;
        this.drawName = true;
        this.nameFont = new Font("SansSerif", 0, 10);
    }

    public static StudyChannelModDPData getData() {
        return _channelModData;
    }

    public Hashtable getProperties() {
        this._properties.clear();
        this._properties.put(FILL_COLOR_STR, "" + this.fillColor.getRGB());
        this._properties.put(DRAW_NAME_STR, "" + this.drawName);
        this._properties.put(NAME_FONT_STR, this.nameFont.getName() + "-" + this.nameFont.getStyle() + "-" + this.nameFont.getSize());
        this._properties.put(CHANNEL_MOD_WIDTH_STR, "" + this.channelModWidth);
        return this._properties;
    }

    @Override
    public double getChannelModWidth() {
        return this.channelModWidth;
    }

    @Override
    public Color getFillColor() {
        return this.fillColor;
    }

    @Override
    public boolean isDrawName() {
        return this.drawName;
    }

    @Override
    public Font getNameFont() {
        return this.nameFont;
    }

    @Override
    public void setFillColor(Color selectedColor) {
        this.fillColor = selectedColor;
    }

    @Override
    public void setChannelModWidth(int width) {
        this.channelModWidth = width;
    }

    @Override
    public void setNameFont(Font font) {
        this.nameFont = font;
    }

    @Override
    public void setDrawName(boolean draw) {
        this.drawName = draw;
    }
}

