/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.MapCanvas;
import hec.map.MapPanel;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.model.StreamElement;
import hec.watershed.client.StudyMouseAdapter;
import hec.watershed.model.ChannelMod;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class StudyChannelModMouseAdapter
extends StudyMouseAdapter
implements MouseListener,
MouseMotionListener {
    Vector _ptVec = new Vector();
    boolean _creatingLevee = false;
    boolean _editingLevee = false;
    LocalPt _beginPt = new LocalPt();
    LocalPt _endPt = new LocalPt();
    LocalPt _pt = new LocalPt();
    LocalPt _pt0 = new LocalPt();
    LocalPt _pt1 = new LocalPt();
    LocalPt _selectedPt = null;
    WorldPt _selectedWPt = null;
    LocalRect _lrc = new LocalRect();
    WorldRect _wrc = new WorldRect();
    ChannelMod _channelMod = null;
    StreamElement _stream = null;
    boolean _poppingUp = false;
    double _leveeCoordStart = Double.NEGATIVE_INFINITY;
    double _leveeCoordEnd = Double.NEGATIVE_INFINITY;
    double _leveeStationStart = Double.NEGATIVE_INFINITY;
    double _leveeStationEnd = Double.NEGATIVE_INFINITY;
    int _leveeStreamElemIndexStart = Integer.MIN_VALUE;
    int _leveeStreamElemIndexEnd = Integer.MIN_VALUE;
    boolean _moving = false;
    boolean _movingStart = false;
    boolean _movingEnd = false;
    static int[] _xpt = new int[4];
    static int[] _ypt = new int[4];
    static int[] _xp = new int[4000];
    static int[] _yp = new int[4000];

    public StudyChannelModMouseAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
    }

    @Override
    public void init() {
        this.findStudySystemGlyph();
    }

    @Override
    public void abort() {
        this.findStudySystemGlyph();
        if (this._sysglyph != null) {
            this._sysglyph.clearSelection();
        }
        this._creatingLevee = false;
        this._editingLevee = false;
        this._channelMod = null;
    }

    @Override
    protected boolean findStudySystemGlyph() {
        this._sysglyph = null;
        this._alignglyph = null;
        super.findStudySystemGlyph();
        this.findStreamAlignmentGlyph();
        if (this._sysglyph != null && this._alignglyph != null) {
            return true;
        }
        System.out.println("findStudySystemGlyph:didn't find StudyGlyph " + this._sysglyph + " and/or StreamAlignment Glyph " + this._alignglyph);
        return false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this._creatingLevee) {
            if (this._pt.equals(this._pt0)) {
                this._creatingLevee = false;
                this._leveeStationStart = Double.NEGATIVE_INFINITY;
                this._leveeStationEnd = Double.NEGATIVE_INFINITY;
                this._leveeCoordStart = Double.NEGATIVE_INFINITY;
                this._leveeCoordEnd = Double.NEGATIVE_INFINITY;
                this._moving = false;
                return;
            }
            this._pt1.init(e.getX(), e.getY());
            this._stream = this._alignglyph.findNearestReach(this._pt1);
            this._selectedWPt = this._mapPanel.scale().lp2wp(this._pt1);
            double station = this._stream.getStationByLocation(this._selectedWPt);
            double coord = this._stream.getCoordByLocation(this._selectedWPt);
            this._leveeStationEnd = station;
            this._leveeCoordEnd = coord;
            this._leveeStreamElemIndexEnd = this._stream.getIndex();
            this._sysglyph.createChannelMod(this._stream.getName(), this._leveeStreamElemIndexStart, this._leveeStreamElemIndexEnd, this._leveeStationStart, this._leveeStationEnd);
            this._mapPanel.viewport().setCursor(this.getCursor());
            this._creatingLevee = false;
            this._moving = false;
            this._leveeCoordStart = Double.NEGATIVE_INFINITY;
            this._leveeCoordEnd = Double.NEGATIVE_INFINITY;
            this._leveeStationStart = Double.NEGATIVE_INFINITY;
            this._leveeStationEnd = Double.NEGATIVE_INFINITY;
            this._leveeStreamElemIndexStart = Integer.MIN_VALUE;
            this._leveeStreamElemIndexEnd = Integer.MIN_VALUE;
        } else if (!this._creatingLevee && e.isControlDown()) {
            if (!this.findStudySystemGlyph()) {
                return;
            }
            if (!this.isConfigurationLocked("Cannot edit Channel Modifications")) {
                return;
            }
            this._ptVec.removeAllElements();
            this._pt0.init(e.getX(), e.getY());
            this._stream = this._alignglyph.findReach(this._pt0);
            if (this._stream != null) {
                this._creatingLevee = true;
                this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
                this._selectedWPt = this._mapPanel.scale().lp2wp(this._pt0);
                double coord = this._stream.getCoordByLocation(this._selectedWPt);
                this._selectedWPt = this._stream.getLocationByCoord(coord);
                this._pt0 = this._mapPanel.scale().wp2lp(this._selectedWPt);
                this._pt.init(this._pt0);
                this.drawPt(this._pt, true);
                this._moving = false;
                this._ptVec.addElement(new LocalPt(this._pt));
                this._leveeCoordStart = coord;
                this._leveeStationStart = this._stream.getStationByCoord(coord);
                this._leveeStreamElemIndexStart = this._stream.getIndex();
            }
        } else if (this._selectedPt != null) {
            if ((this._movingStart || this._movingEnd) && this._stream != null && this._channelMod != null) {
                double s0 = this._stream.getStationByLocation(this._selectedWPt);
                if (this._movingEnd) {
                    this._channelMod.setEndStation(s0);
                } else {
                    this._channelMod.setStartStation(s0);
                }
                this._mapPanel.paintMap();
            }
            this._movingEnd = false;
            this._movingStart = false;
            this._selectedPt = null;
            this._selectedWPt = null;
            this._mapPanel.paintMap();
            this._mapPanel.viewport().setCursor(this.getCursor());
        } else if (e.isPopupTrigger() || StudyChannelModMouseAdapter.pressedButton3((MouseEvent)e)) {
            // empty if block
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this._poppingUp = false;
        if (e.isPopupTrigger() || StudyChannelModMouseAdapter.pressedButton3((MouseEvent)e)) {
            if (!this.findStudySystemGlyph()) {
                return;
            }
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            this._poppingUp = true;
            this._sysglyph.channelModPopupMenu(pt);
        } else if (this._editingLevee && this._channelMod != null) {
            StreamAlignmentGlyph alignglyph = (StreamAlignmentGlyph)this._mapPanel.findGlyphOfClass(StreamAlignmentGlyph.class.getName());
            if (alignglyph == null) {
                return;
            }
            this._stream = alignglyph.findReach(this._channelMod.getStartStreamElementIndex());
            if (this._stream != null) {
                this._movingEnd = false;
                this._movingStart = false;
                double s0 = this._channelMod.getStartStation();
                double s1 = this._channelMod.getEndStation();
                this._pt.init(e.getX(), e.getY());
                double tol = this._mapPanel.scale().x2e(this._pt.x + 5) - this._mapPanel.scale().x2e(this._pt.x);
                WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
                this._wrc.init(wpt.e - tol, wpt.n + tol, wpt.e + tol, wpt.n - tol);
                wpt = this._stream.getLocationByStation(s0);
                WorldPt wpt1 = this._stream.getLocationByStation(s1);
                if (this._wrc.contains(wpt)) {
                    this._movingStart = true;
                    this._selectedWPt = wpt;
                } else if (this._wrc.contains(wpt1)) {
                    this._movingEnd = true;
                    this._selectedWPt = wpt;
                }
                if (this._movingStart || this._movingEnd) {
                    this._selectedPt = this._mapPanel.scale().wp2lp(this._selectedWPt);
                    this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this._creatingLevee && this._leveeCoordStart != Double.NEGATIVE_INFINITY) {
            Graphics g = this._mapCanvas.getGraphics();
            g.setXORMode(new Color(255, 255, 255));
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            if (!this._pt.equals(this._pt0)) {
                this.drawPt(this._pt, true);
            }
            this._moving = true;
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
            double coord = this._stream.getLine().getCoordAtLocation(wpt);
            pt = this._mapPanel.scale().wp2lp(this._stream.getLocationByCoord(coord));
            this._pt.init(pt);
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            if (!this._pt.equals(this._pt0)) {
                this.drawPt(this._pt, true);
            }
            g.setPaintMode();
            g.dispose();
        } else {
            super.mouseMoved(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if ((this._movingStart || this._movingEnd) && this._selectedPt != null && this._channelMod != null) {
            if (this._stream == null) {
                return;
            }
            this._pt0.init(e.getX(), e.getY());
            WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt0);
            double coord = this._stream.getLine().getCoordAtLocation(wpt);
            this._pt0.init(this._mapPanel.scale().wp2lp(this._stream.getLocationByCoord(coord)));
            this.drawPt(this._selectedPt, true);
            this.drawPt(this._pt0, true);
            this._selectedPt.init(this._pt0);
            this._mapPanel.scale().lp2wp(this._selectedPt, this._selectedWPt);
        } else if (this._selectedPt != null && this._channelMod != null) {
            this.drawChannelMod(this._channelMod, true);
            this._selectedPt.init(e.getX(), e.getY());
            this._mapPanel.scale().lp2wp(this._selectedPt, this._selectedWPt);
            this.drawChannelMod(this._channelMod, true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this._creatingLevee) {
            if (e.getClickCount() == 2) {
                if (!this.findStudySystemGlyph()) {
                    return;
                }
                this._pt.init(e.getX(), e.getY());
                WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
                double tol = this._mapPanel.scale().x2e(this._pt.x + 10) - this._mapPanel.scale().x2e(this._pt.x);
                ChannelMod cm = this._sysglyph.findChannelMod(wpt, tol);
                if (cm != null) {
                    this._editingLevee = this.isConfigurationLocked("Cannot Edit Channel Modifications");
                    this._sysglyph.selectChannelMod(cm, false, this._editingLevee);
                } else {
                    this._editingLevee = false;
                }
                this._channelMod = cm;
            } else if (!this._editingLevee) {
                if (!this.findStudySystemGlyph()) {
                    return;
                }
                this._pt.init(e.getX(), e.getY());
                ChannelMod res = this._sysglyph.selectChannelMod(this._pt, false, false);
                this._editingLevee = false;
                this._channelMod = res;
            }
        }
    }

    void drawPt(LocalPt pt, boolean isXOR) {
        Graphics g = this._mapCanvas.getGraphics();
        if (isXOR) {
            g.setXORMode(new Color(255, 255, 255));
        } else {
            g.setColor(Color.black);
        }
        StudyChannelModMouseAdapter._xpt[0] = pt.x - 5;
        StudyChannelModMouseAdapter._ypt[0] = pt.y;
        StudyChannelModMouseAdapter._xpt[1] = pt.x;
        StudyChannelModMouseAdapter._ypt[1] = pt.y + 5;
        StudyChannelModMouseAdapter._xpt[2] = pt.x + 5;
        StudyChannelModMouseAdapter._ypt[2] = pt.y;
        StudyChannelModMouseAdapter._xpt[3] = pt.x;
        StudyChannelModMouseAdapter._ypt[3] = pt.y - 5;
        g.fillPolygon(_xpt, _ypt, 4);
        g.setPaintMode();
        g.dispose();
    }

    void drawChannelMod(ChannelMod levData, boolean isXOR) {
        if (this._sysglyph == null || levData == null) {
            return;
        }
        Graphics g = this._mapCanvas.getGraphics();
        this._sysglyph.drawSelectedChannelMod(g, this._mapPanel.scale(), levData, isXOR, this._editingLevee);
        g.dispose();
    }
}

