/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.watershed.client.ChannelModDrawPropData;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJFontButton;

public class StudyChannonModPropPanel
extends JPanel {
    ChannelModDrawPropData m_dpData = null;
    RmaJColorComboBox m_channelModColorCombo;
    RmaJComboBox m_channelModWidthCombo;
    RmaJCheckBox m_channelModDrawNameCB;
    RmaJFontButton m_nameFontBtn;

    public StudyChannonModPropPanel(ChannelModDrawPropData dpData) {
        super(new GridBagLayout());
        this.m_dpData = dpData;
        this.buildControls();
        this.fillPanel();
    }

    private void buildControls() {
        JLabel label = new JLabel("Channel Modification Line Color:");
        this.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0));
        this.m_channelModColorCombo = new RmaJColorComboBox();
        label.setLabelFor((Component)this.m_channelModColorCombo);
        this.m_channelModColorCombo.setModifiable(true);
        this.add((Component)this.m_channelModColorCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0));
        label = new JLabel("Channel Modification Width:");
        this.add((Component)label, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0));
        Integer[] widthValues = new Integer[10];
        for (int i = 1; i <= 10; ++i) {
            widthValues[i - 1] = new Integer(i);
        }
        this.m_channelModWidthCombo = new RmaJComboBox(new DefaultComboBoxModel<Integer>(widthValues));
        this.m_channelModWidthCombo.setModifiable(true);
        label.setLabelFor((Component)this.m_channelModWidthCombo);
        this.add((Component)this.m_channelModWidthCombo, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 18, 0, RmaInsets.INSETS5505, 50, 0));
        JPanel tempPanel = new JPanel(new GridBagLayout());
        tempPanel.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)tempPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 0, RmaInsets.INSETS5555, 0, 0));
        this.m_channelModDrawNameCB = new RmaJCheckBox("Draw Channel Modification Name");
        tempPanel.add((Component)this.m_channelModDrawNameCB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5550, 0, 0));
        this.m_nameFontBtn = new RmaJFontButton("Font...");
        tempPanel.add((Component)this.m_nameFontBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5555, 0, 0));
    }

    public void fillPanel() {
        if (this.m_dpData == null) {
            return;
        }
        this.m_channelModColorCombo.setSelectedColor(this.m_dpData.getFillColor());
        this.m_channelModWidthCombo.setSelectedItem((Object)new Integer((int)this.m_dpData.getChannelModWidth()));
        this.m_channelModDrawNameCB.setSelected(this.m_dpData.isDrawName());
        this.m_nameFontBtn.setFont(this.m_dpData.getNameFont());
    }

    public void savePanel() {
        if (this.m_dpData == null) {
            return;
        }
        this.m_dpData.setFillColor(this.m_channelModColorCombo.getSelectedColor());
        this.m_dpData.setChannelModWidth((Integer)this.m_channelModWidthCombo.getSelectedItem());
        this.m_dpData.setNameFont(this.m_nameFontBtn.getFont());
        this.m_dpData.setDrawName(this.m_channelModDrawNameCB.isSelected());
        this.m_dpData.save();
    }
}

