/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.watershed.client.CompPtDrawPropData;
import hec.watershed.client.StudyDPData;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.Hashtable;
import rma.util.RMAIO;

public class StudyCompPtDPData
extends StudyDPData
implements Serializable,
CompPtDrawPropData {
    private static final String FILL_COLOR_STR = "StudyCompPtDPData.fillColor";
    private static final String OUTLINE_COLOR_STR = "StudyCompPtDPData.outlineColor";
    private static final String DRAW_NAME_STR = "StudyCompPtDPData.drawName";
    private static final String NAME_FONT_STR = "StudyCompPtDPData.nameFont";
    private static final String COMP_PT_WIDTH_STR = "StudyCompPtDPData.compPtWidth";
    public Color fillColor;
    public Color outlineColor;
    public boolean drawName;
    public Font nameFont;
    public int compPtWidth;
    Hashtable _properties = new Hashtable();
    static StudyCompPtDPData _compPtData = new StudyCompPtDPData();

    protected StudyCompPtDPData() {
        this.load();
    }

    private void load() {
        if (_props == null) {
            return;
        }
        String s = _props.getProp(FILL_COLOR_STR, "-16777216");
        this.fillColor = Color.decode(s);
        s = _props.getProp(OUTLINE_COLOR_STR, "-16777216");
        this.outlineColor = Color.decode(s);
        s = _props.getProp(DRAW_NAME_STR, "true");
        this.drawName = Boolean.valueOf(s);
        s = _props.getProp(NAME_FONT_STR, "SansSerif-plain-10");
        this.nameFont = Font.decode(s);
        if (this.nameFont == null) {
            this.nameFont = new Font("SansSerif", 0, 10);
        }
        s = _props.getProp(COMP_PT_WIDTH_STR, "8");
        this.compPtWidth = RMAIO.parseInt((String)s);
    }

    @Override
    public void save() {
        _props.setProp(FILL_COLOR_STR, "" + this.fillColor.getRGB());
        _props.setProp(OUTLINE_COLOR_STR, "" + this.outlineColor.getRGB());
        _props.setProp(DRAW_NAME_STR, "" + this.drawName);
        _props.setProp(NAME_FONT_STR, this.nameFont.getName() + "-" + this.getFontStyleString(this.nameFont) + "-" + this.nameFont.getSize());
        _props.setProp(COMP_PT_WIDTH_STR, "" + this.compPtWidth);
        _props.saveProperties();
    }

    @Override
    public void setDefaults() {
        this.compPtWidth = 8;
        this.fillColor = Color.black;
        this.outlineColor = Color.black;
        this.drawName = true;
        this.nameFont = new Font("SansSerif", 0, 10);
    }

    public static StudyCompPtDPData getData() {
        return _compPtData;
    }

    public Hashtable getProperties() {
        this._properties.clear();
        this._properties.put(FILL_COLOR_STR, "" + this.fillColor.getRGB());
        this._properties.put(OUTLINE_COLOR_STR, "" + this.outlineColor.getRGB());
        this._properties.put(DRAW_NAME_STR, "" + this.drawName);
        this._properties.put(NAME_FONT_STR, this.nameFont.getName() + "-" + this.nameFont.getStyle() + "-" + this.nameFont.getSize());
        this._properties.put(COMP_PT_WIDTH_STR, "" + this.compPtWidth);
        return this._properties;
    }

    @Override
    public int getCompPtWidth() {
        return this.compPtWidth;
    }

    @Override
    public Color getFillColor() {
        return this.fillColor;
    }

    @Override
    public Color getOutlineColor() {
        return this.outlineColor;
    }

    @Override
    public boolean isDrawName() {
        return this.drawName;
    }

    @Override
    public Font getNameFont() {
        return this.nameFont;
    }

    @Override
    public void setFillColor(Color selectedColor) {
        this.fillColor = selectedColor;
    }

    @Override
    public void setOutlineColor(Color selectedColor) {
        this.outlineColor = selectedColor;
    }

    @Override
    public void setDrawName(boolean draw) {
        this.drawName = draw;
    }

    @Override
    public void setCompPtWidth(int width) {
        this.compPtWidth = width;
    }

    @Override
    public void setNameFont(Font font) {
        this.nameFont = font;
    }
}

