/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.watershed.client.CompPtDrawPropData;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJFontButton;

public class StudyCompPtPropPanel
extends JPanel {
    CompPtDrawPropData _dpData;
    private RmaJColorComboBox fillColorCombo;
    private RmaJCheckBox drawNameCB;
    private RmaJComboBox compPtWidthCombo;
    private RmaJFontButton nameFontBtn;

    public StudyCompPtPropPanel(CompPtDrawPropData dpData) {
        super(new GridBagLayout());
        this._dpData = dpData;
        this.buildControls();
        this.fillPanel();
    }

    private void buildControls() {
        JLabel label = new JLabel("Computation Point Color:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.add((Component)label, gbc);
        this.fillColorCombo = new RmaJColorComboBox();
        this.fillColorCombo.setModifiable(true);
        label.setLabelFor((Component)this.fillColorCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.add((Component)this.fillColorCombo, gbc);
        label = new JLabel("Computation Point Width:");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.add((Component)label, gbc);
        Integer[] widthValues = new Integer[10];
        for (int i = 1; i <= 10; ++i) {
            widthValues[i - 1] = new Integer(i);
        }
        this.compPtWidthCombo = new RmaJComboBox(new DefaultComboBoxModel<Integer>(widthValues));
        this.compPtWidthCombo.setModifiable(true);
        label.setLabelFor((Component)this.compPtWidthCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.ipadx = 50;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.add((Component)this.compPtWidthCombo, gbc);
        JPanel tempPanel = new JPanel(new GridBagLayout());
        tempPanel.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)tempPanel, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 18, 0, RmaInsets.INSETS5555, 0, 0));
        this.drawNameCB = new RmaJCheckBox("Draw Computation Point Name");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = RmaInsets.INSETS5550;
        tempPanel.add((Component)this.drawNameCB, gbc);
        this.nameFontBtn = new RmaJFontButton("Font...");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.INSETS5555;
        tempPanel.add((Component)this.nameFontBtn, gbc);
    }

    public void fillPanel() {
        if (this._dpData == null) {
            return;
        }
        this.fillColorCombo.setSelectedColor(this._dpData.getFillColor());
        this.compPtWidthCombo.setSelectedItem((Object)new Integer(this._dpData.getCompPtWidth()));
        this.drawNameCB.setSelected(this._dpData.isDrawName());
        this.nameFontBtn.setFont(this._dpData.getNameFont());
    }

    public void savePanel() {
        this._dpData.setFillColor(this.fillColorCombo.getSelectedColor());
        this._dpData.setOutlineColor(this.fillColorCombo.getSelectedColor());
        this._dpData.setDrawName(this.drawNameCB.isSelected());
        this._dpData.setCompPtWidth((Integer)this.compPtWidthCombo.getSelectedItem());
        this._dpData.setNameFont(this.nameFontBtn.getFont());
        this._dpData.save();
    }

    public static void main(String[] args) {
        JDialog dialog = new JDialog((Frame)null, true);
        dialog.getContentPane().add((Component)new StudyCompPtPropPanel(null), "Center");
        dialog.pack();
        dialog.setLocation(300, 300);
        dialog.setVisible(true);
    }
}

