/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.appInterface.AppDaddy;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.LocalRegion;
import hec.map.MapCanvas;
import hec.map.MapPanel;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.model.StreamElement;
import hec.watershed.client.StudyMouseAdapter;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.Reservoir;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class StudyComputationPointMouseAdapter
extends StudyMouseAdapter
implements MouseListener,
MouseMotionListener {
    Vector _ptVec = new Vector();
    Vector _nodeVec = new Vector();
    boolean _creatingRegion = false;
    boolean _editingPt = false;
    LocalPt _beginPt = new LocalPt();
    LocalPt _endPt = new LocalPt();
    LocalPt _pt = new LocalPt();
    LocalPt _pt0 = new LocalPt();
    LocalPt _selectedPt = null;
    WorldPt _selectedWPt = null;
    LocalRect _lrc = new LocalRect();
    WorldRect _wrc = new WorldRect();
    ComputationPoint _compPt = null;
    StreamElement _stream = null;
    StreamAlignmentGlyph _alignmentGlyph;
    double _maxUpstreamStation;
    double _maxDownstreamStation;
    boolean _moving = false;
    static int[] _xpt = new int[4];
    static int[] _ypt = new int[4];
    static int[] _xp = new int[4000];
    static int[] _yp = new int[4000];

    public StudyComputationPointMouseAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
    }

    @Override
    public void abort() {
        super.abort();
        this._creatingRegion = false;
        this._editingPt = false;
        this._compPt = null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this._moving && this._compPt != null) {
            WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
            double coord = 0.0;
            double station = this._compPt.getStreamStation();
            if (this._compPt.getSnapToStream() && this._stream != null) {
                coord = this._stream.getLine().getCoordAtLocation(wpt);
                station = this._stream.getStationByCoord(coord);
                wpt = this._stream.getLocationByCoord(coord);
            }
            this._compPt = this._sysglyph.moveCompPoint(this._compPt, wpt, this._stream, coord, station);
            this._moving = false;
            this._mapPanel.viewport().setCursor(this.getCursor());
            this._mapPanel.paintMap();
        } else if (!(this._creatingRegion && e.isControlDown() || this._creatingRegion && !e.isControlDown())) {
            if (!this._editingPt && !this._creatingRegion && e.isControlDown()) {
                if (!this.findStudySystemGlyph()) {
                    return;
                }
                if (!this.isConfigurationLocked("Cannot Edit ComputationPoints")) {
                    return;
                }
                if (this.isInResevoir(e.getX(), e.getY())) {
                    AppDaddy.getApp().postError("Can't create Computation Point inside a Reservoir", "Error");
                    return;
                }
                this._creatingRegion = true;
                this._pt0.init(e.getX(), e.getY());
                this._pt.init(this._pt0);
                this.drawPt(this._pt, true);
                this._compPt = this._sysglyph.createCompPt(this._pt);
                this._creatingRegion = false;
            } else if (this._selectedPt == null && (e.isPopupTrigger() || StudyComputationPointMouseAdapter.pressedButton3((MouseEvent)e)) && !this.findStudySystemGlyph()) {
                return;
            }
        }
    }

    private boolean isInResevoir(int x, int y) {
        StreamElement rch;
        if (!this.findStudySystemGlyph()) {
            return false;
        }
        if (!this.findStreamAlignmentGlyph()) {
            return false;
        }
        WorldPt wpt = this._mapPanel.scale().lp2wp(new LocalPt(x, y));
        Reservoir res = this._sysglyph.findReservoir(wpt);
        return res != null && (rch = this._alignglyph.findReach(wpt)) != null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() || StudyComputationPointMouseAdapter.pressedButton3((MouseEvent)e)) {
            if (!this.findStudySystemGlyph()) {
                return;
            }
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            this._sysglyph.compPtPopupMenu(pt);
        } else if (!this._creatingRegion && (this._creatingRegion || !e.isControlDown()) && this._editingPt && this._compPt != null) {
            WorldPt wpt;
            if (!this.findStudySystemGlyph()) {
                return;
            }
            this._pt.init(e.getX(), e.getY());
            this._pt0.init(this._pt);
            LocalPt lpt = new LocalPt();
            if (this._compPt.getSnapToStream()) {
                if (this._stream == null) {
                    return;
                }
                wpt = this._stream.getLocationByStation(this._compPt.getStreamStation());
            } else {
                wpt = this._compPt.getReferencePt();
            }
            this._mapPanel.scale().wp2lp(wpt, lpt);
            this._lrc.init(this._pt.x - 8, this._pt.y - 8, this._pt.x + 8, this._pt.y + 8);
            if (!this._lrc.contains(lpt)) {
                return;
            }
            if (this._compPt.getSnapToStream()) {
                wpt = this._mapPanel.scale().lp2wp(this._pt);
                double coord = this._stream.getLine().getCoordAtLocation(wpt);
                double station = this._stream.getStationByCoord(coord);
                lpt = this._mapPanel.scale().wp2lp(this._stream.getLocationByCoord(coord));
                this._pt.init(lpt);
                boolean hasReservoir = this._compPt.hasReservoirProject();
                ComputationPoint cpt = this._sysglyph.getUpstreamComputationPoint(this._compPt, hasReservoir);
                this._maxUpstreamStation = cpt != null ? cpt.getStreamStation() : -1.0;
                cpt = this._sysglyph.getDownstreamComputationPoint(this._compPt, hasReservoir);
                this._maxDownstreamStation = cpt != null ? cpt.getStreamStation() : -1.0;
            }
            this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(13));
            Graphics g = this._mapCanvas.getGraphics();
            g.setXORMode(new Color(255, 255, 255));
            g.fillRect(this._pt.x - 5, this._pt.y - 5, 10, 10);
            g.setPaintMode();
            g.dispose();
            this._moving = true;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this._creatingRegion) {
            super.mouseMoved(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this._editingPt && this._compPt != null && this._moving) {
            Graphics g = this._mapCanvas.getGraphics();
            g.setXORMode(new Color(255, 255, 255));
            g.fillRect(this._pt.x - 5, this._pt.y - 5, 10, 10);
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            if (this._compPt.getSnapToStream()) {
                WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
                double coord = this._stream.getLine().getCoordAtLocation(wpt);
                double station = this._stream.getStationByCoord(coord);
                if (this._maxDownstreamStation > -1.0 && station < this._maxDownstreamStation) {
                    station = this._maxDownstreamStation;
                    coord = this._stream.getCoordByStation(station);
                }
                if (this._maxUpstreamStation > -1.0 && station > this._maxUpstreamStation) {
                    station = this._maxUpstreamStation;
                    coord = this._stream.getCoordByStation(station);
                }
                pt = this._mapPanel.scale().wp2lp(this._stream.getLocationByCoord(coord));
            }
            this._pt.init(pt);
            g.fillRect(this._pt.x - 5, this._pt.y - 5, 10, 10);
            g.setPaintMode();
            g.dispose();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this._creatingRegion && e.getClickCount() == 2) {
            if (!this.findStudySystemGlyph()) {
                return;
            }
            this._pt.init(e.getX(), e.getY());
            ComputationPoint compPt = this._sysglyph.findCompPt(this._pt);
            if (compPt != null && !this.isConfigurationLocked("Cannot Edit ComputationPoints")) {
                return;
            }
            if (compPt == null) {
                this._editingPt = false;
                this._stream = null;
            } else if (compPt.getSnapToStream()) {
                compPt = this._sysglyph.selectCompPt(this._pt, false, true);
                this._alignmentGlyph = (StreamAlignmentGlyph)this._mapPanel.findGlyphOfClass(StreamAlignmentGlyph.class.getName());
                this._editingPt = false;
                this._stream = this._alignmentGlyph != null ? this._alignmentGlyph.findReach(compPt.getStreamId()) : null;
                if (this._stream != null) {
                    this._editingPt = true;
                }
            } else {
                compPt = this._sysglyph.selectCompPt(this._pt, false, true);
                this._editingPt = true;
                this._stream = null;
            }
            this._compPt = compPt;
        } else if (!this._editingPt) {
            if (!this.findStudySystemGlyph()) {
                return;
            }
            this._pt.init(e.getX(), e.getY());
            ComputationPoint compPt = this._sysglyph.selectCompPt(this._pt, false, false);
            this._editingPt = false;
            this._compPt = compPt;
        }
    }

    void drawPt(LocalPt pt, boolean isXOR) {
        Graphics g = this._mapCanvas.getGraphics();
        if (isXOR) {
            g.setXORMode(new Color(255, 255, 255));
        } else {
            g.setColor(Color.black);
        }
        StudyComputationPointMouseAdapter._xpt[0] = pt.x - 3;
        StudyComputationPointMouseAdapter._ypt[0] = pt.y;
        StudyComputationPointMouseAdapter._xpt[1] = pt.x;
        StudyComputationPointMouseAdapter._ypt[1] = pt.y + 3;
        StudyComputationPointMouseAdapter._xpt[2] = pt.x + 3;
        StudyComputationPointMouseAdapter._ypt[2] = pt.y;
        StudyComputationPointMouseAdapter._xpt[3] = pt.x;
        StudyComputationPointMouseAdapter._ypt[3] = pt.y - 3;
        g.fillPolygon(_xpt, _ypt, 4);
        g.setPaintMode();
        g.dispose();
    }

    void drawRegion(LocalRegion lreg, boolean isXOR) {
        Graphics g = this._mapCanvas.getGraphics();
        if (isXOR) {
            g.setXORMode(new Color(255, 255, 255));
        } else {
            g.setColor(Color.black);
        }
        int icnt = 0;
        for (int i = 0; i < lreg.pts.size() && i < 4000; ++i) {
            LocalPt pt = (LocalPt)lreg.pts.elementAt(i);
            if (pt == null) continue;
            StudyComputationPointMouseAdapter._xpt[0] = pt.x - 3;
            StudyComputationPointMouseAdapter._ypt[0] = pt.y;
            StudyComputationPointMouseAdapter._xpt[1] = pt.x;
            StudyComputationPointMouseAdapter._ypt[1] = pt.y + 3;
            StudyComputationPointMouseAdapter._xpt[2] = pt.x + 3;
            StudyComputationPointMouseAdapter._ypt[2] = pt.y;
            StudyComputationPointMouseAdapter._xpt[3] = pt.x;
            StudyComputationPointMouseAdapter._ypt[3] = pt.y - 3;
            g.fillPolygon(_xpt, _ypt, 4);
            StudyComputationPointMouseAdapter._xp[icnt] = pt.x;
            StudyComputationPointMouseAdapter._yp[icnt] = pt.y;
            ++icnt;
        }
        g.drawPolygon(_xp, _yp, icnt);
        g.setPaintMode();
        g.dispose();
    }

    void drawCompPt(ComputationPoint compPt, boolean isXOR) {
        if (this._sysglyph == null || compPt == null) {
            return;
        }
        Graphics g = this._mapCanvas.getGraphics();
        this._sysglyph.drawSelectedCompPt(g, this._mapPanel.scale(), compPt, isXOR, this._editingPt);
        g.dispose();
    }
}

