/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.watershed.client.DiversionDrawPropData;
import hec.watershed.client.StudyDPData;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.Hashtable;
import rma.util.RMAIO;

public class StudyDiversionDPData
extends StudyDPData
implements Serializable,
DiversionDrawPropData {
    private static final String FILL_COLOR_STR = "StudyDiversionDPData.fillColor";
    private static final String OUTLINE_COLOR_STR = "StudyDiversionDPData.outlineColor";
    private static final String CONNECTED_COLOR_STR = "StudyDiversionDPData.conColor";
    private static final String DISCONNECTED_COLOR_STR = "StudyDiversionDPData.disConColor";
    private static final String DRAW_NAME_STR = "StudyDiversionDPData.drawName";
    private static final String NAME_FONT_STR = "StudyDiversionDPData.nameFont";
    private static final String DIVERSION_WIDTH_STR = "StudyDiversionDPData.diversionWidth";
    public Color fillColor;
    public Color outlineColor;
    public Color conColor;
    public Color disConColor;
    public boolean drawName;
    public Font nameFont;
    public int diversionWidth;
    Hashtable _properties = new Hashtable();
    static StudyDiversionDPData _diversionData = new StudyDiversionDPData();

    protected StudyDiversionDPData() {
        this.load();
    }

    private void load() {
        if (_props == null) {
            return;
        }
        String s = _props.getProp(FILL_COLOR_STR, "-16777216");
        this.fillColor = Color.decode(s);
        s = _props.getProp(OUTLINE_COLOR_STR, "-16777216");
        this.outlineColor = Color.decode(s);
        s = _props.getProp(CONNECTED_COLOR_STR, "-16776961");
        this.conColor = Color.decode(s);
        s = _props.getProp(DISCONNECTED_COLOR_STR, "-16777216");
        this.disConColor = Color.decode(s);
        s = _props.getProp(DRAW_NAME_STR, "true");
        this.drawName = Boolean.valueOf(s);
        s = _props.getProp(NAME_FONT_STR, "SansSerif-plain-10");
        this.nameFont = Font.decode(s);
        if (this.nameFont == null) {
            this.nameFont = new Font("SansSerif", 0, 10);
        }
        s = _props.getProp(DIVERSION_WIDTH_STR, "6");
        this.diversionWidth = RMAIO.parseInt((String)s);
    }

    @Override
    public void save() {
        if (_props == null) {
            return;
        }
        _props.setProp(FILL_COLOR_STR, "" + this.fillColor.getRGB());
        _props.setProp(OUTLINE_COLOR_STR, "" + this.outlineColor.getRGB());
        _props.setProp(CONNECTED_COLOR_STR, "" + this.conColor.getRGB());
        _props.setProp(DISCONNECTED_COLOR_STR, "" + this.disConColor.getRGB());
        _props.setProp(DRAW_NAME_STR, "" + this.drawName);
        _props.setProp(NAME_FONT_STR, this.nameFont.getName() + "-" + this.getFontStyleString(this.nameFont) + "-" + this.nameFont.getSize());
        _props.setProp(DIVERSION_WIDTH_STR, "" + this.diversionWidth);
        _props.saveProperties();
    }

    @Override
    public void setDefaults() {
        this.diversionWidth = 6;
        this.fillColor = Color.black;
        this.outlineColor = Color.black;
        this.conColor = Color.blue;
        this.disConColor = Color.black;
        this.drawName = true;
        this.nameFont = new Font("SansSerif", 0, 10);
    }

    public static StudyDiversionDPData getData() {
        return _diversionData;
    }

    public Hashtable getProperties() {
        this._properties.clear();
        this._properties.put(FILL_COLOR_STR, "" + this.fillColor.getRGB());
        this._properties.put(OUTLINE_COLOR_STR, "" + this.outlineColor.getRGB());
        this._properties.put(CONNECTED_COLOR_STR, "" + this.conColor.getRGB());
        this._properties.put(DISCONNECTED_COLOR_STR, "" + this.disConColor.getRGB());
        this._properties.put(DRAW_NAME_STR, "" + this.drawName);
        this._properties.put(NAME_FONT_STR, this.nameFont.getName() + "-" + this.nameFont.getStyle() + "-" + this.nameFont.getSize());
        this._properties.put(DIVERSION_WIDTH_STR, "" + this.diversionWidth);
        return this._properties;
    }

    @Override
    public int getDiversionWidth() {
        return this.diversionWidth;
    }

    @Override
    public Color getFillColor() {
        return this.fillColor;
    }

    @Override
    public Font getNameFont() {
        return this.nameFont;
    }

    @Override
    public Color getOutlineColor() {
        return this.outlineColor;
    }

    @Override
    public boolean isDrawName() {
        return this.drawName;
    }

    @Override
    public Color getConColor() {
        return this.conColor;
    }

    @Override
    public Color getDisConColor() {
        return this.disConColor;
    }

    @Override
    public void setFillColor(Color selectedColor) {
        this.fillColor = selectedColor;
    }

    @Override
    public void setOutlineColor(Color selectedColor) {
        this.outlineColor = selectedColor;
    }

    @Override
    public void setConColor(Color selectedColor) {
        this.conColor = selectedColor;
    }

    @Override
    public void setDisConColor(Color selectedColor) {
        this.disConColor = selectedColor;
    }

    @Override
    public void setDrawName(boolean draw) {
        this.drawName = draw;
    }

    @Override
    public void setDiversionWidth(int width) {
        this.diversionWidth = width;
    }

    @Override
    public void setNameFont(Font font) {
        this.nameFont = font;
    }
}

