/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.LocalRegion;
import hec.map.MapCanvas;
import hec.map.MapPanel;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.model.Node;
import hec.model.StreamElement;
import hec.watershed.client.StudyMouseAdapter;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.Diversion;
import hec.watershed.model.Reservoir;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JOptionPane;
import rma.swing.RmaImage;

public class StudyDiversionMouseAdapter
extends StudyMouseAdapter
implements MouseListener,
MouseMotionListener {
    public static final String NODRAG_CURSOR = "NoDragCursor";
    private static Cursor _noDragCursor;
    Vector _ptVec = new Vector();
    boolean _creatingDiv = false;
    boolean _editingDiv = false;
    boolean _movingOutflow = false;
    boolean _movingInflow = false;
    boolean _toolTipShowing = false;
    int _inFlowType = 0;
    LocalPt _beginPt = new LocalPt();
    LocalPt _endPt = new LocalPt();
    LocalPt _pt = new LocalPt();
    LocalPt _pt0 = new LocalPt();
    LocalPt _selectedPt = null;
    WorldPt _selectedWPt = null;
    LocalRect _lrc = new LocalRect();
    WorldRect _wrc = new WorldRect();
    Diversion _diversion;
    Node _selectedNode = null;
    Node _divNode0;
    Node _divNode1;
    StreamElement _stream = null;
    static int[] _xpt;
    static int[] _ypt;
    static int[] _xp;
    static int[] _yp;

    public StudyDiversionMouseAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
        if (_noDragCursor == null) {
            Image noDragCursor = RmaImage.loadURLImage((String)"Images/NoDragCursor.gif");
            _noDragCursor = Toolkit.getDefaultToolkit().createCustomCursor(noDragCursor, new Point(0, 0), NODRAG_CURSOR);
        }
    }

    @Override
    public void abort() {
        if (this._sysglyph != null) {
            this._sysglyph.clearSelection();
        }
        this._creatingDiv = false;
        this._editingDiv = false;
        this.setDiversion(null);
    }

    WorldPt findReservoir(WorldPt wpt) {
        if (!this.findStudySystemGlyph()) {
            return null;
        }
        Reservoir res = this._sysglyph.findReservoir(wpt);
        if (res == null) {
            return null;
        }
        return wpt;
    }

    WorldPt findStream(WorldPt wpt) {
        StreamAlignmentGlyph glyph = (StreamAlignmentGlyph)this._mapPanel.findGlyphOfClass(StreamAlignmentGlyph.class.getName());
        if (glyph == null) {
            return null;
        }
        LocalPt lpt = this._mapPanel.scale().wp2lp(wpt);
        StreamElement reach = glyph.findReach(lpt, null);
        if (reach == null) {
            return null;
        }
        double tol = this._mapPanel.scale().x2e(lpt.x + 5) - this._mapPanel.scale().x2e(lpt.x);
        this._wrc.init(wpt.e - tol, wpt.n + tol, wpt.e + tol, wpt.n - tol);
        double coord = reach.getLine().getCoordAtLocation(wpt);
        if (coord == Double.NEGATIVE_INFINITY) {
            return null;
        }
        WorldPt rchWpt = reach.getLocationByCoord(coord);
        if (this._wrc.contains(rchWpt)) {
            return rchWpt;
        }
        return null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.findStudySystemGlyph()) {
            return;
        }
        if (this._creatingDiv && !e.isControlDown()) {
            this._creatingDiv = false;
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
            WorldPt endWpt = null;
            Reservoir res = this._sysglyph.findReservoir(wpt);
            if (res != null && this._sysglyph.findCompPt(pt) == null) {
                int opt = JOptionPane.showConfirmDialog((Component)this._mapPanel, "Diversion outflow can not end on in a Reservoir.\nWould you like to connect the Diversion to the upstream Computation Point?", "Invalid ending location", 0);
                if (opt == 0) {
                    Node node = res.getUpstreamNode();
                    wpt = node.getLocation();
                    this._mapPanel.scale().wp2lp(wpt, pt);
                } else {
                    this._mapPanel.viewport().setCursor(this.getCursor());
                    this._mapPanel.paintMap();
                    return;
                }
            }
            this._divNode1 = (endWpt = this.findStream(wpt)) != null ? this._sysglyph.createDiversionNode(pt, this._divNode0) : null;
            this._sysglyph.createDiversion(this._divNode0, this._divNode1, this._ptVec, this._inFlowType);
            this._mapPanel.viewport().setCursor(this.getCursor());
        } else if (this._selectedNode != null) {
            WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
            StreamAlignmentGlyph alignmentGlyph = (StreamAlignmentGlyph)this._mapPanel.findGlyphOfClass(StreamAlignmentGlyph.class.getName());
            this._stream = alignmentGlyph.findReach(this._selectedNode.getStreamIndex());
            double coord = this._stream.getLine().getCoordAtLocation(wpt);
            this._selectedNode.setStreamCoord(coord);
            this._selectedNode.setStreamIndex(this._stream.getIndex());
            this._selectedNode.setStreamStation(this._stream.getStationByCoord(coord));
            this._selectedNode.setLocation(wpt);
            this._selectedNode = null;
            if (this._diversion != null) {
                this._diversion.setModified(true);
            }
            this._mapPanel.paintMap();
            this._mapPanel.viewport().setCursor(this.getCursor());
        } else if (this._selectedPt != null) {
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            Reservoir res = this._sysglyph.findReservoir(pt);
            this._sysglyph.connectDiversionElement(this._diversion, this._selectedPt);
            if (this._movingOutflow) {
                WorldPt wpt;
                WorldPt endWpt;
                if (res != null) {
                    pt = this._selectedPt;
                }
                if ((endWpt = this.findStream(wpt = this._mapPanel.scale().lp2wp(pt))) != null) {
                    Node node = this._diversion.getDownstreamNode();
                    if (node != null) {
                        node.setLocation(endWpt);
                        this._diversion.setModified(true);
                    } else {
                        int opt;
                        pt = this._mapPanel.scale().wp2lp(endWpt);
                        ComputationPoint cp = this._sysglyph.findCompPt(pt);
                        if (cp != null && (opt = JOptionPane.showConfirmDialog((Component)this._mapPanel, "<html>Connection Diversion <b>" + this._diversion.getName() + "</b>'s outflow to Computation Point <b>" + cp.getName() + "</b>?", "Connection Found", 0)) == 0) {
                            this._divNode1 = this._sysglyph.createDiversionNode(pt, this._diversion.getUpstreamNode());
                            this._diversion.connectDownstream(this._divNode1, cp);
                        }
                    }
                    wpt = this._diversion.getLine().getLastPt();
                    wpt.init(endWpt);
                } else {
                    Node node = this._diversion.getDownstreamNode();
                    if (node != null) {
                        this._diversion.removeNode(node);
                    }
                }
                this._diversion.setModified(true);
            }
            this._selectedPt = null;
            this._selectedWPt = null;
            this._movingOutflow = false;
            this._mapPanel.viewport().setCursor(this.getCursor());
            this._mapPanel.paintMap();
        } else if (e.isPopupTrigger() || StudyDiversionMouseAdapter.pressedButton3((MouseEvent)e)) {
            // empty if block
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if ((e.isPopupTrigger() || StudyDiversionMouseAdapter.pressedButton3((MouseEvent)e)) && !e.isControlDown()) {
            if (!this.findStudySystemGlyph()) {
                return;
            }
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            this._sysglyph.diversionPopupMenu(pt);
        }
        StreamAlignmentGlyph alignmentGlyph = (StreamAlignmentGlyph)this._mapPanel.findGlyphOfClass("hec.map.streamAlignment.StreamAlignmentGlyph");
        if (this._creatingDiv) {
            this._pt0.init(this._pt);
            this._pt.init(e.getX(), e.getY());
            this.drawPt(this._pt, true);
            WorldPt wpt = this._mapPanel.scale().lp2wp(new LocalPt(this._pt));
            this._ptVec.addElement(wpt);
        } else if (this._editingDiv && e.isControlDown() && e.isShiftDown()) {
            this._pt.init(e.getX(), e.getY());
            WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
            double tol = this._mapPanel.scale().x2e(this._pt.x + 5) - this._mapPanel.scale().x2e(this._pt.x);
            this._diversion.getLine().removePt(wpt, tol);
            this._diversion.setModified(true);
            this._mapPanel.paintMap();
        } else if (this._editingDiv && e.isControlDown() && this._diversion != null) {
            this._pt.init(e.getX(), e.getY());
            WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
            double tol = this._mapPanel.scale().x2e(this._pt.x + 5) - this._mapPanel.scale().x2e(this._pt.x);
            this._diversion.getLine().insertPt(wpt, tol);
            this._diversion.setModified(true);
            this.drawDiversion(this._diversion, false);
        } else if (!this._creatingDiv && e.isControlDown()) {
            if (!this.findStudySystemGlyph()) {
                return;
            }
            if (!this.isConfigurationLocked("Cannot Create Diversions")) {
                return;
            }
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
            WorldPt startWpt = this.findReservoir(wpt);
            if (startWpt == null) {
                startWpt = this.findStream(wpt);
                if (startWpt == null) {
                    this._inFlowType = 0;
                    return;
                }
                this._inFlowType = 0;
            } else {
                this._inFlowType = 1;
            }
            LocalPt startLpt = this._mapPanel.scale().wp2lp(startWpt);
            this._pt0.init(startLpt);
            this._pt.init(this._pt0);
            this.drawPt(this._pt, true);
            this._divNode0 = this._sysglyph.createDiversionNode(this._pt, null);
            this._ptVec.removeAllElements();
            wpt = this._mapPanel.scale().lp2wp(new LocalPt(this._pt));
            if (this._divNode0 == null) {
                return;
            }
            this._creatingDiv = true;
            this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
            this._ptVec.addElement(this._divNode0.getLocation());
        } else if (this._editingDiv && this._diversion != null) {
            this._pt.init(e.getX(), e.getY());
            this._pt0.init(this._pt);
            LocalPt lpt = new LocalPt();
            WorldPt wpt = this._diversion.getReferencePt();
            this._mapPanel.scale().wp2lp(wpt, lpt);
            this._lrc.init(this._pt.x - 8, this._pt.y - 8, this._pt.x + 8, this._pt.y + 8);
            if (this._lrc.contains(lpt)) {
                this._selectedNode = this._diversion.getUpstreamNode();
                if (this._selectedNode == null) {
                    return;
                }
                int streamId = this._selectedNode.getStreamIndex();
                this._stream = alignmentGlyph.findReach(streamId);
                double coord = this._stream.getLine().getCoordAtLocation(wpt);
                lpt = this._mapPanel.scale().wp2lp(this._stream.getLocationByCoord(coord));
                this._pt.init(lpt);
                this._movingInflow = true;
                this._movingOutflow = false;
                this._selectedPt = lpt;
                this._selectedWPt = wpt;
                this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
                return;
            }
            this._movingInflow = false;
            wpt = this._diversion.getLine().getLastPt();
            this._mapPanel.scale().wp2lp(wpt, lpt);
            this._lrc.init(this._pt.x - 8, this._pt.y - 8, this._pt.x + 8, this._pt.y + 8);
            if (this._lrc.contains(lpt)) {
                if (this._diversion.getDownstreamNode() != null) {
                    return;
                }
                this._movingOutflow = true;
                this._selectedPt = lpt;
                this._selectedWPt = wpt;
                this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
            } else {
                this._movingOutflow = false;
                this._lrc.init(this._pt.x - 3, this._pt.y - 3, this._pt.x + 3, this._pt.y + 3);
                for (int i = 0; i < this._diversion.getLine().pts.size(); ++i) {
                    wpt = (WorldPt)this._diversion.getLine().pts.elementAt(i);
                    if (wpt == null) continue;
                    this._mapPanel.scale().wp2lp(wpt, lpt);
                    if (!this._lrc.contains(lpt)) continue;
                    this._selectedPt = lpt;
                    this._selectedWPt = wpt;
                    this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
                    return;
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this._creatingDiv) {
            Graphics g = this._mapCanvas.getGraphics();
            g.setXORMode(new Color(255, 255, 255));
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            this._pt.init(e.getX(), e.getY());
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            Reservoir res = this._sysglyph.findReservoir(this._pt);
            if (res != null) {
                try {
                    this._mapPanel.viewport().setCursor(_noDragCursor);
                }
                catch (Exception ee) {
                    System.out.println("failed to find no drag cursor " + ee);
                }
            } else {
                this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
            }
            g.setPaintMode();
            g.dispose();
        } else {
            super.mouseMoved(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this._selectedNode != null && this._diversion != null && this._diversion.getInflowType() == 1) {
            Graphics g = this._mapCanvas.getGraphics();
            g.setXORMode(new Color(255, 255, 255));
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            if (!this._pt.equals(this._pt0)) {
                this.drawPt(this._pt, true);
            }
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
            Reservoir res = this._sysglyph.findReservoir(wpt);
            if (res == null) {
                return;
            }
            double resNode1 = res.getDownstreamNode().getStreamCoord();
            double coord = this._diversion.getLine().getCoordAtLocation(wpt);
            if (this._movingInflow) {
                Object n;
                wpt = this._mapPanel.scale().lp2wp(pt);
                coord = this._stream.getLine().getCoordAtLocation(wpt);
                double dCoord = this._diversion.getUpstreamNode().getStreamCoord();
                if (dCoord < resNode1) {
                    return;
                }
                if (coord < dCoord ? (n = null) != null && coord < n.getStreamCoord() : (n = null) != null && coord > n.getStreamCoord()) {
                    return;
                }
                pt = this._mapPanel.scale().wp2lp(this._stream.getLocationByCoord(coord));
                wpt = this._mapPanel.scale().lp2wp(pt);
            } else if (res != null) {
                try {
                    this._mapPanel.viewport().setCursor(_noDragCursor);
                }
                catch (Exception ee) {
                    System.out.println("failed to find no drag cursor " + ee);
                }
            } else {
                this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
            }
            this._pt.init(pt);
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            if (!this._pt.equals(this._pt0)) {
                this.drawPt(this._pt, true);
            }
            g.setPaintMode();
            g.dispose();
        } else if (this._selectedNode != null && this._diversion != null) {
            Graphics g = this._mapCanvas.getGraphics();
            g.setXORMode(new Color(255, 255, 255));
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            if (!this._pt.equals(this._pt0)) {
                this.drawPt(this._pt, true);
            }
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
            double coord = this._diversion.getLine().getCoordAtLocation(wpt);
            if (this._movingInflow) {
                Object n;
                double dCoord;
                wpt = this._mapPanel.scale().lp2wp(pt);
                coord = this._stream.getLine().getCoordAtLocation(wpt);
                if (coord < (dCoord = this._diversion.getUpstreamNode().getStreamCoord()) ? (n = null) != null && coord < n.getStreamCoord() : (n = null) != null && coord > n.getStreamCoord()) {
                    return;
                }
                pt = this._mapPanel.scale().wp2lp(this._stream.getLocationByCoord(coord));
                wpt = this._mapPanel.scale().lp2wp(pt);
            } else if (this._movingOutflow) {
                Object n;
                wpt = this._mapPanel.scale().lp2wp(pt);
                coord = this._stream.getLine().getCoordAtLocation(wpt);
                double dCoord = this._diversion.getDownstreamNode().getStreamCoord();
                Reservoir res = this._sysglyph.findReservoir(wpt);
                if (res != null) {
                    try {
                        this._mapPanel.viewport().setCursor(_noDragCursor);
                    }
                    catch (Exception ee) {
                        System.out.println("failed to find no drag cursor " + ee);
                    }
                } else {
                    this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
                }
                if (coord < dCoord ? (n = null) != null && coord < n.getStreamCoord() : (n = null) != null && coord > n.getStreamCoord()) {
                    return;
                }
                pt = this._mapPanel.scale().wp2lp(this._stream.getLocationByCoord(coord));
                wpt = this._mapPanel.scale().lp2wp(pt);
            }
            this._pt.init(pt);
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            if (!this._pt.equals(this._pt0)) {
                this.drawPt(this._pt, true);
            }
            g.setPaintMode();
            g.dispose();
        } else if (this._selectedPt != null && this._diversion != null) {
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            Reservoir res = this._sysglyph.findReservoir(pt);
            if (res != null) {
                try {
                    this._mapPanel.viewport().setCursor(_noDragCursor);
                }
                catch (Exception ee) {
                    System.out.println("failed to find no drag cursor " + ee);
                }
                return;
            }
            this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
            this.drawDiversion(this._diversion, true);
            this._selectedPt.init(e.getX(), e.getY());
            this._mapPanel.scale().lp2wp(this._selectedPt, this._selectedWPt);
            this.drawDiversion(this._diversion, true);
            this._diversion.setModified(true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this._creatingDiv) {
            if (e.getClickCount() == 2) {
                if (!this.findStudySystemGlyph()) {
                    return;
                }
                this._pt.init(e.getX(), e.getY());
                WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
                double tol = this._mapPanel.scale().x2e(this._pt.x + 10) - this._mapPanel.scale().x2e(this._pt.x);
                Diversion div = this._sysglyph.findDiversion(wpt, tol);
                if (div != null) {
                    this._editingDiv = this.isConfigurationLocked("Cannot Edit Diversions") ? true : true;
                    this._sysglyph.selectDiversion(div, false, this._editingDiv);
                } else {
                    this._editingDiv = false;
                }
                this.setDiversion(div);
            } else if (!this._editingDiv) {
                if (!this.findStudySystemGlyph()) {
                    return;
                }
                this._pt.init(e.getX(), e.getY());
                Diversion div = this._sysglyph.selectDiversion(this._pt, false, false);
                this._editingDiv = false;
                this.setDiversion(div);
            }
        }
    }

    void drawPt(LocalPt pt, boolean isXOR) {
        Graphics g = this._mapCanvas.getGraphics();
        if (isXOR) {
            g.setXORMode(new Color(255, 255, 255));
        } else {
            g.setColor(Color.black);
        }
        StudyDiversionMouseAdapter._xpt[0] = pt.x - 3;
        StudyDiversionMouseAdapter._ypt[0] = pt.y;
        StudyDiversionMouseAdapter._xpt[1] = pt.x;
        StudyDiversionMouseAdapter._ypt[1] = pt.y + 3;
        StudyDiversionMouseAdapter._xpt[2] = pt.x + 3;
        StudyDiversionMouseAdapter._ypt[2] = pt.y;
        StudyDiversionMouseAdapter._xpt[3] = pt.x;
        StudyDiversionMouseAdapter._ypt[3] = pt.y - 3;
        g.fillPolygon(_xpt, _ypt, 4);
        g.setPaintMode();
        g.dispose();
    }

    void drawRegion(LocalRegion lreg, boolean isXOR) {
        Graphics g = this._mapCanvas.getGraphics();
        if (isXOR) {
            g.setXORMode(new Color(255, 255, 255));
        } else {
            g.setColor(Color.black);
        }
        int icnt = 0;
        for (int i = 0; i < lreg.pts.size() && i < 4000; ++i) {
            LocalPt pt = (LocalPt)lreg.pts.elementAt(i);
            if (pt == null) continue;
            StudyDiversionMouseAdapter._xpt[0] = pt.x - 3;
            StudyDiversionMouseAdapter._ypt[0] = pt.y;
            StudyDiversionMouseAdapter._xpt[1] = pt.x;
            StudyDiversionMouseAdapter._ypt[1] = pt.y + 3;
            StudyDiversionMouseAdapter._xpt[2] = pt.x + 3;
            StudyDiversionMouseAdapter._ypt[2] = pt.y;
            StudyDiversionMouseAdapter._xpt[3] = pt.x;
            StudyDiversionMouseAdapter._ypt[3] = pt.y - 3;
            g.fillPolygon(_xpt, _ypt, 4);
            StudyDiversionMouseAdapter._xp[icnt] = pt.x;
            StudyDiversionMouseAdapter._yp[icnt] = pt.y;
            ++icnt;
        }
        g.drawPolygon(_xp, _yp, icnt);
        g.setPaintMode();
        g.dispose();
    }

    void drawDiversion(Diversion ireg, boolean isXOR) {
        if (this._sysglyph == null || ireg == null) {
            return;
        }
        Graphics g = this._mapCanvas.getGraphics();
        this._sysglyph.drawSelectedDiversion(g, this._mapPanel.scale(), ireg, isXOR, this._editingDiv);
        g.dispose();
    }

    private void setDiversion(Diversion div) {
        if (this._diversion == null || !this._diversion.isModified() || div != this._diversion) {
            // empty if block
        }
        this._diversion = div;
    }

    static {
        _xpt = new int[4];
        _ypt = new int[4];
        _xp = new int[4000];
        _yp = new int[4000];
    }
}

