/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.watershed.client.DiversionDrawPropData;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJFontButton;

public class StudyDiversionPropPanel
extends JPanel {
    DiversionDrawPropData _dpData;
    private RmaJColorComboBox fillColorCombo;
    private RmaJColorComboBox conFillColorCombo;
    private RmaJColorComboBox disConFillColorCombo;
    private RmaJCheckBox drawNameCB;
    private RmaJComboBox diversionWidthCombo;
    private RmaJFontButton nameFontBtn;

    public StudyDiversionPropPanel(DiversionDrawPropData dpData) {
        super(new GridBagLayout());
        this._dpData = dpData;
        this.buildControls();
        this.fillPanel();
    }

    private void buildControls() {
        JPanel lineElementPanel = new JPanel(new GridBagLayout());
        JPanel arrowHeadPanel = new JPanel(new GridBagLayout());
        lineElementPanel.setBorder(BorderFactory.createTitledBorder("Line Element:"));
        arrowHeadPanel.setBorder(BorderFactory.createTitledBorder("Arrowhead Element:"));
        this.add((Component)lineElementPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS5500, 0, 0));
        this.add((Component)arrowHeadPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 12, 2, RmaInsets.INSETS5505, 0, 0));
        JLabel label = new JLabel("Diverson Line Color:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        lineElementPanel.add((Component)label, gbc);
        this.fillColorCombo = new RmaJColorComboBox();
        this.fillColorCombo.setModifiable(true);
        label.setLabelFor((Component)this.fillColorCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        lineElementPanel.add((Component)this.fillColorCombo, gbc);
        label = new JLabel("Diversion Line Width:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        lineElementPanel.add((Component)label, gbc);
        Integer[] widthValues = new Integer[10];
        for (int i = 1; i <= 10; ++i) {
            widthValues[i - 1] = new Integer(i);
        }
        this.diversionWidthCombo = new RmaJComboBox(new DefaultComboBoxModel<Integer>(widthValues));
        this.diversionWidthCombo.setModifiable(true);
        label.setLabelFor((Component)this.diversionWidthCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        lineElementPanel.add((Component)this.diversionWidthCombo, gbc);
        label = new JLabel("Diversion Arrowhead Color - Connected:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        arrowHeadPanel.add((Component)label, gbc);
        this.conFillColorCombo = new RmaJColorComboBox();
        this.conFillColorCombo.setModifiable(true);
        label.setLabelFor((Component)this.conFillColorCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        arrowHeadPanel.add((Component)this.conFillColorCombo, gbc);
        label = new JLabel("Diversion Arrowhead Color - Disconnected:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        arrowHeadPanel.add((Component)label, gbc);
        this.disConFillColorCombo = new RmaJColorComboBox();
        this.disConFillColorCombo.setModifiable(true);
        label.setLabelFor((Component)this.disConFillColorCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        arrowHeadPanel.add((Component)this.disConFillColorCombo, gbc);
        JPanel tempPanel = new JPanel(new GridBagLayout());
        this.add((Component)tempPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 11, 0, RmaInsets.INSETS5555, 0, 0));
        tempPanel.setBorder(BorderFactory.createEtchedBorder());
        this.drawNameCB = new RmaJCheckBox("Draw Diversion Name");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        tempPanel.add((Component)this.drawNameCB, gbc);
        this.nameFontBtn = new RmaJFontButton("Font...");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        tempPanel.add((Component)this.nameFontBtn, gbc);
    }

    public static void main(String[] args) {
        JDialog dialog = new JDialog((Frame)null, true);
        dialog.getContentPane().add((Component)new StudyDiversionPropPanel(null), "Center");
        dialog.pack();
        dialog.setLocation(300, 300);
        dialog.setVisible(true);
    }

    public void fillPanel() {
        if (this._dpData == null) {
            return;
        }
        this.fillColorCombo.setSelectedColor(this._dpData.getFillColor());
        this.conFillColorCombo.setSelectedColor(this._dpData.getConColor());
        this.disConFillColorCombo.setSelectedColor(this._dpData.getDisConColor());
        this.diversionWidthCombo.setSelectedItem((Object)new Integer(this._dpData.getDiversionWidth()));
        this.drawNameCB.setSelected(this._dpData.isDrawName());
        this.nameFontBtn.setFont(this._dpData.getNameFont());
    }

    public void savePanel() {
        this._dpData.setFillColor(this.fillColorCombo.getSelectedColor());
        this._dpData.setOutlineColor(this.fillColorCombo.getSelectedColor());
        this._dpData.setConColor(this.conFillColorCombo.getSelectedColor());
        this._dpData.setDisConColor(this.disConFillColorCombo.getSelectedColor());
        this._dpData.setDrawName(this.drawNameCB.isSelected());
        this._dpData.setDiversionWidth((Integer)this.diversionWidthCombo.getSelectedItem());
        this._dpData.setNameFont(this.nameFontBtn.getFont());
        this._dpData.save();
    }
}

