/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.map.AttributeInfo;
import hec.watershed.client.HecModelDrawingAttributeSet;
import hec.watershed.client.StudyChannelModDPData;
import hec.watershed.client.StudyCompPtDPData;
import hec.watershed.client.StudyDiversionDPData;
import hec.watershed.client.StudyLeveeDPData;
import hec.watershed.client.StudyReservoirDPData;
import hec.watershed.client.StudyStationSetDPData;
import hec.watershed.client.StudySystemGlyph;
import hec.watershed.client.StudySystemMapGlyph;
import hec.watershed.model.ComputationPointLayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class StudyDrawingAttributeSet
extends HecModelDrawingAttributeSet {
    private static final Color DEFAULT_OBS_STATION_COLOR = new Color(37, 143, 203);
    private static final Color DEFAULT_MET_STATION_COLOR = new Color(162, 94, 200);
    public static final String NAME = "StudyDrawingAttributeSet";
    public static final String RESERVOIRS = "Reservoirs";
    public static final String LEVEES = "Levees";
    public static final String DIVERSIONS = "Diversions";
    public static final String CHANNEL_MODS = "Channel Modifications";
    public static final String OFF_CHANNEL_STORAGE = "Off Channel Storage";
    public static final String OTHER_PROJECTS = "Other Projects";
    public static final String IMPACT_AREAS = "Impact Areas";
    public static final String COMPUTATION_POINTS = "Computation Points";
    public static final String STATIONS = "Stations";
    public static final String LABELS = "Names";
    private HecModelDrawingAttributeSet.HecSymbolIcon _reservoirIcon = new HecModelDrawingAttributeSet.HecSymbolIcon(12);
    private HecModelDrawingAttributeSet.HecSymbolIcon _leveeIcon = new HecModelDrawingAttributeSet.HecSymbolIcon(15);
    private HecModelDrawingAttributeSet.HecSymbolIcon _diversionIcon = new HecModelDrawingAttributeSet.HecSymbolIcon(13);
    private HecModelDrawingAttributeSet.HecSymbolIcon _channelModIcon = new HecModelDrawingAttributeSet.HecSymbolIcon(14);
    private HecModelDrawingAttributeSet.HecSymbolIcon _offChannelIcon = new HecModelDrawingAttributeSet.HecSymbolIcon(19);
    private HecModelDrawingAttributeSet.HecSymbolIcon _otherIcon = new HecModelDrawingAttributeSet.HecSymbolIcon(16);
    private HecModelDrawingAttributeSet.HecSymbolIcon _impactAreaIcon = new HecModelDrawingAttributeSet.HecSymbolIcon(17);
    private HecModelDrawingAttributeSet.HecSymbolIcon _compPtIcon = new HecModelDrawingAttributeSet.HecSymbolIcon(18);
    private StationIcon _stationIcon = new StationIcon();
    private StudySystemMapGlyph _glyph;

    public StudyDrawingAttributeSet() {
        this._attributes.put(RESERVOIRS, true);
        this._attributes.put(LEVEES, true);
        this._attributes.put(DIVERSIONS, true);
        this._attributes.put(CHANNEL_MODS, true);
        this._attributes.put(OFF_CHANNEL_STORAGE, true);
        this._attributes.put(OTHER_PROJECTS, true);
        this._attributes.put(IMPACT_AREAS, true);
        this._attributes.put(COMPUTATION_POINTS, true);
        this._attributes.put(LABELS, true);
        this._attributes.put(STATIONS, true);
        this.setName("Study");
    }

    public List<AttributeInfo> getAttributeInfo(String attrName) {
        if (this._glyph == null) {
            return null;
        }
        if (COMPUTATION_POINTS.equals(attrName)) {
            ArrayList<AttributeInfo> ainfoList = new ArrayList<AttributeInfo>();
            List<ComputationPointLayer> layers = this._glyph.getComputationPointLayers();
            for (int i = 0; i < layers.size(); ++i) {
                ComputationPointLayer layer = layers.get(i);
                AttributeInfo ainfo = new AttributeInfo(layer.getName(), layer.getIcon()){

                    public Icon getIcon() {
                        HecModelDrawingAttributeSet.HecSymbolIcon retVal = new HecModelDrawingAttributeSet.HecSymbolIcon(18);
                        StudyCompPtDPData data = ((StudySystemGlyph)StudyDrawingAttributeSet.this._glyph)._compPtData;
                        if (data != null) {
                            retVal.setFillColor(data.getFillColor());
                            retVal.setOutlineColor(data.getOutlineColor());
                        }
                        return retVal;
                    }
                };
                ainfoList.add(ainfo);
            }
            return ainfoList;
        }
        return null;
    }

    public Icon getIcon(String attrName) {
        if (attrName == null || attrName.length() < 1) {
            return super.getIcon(attrName);
        }
        if (attrName.equals(RESERVOIRS)) {
            StudyReservoirDPData data = ((StudySystemGlyph)this._glyph).resDPData;
            if (data != null) {
                this._reservoirIcon.setFillColor(data.getTriangleFillColor());
                this._reservoirIcon.setOutlineColor(data.getTriangleOutlineColor());
            }
            return this._reservoirIcon;
        }
        if (attrName.equals(LEVEES)) {
            StudyLeveeDPData data = ((StudySystemGlyph)this._glyph)._leveeData;
            if (data != null) {
                this._leveeIcon.setFillColor(data.getFillColor());
                this._leveeIcon.setOutlineColor(data.getOutlineColor());
            }
            return this._leveeIcon;
        }
        if (attrName.equals(DIVERSIONS)) {
            StudyDiversionDPData data = ((StudySystemGlyph)this._glyph)._diversionData;
            if (data != null) {
                this._diversionIcon.setFillColor(data.getFillColor());
                this._diversionIcon.setOutlineColor(data.getOutlineColor());
            }
            return this._diversionIcon;
        }
        if (attrName.equals(CHANNEL_MODS)) {
            StudyChannelModDPData data = ((StudySystemGlyph)this._glyph)._channelModDpData;
            if (data != null) {
                this._channelModIcon.setFillColor(data.getFillColor());
                this._channelModIcon.setOutlineColor(data.getFillColor());
            }
            return this._channelModIcon;
        }
        if (attrName.equals(OFF_CHANNEL_STORAGE)) {
            return this._offChannelIcon;
        }
        if (attrName.equals(OTHER_PROJECTS)) {
            return this._otherIcon;
        }
        if (attrName.equals(IMPACT_AREAS)) {
            return this._impactAreaIcon;
        }
        if (attrName.equals(COMPUTATION_POINTS)) {
            StudyCompPtDPData data = ((StudySystemGlyph)this._glyph)._compPtData;
            if (data != null) {
                this._compPtIcon.setFillColor(data.getFillColor());
            }
            return this._compPtIcon;
        }
        if (attrName.equals(STATIONS)) {
            return this._stationIcon;
        }
        return null;
    }

    public String getDrawPropDialogClassname() {
        return "ressim.hec.watershed.client.StudyPropertiesEditor";
    }

    public void setGlyph(StudySystemMapGlyph glyph) {
        this._glyph = glyph;
    }

    private class StationIcon
    implements Icon {
        Color transparentColor = Color.WHITE;

        private StationIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color metStationColor;
            Color obsStationColor;
            StudyStationSetDPData data = ((StudySystemGlyph)StudyDrawingAttributeSet.this._glyph)._stationSetData;
            if (data != null) {
                obsStationColor = data.getObservedStationColor();
                metStationColor = data.getMetStationColor();
            } else {
                obsStationColor = DEFAULT_OBS_STATION_COLOR;
                metStationColor = DEFAULT_MET_STATION_COLOR;
            }
            g.setColor(this.transparentColor);
            g.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
            int halfWidth = this.getIconWidth() / 2;
            int[] xPoints = new int[]{0, halfWidth, halfWidth};
            int[] yPoints = new int[]{this.getIconHeight() / 2, 0, this.getIconHeight()};
            g.setColor(obsStationColor);
            g.fillPolygon(new Polygon(xPoints, yPoints, 3));
            g.setColor(metStationColor);
            xPoints[0] = this.getIconWidth();
            xPoints[1] = halfWidth;
            xPoints[2] = halfWidth;
            g.fillPolygon(new Polygon(xPoints, yPoints, 3));
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }
}

