/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.watershed.client.ImpactAreaDrawPropData;
import hec.watershed.client.StudyDPData;
import java.awt.Font;
import java.util.Hashtable;

public class StudyImpactAreaDPData
extends StudyDPData
implements ImpactAreaDrawPropData {
    private static final String NAME_FONT_STR = "StudyImpactAreaDPData.nameFont";
    private static final String DRAW_NAME_STR = "StudyImpactAreaDPData.drawName";
    Hashtable _properties = new Hashtable();
    static StudyImpactAreaDPData _impactAreaData = new StudyImpactAreaDPData();
    public Font nameFont;
    public boolean drawName;

    public StudyImpactAreaDPData() {
        this.load();
    }

    private void load() {
        String s = _props.getProp(DRAW_NAME_STR, "true");
        this.drawName = Boolean.valueOf(s);
        s = _props.getProp(NAME_FONT_STR, "SansSerif-plain-10");
        this.nameFont = Font.decode(s);
        if (this.nameFont == null) {
            this.nameFont = new Font("SansSerif", 0, 10);
        }
    }

    @Override
    public void save() {
        if (_props == null) {
            return;
        }
        _props.setProp(DRAW_NAME_STR, "" + this.drawName);
        _props.setProp(NAME_FONT_STR, this.nameFont.getName() + "-" + this.getFontStyleString(this.nameFont) + "-" + this.nameFont.getSize());
        _props.saveProperties();
    }

    @Override
    public void setDefaults() {
        this.drawName = true;
        this.nameFont = new Font("SansSerif", 0, 10);
    }

    public static StudyImpactAreaDPData getData() {
        return _impactAreaData;
    }

    public Hashtable getProperties() {
        this._properties.clear();
        this._properties.put(DRAW_NAME_STR, "" + this.drawName);
        this._properties.put(NAME_FONT_STR, this.nameFont.getName() + "-" + this.nameFont.getStyle() + "-" + this.nameFont.getSize());
        return this._properties;
    }

    @Override
    public boolean isDrawName() {
        return this.drawName;
    }

    @Override
    public Font getNameFont() {
        return this.nameFont;
    }

    @Override
    public void setDrawName(boolean draw) {
        this.drawName = draw;
    }

    @Override
    public void setNameFont(Font font) {
        this.nameFont = font;
    }
}

