/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.clientapp.client.ClientApp;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.LocalRegion;
import hec.map.MapCanvas;
import hec.map.MapPanel;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.WorldRegion;
import hec.model.StreamElement;
import hec.watershed.client.ImpactAreaEditor;
import hec.watershed.client.StudyMouseAdapter;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ImpactArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import rma.swing.RmaJDialog;

public class StudyImpactAreaMouseAdapter
extends StudyMouseAdapter
implements MouseListener,
MouseMotionListener,
KeyListener {
    List _ptVec = new ArrayList();
    LocalPt _beginPt = new LocalPt();
    LocalPt _endPt = new LocalPt();
    LocalPt _pt = new LocalPt();
    LocalPt _pt0 = new LocalPt();
    LocalPt _pt1 = new LocalPt();
    WorldPt dragPt0 = null;
    WorldPt dragPt1 = null;
    LocalPt _selectedPt = null;
    WorldPt _selectedWPt = null;
    LocalRect _lrc = new LocalRect();
    WorldRect _wrc = new WorldRect();
    LocalRegion _localReg = null;
    ImpactArea _impactArea;
    boolean _poppingUp = false;
    boolean _draggingImpactArea = false;
    boolean _draggingImpactAreaRegionPoint = false;
    boolean _editintLabelPt = false;
    boolean _editingStreamIndex = false;
    boolean _moving = false;
    static int[] _xpt = new int[4];
    static int[] _ypt = new int[4];
    static int[] _xp = new int[4000];
    static int[] _yp = new int[4000];

    public StudyImpactAreaMouseAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
    }

    @Override
    public void abort() {
        super.abort();
        this._impactArea = null;
        this._editintLabelPt = false;
        this._moving = false;
    }

    @Override
    void abortEditing() {
        this._selectedPt = null;
        this._selectedWPt = null;
        this.setImpactArea(null);
        super.abortEditing();
    }

    private void setImpactArea(ImpactArea newArea) {
        if (this._impactArea != null && this._impactArea != newArea) {
            this._mapPanel.paintMap();
        }
        this._impactArea = newArea;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() != 27) {
            return;
        }
        switch (this._mode) {
            case 1: {
                this.removeRecentImpactAreaNode();
                break;
            }
            case 2: {
                this.abortEditing();
            }
        }
    }

    @Override
    protected void creatingMouseReleased(MouseEvent e) {
        if (e.isControlDown()) {
            this.addImpactAreaNode(e);
        } else {
            this.addImpactAreaNode(e);
            this.createImpactArea(e);
        }
    }

    @Override
    protected void creatingMouseMoved(MouseEvent e) {
        Graphics g = this._mapCanvas.getGraphics();
        g.setXORMode(new Color(255, 255, 255));
        g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
        this._pt.init(e.getX(), e.getY());
        g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
        g.setPaintMode();
        g.dispose();
    }

    @Override
    protected void editingMouseReleased(MouseEvent e) {
        if (this._selectedPt != null) {
            if (this._draggingImpactArea && this._impactArea != null) {
                this.drawImpactRegion(this._impactArea, true);
                this._mapPanel.paintImage();
                this._impactArea.setModified(true);
                this.drawImpactRegion(this._impactArea, true);
                this._mapPanel.paintMap();
            }
            if ((this._draggingImpactArea || this._draggingImpactAreaRegionPoint) && this._impactArea != null) {
                this._impactArea.setRegion(this._impactArea.getRegion());
            }
            this._editingStreamIndex = false;
            this._selectedPt = null;
            this._selectedWPt = null;
            this._mapPanel.paintMap();
            this._mapPanel.viewport().setCursor(this.getCursor());
            ImpactAreaEditor[] editors = ImpactAreaEditor.getOpenImpactAreaEditors();
            for (int i = 0; i < editors.length; ++i) {
                editors[i].refreshForm();
            }
            this.dragPt0 = null;
            this.dragPt1 = null;
        }
    }

    @Override
    protected void editingMousePressed(MouseEvent e) {
        this._draggingImpactArea = false;
        if (e.isPopupTrigger() || StudyImpactAreaMouseAdapter.pressedButton3((MouseEvent)e)) {
            this.showPopupMenu(e);
        } else if (e.isControlDown() && e.isShiftDown()) {
            this._pt.init(e.getX(), e.getY());
            WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
            double tol = this._mapPanel.scale().x2e(this._pt.x + 5) - this._mapPanel.scale().x2e(this._pt.x);
            this._impactArea.getRegion().removePt(wpt, tol);
            this._impactArea.setModified(true);
            this._mapPanel.paintMap();
        } else if (e.isControlDown() && !e.isAltDown() && this._impactArea != null) {
            this._pt.init(e.getX(), e.getY());
            WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
            double tol = this._mapPanel.scale().x2e(this._pt.x + 5) - this._mapPanel.scale().x2e(this._pt.x);
            this._impactArea.getRegion().insertPt(wpt, tol);
            this._impactArea.setModified(true);
            this.drawImpactRegion(this._impactArea, false);
            this._mapPanel.paintImage();
        } else if (this._impactArea != null) {
            this._pt.init(e.getX(), e.getY());
            this._pt0.init(this._pt);
            WorldPt mouseWorldPt = this._mapPanel.scale().lp2wp(this._pt);
            this._editintLabelPt = false;
            this._editingStreamIndex = false;
            LocalPt localLabelPosition = new LocalPt();
            WorldPt wpt = this._impactArea.getLabelPositionPoint();
            this._mapPanel.scale().wp2lp(wpt, localLabelPosition);
            LocalPt localStreamStationPos = null;
            WorldPt streamStationPosition = null;
            if (!this.findStreamAlignmentGlyph()) {
                return;
            }
            StreamElement elem = this._alignglyph.findReach(this._impactArea.getStreamId());
            if (elem != null) {
                streamStationPosition = elem.getLocationByStation(this._impactArea.getIndexStation());
                localStreamStationPos = this._mapPanel.scale().wp2lp(streamStationPosition);
            }
            this._lrc.init(this._pt.x - 8, this._pt.y - 8, this._pt.x + 8, this._pt.y + 8);
            if (!e.isControlDown() && !e.isAltDown() && e.isShiftDown() && this._impactArea.getRegion().contains(mouseWorldPt)) {
                this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(13));
                this._draggingImpactArea = true;
                this._selectedPt = this._pt;
            } else if (this._lrc.contains(localLabelPosition) && !this._impactArea.getAutoLabelPosition()) {
                this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(13));
                this._editintLabelPt = true;
                this._selectedPt = localLabelPosition;
                this._selectedWPt = this._impactArea.getLabelPositionPoint();
            } else if (localStreamStationPos != null && this._lrc.contains(localStreamStationPos) && !this._impactArea.getAutoIndexStation()) {
                this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(13));
                this._editingStreamIndex = true;
                this._selectedPt = localStreamStationPos;
                this._selectedWPt = streamStationPosition;
            } else {
                LocalPt lpt = new LocalPt();
                this._lrc.init(this._pt.x - 3, this._pt.y - 3, this._pt.x + 3, this._pt.y + 3);
                int size = this._impactArea.getRegion().pts.size();
                for (int i = 0; i < size; ++i) {
                    wpt = (WorldPt)this._impactArea.getRegion().pts.elementAt(i);
                    if (wpt == null) continue;
                    this._mapPanel.scale().wp2lp(wpt, lpt);
                    if (!this._lrc.contains(lpt)) continue;
                    this._selectedPt = lpt;
                    this._selectedWPt = wpt;
                    this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
                    this._draggingImpactAreaRegionPoint = true;
                    break;
                }
            }
        }
    }

    @Override
    protected void editingMouseMoved(MouseEvent e) {
        if (this._impactArea != null) {
            this._pt.init(e.getX(), e.getY());
            this._pt0.init(this._pt);
            WorldPt worldMousePt = new WorldPt();
            this._mapPanel.scale().lp2wp(this._pt, worldMousePt);
            LocalPt localLabelPosition = new LocalPt();
            WorldPt wpt = this._impactArea.getLabelPositionPoint();
            this._mapPanel.scale().wp2lp(wpt, localLabelPosition);
            LocalPt localStreamStationPos = null;
            StreamElement elem = null;
            if (this._alignglyph != null) {
                elem = this._alignglyph.findReach(this._impactArea.getStreamId());
            }
            if (elem != null) {
                wpt = elem.getLocationByStation(this._impactArea.getIndexStation());
                localStreamStationPos = this._mapPanel.scale().wp2lp(wpt);
            }
            boolean assignedCursor = false;
            this._lrc.init(this._pt.x - 8, this._pt.y - 8, this._pt.x + 8, this._pt.y + 8);
            if (this._impactArea.getRegion().contains(worldMousePt) && !e.isControlDown() && !e.isAltDown() && e.isShiftDown()) {
                this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(13));
                assignedCursor = true;
            } else if (this._lrc.contains(localLabelPosition) && !this._impactArea.getAutoLabelPosition() || localStreamStationPos != null && this._lrc.contains(localStreamStationPos) && !this._impactArea.getAutoIndexStation()) {
                this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(13));
                assignedCursor = true;
            } else {
                int size = this._impactArea.getRegion().pts.size();
                this._lrc.init(this._pt.x - 3, this._pt.y - 3, this._pt.x + 3, this._pt.y + 3);
                LocalPt lpt = new LocalPt();
                for (int i = 0; i < size; ++i) {
                    wpt = (WorldPt)this._impactArea.getRegion().pts.elementAt(i);
                    if (wpt == null) continue;
                    this._mapPanel.scale().wp2lp(wpt, lpt);
                    if (!this._lrc.contains(lpt)) continue;
                    this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
                    assignedCursor = true;
                    break;
                }
            }
            if (assignedCursor) {
                return;
            }
            this._mapPanel.viewport().setCursor(this.getCursor());
        }
    }

    protected void checkForImpactAreaEdits() {
        Vector openDialogs = RmaJDialog.getOpenWindows();
        for (int i = 0; openDialogs != null && i < openDialogs.size(); ++i) {
            RmaJDialog dlg = (RmaJDialog)openDialogs.get(i);
            if (!(dlg instanceof ImpactAreaEditor) || !((ImpactAreaEditor)dlg).isModified()) continue;
            int opt = JOptionPane.showConfirmDialog((Component)dlg, "Data has changed. Save Changes?", "Confirm Changes", 0);
            if (opt == 0) {
                ((ImpactAreaEditor)dlg).saveForm();
            } else {
                ((ImpactAreaEditor)dlg).fillForm(this._impactArea);
            }
            return;
        }
    }

    @Override
    protected void editingMouseDragged(MouseEvent e) {
        if (this._selectedPt != null && this._impactArea != null) {
            this.checkForImpactAreaEdits();
            this.drawImpactRegion(this._impactArea, true);
            this._mapPanel.paintImage();
            if (this._editingStreamIndex) {
                StreamElement elem = this._alignglyph.findReach(this._impactArea.getStreamId());
                if (elem == null) {
                    return;
                }
                LocalPt tempLpt = new LocalPt(e.getX(), e.getY());
                WorldPt tempWpt = new WorldPt();
                this._mapPanel.scale().lp2wp(tempLpt, tempWpt);
                double streamStation = elem.getStationByLocation(tempWpt);
                tempWpt = elem.getLocationByStation(streamStation);
                this._selectedWPt.init(tempWpt);
                this._impactArea.setIndexStation(streamStation);
                ComputationPoint cp = this._impactArea.getComputationPoint();
                if (cp != null) {
                    cp.setStreamStation(streamStation);
                }
            } else if (this._draggingImpactArea) {
                this.dragPt0 = this.dragPt1;
                this.dragPt1 = this._mapPanel.scale().lp2wp(new LocalPt(e.getX(), e.getY()));
                double xdiff = 1.0;
                double ydiff = 1.0;
                if (this.dragPt0 != null) {
                    xdiff = this.dragPt1.e - this.dragPt0.e;
                    ydiff = this.dragPt1.n - this.dragPt0.n;
                }
                WorldRegion region = this._impactArea.getRegion();
                for (int i = 0; i < region.pts.size(); ++i) {
                    WorldPt p = (WorldPt)region.pts.elementAt(i);
                    p.e += xdiff;
                    p.n += ydiff;
                }
                if (this.dragPt0 != null) {
                    this.drawImpactRegion(this._impactArea, true);
                    this._mapPanel.paintMap();
                    return;
                }
            } else {
                this._selectedPt.init(e.getX(), e.getY());
                this._mapPanel.scale().lp2wp(this._selectedPt, this._selectedWPt);
            }
            this._impactArea.setModified(true);
            this.drawImpactRegion(this._impactArea, true);
            this._mapPanel.paintImage();
        }
    }

    void removeRecentImpactAreaNode() {
        Graphics g = this._mapCanvas.getGraphics();
        int npts = this._ptVec.size();
        if (npts <= 1) {
            this._ptVec.clear();
            this._mode = 0;
            this._moving = false;
            this._mapPanel.paintMap();
            return;
        }
        g.setXORMode(Color.white);
        if (this._moving) {
            this.drawPt(this._pt, true);
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
        }
        this.drawPt(this._pt0, true);
        LocalPt lpt = (LocalPt)this._ptVec.get(npts - 2);
        this._pt1.init(lpt);
        g.drawLine(this._pt0.x, this._pt0.y, this._pt1.x, this._pt1.y);
        this._ptVec.remove(npts - 1);
        this._pt0.init(this._pt1);
        if (this._moving) {
            g.setXORMode(Color.white);
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            this.drawPt(this._pt, true);
        }
        g.setPaintMode();
        g.dispose();
    }

    protected void addImpactAreaNode(MouseEvent e) {
        this._pt0.init(this._pt);
        this._pt.init(e.getX(), e.getY());
        this.drawPt(this._pt, true);
        this._ptVec.add(new LocalPt(this._pt));
        this._moving = false;
    }

    protected void createImpactArea(MouseEvent e) {
        this._sysglyph.createArea(this._ptVec);
        this._mapPanel.viewport().setCursor(this.getCursor());
        this._mode = 0;
        this._moving = false;
    }

    @Override
    protected void initiateCreateObject(MouseEvent e) {
        if (!this.findStudySystemGlyph()) {
            JOptionPane.showMessageDialog((Component)ClientApp.frame(), "Please create/select a Study first");
            return;
        }
        if (!this.isConfigurationLocked("Cannot Edit Impact Areas")) {
            return;
        }
        this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
        this._pt0.init(e.getX(), e.getY());
        this._pt.init(this._pt0);
        this.drawPt(this._pt, true);
        this._ptVec.clear();
        this._ptVec.add(new LocalPt(this._pt));
        this._mode = 1;
    }

    void drawPt(LocalPt pt, boolean isXOR) {
        Graphics g = this._mapCanvas.getGraphics();
        if (isXOR) {
            g.setXORMode(new Color(255, 255, 255));
        } else {
            g.setColor(Color.black);
        }
        StudyImpactAreaMouseAdapter._xpt[0] = pt.x - 3;
        StudyImpactAreaMouseAdapter._ypt[0] = pt.y;
        StudyImpactAreaMouseAdapter._xpt[1] = pt.x;
        StudyImpactAreaMouseAdapter._ypt[1] = pt.y + 3;
        StudyImpactAreaMouseAdapter._xpt[2] = pt.x + 3;
        StudyImpactAreaMouseAdapter._ypt[2] = pt.y;
        StudyImpactAreaMouseAdapter._xpt[3] = pt.x;
        StudyImpactAreaMouseAdapter._ypt[3] = pt.y - 3;
        g.fillPolygon(_xpt, _ypt, 4);
        g.setPaintMode();
        g.dispose();
    }

    @Override
    protected void selectObject(MouseEvent e) {
        if (!this.findStudySystemGlyph()) {
            return;
        }
        this._pt.init(e.getX(), e.getY());
        ImpactArea iarea = this._sysglyph.findImpactArea(this._pt);
        if (iarea == null) {
            this._sysglyph.clearSelection();
        } else if (iarea == this._impactArea) {
            if (iarea != this._sysglyph.getSelectedObject()) {
                this._sysglyph.selectImpactArea(iarea, false, this._mode == 2);
            }
        } else {
            this._sysglyph.selectImpactArea(iarea, false, false);
            this._mode = 0;
        }
        this.setImpactArea(iarea);
    }

    @Override
    protected void selectObjectForEditing(MouseEvent e) {
        if (!this.findStudySystemGlyph()) {
            return;
        }
        this._pt.init(e.getX(), e.getY());
        ImpactArea iarea = this._sysglyph.findImpactArea(this._pt);
        if (iarea != null) {
            this._mode = this.isConfigurationLocked("Cannot Edit Impact Areas") ? 2 : 0;
            this._sysglyph.selectImpactArea(iarea, false, this._mode == 2);
        } else {
            this._mode = 0;
            this._sysglyph.clearSelection();
        }
        this.setImpactArea(iarea);
    }

    void drawRegion(LocalRegion lreg, boolean isXOR) {
        Graphics g = this._mapCanvas.getGraphics();
        if (isXOR) {
            g.setXORMode(new Color(255, 255, 255));
        } else {
            g.setColor(Color.black);
        }
        int icnt = 0;
        for (int i = 0; i < lreg.pts.size() && i < 4000; ++i) {
            LocalPt pt = (LocalPt)lreg.pts.elementAt(i);
            if (pt == null) continue;
            StudyImpactAreaMouseAdapter._xpt[0] = pt.x - 3;
            StudyImpactAreaMouseAdapter._ypt[0] = pt.y;
            StudyImpactAreaMouseAdapter._xpt[1] = pt.x;
            StudyImpactAreaMouseAdapter._ypt[1] = pt.y + 3;
            StudyImpactAreaMouseAdapter._xpt[2] = pt.x + 3;
            StudyImpactAreaMouseAdapter._ypt[2] = pt.y;
            StudyImpactAreaMouseAdapter._xpt[3] = pt.x;
            StudyImpactAreaMouseAdapter._ypt[3] = pt.y - 3;
            g.fillPolygon(_xpt, _ypt, 4);
            StudyImpactAreaMouseAdapter._xp[icnt] = pt.x;
            StudyImpactAreaMouseAdapter._yp[icnt] = pt.y;
            ++icnt;
        }
        g.drawPolygon(_xp, _yp, icnt);
        g.setPaintMode();
        g.dispose();
    }

    void drawImpactRegion(ImpactArea ireg, boolean isXOR) {
        if (this._sysglyph == null || ireg == null) {
            return;
        }
        Graphics g = this._mapCanvas.getBufferedGraphics();
        this._sysglyph.drawSelectedArea(g, this._mapPanel.scale(), ireg, isXOR, this._mode == 2);
        g.dispose();
    }

    @Override
    void showPopupMenu(MouseEvent e) {
        if (!this.findStudySystemGlyph()) {
            return;
        }
        this._pt.init(e.getX(), e.getY());
        this._sysglyph.impactAreaPopupMenu(this._pt);
    }
}

