/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.watershed.client.LeveeDrawPropData;
import hec.watershed.client.StudyDPData;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.Hashtable;
import rma.util.RMAIO;

public class StudyLeveeDPData
extends StudyDPData
implements Serializable,
LeveeDrawPropData {
    private static final String FILL_COLOR_STR = "StudyLeveeDPData.fillColor";
    private static final String OUTLINE_COLOR_STR = "StudyLeveeDPData.outlineColor";
    private static final String DRAW_NAME_STR = "StudyLeveeDPData.drawName";
    private static final String NAME_FONT_STR = "StudyLeveeDPData.nameFont";
    private static final String LEVEE_WIDTH_STR = "StudyLeveeDPData.diversionWidth";
    public Color fillColor;
    public Color outlineColor;
    public boolean drawName;
    public Font nameFont;
    public int leveeWidth;
    Hashtable _properties = new Hashtable();
    static StudyLeveeDPData _leveeData = new StudyLeveeDPData();

    protected StudyLeveeDPData() {
        this.load();
    }

    private void load() {
        if (_props == null) {
            return;
        }
        String s = _props.getProp(FILL_COLOR_STR, "-16777216");
        this.fillColor = Color.decode(s);
        s = _props.getProp(OUTLINE_COLOR_STR, "-16777216");
        this.outlineColor = Color.decode(s);
        s = _props.getProp(DRAW_NAME_STR, "true");
        this.drawName = Boolean.valueOf(s);
        s = _props.getProp(NAME_FONT_STR, "SansSerif-plain-10");
        this.nameFont = Font.decode(s);
        if (this.nameFont == null) {
            this.nameFont = new Font("SansSerif", 0, 10);
        }
        s = _props.getProp(LEVEE_WIDTH_STR, "8");
        this.leveeWidth = RMAIO.parseInt((String)s);
    }

    @Override
    public void save() {
        if (_props == null) {
            return;
        }
        _props.setProp(FILL_COLOR_STR, "" + this.fillColor.getRGB());
        _props.setProp(OUTLINE_COLOR_STR, "" + this.outlineColor.getRGB());
        _props.setProp(DRAW_NAME_STR, "" + this.drawName);
        _props.setProp(NAME_FONT_STR, this.nameFont.getName() + "-" + this.getFontStyleString(this.nameFont) + "-" + this.nameFont.getSize());
        _props.setProp(LEVEE_WIDTH_STR, "" + this.leveeWidth);
        _props.saveProperties();
    }

    @Override
    public void setDefaults() {
        this.leveeWidth = 8;
        this.fillColor = Color.black;
        this.outlineColor = Color.black;
        this.drawName = true;
        this.nameFont = new Font("SansSerif", 0, 10);
    }

    public static StudyLeveeDPData getData() {
        return _leveeData;
    }

    @Override
    public int getLeveeWidth() {
        return this.leveeWidth;
    }

    @Override
    public Color getFillColor() {
        return this.fillColor;
    }

    @Override
    public boolean isDrawName() {
        return this.drawName;
    }

    @Override
    public Font getNameFont() {
        return this.nameFont;
    }

    @Override
    public Color getOutlineColor() {
        return this.outlineColor;
    }

    @Override
    public void setFillColor(Color selectedColor) {
        this.fillColor = selectedColor;
    }

    @Override
    public void setDrawName(boolean drawName) {
        this.drawName = drawName;
    }

    @Override
    public void setLeveeWidth(int width) {
        this.leveeWidth = width;
    }

    @Override
    public void setNameFont(Font font) {
        this.nameFont = font;
    }

    @Override
    public void setOutlineColor(Color selectedColor) {
        this.outlineColor = selectedColor;
    }

    public Hashtable getProperties() {
        this._properties.clear();
        this._properties.put(FILL_COLOR_STR, "" + this.fillColor.getRGB());
        this._properties.put(OUTLINE_COLOR_STR, "" + this.outlineColor.getRGB());
        this._properties.put(DRAW_NAME_STR, "" + this.drawName);
        this._properties.put(NAME_FONT_STR, this.nameFont.getName() + "-" + this.nameFont.getStyle() + "-" + this.nameFont.getSize());
        this._properties.put(LEVEE_WIDTH_STR, "" + this.leveeWidth);
        return this._properties;
    }
}

