/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.MapCanvas;
import hec.map.MapPanel;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.model.StreamElement;
import hec.model.StreamNode;
import hec.model.StreamSegmentIdentifier;
import hec.watershed.client.StudyMouseAdapter;
import hec.watershed.model.Levee;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class StudyLeveeMouseAdapter
extends StudyMouseAdapter
implements MouseListener,
MouseMotionListener {
    private static final int NONE = 0;
    private static final int LEFT = -1;
    private static final int RIGHT = 1;
    Vector _ptVec = new Vector();
    boolean _creatingLevee = false;
    boolean _editingLevee = false;
    LocalPt _beginPt = new LocalPt();
    LocalPt _endPt = new LocalPt();
    LocalPt _pt = new LocalPt();
    LocalPt _pt0 = new LocalPt();
    LocalPt _pt1 = new LocalPt();
    LocalPt _selectedPt = null;
    WorldPt _selectedWPt = null;
    LocalRect _lrc = new LocalRect();
    WorldRect _wrc = new WorldRect();
    Levee _leveeData = null;
    StreamElement _stream = null;
    boolean _poppingUp = false;
    boolean _movingStartNode = false;
    boolean _movingEndNode = false;
    double _leveeCoordStart = Double.NEGATIVE_INFINITY;
    double _leveeCoordEnd = Double.NEGATIVE_INFINITY;
    double _leveeStationStart = Double.NEGATIVE_INFINITY;
    double _leveeStationEnd = Double.NEGATIVE_INFINITY;
    int _leveeStreamElemIndexStart = Integer.MIN_VALUE;
    int _leveeStreamElemIndexEnd = Integer.MIN_VALUE;
    int _lastDirection = 0;
    StreamNode _streamNode = null;
    Vector _streamSegmentList = new Vector();
    boolean _moving = false;
    static int[] _xpt = new int[4];
    static int[] _ypt = new int[4];
    static int[] _xp = new int[4000];
    static int[] _yp = new int[4000];
    private static boolean _debug = false;

    public StudyLeveeMouseAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
    }

    @Override
    public void init() {
        this.findStudySystemGlyph();
    }

    @Override
    public void abort() {
        this.findStudySystemGlyph();
        if (this._sysglyph != null) {
            this._sysglyph.clearSelection();
        }
        this._creatingLevee = false;
        this._editingLevee = false;
        this._lastDirection = 0;
        this._leveeData = null;
    }

    @Override
    protected boolean findStudySystemGlyph() {
        this._sysglyph = null;
        this._alignglyph = null;
        super.findStudySystemGlyph();
        this.findStreamAlignmentGlyph();
        return this._sysglyph != null && this._alignglyph != null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this._creatingLevee) {
            StreamSegmentIdentifier ssi;
            if (this._pt.equals(this._pt0)) {
                this._creatingLevee = false;
                this._leveeStationStart = Double.NEGATIVE_INFINITY;
                this._leveeStationEnd = Double.NEGATIVE_INFINITY;
                this._leveeCoordStart = Double.NEGATIVE_INFINITY;
                this._leveeCoordEnd = Double.NEGATIVE_INFINITY;
                this._moving = false;
                this._streamSegmentList.clear();
                this._lastDirection = 0;
                this._stream = null;
                this._streamNode = null;
                return;
            }
            this._pt1.init(e.getX(), e.getY());
            this._stream = this._alignglyph.findNearestReach(this._pt1);
            this._selectedWPt = this._mapPanel.scale().lp2wp(this._pt1);
            double station = this._stream.getStationByLocation(this._selectedWPt);
            double coord = this._stream.getCoordByLocation(this._selectedWPt);
            this._leveeStationEnd = station;
            this._leveeCoordEnd = coord;
            boolean addSsi = true;
            int streamId = this._stream.getIndex();
            for (int i = 0; i < this._streamSegmentList.size(); ++i) {
                ssi = (StreamSegmentIdentifier)this._streamSegmentList.elementAt(i);
                if (ssi.streamId != streamId) continue;
                addSsi = false;
                if (ssi.startStation > this._leveeStationStart) {
                    ssi.startStation = this._leveeStationStart;
                }
                ssi.endStation = this._leveeStationEnd;
                break;
            }
            if (addSsi) {
                ssi = new StreamSegmentIdentifier(this._stream.getName(), this._stream.getIndex(), this._leveeStationStart, this._leveeStationEnd);
                if (ssi.endStation != ssi.startStation) {
                    if (_debug) {
                        System.out.println("added last Stream " + ssi.streamId + " startStation=" + ssi.startStation + " endStation=" + ssi.endStation);
                    }
                    this._streamSegmentList.addElement(ssi);
                }
            }
            this._leveeStreamElemIndexEnd = this._stream.getIndex();
            if (this._lastDirection == 0) {
                this._lastDirection = -1;
            }
            if (_debug) {
                System.out.println("creating levee bank = " + (this._lastDirection == -1 ? "left" : "right"));
            }
            this._sysglyph.createLevee(this._streamSegmentList, this._lastDirection);
            this._creatingLevee = false;
            this._moving = false;
            this._leveeCoordStart = Double.NEGATIVE_INFINITY;
            this._leveeCoordEnd = Double.NEGATIVE_INFINITY;
            this._leveeStationStart = Double.NEGATIVE_INFINITY;
            this._leveeStationEnd = Double.NEGATIVE_INFINITY;
            this._leveeStreamElemIndexStart = Integer.MIN_VALUE;
            this._leveeStreamElemIndexEnd = Integer.MIN_VALUE;
            this._lastDirection = 0;
            this._stream = null;
            this._streamNode = null;
            this._streamSegmentList.clear();
        } else if (!this._creatingLevee && e.isControlDown()) {
            if (!this.findStudySystemGlyph()) {
                return;
            }
            if (!this.isConfigurationLocked("Cannot Edit Levees")) {
                return;
            }
            this._ptVec.removeAllElements();
            this._pt0.init(e.getX(), e.getY());
            this._stream = this._alignglyph.findReach(this._pt0);
            if (this._stream != null) {
                this._creatingLevee = true;
                this._mapPanel.printStatus("Creating Levee on Stream " + this._stream.getName());
                this._selectedWPt = this._mapPanel.scale().lp2wp(this._pt0);
                double coord = this._stream.getCoordByLocation(this._selectedWPt);
                this._selectedWPt = this._stream.getLocationByCoord(coord);
                this._pt0 = this._mapPanel.scale().wp2lp(this._selectedWPt);
                this._pt.init(this._pt0);
                this.drawPt(this._pt, true);
                this._moving = false;
                this._ptVec.addElement(new LocalPt(this._pt));
                this._leveeCoordStart = coord;
                this._leveeStationStart = this._stream.getStationByCoord(coord);
                this._leveeStreamElemIndexStart = this._stream.getIndex();
            }
        } else if (this._selectedPt != null) {
            StreamAlignmentGlyph alignGlyph;
            WorldLine line;
            if (_debug) {
                System.out.println("movingEndNode=" + this._movingEndNode + " movingStartNode=" + this._movingStartNode);
            }
            if ((line = this._leveeData.getLine()) != null && (alignGlyph = (StreamAlignmentGlyph)this._mapPanel.findGlyphOfClass(StreamAlignmentGlyph.class.getName())) != null) {
                this._stream = alignGlyph.findReach(this._selectedPt);
                if (this._stream != null) {
                    double station = this._stream.getStationByLocation(this._selectedWPt);
                    if (this._movingStartNode || this._movingEndNode) {
                        // empty if block
                    }
                }
            }
            this._mapPanel.viewport().setCursor(this.getCursor());
            this._selectedPt = null;
            this._selectedWPt = null;
            this._movingStartNode = false;
            this._movingEndNode = false;
            this._mapPanel.paintMap();
        } else if (e.isPopupTrigger() || StudyLeveeMouseAdapter.pressedButton3((MouseEvent)e)) {
            // empty if block
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this._poppingUp = false;
        if (e.isPopupTrigger() || StudyLeveeMouseAdapter.pressedButton3((MouseEvent)e)) {
            if (!this.findStudySystemGlyph()) {
                return;
            }
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            this._poppingUp = true;
            this._sysglyph.leveePopupMenu(pt);
        } else if (this._editingLevee && e.isControlDown() && e.isShiftDown()) {
            this._pt.init(e.getX(), e.getY());
            WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
            double tol = this._mapPanel.scale().x2e(this._pt.x + 5) - this._mapPanel.scale().x2e(this._pt.x);
            if (this._leveeData.getLine().removePt(wpt, tol)) {
                this._leveeData.setModified(true);
            }
            this._mapPanel.paintMap();
        } else if (this._editingLevee && e.isControlDown() && this._leveeData != null) {
            this._pt.init(e.getX(), e.getY());
            WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
            double tol = this._mapPanel.scale().x2e(this._pt.x + 5) - this._mapPanel.scale().x2e(this._pt.x);
            if (this._leveeData.getLine().insertPt(wpt, tol)) {
                this._leveeData.setModified(true);
            }
            this.drawLevee(this._leveeData, false);
        } else if (this._editingLevee && this._leveeData != null && !this._leveeData.getFollowsStream()) {
            this._pt.init(e.getX(), e.getY());
            this._pt0.init(this._pt);
            LocalPt lpt = new LocalPt();
            WorldPt wpt = this._leveeData.getReferencePt();
            this._mapPanel.scale().wp2lp(wpt, lpt);
            this._lrc.init(this._pt.x - 8, this._pt.y - 8, this._pt.x + 8, this._pt.y + 8);
            if (this._lrc.contains(lpt)) {
                this._selectedPt = lpt;
                this._selectedWPt = wpt;
            } else {
                this._movingStartNode = false;
                this._movingEndNode = false;
                this._lrc.init(this._pt.x - 3, this._pt.y - 3, this._pt.x + 3, this._pt.y + 3);
                int size = this._leveeData.getLine().pts.size();
                for (int i = 0; i < size; ++i) {
                    wpt = (WorldPt)this._leveeData.getLine().pts.elementAt(i);
                    if (wpt == null) continue;
                    this._mapPanel.scale().wp2lp(wpt, lpt);
                    if (!this._lrc.contains(lpt)) continue;
                    this._selectedPt = lpt;
                    this._selectedWPt = wpt;
                    if (i == 0) {
                        this._movingStartNode = true;
                    } else if (i == size - 1) {
                        this._movingEndNode = true;
                    }
                    this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
                    break;
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this._creatingLevee && this._leveeCoordStart != Double.NEGATIVE_INFINITY) {
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
            if (this._streamNode != null) {
                StreamElement stream = this._alignglyph.findNearestReach(pt);
                if (stream != this._stream) {
                    if (_debug) {
                        System.out.println("found new stream " + stream + " old stream " + this._stream);
                    }
                    boolean okToTurn = true;
                    double bank = this._stream.getLine().getNearestLocationSigned(wpt, new WorldPt());
                    if (_debug) {
                        System.out.println("bank = " + (bank < 0.0 ? "right" : "left") + " lastDirection = " + (this._lastDirection == 0 ? "none" : (this._lastDirection == -1 ? "left" : "right")));
                    }
                    if (this._lastDirection != 0) {
                        if (bank < 0.0 && this._lastDirection == -1) {
                            okToTurn = false;
                        } else if (bank > 0.0 && this._lastDirection == 1) {
                            okToTurn = false;
                        }
                    } else {
                        int n = this._lastDirection = bank < 0.0 ? 1 : -1;
                    }
                    if (okToTurn) {
                        StreamSegmentIdentifier ssi;
                        double endStation = this._stream.getStationByLocation(this._streamNode.getLocation());
                        if (_debug) {
                            System.out.println("endstation is " + endStation);
                        }
                        int streamId = this._stream.getIndex();
                        boolean addSsi = true;
                        for (int i = 0; i < this._streamSegmentList.size(); ++i) {
                            ssi = (StreamSegmentIdentifier)this._streamSegmentList.elementAt(i);
                            if (ssi.streamId != streamId) continue;
                            addSsi = false;
                            if (ssi.startStation > this._leveeStationStart) {
                                ssi.startStation = this._leveeStationStart;
                            }
                            if (!(ssi.endStation < endStation)) break;
                            ssi.endStation = endStation;
                            break;
                        }
                        if (addSsi) {
                            ssi = new StreamSegmentIdentifier(this._stream.getName(), this._stream.getIndex(), this._leveeStationStart, endStation);
                            if (ssi.endStation != ssi.startStation) {
                                if (_debug) {
                                    System.out.println("added next Stream " + ssi.streamId + " startStation=" + ssi.startStation + " endStation=" + ssi.endStation);
                                }
                                this._streamSegmentList.addElement(ssi);
                            }
                        }
                        this._stream = stream;
                        this._leveeStationStart = this._stream.getStationByLocation(this._streamNode.getLocation());
                    } else if (_debug) {
                        System.out.println("can't turn wrong way");
                    }
                }
                this._streamNode = null;
            }
            Graphics g = this._mapCanvas.getGraphics();
            g.setXORMode(new Color(255, 255, 255));
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            if (!this._pt.equals(this._pt0)) {
                this.drawPt(this._pt, true);
            }
            this._moving = true;
            double coord = this._stream.getLine().getCoordAtLocation(wpt);
            this._streamNode = coord >= this._leveeCoordStart ? this._alignglyph.findUpstreamNode(this._stream, pt) : this._alignglyph.findDownstreamNode(this._stream, pt);
            if (this._streamNode != null && this._streamNode.getJunction() == null) {
                this._streamNode = null;
            }
            pt = this._mapPanel.scale().wp2lp(this._stream.getLocationByCoord(coord));
            this._pt.init(pt);
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            if (!this._pt.equals(this._pt0)) {
                this.drawPt(this._pt, true);
            }
            g.setPaintMode();
            g.dispose();
        } else {
            super.mouseMoved(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this._selectedPt != null && this._leveeData != null) {
            this.drawLevee(this._leveeData, true);
            this._selectedPt.init(e.getX(), e.getY());
            this._mapPanel.scale().lp2wp(this._selectedPt, this._selectedWPt);
            this.drawLevee(this._leveeData, true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this._creatingLevee) {
            if (e.getClickCount() == 2) {
                if (!this.findStudySystemGlyph()) {
                    return;
                }
                this._pt.init(e.getX(), e.getY());
                Levee res = this._sysglyph.selectLevee(this._pt, false, true);
                if (res != null) {
                    if (!this.isConfigurationLocked("Cannot Edit Levees")) {
                        return;
                    }
                    this._editingLevee = true;
                } else {
                    this._editingLevee = false;
                }
                this._leveeData = res;
            } else if (!this._editingLevee) {
                if (!this.findStudySystemGlyph()) {
                    return;
                }
                this._pt.init(e.getX(), e.getY());
                Levee res = this._sysglyph.selectLevee(this._pt, false, false);
                this._editingLevee = false;
                this._leveeData = res;
            }
        }
    }

    void drawPt(LocalPt pt, boolean isXOR) {
        Graphics g = this._mapCanvas.getGraphics();
        if (isXOR) {
            g.setXORMode(new Color(255, 255, 255));
        } else {
            g.setColor(Color.black);
        }
        StudyLeveeMouseAdapter._xpt[0] = pt.x - 5;
        StudyLeveeMouseAdapter._ypt[0] = pt.y;
        StudyLeveeMouseAdapter._xpt[1] = pt.x;
        StudyLeveeMouseAdapter._ypt[1] = pt.y + 5;
        StudyLeveeMouseAdapter._xpt[2] = pt.x + 5;
        StudyLeveeMouseAdapter._ypt[2] = pt.y;
        StudyLeveeMouseAdapter._xpt[3] = pt.x;
        StudyLeveeMouseAdapter._ypt[3] = pt.y - 5;
        g.fillPolygon(_xpt, _ypt, 4);
        g.setPaintMode();
        g.dispose();
    }

    void drawLevee(Levee levData, boolean isXOR) {
        if (this._sysglyph == null || levData == null) {
            return;
        }
        Graphics g = this._mapCanvas.getGraphics();
        this._sysglyph.drawSelectedLevee(g, this._mapPanel.scale(), levData, isXOR, this._editingLevee);
        g.dispose();
    }
}

