/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.appInterface.AppDaddy;
import hec.event.DataListEvent;
import hec.event.DataListListener;
import hec.event.GlyphSelectionEvent;
import hec.event.GlyphSelectionListener;
import hec.gui.SelectorPanelEditor;
import hec.lang.NamedType;
import hec.model.CommonDataList;
import hec.model.CommonDataListContainer;
import hec.watershed.client.StudySystemMapGlyph;
import hec.watershed.client.WatershedConfigMode;
import hec.watershed.model.DefaultDataList;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Iterator;

public class StudyMapSelectionEditor
extends SelectorPanelEditor
implements GlyphSelectionListener,
DataListListener {
    private WatershedConfigMode _configMode;
    protected String _objectType;
    private CommonDataListContainer _commonDataListContainer;
    private StudySystemMapGlyph _glyph;
    public static boolean DEBUG = false;

    public StudyMapSelectionEditor(Dialog parent, boolean modal) {
        super(parent, modal);
        this.init();
    }

    public StudyMapSelectionEditor(Frame parent, boolean modal) {
        super(parent, modal);
        this.init();
    }

    private void init() {
        if (AppDaddy.getFrame() == null) {
            return;
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                StudyMapSelectionEditor.this.selectObject();
            }
        });
        StudySystemMapGlyph glyph = this.getStudyGlyph();
        if (glyph != null) {
            glyph.addGlyphSelectionListener(this);
        }
    }

    protected StudySystemMapGlyph getStudyGlyph() {
        return this._glyph;
    }

    public void setStudyGlyph(StudySystemMapGlyph glyph) {
        this._glyph = glyph;
    }

    public void fillForm(NamedType obj) {
        super.fillForm(obj);
        this.selectObject();
    }

    public void setVisible(boolean b) {
        CommonDataList dl;
        if (!b && (dl = this._commonDataListContainer.getCommonDataList(this._objectType)) instanceof DefaultDataList) {
            DefaultDataList ddl = (DefaultDataList)dl;
            ddl.removeDataListListener(this);
        }
        super.setVisible(b);
    }

    protected void selectObject() {
        StudySystemMapGlyph glyph = this.getStudyGlyph();
        if (glyph == null) {
            return;
        }
        Object obj = this.selectorPanel.getSelectedItem();
        glyph.clearSelection();
        if (obj instanceof NamedType) {
            glyph.selectObject((NamedType)obj);
        }
    }

    public void glyphSelectionChanged(GlyphSelectionEvent e) {
        NamedType obj = e.getSelectedObject();
        if (obj == null) {
            return;
        }
        if (obj.getClass().getName().equals(this._objectType) && this.isVisible()) {
            this.selectorPanel.setSelectedItem((Object)e.getSelectedObject());
        }
    }

    public void setSelectionList(Collection list) {
        if (list != null && list.size() > 0) {
            CommonDataList dl;
            Iterator i = list.iterator();
            Object obj = i.next();
            if (obj != null) {
                this._objectType = obj.getClass().getName();
            }
            if ((dl = this._commonDataListContainer.getCommonDataList(this._objectType)) instanceof DefaultDataList) {
                DefaultDataList ddl = (DefaultDataList)dl;
                ddl.removeDataListListener(this);
                ddl.addDataListListener(this);
            }
        }
        super.setSelectionList(list);
    }

    public void setSelectionList(Object[] list) {
        if (list != null && list.length > 0) {
            CommonDataList dl;
            Object obj = list[0];
            if (obj != null) {
                this._objectType = obj.getClass().getName();
            }
            if ((dl = this._commonDataListContainer.getCommonDataList(this._objectType)) instanceof DefaultDataList) {
                DefaultDataList ddl = (DefaultDataList)dl;
                ddl.removeDataListListener(this);
                ddl.addDataListListener(this);
            }
        }
        super.setSelectionList(list);
    }

    public void dataListChanged(DataListEvent dle) {
        if (dle.getType() == 1 || dle.getType() == 2) {
            this.updateSelectionList();
        }
    }

    protected void updateSelectionList() {
        CommonDataList dl = this._commonDataListContainer.getCommonDataList(this._objectType);
        if (dl != null) {
            Object selectedItem = this.selectorPanel.getSelectedItem();
            Object[] objs = dl.getObjectArray();
            this.setSelectionList(objs);
            this.selectorPanel.setSelectedItem(selectedItem);
        }
    }

    public void setCommonDataListContainer(CommonDataListContainer commonDataListContainer) {
        if (DEBUG) {
            System.out.println("setCommonDataListContainer:commondatalistcontainer=" + commonDataListContainer);
        }
        this._commonDataListContainer = commonDataListContainer;
    }
}

