/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.map.MapCanvas;
import hec.map.MapGlyph;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.watershed.client.StudySystemMapGlyph;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JOptionPane;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.MapPropLoggingMarker;

public abstract class StudyMouseAdapter
extends MapMouseAdapter {
    private static final MarkingClassLogger MAP_PROP_LOGGER = MarkingClassLogger.forMarkingClass(MapPropLoggingMarker.class);
    public static final int READY = 0;
    public static final int CREATING = 1;
    public static final int EDITING = 2;
    protected StudySystemMapGlyph _sysglyph = null;
    protected StreamAlignmentGlyph _alignglyph = null;
    protected int _mode = 0;
    protected boolean _debug;

    public StudyMouseAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
    }

    public void init() {
        this.findStudySystemGlyph();
        this.findStreamAlignmentGlyph();
        this._debug = ((MarkingClassLogger.Api)MAP_PROP_LOGGER.atFine()).isEnabled();
    }

    public void abort() {
        this.findStudySystemGlyph();
        if (this._sysglyph != null) {
            this._sysglyph.clearSelection();
        }
        this._mapPanel.viewport().setCursor(this.getCursor());
        this._mode = 0;
    }

    void abortEditing() {
        this.abort();
    }

    protected boolean findStudySystemGlyph() {
        this._sysglyph = null;
        List gvec = this._mapPanel.managerGlyphList();
        for (int i = 0; i < gvec.size(); ++i) {
            MapGlyph g = (MapGlyph)gvec.get(i);
            if (g == null || !(g instanceof StudySystemMapGlyph)) continue;
            this._sysglyph = (StudySystemMapGlyph)g;
            break;
        }
        if (this._sysglyph == null) {
            System.out.println("findStudySystemGlyph:failed to find StudySystemMapGlyph");
            return false;
        }
        return true;
    }

    protected boolean findStreamAlignmentGlyph() {
        this._alignglyph = null;
        List gvec = this._mapPanel.managerGlyphList();
        for (int i = 0; i < gvec.size(); ++i) {
            MapGlyph g = (MapGlyph)gvec.get(i);
            if (g == null || !(g instanceof StreamAlignmentGlyph)) continue;
            this._alignglyph = (StreamAlignmentGlyph)g;
            break;
        }
        return this._alignglyph != null;
    }

    protected boolean isConfigurationLocked(String title) {
        if (this._sysglyph == null) {
            return false;
        }
        if (title == null) {
            title = "Cannot Edit";
        }
        if (!this._sysglyph.isWriteLocked()) {
            JOptionPane.showMessageDialog((Component)this._mapPanel, "You must first lock the watershed configuration.", title, 1);
            return false;
        }
        return true;
    }

    public void mouseReleased(MouseEvent e) {
        if (this._debug) {
            System.out.println("mouseReleased:mode=" + this.getModeString());
        }
        if (this._mode == 0) {
            this.readyMouseReleased(e);
        } else if (this._mode == 1) {
            this.creatingMouseReleased(e);
        } else if (this._mode == 2) {
            this.editingMouseReleased(e);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this._debug) {
            System.out.println("mousePressed:mode=" + this.getModeString());
        }
        if (this._mode == 0) {
            this.readyMousePressed(e);
        } else if (this._mode == 1) {
            this.creatingMousePressed(e);
        } else if (this._mode == 2) {
            this.editingMousePressed(e);
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this._mode == 0) {
            this.readyMouseMoved(e);
        } else if (this._mode == 1) {
            this.creatingMouseMoved(e);
        } else if (this._mode == 2) {
            this.editingMouseMoved(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this._mode == 0) {
            this.readyMouseReleased(e);
        } else if (this._mode == 1) {
            this.creatingMouseDragged(e);
        } else if (this._mode == 2) {
            this.editingMouseDragged(e);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this._debug) {
            System.out.println("mouseClicked:mode=" + this.getModeString());
        }
        if (this._mode == 0) {
            this.readyMouseClicked(e);
        } else if (this._mode == 1) {
            this.creatingMouseClicked(e);
        } else if (this._mode == 2) {
            this.editingMouseClicked(e);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    protected void readyMouseReleased(MouseEvent e) {
    }

    protected void readyMousePressed(MouseEvent e) {
        if (e.isPopupTrigger() || StudyMouseAdapter.pressedButton3((MouseEvent)e)) {
            this.showPopupMenu(e);
        }
    }

    protected void readyMouseMoved(MouseEvent e) {
        super.mouseMoved(e);
    }

    protected void readyMouseDragged(MouseEvent e) {
    }

    protected void readyMouseClicked(MouseEvent e) {
        if (e.isControlDown()) {
            this.initiateCreateObject(e);
        } else if (e.getClickCount() == 2) {
            this.selectObjectForEditing(e);
        } else {
            this.selectObject(e);
        }
    }

    protected void initiateCreateObject(MouseEvent e) {
    }

    protected void selectObjectForEditing(MouseEvent e) {
    }

    protected void selectObject(MouseEvent e) {
    }

    protected void creatingMouseReleased(MouseEvent e) {
    }

    protected void creatingMousePressed(MouseEvent e) {
        if (e.isPopupTrigger() || StudyMouseAdapter.pressedButton3((MouseEvent)e)) {
            this.showPopupMenu(e);
        }
    }

    protected void creatingMouseMoved(MouseEvent e) {
    }

    protected void creatingMouseDragged(MouseEvent e) {
    }

    protected void creatingMouseClicked(MouseEvent e) {
    }

    protected void editingMouseReleased(MouseEvent e) {
    }

    protected void editingMousePressed(MouseEvent e) {
    }

    protected void editingMouseMoved(MouseEvent e) {
        super.mouseMoved(e);
    }

    protected void editingMouseDragged(MouseEvent e) {
    }

    protected void editingMouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.selectObjectForEditing(e);
        }
    }

    void showPopupMenu(MouseEvent e) {
    }

    public String getModeString() {
        if (this._mode == 0) {
            return "ready";
        }
        if (this._mode == 2) {
            return "editing";
        }
        if (this._mode == 1) {
            return "creating";
        }
        return "unknown:" + this._mode;
    }
}

