/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.LocalRegion;
import hec.map.MapCanvas;
import hec.map.MapPanel;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.watershed.client.StudyMouseAdapter;
import hec.watershed.model.StoragePool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JOptionPane;

public class StudyOffChannelMouseAdapter
extends StudyMouseAdapter
implements MouseListener,
MouseMotionListener,
KeyListener {
    Vector _ptVec = new Vector();
    boolean _moving = false;
    LocalPt _beginPt = new LocalPt();
    LocalPt _endPt = new LocalPt();
    LocalPt _pt = new LocalPt();
    LocalPt _pt0 = new LocalPt();
    LocalPt _pt1 = new LocalPt();
    LocalPt _selectedPt = null;
    WorldPt _selectedWPt = null;
    LocalRect _lrc = new LocalRect();
    WorldRect _wrc = new WorldRect();
    LocalRegion _localReg = null;
    StoragePool _pool;
    boolean _poppingUp = false;
    static int[] _xpt = new int[4];
    static int[] _ypt = new int[4];
    static int[] _xp = new int[4000];
    static int[] _yp = new int[4000];

    public StudyOffChannelMouseAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
    }

    @Override
    public void abort() {
        this.setStoragePool(null);
        super.abort();
    }

    @Override
    void abortEditing() {
        this._selectedPt = null;
        this._selectedWPt = null;
        this.setStoragePool(null);
        super.abortEditing();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() != 27) {
            return;
        }
        switch (this._mode) {
            case 1: {
                this.removeRecentStoragePoolNode();
                break;
            }
            case 2: {
                this.abortEditing();
            }
        }
    }

    @Override
    protected void creatingMouseReleased(MouseEvent e) {
        if (e.isControlDown()) {
            this.addStoragePoolNode(e);
        } else {
            this.addStoragePoolNode(e);
            this.createStoragePool(e);
        }
    }

    @Override
    protected void creatingMouseMoved(MouseEvent e) {
        Graphics g = this._mapCanvas.getGraphics();
        g.setXORMode(new Color(255, 255, 255));
        g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
        this._pt.init(e.getX(), e.getY());
        g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
        g.setPaintMode();
        g.dispose();
    }

    @Override
    protected void editingMouseReleased(MouseEvent e) {
        this._selectedPt = null;
        this._selectedWPt = null;
        this._mapPanel.paintMap();
        this._mapPanel.viewport().setCursor(this.getCursor());
    }

    @Override
    protected void editingMousePressed(MouseEvent e) {
        if (e.isPopupTrigger() || StudyOffChannelMouseAdapter.pressedButton3((MouseEvent)e)) {
            this.showPopupMenu(e);
        } else if (e.isControlDown() && e.isShiftDown()) {
            this._pt.init(e.getX(), e.getY());
            WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
            double tol = this._mapPanel.scale().x2e(this._pt.x + 5) - this._mapPanel.scale().x2e(this._pt.x);
            this._pool.getRegion().removePt(wpt, tol);
            this._pool.setModified(true);
            this._mapPanel.paintMap();
        } else if (e.isControlDown() && this._pool != null) {
            this._pt.init(e.getX(), e.getY());
            WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
            double tol = this._mapPanel.scale().x2e(this._pt.x + 5) - this._mapPanel.scale().x2e(this._pt.x);
            this._pool.getRegion().insertPt(wpt, tol);
            this._pool.setModified(true);
            this.drawStoragePool(this._pool, false);
        } else if (this._pool != null) {
            this._pt.init(e.getX(), e.getY());
            this._pt0.init(this._pt);
            LocalPt lpt = new LocalPt();
            WorldPt wpt = this._pool.getReferencePt();
            this._mapPanel.scale().wp2lp(wpt, lpt);
            this._lrc.init(this._pt.x - 8, this._pt.y - 8, this._pt.x + 8, this._pt.y + 8);
            if (this._lrc.contains(lpt)) {
                this._selectedPt = lpt;
                this._selectedWPt = wpt;
                this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
            } else {
                this._lrc.init(this._pt.x - 3, this._pt.y - 3, this._pt.x + 3, this._pt.y + 3);
                for (int i = 0; i < this._pool.getRegion().pts.size(); ++i) {
                    wpt = (WorldPt)this._pool.getRegion().pts.elementAt(i);
                    if (wpt == null) continue;
                    this._mapPanel.scale().wp2lp(wpt, lpt);
                    if (!this._lrc.contains(lpt)) continue;
                    this._selectedPt = lpt;
                    this._selectedWPt = wpt;
                    this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
                    break;
                }
            }
        }
    }

    @Override
    protected void editingMouseDragged(MouseEvent e) {
        if (this._selectedPt != null && this._pool != null) {
            this.drawStoragePool(this._pool, true);
            this._selectedPt.init(e.getX(), e.getY());
            this._mapPanel.scale().lp2wp(this._selectedPt, this._selectedWPt);
            this._pool.setModified(true);
            this.drawStoragePool(this._pool, true);
        }
    }

    void removeRecentStoragePoolNode() {
        Graphics g = this._mapCanvas.getGraphics();
        int npts = this._ptVec.size();
        if (npts <= 1) {
            this._ptVec.removeAllElements();
            this._mode = 0;
            this._moving = false;
            this._mapPanel.paintMap();
            this._mapPanel.viewport().setCursor(this.getCursor());
            return;
        }
        g.setXORMode(Color.white);
        if (this._moving) {
            this.drawPt(this._pt, true);
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
        }
        this.drawPt(this._pt0, true);
        LocalPt lpt = (LocalPt)this._ptVec.elementAt(npts - 2);
        this._pt1.init(lpt);
        g.drawLine(this._pt0.x, this._pt0.y, this._pt1.x, this._pt1.y);
        this._ptVec.removeElementAt(npts - 1);
        this._pt0.init(this._pt1);
        if (this._moving) {
            g.setXORMode(Color.white);
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            this.drawPt(this._pt, true);
        }
        g.setPaintMode();
        g.dispose();
    }

    protected void addStoragePoolNode(MouseEvent e) {
        this._pt0.init(this._pt);
        this._pt.init(e.getX(), e.getY());
        this.drawPt(this._pt, true);
        this._ptVec.addElement(new LocalPt(this._pt));
        this._moving = false;
    }

    protected void createStoragePool(MouseEvent e) {
        this._sysglyph.createStoragePool(this._ptVec);
        this._mapPanel.viewport().setCursor(this.getCursor());
        this._mode = 0;
        this._moving = false;
    }

    @Override
    protected void initiateCreateObject(MouseEvent e) {
        if (!this.findStudySystemGlyph()) {
            JOptionPane.showMessageDialog((Component)this._mapPanel, "Please create/select a Study first");
            return;
        }
        if (!this.isConfigurationLocked("Cannot Edit Storage Pools")) {
            return;
        }
        this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
        this._mode = 1;
        this._pt0.init(e.getX(), e.getY());
        this._pt.init(this._pt0);
        this.drawPt(this._pt, true);
        this._ptVec.removeAllElements();
        this._ptVec.addElement(new LocalPt(this._pt));
        this._mode = 1;
    }

    @Override
    protected void selectObject(MouseEvent e) {
        StoragePool iregion;
        if (!this.findStudySystemGlyph()) {
            return;
        }
        this._pt.init(e.getX(), e.getY());
        this._pool = iregion = this._sysglyph.selectStoragePool(this._pt, false, false);
    }

    @Override
    protected void selectObjectForEditing(MouseEvent e) {
        if (!this.findStudySystemGlyph()) {
            return;
        }
        this._pt.init(e.getX(), e.getY());
        StoragePool pool = this._sysglyph.findStoragePool(this._pt);
        if (pool != null) {
            this._mode = this.isConfigurationLocked("Cannot Edit Storage Pools") ? 2 : 0;
            this._sysglyph.selectStoragePool(pool, false, this._mode == 2);
        } else {
            this._mode = 0;
        }
        this.setStoragePool(pool);
    }

    void setStoragePool(StoragePool pool) {
        this._pool = pool;
    }

    void drawPt(LocalPt pt, boolean isXOR) {
        Graphics g = this._mapCanvas.getGraphics();
        if (isXOR) {
            g.setXORMode(new Color(255, 255, 255));
        } else {
            g.setColor(Color.black);
        }
        StudyOffChannelMouseAdapter._xpt[0] = pt.x - 3;
        StudyOffChannelMouseAdapter._ypt[0] = pt.y;
        StudyOffChannelMouseAdapter._xpt[1] = pt.x;
        StudyOffChannelMouseAdapter._ypt[1] = pt.y + 3;
        StudyOffChannelMouseAdapter._xpt[2] = pt.x + 3;
        StudyOffChannelMouseAdapter._ypt[2] = pt.y;
        StudyOffChannelMouseAdapter._xpt[3] = pt.x;
        StudyOffChannelMouseAdapter._ypt[3] = pt.y - 3;
        g.fillPolygon(_xpt, _ypt, 4);
        g.setPaintMode();
        g.dispose();
    }

    void drawRegion(LocalRegion lreg, boolean isXOR) {
        Graphics g = this._mapCanvas.getGraphics();
        if (isXOR) {
            g.setXORMode(new Color(255, 255, 255));
        } else {
            g.setColor(Color.black);
        }
        int icnt = 0;
        for (int i = 0; i < lreg.pts.size() && i < 4000; ++i) {
            LocalPt pt = (LocalPt)lreg.pts.elementAt(i);
            if (pt == null) continue;
            StudyOffChannelMouseAdapter._xpt[0] = pt.x - 3;
            StudyOffChannelMouseAdapter._ypt[0] = pt.y;
            StudyOffChannelMouseAdapter._xpt[1] = pt.x;
            StudyOffChannelMouseAdapter._ypt[1] = pt.y + 3;
            StudyOffChannelMouseAdapter._xpt[2] = pt.x + 3;
            StudyOffChannelMouseAdapter._ypt[2] = pt.y;
            StudyOffChannelMouseAdapter._xpt[3] = pt.x;
            StudyOffChannelMouseAdapter._ypt[3] = pt.y - 3;
            g.fillPolygon(_xpt, _ypt, 4);
            StudyOffChannelMouseAdapter._xp[icnt] = pt.x;
            StudyOffChannelMouseAdapter._yp[icnt] = pt.y;
            ++icnt;
        }
        g.drawPolygon(_xp, _yp, icnt);
        g.setPaintMode();
        g.dispose();
    }

    void drawStoragePool(StoragePool ireg, boolean isXOR) {
        if (this._sysglyph == null || ireg == null) {
            return;
        }
        Graphics g = this._mapCanvas.getGraphics();
        this._sysglyph.drawSelectedStoragePool(g, this._mapPanel.scale(), ireg, isXOR, this._mode == 2);
        g.dispose();
    }

    @Override
    void showPopupMenu(MouseEvent e) {
        if (!this.findStudySystemGlyph()) {
            return;
        }
        this._pt.init(e.getX(), e.getY());
        this._sysglyph.offChannelPopupMenu(this._pt);
    }
}

