/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.LocalRegion;
import hec.map.MapCanvas;
import hec.map.MapPanel;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.model.StreamElement;
import hec.watershed.client.StudyMouseAdapter;
import hec.watershed.model.OtherProject;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class StudyOtherProjectMouseAdapter
extends StudyMouseAdapter
implements MouseListener,
MouseMotionListener {
    Vector _ptVec = new Vector();
    Vector _nodeVec = new Vector();
    boolean _creatingRegion = false;
    boolean _editingRegion = false;
    LocalPt _beginPt = new LocalPt();
    LocalPt _endPt = new LocalPt();
    LocalPt _pt = new LocalPt();
    LocalPt _pt0 = new LocalPt();
    LocalPt _selectedPt = null;
    WorldPt _selectedWPt = null;
    LocalRect _lrc = new LocalRect();
    WorldRect _wrc = new WorldRect();
    OtherProject _otherProject = null;
    StreamElement _stream = null;
    boolean _moving = false;
    static int[] _xpt = new int[4];
    static int[] _ypt = new int[4];
    static int[] _xp = new int[4000];
    static int[] _yp = new int[4000];

    public StudyOtherProjectMouseAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
    }

    @Override
    public void abort() {
        super.abort();
        this._creatingRegion = false;
        this._editingRegion = false;
        this._otherProject = null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this._moving && this._otherProject != null) {
            WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
            this._otherProject = this._sysglyph.moveOtherProject(this._otherProject, wpt);
            this._mapPanel.viewport().setCursor(this.getCursor());
            this._moving = false;
            this._mapPanel.paintMap();
        } else if (!(this._creatingRegion && e.isControlDown() || this._creatingRegion && !e.isControlDown())) {
            if (!this._editingRegion && !this._creatingRegion && e.isControlDown()) {
                if (!this.findStudySystemGlyph()) {
                    return;
                }
                if (!this.isConfigurationLocked("Cannot Edit Other Projects")) {
                    return;
                }
                this._creatingRegion = true;
                this._pt0.init(e.getX(), e.getY());
                this._pt.init(this._pt0);
                this.drawPt(this._pt, true);
                this._otherProject = this._sysglyph.createOtherProject(this._pt);
                this._creatingRegion = false;
            } else if (this._selectedPt == null && (e.isPopupTrigger() || StudyOtherProjectMouseAdapter.pressedButton3((MouseEvent)e))) {
                if (!this.findStudySystemGlyph()) {
                    return;
                }
                this._sysglyph.otherProjectPopupMenu(this._pt);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() || StudyOtherProjectMouseAdapter.pressedButton3((MouseEvent)e)) {
            if (!this.findStudySystemGlyph()) {
                return;
            }
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            this._sysglyph.otherProjectPopupMenu(pt);
        } else if (!this._creatingRegion && (this._creatingRegion || !e.isControlDown()) && this._editingRegion && this._otherProject != null) {
            this._pt.init(e.getX(), e.getY());
            this._pt0.init(this._pt);
            LocalPt lpt = new LocalPt();
            WorldPt wpt = this._otherProject.getReferencePt();
            this._mapPanel.scale().wp2lp(wpt, lpt);
            this._lrc.init(this._pt.x - 8, this._pt.y - 8, this._pt.x + 8, this._pt.y + 8);
            if (!this._lrc.contains(lpt)) {
                return;
            }
            this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(13));
            wpt = this._mapPanel.scale().lp2wp(this._pt);
            this._moving = true;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this._creatingRegion) {
            super.mouseMoved(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this._editingRegion && this._otherProject != null && this._moving) {
            Graphics g = this._mapCanvas.getGraphics();
            g.setXORMode(new Color(255, 255, 255));
            g.fillRect(this._pt.x - 5, this._pt.y - 5, 10, 10);
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            if (this._otherProject.isConnectedToStream()) {
                WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
                double coord = this._stream.getLine().getCoordAtLocation(wpt);
                double station = this._stream.getStationByCoord(coord);
                pt = this._mapPanel.scale().wp2lp(this._stream.getLocationByCoord(coord));
            }
            this._pt.init(pt);
            g.fillRect(this._pt.x - 5, this._pt.y - 5, 10, 10);
            g.setPaintMode();
            g.dispose();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this._creatingRegion && e.getClickCount() == 2) {
            if (!this.findStudySystemGlyph()) {
                return;
            }
            this._pt.init(e.getX(), e.getY());
            OtherProject proj = this._sysglyph.findOtherProject(this._pt);
            StreamAlignmentGlyph alignmentGlyph = (StreamAlignmentGlyph)this._mapPanel.findGlyphOfClass(StreamAlignmentGlyph.class.getName());
            if (proj != null) {
                this._stream = alignmentGlyph != null ? alignmentGlyph.findReach(proj.getStreamId()) : null;
                this._editingRegion = this._stream != null && this.isConfigurationLocked("Cannot Edit Other Projects");
                proj = this._sysglyph.selectOtherProject(this._pt, false, this._editingRegion);
            } else {
                this._editingRegion = false;
            }
            this._otherProject = proj;
        } else if (!this._editingRegion) {
            if (!this.findStudySystemGlyph()) {
                return;
            }
            this._pt.init(e.getX(), e.getY());
            OtherProject proj = this._sysglyph.selectOtherProject(this._pt, false, false);
            this._editingRegion = false;
            this._otherProject = proj;
        }
    }

    void drawPt(LocalPt pt, boolean isXOR) {
        Graphics g = this._mapCanvas.getGraphics();
        if (isXOR) {
            g.setXORMode(new Color(255, 255, 255));
        } else {
            g.setColor(Color.black);
        }
        StudyOtherProjectMouseAdapter._xpt[0] = pt.x - 3;
        StudyOtherProjectMouseAdapter._ypt[0] = pt.y;
        StudyOtherProjectMouseAdapter._xpt[1] = pt.x;
        StudyOtherProjectMouseAdapter._ypt[1] = pt.y + 3;
        StudyOtherProjectMouseAdapter._xpt[2] = pt.x + 3;
        StudyOtherProjectMouseAdapter._ypt[2] = pt.y;
        StudyOtherProjectMouseAdapter._xpt[3] = pt.x;
        StudyOtherProjectMouseAdapter._ypt[3] = pt.y - 3;
        g.fillPolygon(_xpt, _ypt, 4);
        g.setPaintMode();
        g.dispose();
    }

    void drawRegion(LocalRegion lreg, boolean isXOR) {
        Graphics g = this._mapCanvas.getGraphics();
        if (isXOR) {
            g.setXORMode(new Color(255, 255, 255));
        } else {
            g.setColor(Color.black);
        }
        int icnt = 0;
        for (int i = 0; i < lreg.pts.size() && i < 4000; ++i) {
            LocalPt pt = (LocalPt)lreg.pts.elementAt(i);
            if (pt == null) continue;
            StudyOtherProjectMouseAdapter._xpt[0] = pt.x - 3;
            StudyOtherProjectMouseAdapter._ypt[0] = pt.y;
            StudyOtherProjectMouseAdapter._xpt[1] = pt.x;
            StudyOtherProjectMouseAdapter._ypt[1] = pt.y + 3;
            StudyOtherProjectMouseAdapter._xpt[2] = pt.x + 3;
            StudyOtherProjectMouseAdapter._ypt[2] = pt.y;
            StudyOtherProjectMouseAdapter._xpt[3] = pt.x;
            StudyOtherProjectMouseAdapter._ypt[3] = pt.y - 3;
            g.fillPolygon(_xpt, _ypt, 4);
            StudyOtherProjectMouseAdapter._xp[icnt] = pt.x;
            StudyOtherProjectMouseAdapter._yp[icnt] = pt.y;
            ++icnt;
        }
        g.drawPolygon(_xp, _yp, icnt);
        g.setPaintMode();
        g.dispose();
    }

    void drawOtherProject(OtherProject proj, boolean isXOR) {
        if (this._sysglyph == null || proj == null) {
            return;
        }
        Graphics g = this._mapCanvas.getGraphics();
        this._sysglyph.drawSelectedOtherProject(g, this._mapPanel.scale(), proj, isXOR, this._editingRegion);
        g.dispose();
    }
}

