/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.MapCanvas;
import hec.map.MapPanel;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.WorldRegion;
import hec.model.Node;
import hec.model.StreamElement;
import hec.model.StreamSegment;
import hec.watershed.client.StudyMouseAdapter;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.Reservoir;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class StudyResMouseAdapter
extends StudyMouseAdapter
implements MouseListener,
MouseMotionListener,
KeyListener {
    static int[] _xpt = new int[4];
    static int[] _ypt = new int[4];
    LocalPt _pt = new LocalPt();
    WorldPt _wpt = new WorldPt();
    LocalPt _pt0 = new LocalPt();
    LocalPt _pt1 = new LocalPt();
    WorldPt _wpt0 = new WorldPt();
    Vector _wptList = new Vector();
    Vector<Node> _nodeVec = new Vector();
    Node _selectedNode = null;
    LocalPt _selectedPt = null;
    WorldPt _selectedWPt = null;
    LocalRect _lrc = new LocalRect();
    WorldRect _wrc = new WorldRect();
    Node _node = new Node();
    Reservoir _reservoir;
    boolean _moving = false;
    private Action _escapeAction;

    public StudyResMouseAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
    }

    @Override
    public void abort() {
        super.abort();
        this._selectedNode = null;
        this._selectedPt = null;
        this._selectedWPt = null;
        this._moving = false;
        this._mapPanel.getInputMap(1).remove(KeyStroke.getKeyStroke(27, 0));
        this._mapPanel.getActionMap().remove("resEscapeKey");
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() != 27) {
            return;
        }
        switch (this._mode) {
            case 1: {
                this.removeRecentReserviorNode();
                break;
            }
            case 2: {
                this.abortEditing();
            }
        }
    }

    @Override
    public void init() {
        super.init();
        if (this._escapeAction == null) {
            this._escapeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StudyResMouseAdapter.this.escapeKeyAction();
                }
            };
        }
        if (this._mapPanel.getActionMap().get("resEscapeKey") == null) {
            this._mapPanel.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "resEscapeKey");
            this._mapPanel.getActionMap().put("resEscapeKey", this._escapeAction);
        }
    }

    protected void escapeKeyAction() {
        switch (this._mode) {
            case 1: {
                this.removeRecentReserviorNode();
                break;
            }
            case 2: {
                this.abortEditing();
            }
        }
    }

    @Override
    protected void creatingMouseReleased(MouseEvent e) {
        if (e.isControlDown()) {
            this.addReservoirNode(e);
        } else {
            this.addReservoirNode(e);
            this.createReservoir(e);
        }
    }

    @Override
    protected void creatingMouseMoved(MouseEvent e) {
        Graphics g = this._mapCanvas.getGraphics();
        g.setXORMode(Color.white);
        if (this._moving) {
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            this.drawPt(this._pt, true);
        }
        this._moving = true;
        this._pt1.init(e.getX(), e.getY());
        StreamElement strm = this._alignglyph.findNearestReach(this._pt1);
        if (strm != null) {
            WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt1);
            strm.getLine().getNearestLocation(wpt, this._wpt);
            this._mapPanel.scale().wp2lp(this._wpt, this._pt1);
        }
        if (this._sysglyph.findReservoir(this._wpt) == null) {
            this._pt.init(this._pt1);
            if (strm != null) {
                this._node.setStreamIndex(strm.getIndex());
                this._node.setStreamName(strm.getName());
                this._node.setStreamStation(strm.getStationByLocation(this._wpt));
                this._node.setStreamCoord(strm.getCoordByLocation(this._wpt));
                this._node.setLocation(this._wpt);
            }
        }
        g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
        this.drawPt(this._pt, true);
        g.setPaintMode();
        g.dispose();
    }

    @Override
    protected void editingMouseReleased(MouseEvent e) {
        if (this._selectedNode != null) {
            Node node = new Node();
            node.setStreamIndex(this._selectedNode.getStreamIndex());
            node.setStreamStation(this._selectedNode.getStreamStation());
            node.setStreamCoord(this._selectedNode.getStreamCoord());
            node.setLocation(new WorldPt(this._selectedNode.getLocation()));
            this._selectedNode.setStreamIndex(this._node.getStreamIndex());
            this._selectedNode.setStreamStation(this._node.getStreamStation());
            this._selectedNode.setStreamCoord(this._node.getStreamCoord());
            this._selectedNode.setLocation(new WorldPt(this._node.getLocation()));
            Vector ndirVec = new Vector();
            Vector<StreamSegment> segVec = new Vector<StreamSegment>();
            String errstr = null;
            errstr = this._alignglyph.getStreamSegmentsByNodes(this._reservoir.getNodeVector(), ndirVec, segVec);
            if (errstr != null) {
                JOptionPane.showMessageDialog((Component)this._mapPanel, errstr, "Cannot change reservoir node location", 1);
                this._selectedNode.setStreamIndex(node.getStreamIndex());
                this._selectedNode.setStreamStation(node.getStreamStation());
                this._selectedNode.setStreamCoord(node.getStreamCoord());
                this._selectedNode.setLocation(new WorldPt(node.getLocation()));
            } else {
                this._reservoir.updateComputationPoint(this._selectedNode);
                this._sysglyph.updateReservoirDiversions(this._reservoir, this._selectedNode.getStreamIndex());
                this._reservoir.getNodeDirVector().removeAllElements();
                this._reservoir.getNodeDirVector().addAll(ndirVec);
                this._reservoir.setStreamSegmentVector(segVec);
                this._reservoir.setModified(true);
            }
            this._selectedNode = null;
            this._mapPanel.paintMap();
        }
        if (this._selectedPt != null) {
            this._selectedPt = null;
            this._selectedWPt = null;
            this._mapPanel.paintMap();
        }
    }

    @Override
    protected void editingMousePressed(MouseEvent e) {
        if (e.isPopupTrigger() || StudyResMouseAdapter.pressedButton3((MouseEvent)e)) {
            this.showPopupMenu(e);
        } else if (e.isControlDown() && e.isShiftDown()) {
            this._pt.init(e.getX(), e.getY());
            WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
            double tol = this._mapPanel.scale().x2e(this._pt.x + 5) - this._mapPanel.scale().x2e(this._pt.x);
            if (this._reservoir.getRegion().removePt(wpt, tol)) {
                this._reservoir.setModified(true);
            }
            this._mapPanel.paintMap();
        } else if (e.isControlDown()) {
            this._pt.init(e.getX(), e.getY());
            WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt);
            double tol = this._mapPanel.scale().x2e(this._pt.x + 5) - this._mapPanel.scale().x2e(this._pt.x);
            if (this._reservoir.getRegion().insertPt(wpt, tol)) {
                this._reservoir.setModified(true);
            }
            this.drawReservoir(this._reservoir, false, false);
        } else {
            WorldPt wpt;
            this._pt.init(e.getX(), e.getY());
            this._pt0.init(this._pt);
            this._lrc.init(this._pt.x - 8, this._pt.y - 8, this._pt.x + 8, this._pt.y + 8);
            LocalPt lpt = new LocalPt();
            Vector<Node> nodevec = this._reservoir.getNodeVector();
            for (int in = 0; in < nodevec.size(); ++in) {
                Node node = nodevec.elementAt(in);
                StreamElement elem = this._alignglyph.findReach(node.getStreamIndex());
                wpt = elem != null ? elem.getLocationByStation(node.getStreamStation()) : node.getLocation();
                this._mapPanel.scale().wp2lp(wpt, lpt);
                if (!this._lrc.contains(lpt)) continue;
                this._selectedNode = node;
                this._node.setStreamIndex(this._selectedNode.getStreamIndex());
                this._node.setStreamName(this._selectedNode.getStreamName());
                this._node.setStreamStation(this._selectedNode.getStreamStation());
                this._node.setStreamCoord(this._selectedNode.getStreamCoord());
                this._node.setLocation(new WorldPt(this._selectedNode.getLocation()));
                this._pt0.init(lpt);
                this._pt.init(lpt);
                this.drawPt(this._pt0, false);
                return;
            }
            wpt = this._reservoir.getReferencePt();
            this._mapPanel.scale().wp2lp(wpt, lpt);
            if (this._lrc.contains(lpt)) {
                this._selectedPt = lpt;
                this._selectedWPt = wpt;
                return;
            }
            this._lrc.init(this._pt.x - 3, this._pt.y - 3, this._pt.x + 3, this._pt.y + 3);
            for (int i = 0; i < this._reservoir.getRegion().pts.size(); ++i) {
                wpt = (WorldPt)this._reservoir.getRegion().pts.elementAt(i);
                if (wpt == null) continue;
                this._mapPanel.scale().wp2lp(wpt, lpt);
                if (!this._lrc.contains(lpt)) continue;
                this._selectedPt = lpt;
                this._selectedWPt = wpt;
                return;
            }
        }
    }

    @Override
    protected void editingMouseMoved(MouseEvent e) {
        if (this._reservoir == null) {
            return;
        }
        WorldRegion region = this._reservoir.getRegion();
        this._pt.init(e.getX(), e.getY());
        int size = region.pts.size();
        this._lrc.init(this._pt.x - 3, this._pt.y - 3, this._pt.x + 3, this._pt.y + 3);
        LocalPt lpt = new LocalPt();
        boolean assignedCursor = false;
        for (int i = 0; i < size; ++i) {
            WorldPt wpt = (WorldPt)region.pts.get(i);
            if (wpt == null) continue;
            this._mapPanel.scale().wp2lp(wpt, lpt);
            if (!this._lrc.contains(lpt)) continue;
            this._mapPanel.viewport().setCursor(Cursor.getPredefinedCursor(1));
            assignedCursor = true;
            break;
        }
        if (!assignedCursor) {
            this._mapPanel.viewport().setCursor(this.getCursor());
        }
    }

    @Override
    protected void editingMouseDragged(MouseEvent e) {
        if (this._selectedNode != null && this._reservoir != null) {
            Reservoir res;
            Graphics g = this._mapCanvas.getGraphics();
            g.setXORMode(Color.white);
            this.drawPt(this._pt, true);
            this._pt1.init(e.getX(), e.getY());
            StreamElement strm = this._alignglyph.findReach(this._selectedNode.getStreamIndex());
            if (strm != null) {
                WorldPt wpt = this._mapPanel.scale().lp2wp(this._pt1);
                strm.getLine().getNearestLocation(wpt, this._wpt);
                this._mapPanel.scale().wp2lp(this._wpt, this._pt1);
            }
            if ((res = this._sysglyph.findReservoir(this._wpt)) == null || res == this._reservoir) {
                this._pt.init(this._pt1);
                if (strm != null) {
                    this._node.setStreamStation(strm.getStationByLocation(this._wpt));
                    this._node.setStreamCoord(strm.getCoordByLocation(this._wpt));
                    this._node.setLocation(new WorldPt(this._wpt));
                    this._reservoir.setModified(true);
                }
            }
            this.drawPt(this._pt, true);
            g.setPaintMode();
            g.dispose();
        } else if (this._selectedPt != null && this._reservoir != null) {
            this.drawReservoir(this._reservoir, true, false);
            this._selectedPt.init(e.getX(), e.getY());
            this._mapPanel.scale().lp2wp(this._selectedPt, this._selectedWPt);
            this._reservoir.setModified(true);
            this.drawReservoir(this._reservoir, true, false);
        }
    }

    void removeRecentReserviorNode() {
        Graphics g = this._mapCanvas.getGraphics();
        int npts = this._wptList.size();
        if (npts <= 1) {
            this._wptList.removeAllElements();
            this._mode = 0;
            this._moving = false;
            this._mapPanel.paintMap();
            return;
        }
        g.setXORMode(Color.white);
        if (this._moving) {
            this.drawPt(this._pt, true);
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
        }
        this.drawPt(this._pt0, true);
        WorldPt wpt = (WorldPt)this._wptList.elementAt(npts - 2);
        this._mapPanel.scale().wp2lp(wpt, this._pt1);
        g.drawLine(this._pt0.x, this._pt0.y, this._pt1.x, this._pt1.y);
        this._wptList.removeElementAt(npts - 1);
        this._nodeVec.removeElementAt(npts - 1);
        this._pt0.init(this._pt1);
        if (this._moving) {
            g.setXORMode(Color.white);
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            this.drawPt(this._pt, true);
        }
        g.setPaintMode();
        g.dispose();
    }

    @Override
    protected void initiateCreateObject(MouseEvent e) {
        if (!this.findStudySystemGlyph()) {
            return;
        }
        if (!this._sysglyph.isWriteLocked()) {
            JOptionPane.showMessageDialog((Component)this._mapPanel, "You must first lock the watershed configuration.", "Cannot create reservoir", 1);
            return;
        }
        if (!this.findStreamAlignmentGlyph()) {
            return;
        }
        this._pt.init(e.getX(), e.getY());
        if (this._sysglyph.findReservoir(this._pt) != null) {
            JOptionPane.showMessageDialog((Component)this._mapPanel, "A reservoir already exists at this location", "Cannot create reservoir", 1);
            return;
        }
        StreamElement stream = this._alignglyph.findReach(this._pt);
        if (stream == null) {
            JOptionPane.showMessageDialog((Component)this._mapPanel, "Click near a stream to begin creating a reservoir.", "Cannot create reservoir", 1);
            return;
        }
        this._wptList.removeAllElements();
        this._nodeVec.removeAllElements();
        this._mapPanel.scale().lp2wp(this._pt, this._wpt);
        stream.getLine().getNearestLocation(this._wpt, this._wpt0);
        this._mapPanel.scale().wp2lp(this._wpt0, this._pt0);
        this._wptList.addElement(new WorldPt(this._wpt0));
        this._node.setStreamIndex(stream.getIndex());
        this._node.setStreamStation(stream.getStationByLocation(this._wpt0));
        this._node.setStreamCoord(stream.getCoordByLocation(this._wpt0));
        this._node.setStreamName(stream.getName());
        Node node = new Node();
        node.setStreamIndex(this._node.getStreamIndex());
        node.setStreamStation(this._node.getStreamStation());
        node.setStreamCoord(this._node.getStreamCoord());
        node.setLocation(new WorldPt(this._wpt0));
        this._nodeVec.addElement(node);
        this.drawPt(this._pt0, false);
        this._pt.init(this._pt0);
        this._mode = 1;
    }

    void addReservoirNode(MouseEvent e) {
        this._mapPanel.scale().lp2wp(this._pt, this._wpt);
        WorldPt wpt = (WorldPt)this._wptList.lastElement();
        if (wpt != null && this._wpt.equals(wpt)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Node node = new Node();
        node.setStreamIndex(this._node.getStreamIndex());
        node.setStreamStation(this._node.getStreamStation());
        node.setStreamCoord(this._node.getStreamCoord());
        node.setLocation(new WorldPt(this._node.getLocation()));
        int size = this._nodeVec.size();
        int cnt = 1;
        int streamIndex = this._node.getStreamIndex();
        for (int i = 0; i < size; ++i) {
            Node n0 = this._nodeVec.get(i);
            if (n0.getStreamIndex() == streamIndex) {
                ++cnt;
            }
            if (cnt <= 2) continue;
            System.out.println("addReservoirNode:can't add a third reservoir node to Stream " + node.getStreamName());
            return;
        }
        this._wptList.addElement(new WorldPt(this._wpt));
        this._nodeVec.addElement(node);
        this.drawPt(this._pt, false);
        this._pt0.init(this._pt);
        this._moving = false;
    }

    void createReservoir(MouseEvent e) {
        Vector ndirVec = new Vector();
        Vector segVec = new Vector();
        String errstr = null;
        errstr = this._alignglyph.getStreamSegmentsByNodes(this._nodeVec, ndirVec, segVec);
        if (errstr != null) {
            JOptionPane.showMessageDialog((Component)this._mapPanel, errstr, "Cannot create reservoir", 1);
            this._mapPanel.paintMap();
        } else {
            boolean foundCp = false;
            boolean foundCpOk = false;
            LocalPt lpt = new LocalPt();
            for (int i = 0; i < segVec.size(); ++i) {
                StreamSegment ss = (StreamSegment)segVec.get(i);
                ComputationPoint cp = this._sysglyph.findCompPt(ss.streamIndex, ss.upstreamCoord, ss.downstreamCoord);
                if (cp == null) continue;
                foundCpOk = false;
                for (int j = 0; j < this._wptList.size(); ++j) {
                    this._mapPanel.scale().wp2lp((WorldPt)this._wptList.get(j), lpt);
                    if (this._sysglyph.findCompPt(lpt) != cp) continue;
                    foundCpOk = true;
                    break;
                }
                if (foundCpOk) continue;
                JOptionPane.showMessageDialog((Component)this._mapPanel, "Can not create a Reservoir that encloses existing Computation Points", "Cannot create Reservoir", 1);
                foundCp = true;
                this._mapPanel.paintMap();
                break;
            }
            if (!foundCp) {
                Vector<LocalPt> ptvec = new Vector<LocalPt>();
                for (int i = 0; i < this._wptList.size(); ++i) {
                    ptvec.addElement(this._mapPanel.scale().wp2lp((WorldPt)this._wptList.elementAt(i)));
                }
                this._sysglyph.createReservoir(ptvec, this._nodeVec, ndirVec, segVec);
            }
        }
        this._mode = 0;
        this._moving = false;
    }

    @Override
    void showPopupMenu(MouseEvent e) {
        if (!this.findStudySystemGlyph()) {
            return;
        }
        this._pt.init(e.getX(), e.getY());
        this._sysglyph.reservoirPopupMenu(this._pt);
    }

    @Override
    protected void selectObject(MouseEvent e) {
        if (!this.findStudySystemGlyph()) {
            return;
        }
        this._pt.init(e.getX(), e.getY());
        Reservoir iregion = this._sysglyph.findReservoir(this._pt);
        if (iregion == null) {
            this._sysglyph.clearSelection();
        } else if (iregion == this._reservoir) {
            this._sysglyph.selectReservoir(iregion, false, this._mode == 2);
        } else {
            this._sysglyph.selectReservoir(iregion, false, false);
            this._mode = 0;
        }
        this.setReservoir(iregion);
    }

    @Override
    void abortEditing() {
        this._selectedPt = null;
        this._selectedWPt = null;
        this.setReservoir(null);
        super.abortEditing();
    }

    @Override
    protected void selectObjectForEditing(MouseEvent e) {
        if (!this.findStudySystemGlyph()) {
            return;
        }
        this._pt.init(e.getX(), e.getY());
        Reservoir iregion = this._sysglyph.findReservoir(this._pt);
        if (iregion != null) {
            if (!this._sysglyph.isWriteLocked()) {
                JOptionPane.showMessageDialog((Component)this._mapPanel, "You must first lock the watershed configuration.", "Cannot edit reservoir", 1);
                this._mode = 0;
            } else {
                this._mode = 2;
            }
            this._sysglyph.selectReservoir(iregion, false, this._mode == 2);
        } else {
            this._mode = 0;
        }
        this.setReservoir(iregion);
    }

    synchronized void drawPt(LocalPt pt, boolean isXOR) {
        Graphics g = this._mapCanvas.getGraphics();
        if (isXOR) {
            g.setXORMode(Color.white);
        } else {
            g.setColor(Color.black);
        }
        StudyResMouseAdapter._xpt[0] = pt.x - 5;
        StudyResMouseAdapter._ypt[0] = pt.y;
        StudyResMouseAdapter._xpt[1] = pt.x;
        StudyResMouseAdapter._ypt[1] = pt.y + 5;
        StudyResMouseAdapter._xpt[2] = pt.x + 5;
        StudyResMouseAdapter._ypt[2] = pt.y;
        StudyResMouseAdapter._xpt[3] = pt.x;
        StudyResMouseAdapter._ypt[3] = pt.y - 5;
        g.fillPolygon(_xpt, _ypt, 4);
        g.setPaintMode();
        g.dispose();
    }

    void drawReservoir(Reservoir ireg, boolean isXOR, boolean fillPolygon) {
        if (this._sysglyph == null || ireg == null) {
            return;
        }
        Graphics g = this._mapCanvas.getGraphics();
        this._sysglyph.drawSelectedReservoir(g, this._mapPanel.scale(), ireg, isXOR, this._mode == 2, fillPolygon);
        g.dispose();
    }

    private void setReservoir(Reservoir newres) {
        if (this._reservoir == null || this._reservoir != newres) {
            // empty if block
        }
        this._reservoir = newres;
        if (this._reservoir == null) {
            this._mode = 0;
        }
    }
}

