/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.client.ResDrawPropData;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJFontButton;

public class StudyResPropPanel
extends JPanel {
    ResDrawPropData _dpData;
    private RmaJColorComboBox fillColorCombo;
    private RmaJColorComboBox outlineColorCombo;
    private RmaJColorComboBox reachOutlineColorCombo;
    private RmaJColorComboBox reachFillColorCombo;
    private RmaJColorComboBox damColorCombo;
    private RmaJCheckBox drawNameCB;
    private RmaJCheckBox drawRPolygonCB;
    private RmaJComboBox damWidthCombo;
    private RmaJComboBox reachWidthCombo;
    private RmaJFontButton nameFontBtn;

    public StudyResPropPanel(ResDrawPropData dpData) {
        super(new GridBagLayout());
        this._dpData = dpData;
        this.buildControls();
        this.fillPanel();
    }

    private void buildControls() {
        JPanel tempPanel = new JPanel(new GridBagLayout());
        tempPanel.setBorder(BorderFactory.createTitledBorder("Triangle Element:"));
        this.add((Component)tempPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0));
        JLabel label = new JLabel("Triangle Fill Color:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        tempPanel.add((Component)label, gbc);
        this.fillColorCombo = new RmaJColorComboBox();
        this.fillColorCombo.setModifiable(true);
        label.setLabelFor((Component)this.fillColorCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        tempPanel.add((Component)this.fillColorCombo, gbc);
        label = new JLabel("Triangle Outline Color:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        tempPanel.add((Component)label, gbc);
        this.outlineColorCombo = new RmaJColorComboBox();
        this.outlineColorCombo.setModifiable(true);
        label.setLabelFor((Component)this.outlineColorCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        tempPanel.add((Component)this.outlineColorCombo, gbc);
        this.drawRPolygonCB = new RmaJCheckBox("Draw Reservoir Triangle");
        this.drawRPolygonCB.setMargin(RmaInsets.INSETS0000);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        tempPanel.add((Component)this.drawRPolygonCB, gbc);
        tempPanel = new JPanel(new GridBagLayout());
        tempPanel.setBorder(BorderFactory.createTitledBorder("Storage Reach Element:"));
        this.add((Component)tempPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, RmaInsets.INSETS5555, 0, 0));
        label = new JLabel("Storage Reach Fill Color:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        tempPanel.add((Component)label, gbc);
        this.reachFillColorCombo = new RmaJColorComboBox();
        this.reachFillColorCombo.setModifiable(true);
        label.setLabelFor((Component)this.reachFillColorCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        tempPanel.add((Component)this.reachFillColorCombo, gbc);
        label = new JLabel("Storage Reach Outline Color:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        tempPanel.add((Component)label, gbc);
        this.reachOutlineColorCombo = new RmaJColorComboBox();
        this.reachOutlineColorCombo.setModifiable(true);
        label.setLabelFor((Component)this.reachOutlineColorCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        tempPanel.add((Component)this.reachOutlineColorCombo, gbc);
        label = new JLabel("Storage Reach Width:");
        tempPanel.add((Component)label, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, RmaInsets.INSETS5555, 50, 0));
        Integer[] values = new Integer[10];
        for (int i = 0; i < values.length; ++i) {
            values[i] = new Integer(i + 1);
        }
        this.reachWidthCombo = new RmaJComboBox(new DefaultComboBoxModel<Integer>(values));
        this.reachWidthCombo.setModifiable(true);
        tempPanel.add((Component)this.reachWidthCombo, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 0, RmaInsets.INSETS5555, 50, 0));
        tempPanel = new JPanel(new GridBagLayout());
        tempPanel.setBorder(BorderFactory.createTitledBorder("Dam Element:"));
        this.add((Component)tempPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, RmaInsets.INSETS5550, 50, 0));
        label = new JLabel("Dam Fill Color");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        tempPanel.add((Component)label, gbc);
        label = new JLabel("Dam Width:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)0);
        tempPanel.add((Component)label, gbc);
        this.damColorCombo = new RmaJColorComboBox();
        this.damColorCombo.setModifiable(true);
        label.setLabelFor((Component)this.damColorCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        tempPanel.add((Component)this.damColorCombo, gbc);
        DefaultComboBoxModel<Integer> model = new DefaultComboBoxModel<Integer>(values);
        this.damWidthCombo = new RmaJComboBox(model);
        this.damWidthCombo.setModifiable(true);
        label.setLabelFor((Component)this.damWidthCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.ipadx = 50;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        tempPanel.add((Component)this.damWidthCombo, gbc);
        tempPanel = new JPanel(new GridBagLayout());
        tempPanel.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)tempPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(15, 5, 5, 5), 0, 0));
        this.drawNameCB = new RmaJCheckBox("Draw Reservoir Name");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)0);
        tempPanel.add((Component)this.drawNameCB, gbc);
        this.nameFontBtn = new RmaJFontButton("Font...");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        tempPanel.add((Component)this.nameFontBtn, gbc);
    }

    public void fillPanel() {
        if (this._dpData == null) {
            return;
        }
        this.fillColorCombo.setSelectedColor(this._dpData.getTriangleFillColor());
        this.reachOutlineColorCombo.setSelectedColor(this._dpData.getReachOutlineColor());
        this.reachFillColorCombo.setSelectedColor(this._dpData.getReachFillColor());
        this.damColorCombo.setSelectedColor(this._dpData.getDamColor());
        this.drawNameCB.setSelected(this._dpData.isDrawName());
        this.drawRPolygonCB.setSelected(this._dpData.isDrawRPolygon());
        this.damWidthCombo.setSelectedItem((Object)new Integer((int)this._dpData.getMinDamWidth()));
        this.reachWidthCombo.setSelectedItem((Object)new Integer((int)this._dpData.getReachWidth()));
        this.nameFontBtn.setFont(this._dpData.getNameFont());
        this.outlineColorCombo.setSelectedColor(this._dpData.getTriangleOutlineColor());
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JDialog dialog = new JDialog((Frame)null, true);
        dialog.getContentPane().add((Component)new StudyResPropPanel(null), "Center");
        dialog.setLocation(200, 200);
        dialog.pack();
        dialog.setVisible(true);
    }

    public void savePanel() {
        if (this._dpData == null) {
            return;
        }
        this._dpData.setTriangleFillColor(this.fillColorCombo.getSelectedColor());
        this._dpData.setReachOutlineColor(this.reachOutlineColorCombo.getSelectedColor());
        this._dpData.setReachFillColor(this.reachFillColorCombo.getSelectedColor());
        this._dpData.setDamColor(this.damColorCombo.getSelectedColor());
        this._dpData.setDrawName(this.drawNameCB.isSelected());
        this._dpData.setDrawRPolygon(this.drawRPolygonCB.isSelected());
        this._dpData.setMinDamWidth(((Integer)this.damWidthCombo.getSelectedItem()).intValue());
        this._dpData.setReachWidth(((Integer)this.reachWidthCombo.getSelectedItem()).intValue());
        this._dpData.setNameFont(this.nameFontBtn.getFont());
        this._dpData.setTriangleOutlineColor(this.outlineColorCombo.getSelectedColor());
        this._dpData.save();
    }
}

