/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.client.ResDrawPropData;
import hec.watershed.client.StudyDPData;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.Hashtable;
import rma.util.RMAIO;

public class StudyReservoirDPData
extends StudyDPData
implements Serializable,
ResDrawPropData {
    private static final String FILL_COLOR_STR = "StudyReservoirDPData.TriangleFillColor";
    private static final String OUTLINE_COLOR_STR = "StudyReservoirDPData.TriangleOutlineColor";
    private static final String REACH_FILL_COLOR_STR = "StudyReservoirDPData.StorageReachFillColor";
    private static final String REACH_OUTLINE_COLOR_STR = "StudyReservoirDPData.StorageReachOutlineColor";
    private static final String DAM_COLOR_STR = "StudyReservoirDPData.DamColor";
    private static final String DRAW_NAME_STR = "StudyReservoirDPData.DrawName";
    private static final String DRAW_POLYGON_STR = "StudyReservoirDPData.DrawPolygon";
    private static final String MIN_DRAW_WIDTH_STR = "StudyReservoirDPData.MinimumDamWidth";
    private static final String REACH_WIDTH_STR = "StudyReservoirDPData.ReachWidth";
    private static final String NAME_FONT_STR = "StudyReservoirDPData.Name_Font";
    public Color triangleFillColor;
    public Color triangleOutlineColor;
    public Color reachFillColor;
    public Color reachOutlineColor;
    public Color damColor;
    public boolean drawName;
    public boolean drawRPolygon;
    public int minDamWidth;
    public int reachWidth;
    public Font nameFont;
    static StudyReservoirDPData _reservoirData = new StudyReservoirDPData();
    private Hashtable _properties = new Hashtable();
    private static boolean _loaded = false;

    protected StudyReservoirDPData() {
        this.load();
    }

    private void load() {
        if (StudyDPData._props == null) {
            return;
        }
        String s = StudyDPData._props.getProp(FILL_COLOR_STR, "-16711681");
        this.triangleFillColor = Color.decode(s);
        s = StudyDPData._props.getProp(OUTLINE_COLOR_STR, "-16776961");
        this.triangleOutlineColor = Color.decode(s);
        s = StudyDPData._props.getProp(REACH_FILL_COLOR_STR, "-16711681");
        this.reachFillColor = Color.decode(s);
        s = StudyDPData._props.getProp(REACH_OUTLINE_COLOR_STR, "-16776961");
        this.reachOutlineColor = Color.decode(s);
        s = StudyDPData._props.getProp(DAM_COLOR_STR, Integer.toString(Color.lightGray.getRGB()));
        this.damColor = Color.decode(s);
        s = StudyDPData._props.getProp(DRAW_NAME_STR, "true");
        this.drawName = Boolean.valueOf(s);
        s = StudyDPData._props.getProp(DRAW_POLYGON_STR, "true");
        this.drawRPolygon = Boolean.valueOf(s);
        s = StudyDPData._props.getProp(MIN_DRAW_WIDTH_STR, "10");
        this.minDamWidth = RMAIO.parseInt((String)s);
        s = StudyDPData._props.getProp(REACH_WIDTH_STR, "8");
        this.reachWidth = RMAIO.parseInt((String)s);
        s = StudyDPData._props.getProp(NAME_FONT_STR, "SansSerif-plain-10");
        this.nameFont = Font.decode(s);
        if (this.nameFont == null) {
            this.nameFont = new Font("SansSerif", 0, 10);
        }
    }

    public static StudyReservoirDPData getData() {
        return _reservoirData;
    }

    @Override
    public void setDefaults() {
        this.triangleFillColor = Color.cyan;
        this.triangleOutlineColor = Color.blue;
        this.reachFillColor = Color.cyan;
        this.reachOutlineColor = Color.blue;
        this.damColor = Color.lightGray;
        this.drawName = true;
        this.drawRPolygon = true;
        this.minDamWidth = 10;
        this.reachWidth = 8;
        this.nameFont = new Font("SansSerif", 0, 10);
    }

    public void save() {
        if (StudyDPData._props == null) {
            return;
        }
        StudyDPData._props.setProp(FILL_COLOR_STR, "" + this.triangleFillColor.getRGB());
        StudyDPData._props.setProp(OUTLINE_COLOR_STR, "" + this.triangleOutlineColor.getRGB());
        StudyDPData._props.setProp(REACH_FILL_COLOR_STR, "" + this.reachFillColor.getRGB());
        StudyDPData._props.setProp(REACH_OUTLINE_COLOR_STR, "" + this.reachOutlineColor.getRGB());
        StudyDPData._props.setProp(DAM_COLOR_STR, "" + this.damColor.getRGB());
        StudyDPData._props.setProp(DRAW_NAME_STR, "" + this.drawName);
        StudyDPData._props.setProp(DRAW_POLYGON_STR, "" + this.drawRPolygon);
        StudyDPData._props.setProp(MIN_DRAW_WIDTH_STR, "" + this.minDamWidth);
        StudyDPData._props.setProp(REACH_WIDTH_STR, "" + this.reachWidth);
        StudyDPData._props.setProp(NAME_FONT_STR, this.nameFont.getName() + "-" + this.getFontStyleString(this.nameFont) + "-" + this.nameFont.getSize());
        StudyDPData._props.saveProperties();
    }

    public Hashtable getProperties() {
        this._properties.clear();
        this._properties.put(FILL_COLOR_STR, "" + this.triangleFillColor.getRGB());
        this._properties.put(OUTLINE_COLOR_STR, "" + this.triangleOutlineColor.getRGB());
        this._properties.put(REACH_FILL_COLOR_STR, "" + this.reachFillColor.getRGB());
        this._properties.put(REACH_OUTLINE_COLOR_STR, "" + this.reachOutlineColor.getRGB());
        this._properties.put(DAM_COLOR_STR, "" + this.damColor.getRGB());
        this._properties.put(DRAW_NAME_STR, "" + this.drawName);
        this._properties.put(DRAW_POLYGON_STR, "" + this.drawRPolygon);
        this._properties.put(MIN_DRAW_WIDTH_STR, "" + this.minDamWidth);
        this._properties.put(REACH_WIDTH_STR, "" + this.reachWidth);
        this._properties.put(NAME_FONT_STR, this.nameFont.getName() + "-" + this.nameFont.getStyle() + "-" + this.nameFont.getSize());
        return this._properties;
    }

    public Color getReachOutlineColor() {
        return this.reachOutlineColor;
    }

    public double getMinDamWidth() {
        return this.minDamWidth;
    }

    public Color getDamColor() {
        return this.damColor;
    }

    public Font getNameFont() {
        return this.nameFont;
    }

    public Color getTriangleFillColor() {
        return this.triangleFillColor;
    }

    public Color getTriangleOutlineColor() {
        return this.triangleOutlineColor;
    }

    public double getReachWidth() {
        return this.reachWidth;
    }

    public Color getReachFillColor() {
        return this.reachFillColor;
    }

    public boolean isDrawName() {
        return this.drawName;
    }

    public boolean isDrawRPolygon() {
        return this.drawRPolygon;
    }

    public void setTriangleFillColor(Color selectedColor) {
        this.triangleFillColor = selectedColor;
    }

    public void setReachOutlineColor(Color selectedColor) {
        this.reachOutlineColor = selectedColor;
    }

    public void setReachFillColor(Color selectedColor) {
        this.reachFillColor = selectedColor;
    }

    public void setDamColor(Color selectedColor) {
        this.damColor = selectedColor;
    }

    public void setDrawName(boolean drawName) {
        this.drawName = drawName;
    }

    public void setDrawRPolygon(boolean drawPolygon) {
        this.drawRPolygon = drawPolygon;
    }

    public void setMinDamWidth(int width) {
        this.minDamWidth = width;
    }

    public void setReachWidth(int width) {
        this.reachWidth = width;
    }

    public void setNameFont(Font font) {
        this.nameFont = font;
    }

    public void setTriangleOutlineColor(Color selectedColor) {
        this.triangleOutlineColor = selectedColor;
    }
}

