/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.watershed.client.StationSetDrawPropData;
import hec.watershed.client.StudyDPData;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import rma.swing.RmaColor;

public class StudyStationSetDPData
extends StudyDPData
implements StationSetDrawPropData {
    private static final String NAME_FONT_STR = "StudyStationSetDPData.nameFont";
    private static final String DRAW_NAME_STR = "StudyStationSetDPData.drawName";
    private static final String MET_STATION_COLOR = "StudyStationSetDPData.metStationColor";
    private static final String OBS_STATION_COLOR = "StudyStationSetDPData.obsStationColor";
    Hashtable _properties = new Hashtable();
    static StudyStationSetDPData _stationSetData = new StudyStationSetDPData();
    public Font nameFont;
    public boolean drawName;
    private Color metStationColor;
    private Color obsStationColor;

    public StudyStationSetDPData() {
        this.load();
    }

    private void load() {
        String s = _props.getProp(DRAW_NAME_STR, "true");
        this.drawName = Boolean.valueOf(s);
        s = _props.getProp(NAME_FONT_STR, "SansSerif-plain-10");
        this.nameFont = Font.decode(s);
        if (this.nameFont == null) {
            this.nameFont = new Font("SansSerif", 0, 10);
        }
        String color = _props.getProp(MET_STATION_COLOR, RmaColor.color2String((Color)new Color(164, 94, 200)));
        this.metStationColor = RmaColor.parseColorString((String)color);
        color = _props.getProp(OBS_STATION_COLOR, RmaColor.color2String((Color)new Color(37, 143, 203)));
        this.obsStationColor = RmaColor.parseColorString((String)color);
    }

    @Override
    public void save() {
        if (_props == null) {
            return;
        }
        _props.setProp(DRAW_NAME_STR, "" + this.drawName);
        _props.setProp(NAME_FONT_STR, this.nameFont.getName() + "-" + this.getFontStyleString(this.nameFont) + "-" + this.nameFont.getSize());
        _props.setProp(MET_STATION_COLOR, RmaColor.color2String((Color)this.metStationColor));
        _props.setProp(OBS_STATION_COLOR, RmaColor.color2String((Color)this.obsStationColor));
        _props.saveProperties();
    }

    @Override
    public void setDefaults() {
        this.drawName = true;
        this.nameFont = new Font("SansSerif", 0, 10);
        this.metStationColor = new Color(264, 94, 200);
        this.obsStationColor = new Color(37, 143, 203);
    }

    public static StudyStationSetDPData getData() {
        return _stationSetData;
    }

    public Hashtable getProperties() {
        this._properties.clear();
        this._properties.put(DRAW_NAME_STR, "" + this.drawName);
        this._properties.put(NAME_FONT_STR, this.nameFont.getName() + "-" + this.nameFont.getStyle() + "-" + this.nameFont.getSize());
        this._properties.put(MET_STATION_COLOR, RmaColor.color2String((Color)this.metStationColor));
        this._properties.put(OBS_STATION_COLOR, RmaColor.color2String((Color)this.obsStationColor));
        return this._properties;
    }

    @Override
    public boolean isDrawName() {
        return this.drawName;
    }

    @Override
    public Font getNameFont() {
        return this.nameFont;
    }

    @Override
    public void setDrawName(boolean draw) {
        this.drawName = draw;
    }

    @Override
    public void setNameFont(Font font) {
        this.nameFont = font;
    }

    @Override
    public void setObservedStationColor(Color color) {
        this.obsStationColor = color;
    }

    @Override
    public Color getObservedStationColor() {
        return this.obsStationColor;
    }

    @Override
    public void setMetStationColor(Color color) {
        this.metStationColor = color;
    }

    @Override
    public Color getMetStationColor() {
        return this.metStationColor;
    }
}

