/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import com.google.common.flogger.FluentLogger;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.client.HecClientFrame;
import hec.clientapp.model.StreamAlignment;
import hec.gfx2d.Symbol;
import hec.gui.NameDialog;
import hec.lang.NamedType;
import hec.map.LayerSelectionFactory;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.LocalRegion;
import hec.map.MapGlyph;
import hec.map.MapLabelItem;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.ModeDrawingAttributeSet;
import hec.map.ModelDrawingAttributeSet;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.WorldRegion;
import hec.map.crs.CRSException;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.model.CommonDataList;
import hec.model.DataList;
import hec.model.DataObject;
import hec.model.DataStruct;
import hec.model.Node;
import hec.model.StreamElement;
import hec.model.StreamJunction;
import hec.model.StreamNode;
import hec.model.StreamPolyLine;
import hec.model.StreamSegment;
import hec.model.StreamSegmentIdentifier;
import hec.watershed.client.NewCompPtDialog;
import hec.watershed.client.ObsStationSnapPoint;
import hec.watershed.client.PlaceCompPtDialog;
import hec.watershed.client.StationWrapper;
import hec.watershed.client.StudyChannelModDPData;
import hec.watershed.client.StudyCompPtDPData;
import hec.watershed.client.StudyDiversionDPData;
import hec.watershed.client.StudyDrawingAttributeSet;
import hec.watershed.client.StudyImpactAreaDPData;
import hec.watershed.client.StudyLeveeDPData;
import hec.watershed.client.StudyReservoirDPData;
import hec.watershed.client.StudyStationSetDPData;
import hec.watershed.client.StudySystemGlyphSelection;
import hec.watershed.client.StudySystemMapGlyph;
import hec.watershed.client.WatershedConfigMode;
import hec.watershed.client.WatershedDisplayMode;
import hec.watershed.model.ChannelMod;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ComputationPointLayer;
import hec.watershed.model.Condition;
import hec.watershed.model.DefaultDataList;
import hec.watershed.model.Diversion;
import hec.watershed.model.ImpactArea;
import hec.watershed.model.Levee;
import hec.watershed.model.OtherProject;
import hec.watershed.model.Project;
import hec.watershed.model.Reservoir;
import hec.watershed.model.Station;
import hec.watershed.model.StationSet;
import hec.watershed.model.StationSetDataList;
import hec.watershed.model.StationSetDataObject;
import hec.watershed.model.StoragePool;
import hec.watershed.model.Study;
import hec.watershed.model.StudyRegion;
import hec.watershed.model.WatershedDataList;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import rma.swing.RmaImage;
import rma.swing.text.DssPathnamePartDocument;
import rma.util.RMAConst;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.MapPropLoggingMarker;

public class StudySystemGlyph
extends MapGlyph
implements ActionListener,
StudySystemMapGlyph {
    private static final MarkingClassLogger MAP_PROP_LOGGER;
    private static final FluentLogger LOGGER;
    private static final double[] _angle;
    Study _study = null;
    StreamAlignment _alignment;
    Vector<MapGlyph.Selection> _selectionVector = new Vector();
    WatershedDataList _channelModList;
    WatershedDataList _compPtList;
    WatershedDataList _leveeList;
    StationSetDataList _stationSetDataList;
    ImageIcon stationImage;
    ImageIcon metstationImage;
    ImageIcon observedStation;
    ImageIcon bothStation;
    static Image _impactImage;
    static Image _impactImageNS;
    static Image _tsImage;
    static Image _selTsImage;
    static Image _otherProjImage;
    static Image _selOtherProjImage;
    HecClientFrame _frame = ClientApp.frame();
    WatershedDisplayMode _watershedMode;
    WorldPt _lastFindwpt = new WorldPt();
    WorldRect _lastFindRect = new WorldRect();
    int _lastFoundObj;
    int _numObjs = 5;
    StudyDrawingAttributeSet _studyDas = null;
    LocalPt tmpLpt = new LocalPt();
    WorldPt tmpWpt = new WorldPt();
    StudyReservoirDPData resDPData = StudyReservoirDPData.getData();
    StudyDiversionDPData _diversionData = StudyDiversionDPData.getData();
    StudyLeveeDPData _leveeData = StudyLeveeDPData.getData();
    StudyCompPtDPData _compPtData = StudyCompPtDPData.getData();
    StudyChannelModDPData _channelModDpData = StudyChannelModDPData.getData();
    StudyImpactAreaDPData _impactAreaData = StudyImpactAreaDPData.getData();
    StudyStationSetDPData _stationSetData = StudyStationSetDPData.getData();
    transient int _glyphLevel;
    int[] xy = new int[2];
    private boolean _debug;
    private List<ComputationPointLayer> _ccpVisibleLayers = new ArrayList<ComputationPointLayer>();
    private final Map<Station, Boolean> _isObsStationMap = new HashMap<Station, Boolean>();
    private static int stationIconWidth;

    public StudySystemGlyph(MapPanel panel, Study map) {
        super(panel, (MapObjectInterface)map);
        ModeDrawingAttributeSet modeDas;
        this._study = map;
        this.getChannelModList();
        this.getCompPtList();
        this.getLeveeList();
        this.getStationList();
        ClientMode mode = this._frame.getCurrentMode();
        if (mode instanceof WatershedDisplayMode) {
            this._watershedMode = (WatershedDisplayMode)mode;
        }
        if ((modeDas = ModeDrawingAttributeSet.getModeAttributeSet((String)ClientApp.frame().getCurrentMode().toString())) == null) {
            return;
        }
        this._studyDas = (StudyDrawingAttributeSet)modeDas.getModelAttributeSet("Study");
        this._studyDas.setGlyph(this);
        ClientWorkspace wksp = ClientApp.Workspace();
        if (wksp == null) {
            return;
        }
        this._alignment = (StreamAlignment)wksp.openManager("stream.align");
        if (_impactImage == null) {
            _impactImage = RmaImage.loadURLImage((String)"Images/fia3.gif");
        }
        if (_impactImageNS == null) {
            _impactImageNS = RmaImage.loadURLImage((String)"Images/fiaNS.gif");
        }
        if (_tsImage == null) {
            _tsImage = RmaImage.loadURLImage((String)"Images/modelup.gif");
        }
        if (_selTsImage == null) {
            _selTsImage = RmaImage.loadURLImage((String)"Images/modelsel.gif");
        }
        if (_otherProjImage == null) {
            _otherProjImage = RmaImage.loadURLImage((String)"Images/OtherProjUp.gif");
        }
        if (_selOtherProjImage == null) {
            _selOtherProjImage = RmaImage.loadURLImage((String)"Images/OtherProjDown.gif");
        }
        if (_selOtherProjImage == null) {
            _selOtherProjImage = RmaImage.loadURLImage((String)"Images/OtherProjDown.gif");
        }
        this.metstationImage = RmaImage.getImageIcon((String)"Images/stationset/blue/wide_diamond_blue.png");
        this.stationImage = RmaImage.getImageIcon((String)"Images/stationset/blue/wide_diamond_blue.png");
        this.observedStation = RmaImage.getImageIcon((String)"Images/stationset/purple/wide_diamond_purple.png");
        this.bothStation = RmaImage.getImageIcon((String)"Images/stationset/purple-blue/wide_diamond_purple_blue.png");
    }

    protected boolean getChannelModList() {
        ClientWorkspace wksp = ClientApp.Workspace();
        if (wksp == null) {
            return false;
        }
        this._channelModList = (WatershedDataList)wksp.getDataListContainer().getDataList(ChannelMod.class.getName());
        return this._channelModList != null;
    }

    protected boolean getLeveeList() {
        ClientWorkspace wksp = ClientApp.Workspace();
        if (wksp == null) {
            return false;
        }
        this._leveeList = (WatershedDataList)wksp.getDataListContainer().getDataList(Levee.class.getName());
        return this._leveeList != null;
    }

    protected boolean getStationList() {
        ClientWorkspace wksp = ClientApp.Workspace();
        if (wksp == null) {
            return false;
        }
        this._stationSetDataList = (StationSetDataList)wksp.getDataListContainer().getDataList(StationSet.class.getName());
        return this._stationSetDataList != null;
    }

    private void deleteStation(Station selectedStation) {
        if (selectedStation == null) {
            return;
        }
        DataStruct[] objectArray = this._stationSetDataList.getObjectArray();
        StationSet stationSet = null;
        if (objectArray != null && objectArray.length > 0) {
            StationSetDataObject stationSetDataObject = (StationSetDataObject)objectArray[0];
            stationSet = stationSetDataObject.getStationSet();
        }
        if (stationSet == null) {
            return;
        }
        stationSet.removeFeature(selectedStation);
        this.getMapPanel().paintMap();
    }

    public Station createStation(LocalPt pt) {
        String description;
        String name;
        if (pt == null) {
            return null;
        }
        if (!this.isWriteLocked()) {
            return null;
        }
        DataStruct[] objectArray = this._stationSetDataList.getObjectArray();
        StationSet stationSet = null;
        if (objectArray != null && objectArray.length > 0) {
            StationSetDataObject stationSetDataObject = (StationSetDataObject)objectArray[0];
            stationSet = stationSetDataObject.getStationSet();
        }
        if (stationSet == null) {
            return null;
        }
        List<ComputationPointLayer> computationPointLayers = this.getComputationPointLayers();
        Predicate<ComputationPoint> p = cp -> this.computeLocalBoundRect(cp.getReferencePt(), stationIconWidth).contains(pt);
        ComputationPoint cpStation = null;
        for (ComputationPointLayer computationPointLayer : computationPointLayers) {
            List<ComputationPoint> compPts = computationPointLayer.getCompPts();
            List collect = compPts.stream().filter(p).collect(Collectors.toList());
            if (collect.isEmpty()) continue;
            ComputationPoint tempPoint = (ComputationPoint)collect.get(0);
            Object msg = "Do you want to place the station at the computation point %s? ";
            int showConfirmDialog = JOptionPane.showConfirmDialog((Component)this._mapPanel, msg = String.format((String)msg, tempPoint.getName()), "Place Station", 0, 3);
            if (showConfirmDialog != 0) break;
            cpStation = tempPoint;
            break;
        }
        if (cpStation == null) {
            NameDialog dlg = new NameDialog((Frame)AppDaddy.getFrame(), true);
            List stations = stationSet.getFeatures();
            ArrayList<String> names = new ArrayList<String>();
            for (Station station : stations) {
                names.add(station.getName());
            }
            dlg.setExistingNames(names);
            dlg.setName("");
            dlg.setDescription("");
            dlg.setTitle("Name New Station");
            dlg.setVisible(true);
            if (dlg.isCanceled()) {
                return null;
            }
            name = dlg.getName();
            description = dlg.getDescription();
        } else {
            name = cpStation.getName();
            description = "";
            Predicate<Station> nameQ = s -> name.equalsIgnoreCase(s.getName());
            List stationsWithExistingName = stationSet.getFeatures(nameQ);
            if (!stationsWithExistingName.isEmpty()) {
                String message = "A station already exists with the name: " + name + ".\nPlease rename the existing station before placing a new station at the computation point " + name + ".";
                RMAIO.postWarning((Component)this.getMapPanel(), (String)message, (String)"Duplicate Name");
                return null;
            }
        }
        MapScale scale = this.getMapPanel().scale((MapGlyph)this);
        WorldPt wpt = scale.lp2wp(pt);
        Point createPoint = new GeometryFactory().createPoint(new Coordinate(wpt.e, wpt.n));
        Station station = new Station();
        station.setGeometry((Geometry)createPoint);
        stationSet.addFeature(station);
        station.setName(name);
        station.setDescription(description);
        if (cpStation != null) {
            WorldPt referencePt = cpStation.getReferencePt();
            createPoint = new GeometryFactory().createPoint(new Coordinate(referencePt.e, referencePt.n));
            station.setGeometry((Geometry)createPoint);
            station.setComputationPointId((int)cpStation.getId());
            if (cpStation.getSnapToStream()) {
                StreamElement findReach;
                station.setStreamStation(cpStation.getStreamStation());
                if (this._alignment != null && (findReach = this.getStreamAlignmentGlyph().findReach(cpStation.getStreamId())) != null) {
                    station.setStreamName(findReach.getName());
                    WorldPt pt2 = findReach.getLocationByStation(cpStation.getStreamStation());
                    createPoint = new GeometryFactory().createPoint(new Coordinate(pt2.e, pt2.n));
                    station.setGeometry((Geometry)createPoint);
                }
            }
        } else if (this._alignment != null) {
            WorldPt bestPt = new WorldPt();
            StreamElement findReach = this.getStreamAlignmentGlyph().findReach(pt);
            if (findReach != null) {
                station.setStreamName(findReach.getName());
                station.setStreamStation(findReach.getStationByLocation(wpt));
            } else {
                station.setStreamName("");
                station.setStreamStation(0.0);
            }
        }
        this.getMapPanel().paintMap();
        return station;
    }

    public Station findStation(LocalPt lpt) {
        DataStruct[] objectArray = this._stationSetDataList.getObjectArray();
        StationSet stationSet = null;
        if (objectArray != null && objectArray.length > 0) {
            StationSetDataObject stationSetDataObject = (StationSetDataObject)objectArray[0];
            stationSet = stationSetDataObject.getStationSet();
        }
        if (stationSet == null) {
            return null;
        }
        Station station = null;
        Predicate<Station> p = s -> {
            if (s.getStationIconLocation() == null) {
                return this.computeLocalBoundRect(s.getGeometry(), stationIconWidth).contains(lpt);
            }
            return this.computeLocalBoundRect(s.getStationIconLocation(), stationIconWidth).contains(lpt);
        };
        List findStation = stationSet.getFeatures(p);
        station = findStation != null && !findStation.isEmpty() ? (Station)((Object)findStation.get(0)) : null;
        return station;
    }

    private LocalRect computeLocalBoundRect(WorldPt g, int localBoundsBuffer) {
        if (g == null) {
            return new LocalRect(0, 0, 0, 0);
        }
        WorldRect wr = new WorldRect(g.e, g.n, g.e, g.n);
        MapScale scale = this.getMapPanel().scale((MapGlyph)this);
        LocalRect localRect = scale.wr2lr(wr);
        int l = localRect.l;
        int r = localRect.r;
        int t = localRect.t;
        int b = localRect.b;
        if (localRect.width() == 0) {
            l = localRect.l - localBoundsBuffer;
            r = localRect.l + localBoundsBuffer;
        }
        if (localRect.height() == 0) {
            t = localRect.t - localBoundsBuffer;
            b = localRect.t + localBoundsBuffer;
        }
        localRect = new LocalRect(l, t, r, b);
        return localRect;
    }

    private LocalRect computeLocalBoundRect(Geometry g, int localBoundsBuffer) {
        if (g == null) {
            return new LocalRect(0, 0, 0, 0);
        }
        Envelope env = g.getEnvelopeInternal();
        WorldRect wr = new WorldRect(env.getMinX(), env.getMaxY(), env.getMaxX(), env.getMinY());
        MapScale scale = this.getMapPanel().scale((MapGlyph)this);
        LocalRect localRect = scale.wr2lr(wr);
        int l = localRect.l;
        int r = localRect.r;
        int t = localRect.t;
        int b = localRect.b;
        if (localRect.width() == 0) {
            l = localRect.l - localBoundsBuffer;
            r = localRect.l + localBoundsBuffer;
        }
        if (localRect.height() == 0) {
            t = localRect.t - localBoundsBuffer;
            b = localRect.t + localBoundsBuffer;
        }
        localRect = new LocalRect(l, t, r, b);
        return localRect;
    }

    protected boolean getCompPtList() {
        ClientWorkspace wksp = ClientApp.Workspace();
        if (wksp == null) {
            return false;
        }
        this._compPtList = (WatershedDataList)wksp.getDataListContainer().getDataList(ComputationPoint.class.getName());
        return this._compPtList != null;
    }

    @Override
    public boolean compPtPopupMenu(LocalPt pt) {
        if (this._study == null || pt == null) {
            return false;
        }
        ComputationPoint cp = this.selectCompPt(pt, false, false);
        if (cp == null) {
            return false;
        }
        this.clearSelection();
        this.addSelection(cp, true, false);
        ClientMode mode = this._frame.getCurrentMode();
        return mode.objectPopupMenu((NamedType)cp, pt);
    }

    @Override
    public boolean offChannelPopupMenu(LocalPt pt) {
        if (this._study == null || pt == null) {
            return false;
        }
        StoragePool pool = this.selectStoragePool(pt, false, false);
        if (pool == null) {
            return false;
        }
        this.clearSelection();
        this.addSelection(pool, true, false);
        ClientMode mode = this._frame.getCurrentMode();
        return mode.objectPopupMenu((NamedType)pool, pt);
    }

    @Override
    public boolean channelModPopupMenu(LocalPt pt) {
        if (this._study == null || pt == null) {
            return false;
        }
        ChannelMod cm = this.selectChannelMod(pt, false, false);
        if (cm == null) {
            return false;
        }
        this.clearSelection();
        this.addSelection(cm, true, false);
        ClientMode mode = this._frame.getCurrentMode();
        return mode.objectPopupMenu((NamedType)cm, pt);
    }

    @Override
    public boolean impactAreaPopupMenu(LocalPt pt) {
        if (this._study == null || pt == null) {
            return false;
        }
        double tol = this._mapPanel.scale().x2e(pt.x + 10) - this._mapPanel.scale().x2e(pt.x);
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        ImpactArea iregion = this._study.findImpactArea(wpt, tol);
        if (iregion == null) {
            return false;
        }
        this.clearSelection();
        this.addSelection(iregion, true, false);
        ClientMode mode = this._frame.getCurrentMode();
        return mode.objectPopupMenu((NamedType)iregion, pt);
    }

    @Override
    public boolean leveePopupMenu(LocalPt pt) {
        if (this._study == null || pt == null) {
            return false;
        }
        double tol = this._mapPanel.scale().x2e(pt.x + 10) - this._mapPanel.scale().x2e(pt.x);
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        Levee levee = this.findLevee(wpt, tol);
        if (levee == null) {
            return false;
        }
        this.clearSelection();
        this.addSelection(levee, true, false);
        ClientMode mode = this._frame.getCurrentMode();
        return mode.objectPopupMenu((NamedType)levee, pt);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object instanceof MenuItem) {
            MenuItem mitem = (MenuItem)object;
            String name = mitem.getName();
            if (!mitem.getLabel().equals("Edit") && !mitem.getLabel().equals("Rename") && mitem.getLabel().equals("Delete")) {
                this.clearSelection(name);
                if (this._study != null) {
                    this._study.deleteImpactArea(name);
                }
                this._mapPanel.paintMap();
            }
        }
    }

    public boolean isShown() {
        if (this._studyDas == null) {
            return false;
        }
        return this._studyDas.isShown();
    }

    public void setShown(boolean shown) {
        if (this._studyDas == null) {
            return;
        }
        this._studyDas.setShown(shown);
    }

    public void showMapElement(String name, String glyphElement, boolean show) {
        if (glyphElement.equalsIgnoreCase("shown")) {
            this._studyDas.setShown(show);
        } else {
            this._studyDas.setAttribute(glyphElement, show);
        }
    }

    @Override
    public void clearSelection() {
        if (this._debug) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("clearSelection:clearing");
        }
        this._selectionVector.clear();
        this._mapPanel.paintMap();
    }

    public void clearSelection(NamedType obj) {
        this.clearSelectionObject(obj);
    }

    public void clearSelectionObject(Object obj) {
        if (obj == null) {
            return;
        }
        for (int i = 0; i < this._selectionVector.size(); ++i) {
            MapGlyph.Selection sel = this._selectionVector.get(i);
            if (sel == null || obj != sel.object) continue;
            this._selectionVector.remove(i);
            this._mapPanel.paintMap();
            break;
        }
    }

    public void clearSelection(String name) {
        boolean found = false;
        for (int i = 0; i < this._selectionVector.size(); ++i) {
            ImpactArea iArea;
            MapGlyph.Selection sel = this._selectionVector.get(i);
            if (sel == null || !name.equals((iArea = (ImpactArea)sel.object).getName())) continue;
            this._selectionVector.remove(sel);
            found = true;
            break;
        }
        if (found) {
            this._mapPanel.paintMap();
        }
    }

    private void addSelection(Object obj, boolean add, boolean editing) {
        if (this._debug) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("addSelection:adding object " + obj + " editing=" + editing);
        }
        if (obj != null) {
            MapGlyph.Selection sel = new MapGlyph.Selection((MapGlyph)this, obj, editing);
            if (!this._selectionVector.contains(sel)) {
                this._selectionVector.add(sel);
            }
            if (add) {
                Graphics g = this._mapPanel.viewport().getGraphics();
                this.drawSelectedObject(g, this._mapPanel.scale(), obj, add, editing);
                g.dispose();
            } else {
                this._mapPanel.paintMap();
            }
        } else if (!add) {
            this._mapPanel.paintMap();
        }
        if (obj instanceof NamedType) {
            this.fireGlyphSelectionChanged((NamedType)obj);
        }
    }

    @Override
    public Reservoir selectReservoir(Reservoir res, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        if (res == null) {
            return res;
        }
        this.addSelection(res, add, editing);
        return res;
    }

    public Reservoir selectReservoir(LocalPt pt, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        if (pt == null) {
            return null;
        }
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        Reservoir res = this.findReservoir(wpt);
        this.addSelection(res, add, editing);
        return res;
    }

    @Override
    public StoragePool selectStoragePool(StoragePool pool, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        this.addSelection(pool, add, editing);
        return pool;
    }

    @Override
    public StoragePool selectStoragePool(LocalPt pt, boolean add, boolean editing) {
        return (StoragePool)this.selectRegion(pt, add, editing, StoragePool.class.getName(), Color.blue);
    }

    public ComputationPoint selectCompPt(ComputationPoint cp, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        this.addSelection(cp, add, editing);
        return cp;
    }

    public Station selectStation(LocalPt pt, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        if (pt == null) {
            return null;
        }
        Station station = this.findStation(pt);
        this.addSelection((Object)station, add, editing);
        return station;
    }

    public Station selectStation(Station station, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        this.addSelection((Object)station, add, editing);
        return station;
    }

    @Override
    public ComputationPoint selectCompPt(LocalPt pt, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        if (pt == null) {
            return null;
        }
        ComputationPoint compPt = this.findCompPt(pt);
        this.addSelection(compPt, add, editing);
        return compPt;
    }

    @Override
    public void selectImpactArea(ImpactArea area, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        this.addSelection(area, add, editing);
    }

    @Override
    public Diversion selectDiversion(Diversion div, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        this.addSelection(div, add, editing);
        return div;
    }

    @Override
    public Diversion selectDiversion(LocalPt pt, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        if (pt == null) {
            this._mapPanel.paintMap();
            return null;
        }
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        double tol = this._mapPanel.scale().x2e(pt.x + 10) - this._mapPanel.scale().x2e(pt.x);
        Diversion div = this.findDiversion(wpt, tol);
        this.addSelection(div, add, editing);
        return div;
    }

    @Override
    public Levee selectLevee(Levee levee, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        if (levee == null) {
            return null;
        }
        this.addSelection(levee, add, editing);
        return levee;
    }

    @Override
    public Levee selectLevee(LocalPt pt, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        if (pt == null) {
            return null;
        }
        double tol = this._mapPanel.scale().x2e(pt.x + 5) - this._mapPanel.scale().x2e(pt.x);
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        Levee levee = this.findLevee(wpt, tol);
        if (levee == null) {
            return null;
        }
        this.addSelection(levee, add, editing);
        return levee;
    }

    public ImpactArea selectImpactArea(LocalPt pt, boolean add, boolean editing) {
        return (ImpactArea)this.selectRegion(pt, add, editing, ImpactArea.class.getName(), Color.red);
    }

    @Override
    public ImpactArea findImpactArea(LocalPt pt) {
        double tol = this._mapPanel.scale().x2e(pt.x + 10) - this._mapPanel.scale().x2e(pt.x);
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        StudyRegion region = this._study.findRegion(wpt, tol, ImpactArea.class.getName());
        return (ImpactArea)region;
    }

    @Override
    public StoragePool findStoragePool(LocalPt pt) {
        double tol = this._mapPanel.scale().x2e(pt.x + 10) - this._mapPanel.scale().x2e(pt.x);
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        StudyRegion region = this._study.findRegion(wpt, tol, StoragePool.class.getName());
        return (StoragePool)region;
    }

    protected StudyRegion selectRegion(LocalPt pt, boolean add, boolean editing, String type, Color outLine) {
        double tol = this._mapPanel.scale().x2e(pt.x + 10) - this._mapPanel.scale().x2e(pt.x);
        if (!add) {
            this._selectionVector.clear();
        }
        if (this._study == null || pt == null) {
            return null;
        }
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        StudyRegion region = this._study.findRegion(wpt, tol, type);
        this.addSelection(region, add, editing);
        return region;
    }

    @Override
    public OtherProject selectOtherProject(OtherProject op, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        this.addSelection(op, add, editing);
        return op;
    }

    @Override
    public OtherProject selectOtherProject(LocalPt pt, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        if (this._study == null || pt == null) {
            return null;
        }
        double tol = this._mapPanel.scale().x2e(pt.x + 20) - this._mapPanel.scale().x2e(pt.x);
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        OtherProject proj = this._study.findOtherProject(wpt, tol, true);
        this.addSelection(proj, add, editing);
        return proj;
    }

    public LocalRegion getLocalRegion(LocalPt pt) {
        if (this._study == null || pt == null) {
            return null;
        }
        double tol = this._mapPanel.scale().x2e(pt.x + 10) - this._mapPanel.scale().x2e(pt.x);
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        ImpactArea iarea = this._study.findImpactArea(wpt, tol);
        if (iarea == null) {
            return null;
        }
        WorldRegion reg = iarea.getRegion();
        LocalRegion lreg = new LocalRegion();
        for (int i = 0; i < reg.pts.size(); ++i) {
            wpt = (WorldPt)reg.pts.elementAt(i);
            if (wpt == null) continue;
            lreg.pts.addElement(this._mapPanel.scale().wp2lp(wpt));
        }
        return lreg;
    }

    public void dropRegionAtPt(LocalPt pt) {
        if (this._study == null) {
            return;
        }
        double e = this._mapPanel.scale().x2e(pt.x);
        double n = this._mapPanel.scale().y2n(pt.y);
        WorldRegion reg = new WorldRegion();
        reg.pts.addElement(new WorldPt(e - 2000.0, n - 2000.0));
        reg.pts.addElement(new WorldPt(e + 2000.0, n - 2000.0));
        reg.pts.addElement(new WorldPt(e + 2000.0, n + 2000.0));
        reg.pts.addElement(new WorldPt(e - 2000.0, n + 2000.0));
        ImpactArea iarea = this._study.addImpactArea(reg);
        if (iarea != null) {
            this._mapPanel.paintMap();
        }
    }

    @Override
    public void createDiversion(Node n0, Node n1, Vector ptVec, int inflowType) {
        if (this._study == null || ptVec == null) {
            return;
        }
        if (ptVec.size() < 1) {
            return;
        }
        String[] info = this.getNewProjectName("Name New Diversion", Diversion.class.getName());
        if (info == null) {
            this._mapPanel.paintMap();
            return;
        }
        Diversion diversion = null;
        diversion = this._study.createDiversion(n0, n1, ptVec, 0.0, inflowType, info[0], info[1]);
        this._mapPanel.paintMap();
    }

    @Override
    public Node createDiversionNode(LocalPt pt, Node upnode) {
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        Reservoir existingRes = null;
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        if (alignglyph == null) {
            return null;
        }
        StreamElement rch = alignglyph.findReach(pt, null);
        if (rch == null) {
            return null;
        }
        double coord = rch.getLine().getCoordAtLocation(wpt);
        if (coord == Double.NEGATIVE_INFINITY) {
            return null;
        }
        if (upnode == null) {
            existingRes = this._study.findReservoir(wpt);
        }
        Node node = this._study.createNode(wpt);
        node.setStreamIndex(rch.getIndex());
        node.setStreamCoord(coord);
        node.setStreamStation(rch.getStationByCoord(coord));
        if (existingRes != null) {
            existingRes.addNode(node, 1);
        }
        return node;
    }

    public Node createReservoirNode(LocalPt pt, StreamElement rch0, Vector nodevec) {
        if (pt == null) {
            return null;
        }
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        if (alignglyph == null) {
            return null;
        }
        StreamElement rch = alignglyph.findReach(pt, null);
        if (rch == null) {
            return null;
        }
        if (nodevec != null) {
            for (int i = 0; i < nodevec.size(); ++i) {
                Node upnode = (Node)nodevec.elementAt(i);
                if (upnode != null) continue;
            }
        }
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        double coord = rch.getLine().getCoordAtLocation(wpt);
        if (coord == Double.NEGATIVE_INFINITY) {
            return null;
        }
        Reservoir existingRes = null;
        existingRes = this._study.findReservoir(wpt);
        if (existingRes == null) {
            existingRes = this._study.findReservoir(rch.getIndex(), coord);
        }
        if (existingRes != null) {
            return null;
        }
        Node node = this._study.createNode(rch.getLocationByCoord(coord));
        node.setStreamIndex(rch.getIndex());
        node.setStreamCoord(coord);
        node.setStreamStation(rch.getStationByCoord(coord));
        return node;
    }

    public Reservoir createReservoir(Vector ptVec, Vector nodeVec) {
        return this.createReservoir(ptVec, nodeVec, null, null);
    }

    @Override
    public Reservoir createReservoir(Vector ptVec, Vector nodeVec, Vector ndirVec, Vector segVec) {
        if (this._study == null || ptVec == null) {
            return null;
        }
        if (ptVec.size() < 1) {
            return null;
        }
        WorldRegion reg = new WorldRegion();
        LocalPt pt = (LocalPt)ptVec.elementAt(0);
        double tol = this._mapPanel.scale().x2e(pt.x + 5) - this._mapPanel.scale().x2e(pt.x);
        Reservoir reservoir = null;
        NameDialog dlg = new NameDialog((Frame)ClientApp.frame(), true);
        dlg.setName("");
        dlg.setDescription("");
        dlg.setNameFieldDocument((Document)new DssPathnamePartDocument());
        dlg.setTitle("Name New Reservoir");
        List names = this._study.getObjectNamesList(Reservoir.class.getName());
        dlg.setExistingNames(names);
        dlg.setVisible(true);
        if (!dlg.isCanceled()) {
            String rname = dlg.getName();
            String rdescrip = dlg.getDescription();
            reservoir = ndirVec == null ? this._study.createReservoir(reg, (List)nodeVec, tol, rname, rdescrip) : this._study.createReservoir(reg, (List)nodeVec, (List)ndirVec, tol, rname, rdescrip);
            reservoir = (Reservoir)reservoir.getDataList().getObject(reservoir.getId());
            reservoir.setStreamSegmentVector(segVec);
            WorldPt regpt = reservoir.getDownstreamNode().getLocation();
            pt = this._mapPanel.scale().wp2lp(regpt);
            double e = this._mapPanel.scale().x2e(pt.x + 15);
            double n = this._mapPanel.scale().y2n(pt.y);
            reg.pts.addElement(new WorldPt(e, n));
            e = this._mapPanel.scale().x2e(pt.x);
            n = this._mapPanel.scale().y2n(pt.y - 20);
            reg.pts.addElement(new WorldPt(e, n));
            e = this._mapPanel.scale().x2e(pt.x - 15);
            n = this._mapPanel.scale().y2n(pt.y);
            reg.pts.addElement(new WorldPt(e, n));
            reservoir.setRegion(reg);
            reservoir.updateComputationPoint();
        }
        if (reservoir != null) {
            this.drawReservoir(this._mapPanel.viewport().getGraphics(), this._mapPanel.scale(), reservoir);
        }
        this._mapPanel.paintMap();
        return reservoir;
    }

    @Override
    public Levee createLevee(Vector ssiList, int bank) {
        if (this._study == null) {
            return null;
        }
        if (ssiList == null || ssiList.size() < 1) {
            return null;
        }
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        if (alignglyph == null) {
            return null;
        }
        String[] info = this.getNewProjectName("Name New Levee", Levee.class.getName());
        if (info == null) {
            this._mapPanel.paintMap();
            return null;
        }
        Levee levee = this._study.addLevee(ssiList, bank, 50, info[0], info[1]);
        this.getLeveeLine(null, null, levee);
        levee.updateComputationPoint();
        this.drawLevee(this._mapPanel.viewport().getGraphics(), this._mapPanel.scale(), levee);
        this._mapPanel.paintMap();
        return levee;
    }

    @Override
    public ComputationPoint createCompPt(LocalPt pt) {
        return this.createCompPt(pt, null);
    }

    private ComputationPoint createCompPt(LocalPt pt, Station stationForCompPoint) {
        if (this._study == null || pt == null) {
            return null;
        }
        if (this.findCompPt(pt) != null) {
            return null;
        }
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        ComputationPoint cpt = null;
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        String name = null;
        String description = null;
        Station stationAtPoint = null;
        if (stationForCompPoint == null && (stationAtPoint = this.findStation(pt)) != null && stationAtPoint.getComputationPointId() != -1) {
            stationAtPoint = null;
        }
        if (stationAtPoint != null) {
            String msg = "Do you want to place the computation point at the station %s? ";
            int showConfirmDialog = JOptionPane.showConfirmDialog((Component)this._mapPanel, msg = String.format(msg, stationAtPoint.getName()), "Place Station", 0, 3);
            if (showConfirmDialog == 0) {
                WorldPt swpt = new WorldPt(stationAtPoint.getGeometry().getCoordinate().x, stationAtPoint.getGeometry().getCoordinate().y);
                LocalPt slpt = this._mapPanel.scale().wp2lp(swpt);
                ComputationPoint retVal = this.createCompPt(slpt, stationAtPoint);
                stationAtPoint.setComputationPointId((int)retVal.getId());
                return retVal;
            }
        }
        if (alignglyph != null) {
            String[] info;
            StreamElement stream = alignglyph.findReach(pt);
            if (stream != null) {
                StreamJunction junc = alignglyph.findStreamJunction(stream, pt);
                if (junc != null) {
                    DefaultDataList list;
                    ComputationPointLayer layer;
                    PlaceCompPtDialog dialog = new PlaceCompPtDialog((Frame)this._frame, true);
                    dialog.setJunction(junc);
                    CommonDataList layerList = this._study.getCommonDataListContainer().getCommonDataList(ComputationPointLayer.class.getName());
                    dialog.setComputationPointLayers(layerList);
                    for (int i = 0; i < this._ccpVisibleLayers.size(); ++i) {
                        layer = this._ccpVisibleLayers.get(i);
                        if (layer.isDefaultLayer()) continue;
                        dialog.setSelectedComputationPointLayer(layer);
                        break;
                    }
                    if ((list = (DefaultDataList)ClientApp.Workspace().getDataListContainer().getDataList(ComputationPoint.class.getName())) == null) {
                        ((FluentLogger.Api)LOGGER.atInfo()).log("getNewProjectName: Failed to get DataList for " + ComputationPoint.class.getName());
                        return null;
                    }
                    Vector listOfNames = list.getNamesVector();
                    dialog.setExistingNames(listOfNames);
                    Object obj = null;
                    if (stationForCompPoint == null) {
                        dialog.setVisible(true);
                        if (dialog.isCanceled()) {
                            return null;
                        }
                        name = dialog.getName();
                        description = dialog.getDescription();
                    } else {
                        name = stationForCompPoint.getName();
                        description = stationForCompPoint.getDescription();
                    }
                    obj = dialog.getSelectedObject();
                    cpt = this._study.addCompPt(wpt, false, name, description);
                    if (cpt == null) {
                        return null;
                    }
                    layer = dialog.getComputationPointLayout();
                    if (layer != null && !layer.isDefaultLayer()) {
                        layer.addComputationPoint(cpt);
                    }
                    if (obj == junc) {
                        Vector nodes = junc.getNodeVector();
                        StreamNode node = (StreamNode)nodes.get(0);
                        for (int i = 1; i < nodes.size(); ++i) {
                            StreamNode node2 = (StreamNode)nodes.get(i);
                            if (!(node2.getStreamCoord() > node.getStreamCoord())) continue;
                            node = node2;
                        }
                        stream = node.getStream();
                        cpt.setStreamStation(node.getStation());
                        cpt.setStreamCoord(node.getStreamCoord());
                        cpt.setStreamId(stream.getIndex());
                        cpt.setStreamName(stream.getName());
                        cpt.setReferencePt(stream.getLocationByStation(cpt.getStreamStation()));
                        cpt.setSnapToStream(true);
                        cpt.setJunctionIndex(junc.getIndex());
                    } else if (obj instanceof StreamElement) {
                        stream = (StreamElement)obj;
                        cpt.setStreamStation(stream.getStationByLocation(wpt));
                        cpt.setStreamCoord(stream.getCoordByLocation(wpt));
                        cpt.setStreamId(stream.getIndex());
                        cpt.setSnapToStream(true);
                    }
                } else {
                    ComputationPointLayer layer;
                    info = stationForCompPoint != null ? new String[]{stationForCompPoint.getName(), stationForCompPoint.getDescription()} : this.getNewProjectName("Name New Computation Point", ComputationPoint.class.getName());
                    if (info == null) {
                        this._mapPanel.paintMap();
                        return null;
                    }
                    cpt = this._study.addCompPt(wpt, false, info[0], info[1]);
                    if (cpt == null) {
                        return null;
                    }
                    CommonDataList cdl = this._study.getCommonDataListContainer().getCommonDataList(ComputationPointLayer.class.getName());
                    if (cdl != null && info.length >= 3 && (layer = (ComputationPointLayer)cdl.getObject(info[2])) != null) {
                        layer.addComputationPoint(cpt);
                    }
                    cpt.setStreamStation(stream.getStationByLocation(wpt));
                    cpt.setStreamCoord(stream.getCoordByLocation(wpt));
                    cpt.setStreamId(stream.getIndex());
                    cpt.setSnapToStream(true);
                }
            } else {
                ComputationPointLayer layer;
                info = stationForCompPoint != null ? new String[]{stationForCompPoint.getName(), stationForCompPoint.getDescription()} : this.getNewProjectName("Name New Computation Point", ComputationPoint.class.getName());
                if (info == null) {
                    this._mapPanel.paintMap();
                    return null;
                }
                cpt = this._study.addCompPt(wpt, false, info[0], info[1]);
                if (cpt == null) {
                    return null;
                }
                CommonDataList cdl = this._study.getCommonDataListContainer().getCommonDataList(ComputationPointLayer.class.getName());
                if (cdl != null && info.length >= 3 && (layer = (ComputationPointLayer)cdl.getObject(info[2])) != null) {
                    layer.addComputationPoint(cpt);
                }
            }
        }
        if (cpt != null) {
            this.drawCompPt(this._mapPanel.viewport().getBufferedGraphics(), this._mapPanel.scale(), cpt);
        }
        this._mapPanel.paintMap();
        return cpt;
    }

    @Override
    public void createArea(List ptVec) {
        if (this._study == null || ptVec == null) {
            return;
        }
        if (ptVec.size() < 1) {
            return;
        }
        String[] info = this.getNewProjectName("Name New Impact Area", ImpactArea.class.getName());
        if (info == null) {
            this._mapPanel.paintMap();
            return;
        }
        ImpactArea iarea = this.createArea(info[0], info[1], ptVec);
        if (iarea != null) {
            this._mapPanel.paintMap();
        }
    }

    public ImpactArea createArea(String name, String description, List ptVec) {
        WorldRegion reg = new WorldRegion();
        LocalPt pt = new LocalPt();
        LocalPt begPt = new LocalPt();
        if (ptVec.size() < 3) {
            pt = (LocalPt)ptVec.get(0);
            begPt = (LocalPt)ptVec.get(0);
            if (pt == null) {
                return null;
            }
            double e = this._mapPanel.scale().x2e(pt.x - 10);
            double n = this._mapPanel.scale().y2n(pt.y + 10);
            reg.pts.addElement(new WorldPt(e, n));
            e = this._mapPanel.scale().x2e(pt.x + 10);
            n = this._mapPanel.scale().y2n(pt.y + 10);
            reg.pts.addElement(new WorldPt(e, n));
            e = this._mapPanel.scale().x2e(pt.x + 10);
            n = this._mapPanel.scale().y2n(pt.y - 10);
            reg.pts.addElement(new WorldPt(e, n));
            e = this._mapPanel.scale().x2e(pt.x - 10);
            n = this._mapPanel.scale().y2n(pt.y - 10);
            reg.pts.addElement(new WorldPt(e, n));
        } else {
            for (int i = 0; i < ptVec.size(); ++i) {
                pt = (LocalPt)ptVec.get(i);
                if (pt == null) continue;
                if (i == 0) {
                    begPt = (LocalPt)ptVec.get(0);
                }
                double e = this._mapPanel.scale().x2e(pt.x);
                double n = this._mapPanel.scale().y2n(pt.y);
                reg.pts.addElement(new WorldPt(e, n));
            }
        }
        return this.createArea(name, description, reg);
    }

    @Override
    public ImpactArea createArea(String name, String description, WorldRegion region) {
        ImpactArea iarea = this._study.addImpactArea(region, name, description);
        return iarea;
    }

    @Override
    public OtherProject createOtherProject(LocalPt pt) {
        if (this._study == null || pt == null) {
            return null;
        }
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        String[] info = this.getNewProjectName("Name New Other Project", "hec.watershed.model.OtherProject");
        if (info == null) {
            this._mapPanel.paintMap();
            return null;
        }
        OtherProject proj = this._study.addOtherProject(wpt, info[0], info[1]);
        if (proj != null) {
            this._mapPanel.paintMap();
        }
        return proj;
    }

    @Override
    public void createStoragePool(Vector ptVec) {
        if (this._study == null || ptVec == null) {
            return;
        }
        if (ptVec.size() < 1) {
            return;
        }
        String[] info = this.getNewProjectName("Name New Off Channel Storage", StoragePool.class.getName());
        if (info == null) {
            this._mapPanel.paintMap();
            return;
        }
        WorldRegion reg = new WorldRegion();
        LocalPt pt = new LocalPt();
        LocalPt begPt = new LocalPt();
        if (ptVec.size() < 3) {
            pt = (LocalPt)ptVec.elementAt(0);
            begPt = (LocalPt)ptVec.elementAt(0);
            if (pt == null) {
                return;
            }
            double e = this._mapPanel.scale().x2e(pt.x - 10);
            double n = this._mapPanel.scale().y2n(pt.y + 10);
            reg.pts.addElement(new WorldPt(e, n));
            e = this._mapPanel.scale().x2e(pt.x + 10);
            n = this._mapPanel.scale().y2n(pt.y + 10);
            reg.pts.addElement(new WorldPt(e, n));
            e = this._mapPanel.scale().x2e(pt.x + 10);
            n = this._mapPanel.scale().y2n(pt.y - 10);
            reg.pts.addElement(new WorldPt(e, n));
            e = this._mapPanel.scale().x2e(pt.x - 10);
            n = this._mapPanel.scale().y2n(pt.y - 10);
            reg.pts.addElement(new WorldPt(e, n));
        } else {
            for (int i = 0; i < ptVec.size(); ++i) {
                pt = (LocalPt)ptVec.elementAt(i);
                if (pt == null) continue;
                if (i == 0) {
                    begPt = (LocalPt)ptVec.elementAt(0);
                }
                double e = this._mapPanel.scale().x2e(pt.x);
                double n = this._mapPanel.scale().y2n(pt.y);
                reg.pts.addElement(new WorldPt(e, n));
            }
        }
        StoragePool pool = this._study.addStoragePool(reg, info[0], info[1]);
        if (begPt == null) {
            return;
        }
        if (pool != null) {
            this._mapPanel.paintMap();
        }
    }

    @Override
    public ChannelMod createChannelMod(String streamName, int streamStartIndex, int streamEndIndex, double start, double end) {
        if (this._channelModList == null) {
            return null;
        }
        String[] info = this.getNewProjectName("Name New Channel Modification", ChannelMod.class.getName());
        if (info == null) {
            this._mapPanel.paintMap();
            return null;
        }
        ChannelMod cm = this._study.addChannelMod(streamName, streamStartIndex, streamEndIndex, start, end, info[0], info[1]);
        if (cm == null) {
            return null;
        }
        this._mapPanel.paintMap();
        return cm;
    }

    public void drawChannelMod(Graphics g, MapScale scl, ChannelMod cm) {
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        if (alignglyph == null || cm == null) {
            return;
        }
        double c0 = 0.0;
        double c1 = 0.0;
        double s0 = 0.0;
        double s1 = 0.0;
        StreamPolyLine line = null;
        StreamElement stream = null;
        if (alignglyph != null) {
            stream = alignglyph.findReach(cm.getStartStreamElementIndex());
        }
        if (stream != null) {
            s0 = cm.getStartStation();
            s1 = cm.getEndStation();
            c0 = stream.getCoordByStation(s0);
            c1 = stream.getCoordByStation(s1);
            line = stream.getLineSegment(c1, c0);
        }
        if (line == null) {
            return;
        }
        int sizeNeeded = Math.min(line.pts.size() * 2, MapGlyph.maxPtArraySz);
        int[] locxarray = new int[sizeNeeded + 1];
        int[] locyarray = new int[sizeNeeded + 1];
        int i = line.getLocalRegionArrays(scl, locxarray, locyarray);
        double halfwidth = (double)this._channelModDpData.channelModWidth / 2.0;
        i = line.getLocalRegionArrays(scl, locxarray, locyarray, halfwidth);
        Color channelModColor = this._channelModDpData.fillColor;
        int ID = (int)cm.getId();
        if (i > 0) {
            g.setPaintMode();
            g.setColor(channelModColor);
            g.fillPolygon(locxarray, locyarray, i);
            g.setColor(channelModColor);
            g.drawPolygon(locxarray, locyarray, i);
        }
        if (this._channelModDpData.drawName && stream != null && this._studyDas.isAttributeShown("Names")) {
            double coord = (c0 + c1) / 2.0;
            this.drawConformingString(g, scl, stream.getLine(), cm.getName(), coord, (int)halfwidth, this._channelModDpData.nameFont, Color.blue, 1, (float)this._glyphLevel + 0.4f);
        }
    }

    @Override
    public void drawSelectedChannelMod(Graphics g, MapScale scl, ChannelMod cm, boolean isXOR, boolean editing) {
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        double c0 = 0.0;
        double c1 = 0.0;
        double s0 = 0.0;
        double s1 = 0.0;
        StreamPolyLine line = null;
        StreamElement stream = null;
        if (alignglyph != null) {
            stream = alignglyph.findReach(cm.getStartStreamElementIndex());
        }
        if (stream != null) {
            s0 = cm.getStartStation();
            s1 = cm.getEndStation();
            c0 = stream.getCoordByStation(s0);
            c1 = stream.getCoordByStation(s1);
            line = stream.getLineSegment(c1, c0);
        }
        int sizeNeeded = Math.min(line.pts.size() * 2, MapGlyph.maxPtArraySz);
        int[] locxarray = new int[sizeNeeded + 1];
        int[] locyarray = new int[sizeNeeded + 1];
        int icnt = line.getLocalRegionArrays(scl, locxarray, locyarray);
        g.setColor(Color.red);
        g.fillPolygon(locxarray, locyarray, icnt);
        g.setColor(Color.yellow);
        g.drawPolygon(locxarray, locyarray, icnt);
        if (editing) {
            WorldPt pt = line.getFirstPt();
            LocalPt lpt = this._mapPanel.scale().wp2lp(pt);
            g.fillOval(lpt.x - 4, lpt.y - 4, 8, 8);
            pt = line.getLastPt();
            lpt = this._mapPanel.scale().wp2lp(pt);
            g.fillOval(lpt.x - 4, lpt.y - 4, 8, 8);
        }
    }

    @Override
    public ChannelMod selectChannelMod(LocalPt pt, boolean add, boolean editing) {
        double tol = this._mapPanel.scale().x2e(pt.x + 5) - this._mapPanel.scale().x2e(pt.x);
        if (!add) {
            this._selectionVector.clear();
        }
        if (this._channelModList == null || pt == null) {
            return null;
        }
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        return this.selectChannelMod(this.findChannelMod(wpt, tol), add, editing);
    }

    @Override
    public ChannelMod selectChannelMod(ChannelMod cm, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        this.addSelection(cm, add, editing);
        return cm;
    }

    @Override
    public Reservoir findReservoir(LocalPt pt) {
        this._mapPanel.scale().lp2wp(pt, this.tmpWpt);
        return this.findReservoir(this.tmpWpt);
    }

    @Override
    public Reservoir findReservoir(WorldPt wpt) {
        double coord;
        LocalPt pt;
        StreamElement rch;
        StreamAlignmentGlyph alignglyph;
        Condition c = this._watershedMode.getSelectedCondition();
        if (c == null) {
            return null;
        }
        Reservoir res = this._study.findReservoir(wpt);
        if (res == null && (alignglyph = this.getStreamAlignmentGlyph()) != null && (rch = alignglyph.findReach(pt = this._mapPanel.scale().wp2lp(wpt), null)) != null && (coord = rch.getLine().getCoordAtLocation(wpt)) != Double.NEGATIVE_INFINITY) {
            res = this._study.findReservoir(rch.getIndex(), coord);
        }
        if (c.hasProject(res)) {
            return res;
        }
        return null;
    }

    @Override
    public Diversion findDiversion(WorldPt wpt, double tol) {
        if (this._study == null || wpt == null) {
            return null;
        }
        Diversion div = this._study.findDiversion(wpt, tol);
        Condition c = this._watershedMode.getSelectedCondition();
        if (c == null) {
            return null;
        }
        if (c.hasProject(div)) {
            return div;
        }
        return null;
    }

    @Override
    public Condition getSelectedCondition() {
        Condition c = this._watershedMode.getSelectedCondition();
        return c;
    }

    public Levee findLevee(WorldPt wpt, double tol) {
        DataObject[] elemList = this._leveeList.getObjects();
        Condition c = this._watershedMode.getSelectedCondition();
        if (c == null) {
            return null;
        }
        for (int i = 0; i < elemList.length; ++i) {
            DataObject elem = elemList[i];
            if (elem == null || !(elem instanceof Levee)) continue;
            Levee levee = (Levee)elem;
            WorldLine line = levee.getLine();
            if (line == null) {
                line = this.getLeveeLine(null, null, levee);
            }
            if (line == null) {
                return null;
            }
            if (!line.nearPt(wpt, tol) || !c.hasProject(levee)) continue;
            return levee;
        }
        return null;
    }

    @Override
    public ChannelMod findChannelMod(WorldPt wpt, double tol) {
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        if (alignglyph == null) {
            return null;
        }
        DataObject[] elemList = this._channelModList.getObjects();
        Condition c = this._watershedMode.getSelectedCondition();
        if (c == null) {
            return null;
        }
        for (int i = 0; i < elemList.length; ++i) {
            DataObject elem = elemList[i];
            if (elem == null || !(elem instanceof ChannelMod)) continue;
            ChannelMod cm = (ChannelMod)elem;
            StreamElement stream = alignglyph.findReach(cm.getStartStreamElementIndex());
            if (stream == null) {
                return null;
            }
            double s0 = cm.getStartStation();
            double s1 = cm.getEndStation();
            double c0 = stream.getCoordByStation(s0);
            double c1 = stream.getCoordByStation(s1);
            StreamPolyLine line = stream.getLineSegment(c1, c0);
            if (!line.nearPt(wpt, tol) || !c.hasProject(cm)) continue;
            return cm;
        }
        return null;
    }

    public void drawTSNode(Graphics g, MapScale scl, WorldPt pt, String name, int labelPosition) {
        int x = scl.e2x(pt.e);
        int y = scl.n2y(pt.n);
        int offset = 11;
        if (_tsImage != null) {
            g.drawImage(_tsImage, x - 10, y - 10, (ImageObserver)this._mapPanel);
        } else {
            g.setColor(Color.red);
            g.fillOval(x - 4, y - 4, 8, 8);
            g.setColor(Color.blue);
            g.drawOval(x - 4, y - 4, 8, 8);
            offset = 5;
        }
        if (name != null && this._studyDas.isAttributeShown("Names")) {
            float priority = (float)this._glyphLevel + 0.3f;
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(name, x, y, labelPosition, offset, priority, g.getFont(), Color.blue, null, false, g));
        }
    }

    public void drawRegion(Graphics g, MapScale scl, StudyRegion region, Color fill, Color outLine) {
        int i;
        WorldPt pt;
        if (region == null) {
            return;
        }
        WorldRegion reg = region.getRegion();
        if (region instanceof ImpactArea) {
            StreamElement elem;
            pt = ((ImpactArea)region).getLabelPositionPoint();
            if (this._alignment != null && (elem = this._alignment.findReach(((ImpactArea)region).getStreamId())) != null) {
                WorldPt pt2 = elem.getLocationByStation(((ImpactArea)region).getIndexStation());
                LocalPt lpt = scl.wp2lp(pt);
                LocalPt lpt2 = scl.wp2lp(pt2);
                g.setColor(outLine);
                g.drawLine(lpt.x, lpt.y, lpt2.x, lpt2.y);
            }
        }
        int size = reg.pts.size();
        int[] locxarray = new int[size + 1];
        int[] locyarray = new int[size + 1];
        for (i = 0; i < size && (pt = (WorldPt)reg.pts.elementAt(i)) != null; ++i) {
            locxarray[i] = scl.e2x(pt.e);
            locyarray[i] = scl.n2y(pt.n);
        }
        Graphics2D g2 = null;
        Composite oldac = null;
        AlphaComposite ac = null;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
            oldac = g2.getComposite();
            ac = AlphaComposite.getInstance(3, 0.6f);
        }
        if (i > 0) {
            g.setColor(fill);
            if (g2 != null) {
                g2.setComposite(ac);
                g2.fillPolygon(locxarray, locyarray, i);
                if (oldac != null) {
                    g2.setComposite(oldac);
                }
            } else {
                g.setXORMode(XOR_COLOR);
                g.fillPolygon(locxarray, locyarray, i);
                g.setPaintMode();
            }
            g.setColor(outLine);
            g.drawPolygon(locxarray, locyarray, i);
        }
        pt = region.getReferencePt();
        int x = scl.e2x(pt.e);
        int y = scl.n2y(pt.n);
        int offset = 9;
        g.setColor(outLine);
        if (region instanceof StoragePool) {
            this.drawTSNode(g, scl, region.getReferencePt(), region.getName(), region.getLabelPosition());
        } else if (region instanceof ImpactArea) {
            if (this._impactAreaData.drawName && this._studyDas.isAttributeShown("Names")) {
                pt = ((ImpactArea)region).getLabelPositionPoint();
                int x1 = scl.e2x(pt.e);
                int y1 = scl.n2y(pt.n);
                ImpactArea iarea = (ImpactArea)region;
                float priority = -1.0f;
                this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(iarea.getName(), x1, y1, iarea.getLabelPosition(), offset, priority, this._impactAreaData.nameFont, Color.black, null, false, g));
            }
        } else {
            this.drawString(g, region.getName(), x + 10, y + 4, this._glyphLevel);
        }
    }

    @Override
    public void drawSelectedDiversion(Graphics g, MapScale scl, Diversion diversion, boolean isXOR, boolean editing) {
        if (diversion == null) {
            return;
        }
        WorldLine line = null;
        line = diversion.getLine();
        ComputationPoint cp0 = diversion.getComputationPoint(true);
        ComputationPoint cp1 = diversion.getComputationPoint(false);
        Node n0 = diversion.getUpstreamNode();
        Node n1 = diversion.getDownstreamNode();
        if (diversion.getReservoirId() > -1L) {
            StreamSegment ss;
            DataList dl = ClientApp.Workspace().getDataListContainer().getDataList("hec.watershed.model.Reservoir");
            Reservoir res = (Reservoir)dl.getObject(diversion.getReservoirId());
            if (res != null && (ss = res.getStreamSegment(n0.getStreamIndex())) != null) {
                double offset = diversion.getReservoirOffset();
                double upCoord = ss.upstreamCoord;
                double downCoord = ss.downstreamCoord;
                double divCoord = (upCoord - downCoord) * offset;
                StreamElement elem = this._alignment.findReach(n0.getStreamIndex());
                if (elem != null) {
                    line.getFirstPt().init(elem.getLocationByCoord(divCoord));
                }
            }
        } else {
            this.setPointByComptPt(line.getFirstPt(), cp0, n0.getLocation());
        }
        if (n1 != null) {
            this.setPointByComptPt(line.getLastPt(), cp1, n1.getLocation());
        }
        if (n0 == null) {
            return;
        }
        if (line != null) {
            int sizeNeeded = Math.min(line.pts.size() * 2, MapGlyph.maxPtArraySz);
            int[] locxarray = new int[sizeNeeded + 1];
            int[] locyarray = new int[sizeNeeded + 1];
            double halfwidth = (double)this._diversionData.diversionWidth / 1.5;
            int li = line.getLocalRegionArrays(scl, locxarray, locyarray, halfwidth);
            if (isXOR) {
                g.setXORMode(XOR_COLOR);
            } else {
                g.setColor(this._diversionData.fillColor);
            }
            if (li > 0) {
                g.setColor(Color.yellow);
                g.fillPolygon(locxarray, locyarray, li);
                g.setColor(Color.yellow);
                g.drawPolygon(locxarray, locyarray, li);
            }
            int[] xpt = new int[4];
            int[] ypt = new int[4];
            if (editing) {
                g.setColor(Color.black);
                int ptSize = this._diversionData.diversionWidth / 2;
                for (int i = 0; i < line.pts.size(); ++i) {
                    WorldPt wpt = (WorldPt)line.pts.elementAt(i);
                    LocalPt lpt = this._mapPanel.scale().wp2lp(wpt);
                    xpt[0] = lpt.x - ptSize;
                    ypt[0] = lpt.y;
                    xpt[1] = lpt.x;
                    ypt[1] = lpt.y + ptSize;
                    xpt[2] = lpt.x + ptSize;
                    ypt[2] = lpt.y;
                    xpt[3] = lpt.x;
                    ypt[3] = lpt.y - ptSize;
                    g.fillPolygon(xpt, ypt, 4);
                }
            }
        }
        WorldPt midpt = new WorldPt();
        WorldPt slope = new WorldPt();
        line.getSlopeAtCoord(1.0, midpt, slope);
        this.drawEndArrow(g, scl, line.getLastPt(), slope, true, n1 != null);
        if (isXOR) {
            g.setPaintMode();
        }
    }

    public void drawStoragePool(Graphics g, MapScale scl, StoragePool pool) {
        this.drawRegion(g, scl, pool, Color.blue, Color.black);
    }

    public void drawCompPt(Graphics g, MapScale scl, ComputationPoint cpt) {
        if (cpt == null) {
            return;
        }
        this.drawCompPt(g, scl, cpt, 9, Color.black, Color.black, 1);
    }

    public void drawCompPt(Graphics g, MapScale scl, ComputationPoint cpt, int size, Color bgcolor, Color fgcolor, int symbolNum) {
        int width = size;
        int halfwidth = (int)((double)width / 2.0);
        Vector projects = cpt.getProjects();
        Condition c = this._watershedMode.getSelectedCondition();
        WorldPt pt = cpt.getReferencePt();
        if (pt == null || !pt.isValid() && !cpt.getSnapToStream()) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("drawCompPt: null or invalid location for " + cpt.getName());
            return;
        }
        this.getCompPtXY(cpt, this.xy, scl);
        if (cpt.getSnapToStream()) {
            Symbol.draw((Graphics)g, (int)this.xy[0], (int)this.xy[1], (int)symbolNum, (Color)fgcolor, (Color)bgcolor, (float)width);
        } else {
            g.setColor(Color.lightGray);
            Symbol.draw((Graphics)g, (int)this.xy[0], (int)this.xy[1], (int)symbolNum, (Color)fgcolor, (Color)bgcolor, (float)width);
        }
        if (this._compPtData.drawName && this._studyDas.isAttributeShown("Names")) {
            float priority = (float)this._glyphLevel + 0.5f;
            int offset = halfwidth;
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(cpt.getName(), this.xy[0], this.xy[1], cpt.getLabelPosition(), offset, priority, this._compPtData.nameFont, Color.black, null, false, g));
        }
    }

    private void getCompPtXY(ComputationPoint cpt, int[] xy, MapScale scl) {
        WorldPt pt = cpt.getReferencePt();
        xy[0] = scl.e2x(pt.e);
        xy[1] = scl.n2y(pt.n);
        if (cpt.getSnapToStream()) {
            int streamId = cpt.getStreamId();
            StreamElement elem = this._alignment.findReach(streamId);
            if (elem != null) {
                WorldPt wpt = elem.getLocationByStation(cpt.getStreamStation());
                xy[0] = scl.e2x(wpt.e);
                xy[1] = scl.n2y(wpt.n);
            } else {
                ((FluentLogger.Api)LOGGER.atInfo()).log("getCompPtXY: no stream elem for id " + streamId);
            }
        }
    }

    public void drawArea(Graphics g, MapScale scl, ImpactArea iarea) {
        if (iarea == null) {
            return;
        }
        this.drawRegion(g, scl, iarea, iarea.getColor(), Color.red);
    }

    public void drawSelectedTSNode(Graphics g, MapScale scl, WorldPt pt, String name, boolean isXOR, boolean editing, int labelPosition) {
        if (pt == null || !pt.isValid()) {
            return;
        }
        if (isXOR) {
            g.setXORMode(XOR_COLOR);
        }
        int x = scl.e2x(pt.e);
        int y = scl.n2y(pt.n);
        int offset = 11;
        if (_selTsImage != null) {
            g.drawImage(_selTsImage, x - 10, y - 10, (ImageObserver)this._mapPanel);
        } else {
            g.setColor(Color.red);
            g.fillOval(x - 4, y - 4, 8, 8);
            g.setColor(Color.blue);
            g.drawOval(x - 4, y - 4, 8, 8);
            offset = 5;
        }
        if (editing) {
            g.setColor(Color.black);
            g.fillRect(x - 14, y - 14, 4, 4);
            g.fillRect(x - 14, y + 12, 4, 4);
            g.fillRect(x + 12, y - 14, 4, 4);
            g.fillRect(x + 12, y + 12, 4, 4);
        }
        g.setColor(Color.blue);
        if (name != null && this._studyDas.isAttributeShown("Names")) {
            float priority = -1.0f;
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(name, x, y, labelPosition, offset, priority, g.getFont(), Color.blue, null, false, g));
        }
        if (isXOR) {
            g.setPaintMode();
        }
    }

    public void drawOtherProject(Graphics g, MapScale scl, OtherProject proj) {
        if (proj == null) {
            return;
        }
        WorldPt pt = proj.getReferencePt();
        this.xy[0] = scl.e2x(pt.e);
        this.xy[1] = scl.n2y(pt.n);
        int offset = 11;
        int position = proj.getIconPosition();
        StudySystemGlyph.getOtherProjectIconPosition(position, this.xy);
        int x = this.xy[0];
        int y = this.xy[1];
        ComputationPoint cpt = proj.getComputationPoint();
        if (cpt != null) {
            pt = cpt.getReferencePt();
            if (pt == null || !pt.isValid()) {
                return;
            }
            this.getCompPtXY(cpt, this.xy, scl);
            g.drawLine(x + 10, y + 10, this.xy[0], this.xy[1]);
        }
        if (_otherProjImage != null) {
            g.drawImage(_otherProjImage, x, y, (ImageObserver)this._mapPanel);
        } else {
            g.setColor(Color.red);
            g.fillOval(x - 4, y - 4, 8, 8);
            g.setColor(Color.blue);
            g.drawOval(x - 4, y - 4, 8, 8);
            offset = 5;
        }
        float priority = (float)this._glyphLevel + 0.3f;
        if (proj.getName() != null && this._studyDas.isAttributeShown("Names")) {
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(proj.getName(), x, y, proj.getLabelPosition(), offset, priority, g.getFont(), Color.blue, null, false, g));
        }
    }

    @Override
    public void drawSelectedOtherProject(Graphics g, MapScale scl, OtherProject proj, boolean isXOR, boolean editing) {
        if (proj == null) {
            return;
        }
        WorldPt pt = proj.getReferencePt();
        if (pt == null || !pt.isValid()) {
            return;
        }
        if (isXOR) {
            g.setXORMode(XOR_COLOR);
        }
        this.xy[0] = scl.e2x(pt.e);
        this.xy[1] = scl.n2y(pt.n);
        int position = proj.getIconPosition();
        StudySystemGlyph.getOtherProjectIconPosition(position, this.xy);
        int offset = 11;
        if (_selOtherProjImage != null) {
            g.drawImage(_selOtherProjImage, this.xy[0], this.xy[1], (ImageObserver)this._mapPanel);
        } else {
            g.setColor(Color.red);
            g.fillOval(this.xy[0] - 4, this.xy[1] - 4, 8, 8);
            g.setColor(Color.blue);
            g.drawOval(this.xy[0] - 4, this.xy[1] - 4, 8, 8);
            offset = 5;
        }
        if (editing) {
            g.setColor(Color.black);
            g.fillRect(this.xy[0] - 4, this.xy[1] - 4, 4, 4);
            g.fillRect(this.xy[0] - 4, this.xy[1] + 20, 4, 4);
            g.fillRect(this.xy[0] + 20, this.xy[1] - 4, 4, 4);
            g.fillRect(this.xy[0] + 20, this.xy[1] + 20, 4, 4);
        }
        if (proj.getName() != null && this._studyDas.isAttributeShown("Names")) {
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(proj.getName(), this.xy[0], this.xy[1], proj.getLabelPosition(), offset, -1.0f, g.getFont(), Color.blue, null, false, g));
        }
        if (isXOR) {
            g.setPaintMode();
        }
    }

    public static void getOtherProjectIconPosition(int position, int[] xy) {
        int xoff;
        int yoff;
        double ca = Math.cos(_angle[position]);
        double sa = Math.sin(_angle[position]);
        int offset = 15;
        switch (position) {
            case 0: 
            case 4: {
                yoff = (int)((double)(-offset) / 1.4);
                break;
            }
            case 1: 
            case 3: {
                yoff = -offset;
                break;
            }
            case 2: {
                yoff = (int)((double)(-offset) * 1.5);
                break;
            }
            case 5: 
            case 7: {
                yoff = (int)((double)offset / 2.5);
                break;
            }
            default: {
                yoff = 0;
            }
        }
        switch (position) {
            case 0: 
            case 1: 
            case 7: {
                xoff = offset / 2;
                break;
            }
            case 2: 
            case 6: {
                xoff = (int)((double)(-offset) / 1.4);
                break;
            }
            default: {
                xoff = -offset * 2;
            }
        }
        xy[0] = (int)((double)xy[0] + (double)offset * ca + (double)xoff + 0.5);
        xy[1] = (int)((double)xy[1] - (double)offset * sa + (double)yoff + 0.5);
    }

    public void drawSelectedStation(Graphics g, MapScale scl, Station station, boolean isXOR, boolean editing) {
        if (station == null) {
            return;
        }
        int halfWidth = (int)Math.floor((double)stationIconWidth / 2.0);
        try {
            WorldPt wp = new WorldPt();
            Geometry geometry = station.getGeometry();
            Point centroid = geometry.getCentroid();
            wp.e = centroid.getX();
            wp.n = centroid.getY();
            LocalPt localPt = this.transformPointToLocal(wp);
            if (station.getStationIconLocation() != null) {
                localPt = this.transformPointToLocal(station.getStationIconLocation());
            }
            this.xy[0] = localPt.x;
            this.xy[1] = localPt.y;
            AffineTransform at = AffineTransform.getTranslateInstance(this.xy[0] - halfWidth, this.xy[1] - halfWidth);
            Shape s = at.createTransformedShape(new Diamond(stationIconWidth, stationIconWidth));
            g.setColor(Color.yellow);
            ((Graphics2D)g).fill(s);
            g.setColor(Color.black);
            ((Graphics2D)g).draw(s);
            if (editing) {
                g.setColor(Color.black);
                g.fillRect(this.xy[0] - halfWidth - 5, this.xy[1] - halfWidth - 5, 5, 5);
                g.fillRect(this.xy[0] - halfWidth - 5, this.xy[1] + halfWidth, 5, 5);
                g.fillRect(this.xy[0] + halfWidth, this.xy[1] - halfWidth - 5, 5, 5);
                g.fillRect(this.xy[0] + halfWidth, this.xy[1] + halfWidth, 5, 5);
            }
        }
        catch (CRSException e) {
            Logger.getLogger(StudySystemGlyph.class.getName()).log(Level.INFO, "Error transforming station coordinate", e);
        }
    }

    @Override
    public void drawSelectedCompPt(Graphics g, MapScale scl, ComputationPoint compPt, boolean isXOR, boolean editing) {
        if (compPt == null) {
            return;
        }
        int width = this._compPtData.compPtWidth + 2;
        int halfwidth = (int)((double)width / 2.0);
        WorldPt pt = compPt.getReferencePt();
        if (pt == null || !pt.isValid()) {
            return;
        }
        int x = scl.e2x(pt.e);
        int y = scl.n2y(pt.n);
        if (compPt.getSnapToStream()) {
            int streamId = compPt.getStreamId();
            StreamElement elem = this._alignment.findReach(streamId);
            if (elem != null) {
                WorldPt wpt = elem.getLocationByStation(compPt.getStreamStation());
                x = scl.e2x(wpt.e);
                y = scl.n2y(wpt.n);
            } else {
                ((FluentLogger.Api)LOGGER.atInfo()).log("drawSelectedCompPt: no stream elem for id " + streamId);
            }
            g.setColor(this._compPtData.fillColor);
            g.fillOval(x - halfwidth, y - halfwidth, width, width);
        } else {
            g.setColor(Color.yellow);
            g.fillOval(x - halfwidth, y - halfwidth, width, width);
            g.setColor(this._compPtData.outlineColor);
            g.drawOval(x - halfwidth, y - halfwidth, width, width);
        }
        if (this._compPtData.drawName && this._studyDas.isAttributeShown("Names")) {
            int offset = halfwidth;
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(compPt.getName(), x, y, compPt.getLabelPosition(), offset, -1.0f, this._compPtData.nameFont, Color.black, null, false, g));
        }
        if (isXOR) {
            g.setXORMode(XOR_COLOR);
        }
        if (editing) {
            g.setColor(Color.black);
            g.fillRect(x - halfwidth - 5, y - halfwidth - 5, 5, 5);
            g.fillRect(x - halfwidth - 5, y + halfwidth, 5, 5);
            g.fillRect(x + halfwidth, y - halfwidth - 5, 5, 5);
            g.fillRect(x + halfwidth, y + halfwidth, 5, 5);
        }
        if (isXOR) {
            g.setPaintMode();
        }
    }

    @Override
    public void drawSelectedStoragePool(Graphics g, MapScale scl, StoragePool pool, boolean isXOR, boolean editing) {
        this.drawSelectedRegion(g, scl, pool, isXOR, editing, Color.blue);
    }

    @Override
    public void drawSelectedArea(Graphics g, MapScale scl, ImpactArea iarea, boolean isXOR, boolean editing) {
        StreamElement elem;
        WorldPt wpt;
        int icnt = 0;
        LocalPt pt = new LocalPt();
        int size = iarea.getRegion().pts.size();
        int[] locxarray = new int[size + 1];
        int[] locyarray = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            wpt = (WorldPt)iarea.getRegion().pts.elementAt(i);
            if (wpt == null) continue;
            scl.wp2lp(wpt, pt);
            locxarray[icnt] = pt.x;
            locyarray[icnt] = pt.y;
            ++icnt;
        }
        if (isXOR) {
            g.setXORMode(XOR_COLOR);
        }
        g.setColor(Color.yellow);
        g.fillPolygon(locxarray, locyarray, icnt);
        g.setPaintMode();
        if (isXOR) {
            g.setXORMode(XOR_COLOR);
        }
        g.setColor(Color.red);
        g.drawPolygon(locxarray, locyarray, icnt);
        if (editing) {
            int[] xpt = new int[4];
            int[] ypt = new int[4];
            for (int i = 0; i < icnt; ++i) {
                xpt[0] = locxarray[i] - 3;
                ypt[0] = locyarray[i];
                xpt[1] = locxarray[i];
                ypt[1] = locyarray[i] + 3;
                xpt[2] = locxarray[i] + 3;
                ypt[2] = locyarray[i];
                xpt[3] = locxarray[i];
                ypt[3] = locyarray[i] - 3;
                g.fillPolygon(xpt, ypt, 4);
            }
        }
        wpt = iarea.getLabelPositionPoint();
        int x = scl.e2x(wpt.e);
        int y = scl.n2y(wpt.n);
        int offset = 9;
        if (this._alignment != null && (elem = this._alignment.findReach(iarea.getStreamId())) != null) {
            Graphics2D g2d;
            WorldPt pt2 = elem.getLocationByStation(iarea.getIndexStation());
            LocalPt lpt = scl.wp2lp(wpt);
            LocalPt lpt2 = scl.wp2lp(pt2);
            g.setColor(Color.red.brighter());
            Stroke oldStroke = null;
            if (g instanceof Graphics2D) {
                g2d = (Graphics2D)g;
                oldStroke = g2d.getStroke();
                if (oldStroke instanceof BasicStroke) {
                    g2d.setStroke(new BasicStroke(((BasicStroke)oldStroke).getLineWidth() + 1.0f));
                } else {
                    g2d.setStroke(new BasicStroke(2.0f));
                }
            }
            g.drawLine(lpt.x, lpt.y, lpt2.x, lpt2.y);
            if (g instanceof Graphics2D) {
                g2d = (Graphics2D)g;
                g2d.setStroke(oldStroke);
            }
        }
        float priority = (float)this._glyphLevel + 0.3f;
        if (this._studyDas.isAttributeShown("Names")) {
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(iarea.getName(), x, y, iarea.getLabelPosition(), offset, priority, g.getFont(), Color.black, null, false, g));
        }
        if (isXOR) {
            g.setPaintMode();
        }
    }

    public void drawSelectedRegion(Graphics g, MapScale scl, StudyRegion sr, boolean isXOR, boolean editing, Color outLine) {
        LocalPt pt = new LocalPt();
        if (sr instanceof ImpactArea) {
            StreamElement elem;
            WorldPt wpt = sr.getReferencePt();
            if (this._alignment != null && (elem = this._alignment.findReach(((ImpactArea)sr).getStreamId())) != null) {
                WorldPt pt2 = elem.getLocationByStation(((ImpactArea)sr).getIndexStation());
                pt = scl.wp2lp(wpt);
                LocalPt lpt2 = scl.wp2lp(pt2);
                g.setColor(outLine);
                g.drawLine(pt.x, pt.y, lpt2.x, lpt2.y);
            }
        }
        int MAX = 4000;
        int loopBound = Math.min(sr.getRegion().pts.size(), 4000);
        int[] locxarray = new int[loopBound];
        int[] locyarray = new int[loopBound];
        int icnt = 0;
        for (int i = 0; i < loopBound; ++i) {
            WorldPt wpt = (WorldPt)sr.getRegion().pts.elementAt(i);
            if (wpt == null) continue;
            scl.wp2lp(wpt, pt);
            locxarray[icnt] = pt.x;
            locyarray[icnt] = pt.y;
            ++icnt;
        }
        if (isXOR) {
            g.setXORMode(XOR_COLOR);
        }
        g.setColor(Color.yellow);
        g.fillPolygon(locxarray, locyarray, icnt);
        g.setPaintMode();
        if (isXOR) {
            g.setXORMode(XOR_COLOR);
        }
        g.setColor(outLine);
        g.drawPolygon(locxarray, locyarray, icnt);
        if (editing) {
            int[] xpt = new int[4];
            int[] ypt = new int[4];
            for (int i = 0; i < icnt; ++i) {
                xpt[0] = locxarray[i] - 3;
                ypt[0] = locyarray[i];
                xpt[1] = locxarray[i];
                ypt[1] = locyarray[i] + 3;
                xpt[2] = locxarray[i] + 3;
                ypt[2] = locyarray[i];
                xpt[3] = locxarray[i];
                ypt[3] = locyarray[i] - 3;
                g.fillPolygon(xpt, ypt, 4);
            }
        }
        WorldPt wpt = sr.getReferencePt();
        int x = scl.e2x(wpt.e);
        int y = scl.n2y(wpt.n);
        if (_impactImage != null) {
            g.drawImage(_impactImage, x - 8, y - 8, 16, 16, (ImageObserver)this._mapPanel);
        } else {
            g.setColor(outLine);
            g.fillOval(x - 2, y - 2, 4, 4);
            g.setColor(Color.blue);
            g.drawOval(x - 2, y - 2, 4, 4);
        }
        g.setColor(outLine);
        if (isXOR) {
            g.setPaintMode();
        }
        this.drawSelectedTSNode(g, scl, sr.getReferencePt(), sr.getName(), isXOR, editing, sr.getLabelPosition());
    }

    private GeneralPath drawDiamond(int x1, int y1, int x2, int y2) {
        int width = Math.abs(x1 - x2);
        int height = Math.abs(y1 - y2);
        Rectangle2D.Double diamond = new Rectangle2D.Double(x1, y1, width, height);
        GeneralPath connectedDiamond = new GeneralPath(0);
        connectedDiamond.append(diamond, true);
        AffineTransform at = new AffineTransform();
        at.rotate(Math.toRadians(45.0));
        connectedDiamond.transform(at);
        return connectedDiamond;
    }

    public void drawStations(Graphics g2d, MapScale scl) {
        if (this._stationSetDataList == null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("drawStations:no StationSetDataList, so no Stations drawn");
            return;
        }
        DataStruct[] objectArray = this._stationSetDataList.getObjectArray();
        StationSet stationSet = null;
        if (objectArray != null && objectArray.length > 0) {
            StationSetDataObject stationSetDataObject = (StationSetDataObject)objectArray[0];
            stationSet = stationSetDataObject.getStationSet();
        }
        if (stationSet == null) {
            return;
        }
        List features = stationSet.getFeatures();
        WorldPt wp = new WorldPt();
        HalfDiamondLeft hdl = new HalfDiamondLeft(stationIconWidth, stationIconWidth);
        HalfDiamondRight hdr = new HalfDiamondRight(stationIconWidth, stationIconWidth);
        Diamond r = new Diamond(stationIconWidth, stationIconWidth);
        Circle c = new Circle((double)(stationIconWidth / 2));
        ArrayList<Path2D.Double> iconShapes = new ArrayList<Path2D.Double>();
        ArrayList<Color> shapeColor = new ArrayList<Color>();
        WorldPt snapWp = null;
        for (Station station : features) {
            iconShapes.clear();
            shapeColor.clear();
            Geometry geometry = station.getGeometry();
            if (!station.isMetStation() && !station.isObservedStation()) {
                iconShapes.add(r);
                shapeColor.add(this._stationSetData.getMetStationColor());
            } else if (station.isMetStation() && !station.isObservedStation()) {
                iconShapes.add(r);
                shapeColor.add(this._stationSetData.getMetStationColor());
            } else if (!station.isMetStation() && station.isObservedStation()) {
                iconShapes.add(r);
                shapeColor.add(this._stationSetData.getObservedStationColor());
            } else if (station.isMetStation() && station.isObservedStation()) {
                iconShapes.add(hdl);
                shapeColor.add(this._stationSetData.getObservedStationColor());
                iconShapes.add(hdr);
                shapeColor.add(this._stationSetData.getMetStationColor());
            }
            try {
                Point centroid = geometry.getCentroid();
                wp.e = centroid.getX();
                wp.n = centroid.getY();
                LocalPt localPt = this.transformPointToLocal(wp);
                if (station.getStationIconLocation() != null) {
                    localPt = this.transformPointToLocal(station.getStationIconLocation());
                }
                this.xy[0] = localPt.x;
                this.xy[1] = localPt.y;
            }
            catch (CRSException e) {
                e.printStackTrace();
                break;
            }
            AffineTransform at = AffineTransform.getTranslateInstance(this.xy[0] - stationIconWidth / 2, this.xy[1] - stationIconWidth / 2);
            for (int i = 0; i < iconShapes.size(); ++i) {
                StreamElement elem;
                Shape shape = at.createTransformedShape((Shape)iconShapes.get(i));
                ((Graphics2D)g2d).setColor((Color)shapeColor.get(i));
                ((Graphics2D)g2d).fill(shape);
                if (!station.isObservedStation()) continue;
                ((Graphics2D)g2d).setColor(this._stationSetData.getObservedStationColor());
                ((Graphics2D)g2d).draw(shape);
                if (station.getGeometry() != null) {
                    Point geoPoint = station.getGeometry().getCentroid();
                    snapWp = new WorldPt(geoPoint.getX(), geoPoint.getY());
                }
                if (snapWp == null || (elem = this._alignment.findNearestReach(snapWp, new WorldPt())) == null) continue;
                WorldPt snapWpByStation = elem.getLocationByStation(station.getStreamStation());
                LocalPt snapToStreamPoint = scl.wp2lp(snapWpByStation);
                if (station.isObservedStation() && this._isObsStationMap.get((Object)station) != null && !this._isObsStationMap.get((Object)station).booleanValue()) {
                    this.xy[0] = snapToStreamPoint.x;
                    this.xy[1] = snapToStreamPoint.y;
                    station.setStationIconLocation(snapWpByStation);
                    SwingUtilities.invokeLater(() -> this.getMapPanel().paintMap());
                }
                g2d.drawLine(this.xy[0], this.xy[1], snapToStreamPoint.x, snapToStreamPoint.y);
                station.setGeometry((Geometry)new GeometryFactory().createPoint(new Coordinate(snapWpByStation.e, snapWpByStation.n)));
                if (!this._selectionVector.stream().anyMatch(s -> s instanceof MapGlyph.Selection && s.object == station && s.editing)) continue;
                g2d.setColor(Color.BLACK);
                ObsStationSnapPoint snapDrawPoint = new ObsStationSnapPoint(5);
                snapDrawPoint.draw(g2d, snapToStreamPoint);
                station.setSnapPoint(snapDrawPoint);
            }
            this._isObsStationMap.put(station, station.isObservedStation());
            if (!this._stationSetData.drawName) continue;
            double halfwidth = (double)stationIconWidth / 1.5;
            if (!this._studyDas.isAttributeShown("Names")) continue;
            float priority = (float)this._glyphLevel + 0.5f;
            int offset = (int)halfwidth;
            int idx = 0;
            for (String string : MapLabelItem.POSITION_STRINGS) {
                if (string.equals(station.getLabelPosition())) break;
                ++idx;
            }
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(station.getName(), this.xy[0], this.xy[1], idx, offset, priority, this._stationSetData.nameFont, Color.black, null, false, g2d));
        }
    }

    public void drawLevee(Graphics g, MapScale scl, Levee levee) {
        int[] locyarray;
        WorldLine wl;
        if (levee == null) {
            return;
        }
        if (levee.getFollowsStream()) {
            this.getLeveeLine(g, scl, levee);
        }
        if ((wl = levee.getLine()) == null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("drawLevee: no line for Levee " + levee.getName());
            return;
        }
        double halfwidth = (double)this._leveeData.leveeWidth / 1.5;
        int sizeNeeded = Math.min(wl.pts.size() * 2, MapGlyph.maxPtArraySz);
        int[] locxarray = new int[sizeNeeded + 1];
        int li = wl.getLocalRegionArrays(scl, locxarray, locyarray = new int[sizeNeeded + 1], halfwidth);
        if (li > 0) {
            g.setColor(this._leveeData.fillColor);
            g.fillPolygon(locxarray, locyarray, li);
            if (this._leveeData.drawName) {
                Font f = g.getFont();
                g.setFont(this._leveeData.nameFont);
                if (this._studyDas.isAttributeShown("Names")) {
                    this.drawConformingString(g, scl, wl, levee.getName(), 0.5, (int)halfwidth, this._leveeData.nameFont, this._leveeData.fillColor, levee.getBank(), (float)this._glyphLevel + 0.35f);
                }
                g.setFont(f);
            }
        }
    }

    @Override
    public void drawSelectedLevee(Graphics g, MapScale scl, Levee levee, boolean isXOR, boolean editing) {
        int[] locyarray;
        WorldLine wl;
        if (levee == null) {
            return;
        }
        if (levee.getFollowsStream()) {
            this.getLeveeLine(g, scl, levee);
        }
        if ((wl = levee.getLine()) == null) {
            return;
        }
        double halfwidth = (double)this._leveeData.leveeWidth / 1.5;
        int sizeNeeded = Math.min(wl.pts.size() * 2, MapGlyph.maxPtArraySz);
        int[] locxarray = new int[sizeNeeded + 1];
        int li = wl.getLocalRegionArrays(scl, locxarray, locyarray = new int[sizeNeeded + 1], halfwidth);
        if (li > 0) {
            g.setPaintMode();
            g.setColor(Color.yellow);
            g.fillPolygon(locxarray, locyarray, li);
            g.setColor(this._leveeData.outlineColor);
            g.drawPolygon(locxarray, locyarray, li);
        }
        if (editing && !levee.getFollowsStream()) {
            int[] xpt = new int[4];
            int[] ypt = new int[4];
            g.setColor(this._leveeData.fillColor);
            int ptSize = this._leveeData.leveeWidth / 2;
            int size = wl.pts.size();
            for (int i = 0; i < size; ++i) {
                this.tmpWpt.init((WorldPt)wl.pts.elementAt(i));
                this._mapPanel.scale().wp2lp(this.tmpWpt, this.tmpLpt);
                xpt[0] = this.tmpLpt.x - ptSize;
                ypt[0] = this.tmpLpt.y;
                xpt[1] = this.tmpLpt.x;
                ypt[1] = this.tmpLpt.y + ptSize;
                xpt[2] = this.tmpLpt.x + ptSize;
                ypt[2] = this.tmpLpt.y;
                xpt[3] = this.tmpLpt.x;
                ypt[3] = this.tmpLpt.y - ptSize;
                g.fillPolygon(xpt, ypt, 4);
            }
        }
    }

    public void drawDiversion(Graphics g, MapScale scl, Diversion diversion) {
        int[] locyarray;
        int sizeNeeded;
        int[] locxarray;
        int li;
        ComputationPoint cp0 = diversion.getComputationPoint(true);
        ComputationPoint cp1 = diversion.getComputationPoint(false);
        Node n0 = diversion.getUpstreamNode();
        Node n1 = diversion.getDownstreamNode();
        WorldLine wl = diversion.getLine();
        double halfwidth = (double)this._diversionData.diversionWidth / 1.5;
        if (diversion.getReservoirId() > -1L) {
            StreamSegment ss;
            DataList dl = ClientApp.Workspace().getDataListContainer().getDataList(Reservoir.class.getName());
            Reservoir res = (Reservoir)dl.getObject(diversion.getReservoirId());
            if (res != null && (ss = res.getStreamSegment(n0.getStreamIndex())) != null) {
                double offset = diversion.getReservoirOffset();
                double upCoord = ss.upstreamCoord;
                double downCoord = ss.downstreamCoord;
                double divCoord = (upCoord - downCoord) * offset;
                StreamElement elem = this._alignment.findReach(n0.getStreamIndex());
                if (elem != null) {
                    wl.getFirstPt().init(elem.getLocationByCoord(divCoord));
                }
            }
        } else {
            this.setPointByComptPt(wl.getFirstPt(), cp0, n0.getLocation());
        }
        if (n1 != null) {
            this.setPointByComptPt(wl.getLastPt(), cp1, n1.getLocation());
        }
        if ((li = wl.getLocalRegionArrays(scl, locxarray = new int[(sizeNeeded = Math.min(wl.pts.size() * 2, MapGlyph.maxPtArraySz)) + 1], locyarray = new int[sizeNeeded + 1], halfwidth)) > 0) {
            g.setPaintMode();
            g.setColor(this._diversionData.fillColor);
            g.fillPolygon(locxarray, locyarray, li);
            if (this._diversionData.drawName && this._studyDas.isAttributeShown("Names")) {
                Font f = g.getFont();
                g.setFont(this._diversionData.nameFont);
                this.drawConformingString(g, scl, diversion.getLine(), diversion.getName(), 0.5, (int)halfwidth, this._diversionData.nameFont, this._diversionData.fillColor, 1, (float)this._glyphLevel + 0.3f);
                g.setFont(f);
            }
        }
        WorldPt pt0 = null;
        Object pt1 = null;
        pt0 = n0.getLocation();
        WorldPt midpt = new WorldPt();
        WorldPt slope = new WorldPt();
        wl.getSlopeAtCoord(1.0, midpt, slope);
        if (n1 != null) {
            g.setColor(this._diversionData.conColor);
        } else {
            g.setColor(this._diversionData.disConColor);
        }
        this.drawEndArrow(g, scl, wl.getLastPt(), slope, false, n1 != null);
    }

    void setPointByComptPt(WorldPt pt2set, ComputationPoint cp, WorldPt defaultPt) {
        WorldPt wpt;
        StreamElement elem;
        if (cp != null && (elem = this._alignment.findReach(cp.getStreamId())) != null && (wpt = elem.getLocationByStation(cp.getStreamStation())) != null && wpt.isValid()) {
            pt2set.init(wpt);
            return;
        }
        if (defaultPt != null) {
            pt2set.init(defaultPt);
        }
    }

    public void drawReservoir(Graphics g, MapScale scl, Reservoir reservoir) {
        WorldPt pt;
        int i;
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        if (alignglyph == null) {
            return;
        }
        StreamPolyLine line = null;
        if (reservoir == null) {
            return;
        }
        WorldRegion reg = reservoir.getRegion();
        int size = reg.pts.size();
        int[] locxarray = new int[size + 1];
        int[] locyarray = new int[size + 1];
        for (i = 0; i < size && (pt = (WorldPt)reg.pts.elementAt(i)) != null; ++i) {
            locxarray[i] = scl.e2x(pt.e);
            locyarray[i] = scl.n2y(pt.n);
        }
        Node dsn = reservoir.getDownstreamNode();
        if (dsn != null) {
            pt = dsn.getLocation();
            locxarray[i] = scl.e2x(pt.e);
            locyarray[i] = scl.n2y(pt.n);
            ++i;
        }
        if (i > 0 && this.resDPData.drawRPolygon) {
            Graphics2D g2 = null;
            Composite oldac = null;
            AlphaComposite ac = null;
            if (g instanceof Graphics2D) {
                g2 = (Graphics2D)g;
                oldac = g2.getComposite();
                ac = AlphaComposite.getInstance(3, 0.6f);
            }
            g.setColor(this.resDPData.triangleFillColor);
            if (g2 != null) {
                g2.setComposite(ac);
                g2.fillPolygon(locxarray, locyarray, i);
                if (oldac != null) {
                    g2.setComposite(oldac);
                }
                g.setColor(this.resDPData.triangleOutlineColor);
                g.drawPolygon(locxarray, locyarray, i);
            } else {
                g.setXORMode(XOR_COLOR);
                g.fillPolygon(locxarray, locyarray, i);
                g.setPaintMode();
                g.setColor(this.resDPData.triangleOutlineColor);
                g.drawPolygon(locxarray, locyarray, i);
            }
        }
        Vector<Node> nvec = reservoir.getNodeVector();
        Vector<Integer> ndirvec = reservoir.getNodeDirVector();
        size = nvec.size();
        double halfwidth = (double)this.resDPData.reachWidth / 1.5;
        Vector<StreamSegment> segvec = reservoir.getStreamSegmentVector();
        if (segvec != null) {
            size = segvec.size();
            for (i = 0; i < size; ++i) {
                int li;
                double c1;
                double c0;
                StreamElement strm;
                StreamSegment ss = segvec.elementAt(i);
                if (ss == null || (strm = alignglyph.findReach(ss.streamIndex)) == null || (c0 = ss.downstreamStation != Double.NEGATIVE_INFINITY ? strm.getCoordByStation(ss.downstreamStation) : ss.downstreamCoord) == (c1 = ss.upstreamStation != Double.NEGATIVE_INFINITY ? strm.getCoordByStation(ss.upstreamStation) : ss.upstreamCoord)) continue;
                line = strm.getLineSegment(c0, c1);
                int sizeNeeded = Math.min(line.pts.size() * 2, MapGlyph.maxPtArraySz);
                if (locxarray.length < sizeNeeded) {
                    locxarray = new int[sizeNeeded + 1];
                    locyarray = new int[sizeNeeded + 1];
                }
                if ((li = line.getLocalRegionArrays(scl, locxarray, locyarray, halfwidth)) <= 0) continue;
                g.setPaintMode();
                g.setColor(this.resDPData.reachFillColor);
                g.fillPolygon(locxarray, locyarray, li);
                g.setColor(this.resDPData.reachOutlineColor);
                g.drawPolygon(locxarray, locyarray, li);
            }
        } else {
            for (i = 0; i < size; ++i) {
                int li;
                StreamElement stream;
                Node node = nvec.elementAt(i);
                if (node == null || (stream = alignglyph.findReach(node.getStreamIndex())) == null) continue;
                double station0 = node.getStreamStation();
                double c0 = stream.getCoordByStation(station0);
                double station1 = Double.NEGATIVE_INFINITY;
                double c1 = Double.NEGATIVE_INFINITY;
                for (int j = 0; j < size; ++j) {
                    Node node1;
                    if (i == j || (node1 = nvec.elementAt(j)) == null || node1.getStreamIndex() != node.getStreamIndex()) continue;
                    station1 = node1.getStreamStation();
                    c1 = stream.getCoordByStation(station1);
                    break;
                }
                if (c1 == Double.NEGATIVE_INFINITY) {
                    Integer idir = ndirvec.elementAt(i);
                    if (1 == idir) {
                        c1 = 0.0;
                    } else {
                        c1 = c0;
                        c0 = 1.0;
                    }
                } else if (c1 >= c0) continue;
                line = stream.getLineSegment(c1, c0);
                int sizeNeeded = Math.min(line.pts.size() * 2, MapGlyph.maxPtArraySz);
                if (locxarray.length < sizeNeeded) {
                    locxarray = new int[sizeNeeded + 1];
                    locyarray = new int[sizeNeeded + 1];
                }
                if ((li = line.getLocalRegionArrays(scl, locxarray, locyarray, halfwidth)) <= 0) continue;
                g.setPaintMode();
                g.setColor(this.resDPData.reachFillColor);
                g.fillPolygon(locxarray, locyarray, li);
                g.setColor(this.resDPData.reachOutlineColor);
                g.drawPolygon(locxarray, locyarray, li);
            }
        }
        this.drawReservoirDam(g, reservoir, false, (double)this.resDPData.minDamWidth / 1.5, alignglyph, this.resDPData.damColor);
        pt = reservoir.getReferencePt();
        int x = scl.e2x(pt.e);
        int y = scl.n2y(pt.n);
        if (_impactImage == null) {
            g.setColor(Color.red);
            g.fillOval(x - 2, y - 2, 4, 4);
            g.setColor(Color.blue);
            g.drawOval(x - 2, y - 2, 4, 4);
        }
        if (this.resDPData.drawName && this._studyDas.isAttributeShown("Names")) {
            Font f = g.getFont();
            g.setFont(this.resDPData.nameFont);
            g.setColor(this.resDPData.triangleOutlineColor);
            this.drawString(g, reservoir.getName(), x + 10, y + 4, 3.0f, reservoir.getLabelPosition());
            g.setFont(f);
        }
    }

    public void drawSelectedReservoir(Graphics g, MapScale scl, Reservoir lreg, boolean isXOR, boolean editing) {
        this.drawSelectedReservoir(g, scl, lreg, isXOR, editing, true);
    }

    @Override
    public void drawSelectedReservoir(Graphics g, MapScale scl, Reservoir lreg, boolean isXOR, boolean editing, boolean fillRegion) {
        WorldPt wpt;
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        if (alignglyph == null) {
            return;
        }
        int icnt = 0;
        int[] locxarray = new int[MapGlyph.maxPtArraySz];
        int[] locyarray = new int[MapGlyph.maxPtArraySz];
        for (int i = 0; i < lreg.getRegion().pts.size() && i < 4000; ++i) {
            wpt = (WorldPt)lreg.getRegion().pts.elementAt(i);
            if (wpt == null) continue;
            scl.wp2lp(wpt, this.tmpLpt);
            locxarray[icnt] = this.tmpLpt.x;
            locyarray[icnt] = this.tmpLpt.y;
            ++icnt;
        }
        Graphics2D g2 = null;
        Composite oldac = null;
        AlphaComposite ac = null;
        Node dsn = lreg.getDownstreamNode();
        if (dsn != null) {
            wpt = dsn.getLocation();
            locxarray[icnt] = scl.e2x(wpt.e);
            locyarray[icnt] = scl.n2y(wpt.n);
            ++icnt;
        }
        if (fillRegion) {
            if (g instanceof Graphics2D) {
                g2 = (Graphics2D)g;
                oldac = g2.getComposite();
                ac = AlphaComposite.getInstance(3, 0.6f);
                g2.setComposite(ac);
                g.setColor(Color.yellow);
                g2.fillPolygon(locxarray, locyarray, icnt);
                if (oldac != null) {
                    g2.setComposite(oldac);
                }
            } else {
                if (isXOR) {
                    g.setXORMode(XOR_COLOR);
                }
                g.setColor(Color.yellow);
                g.fillPolygon(locxarray, locyarray, icnt);
                g.setPaintMode();
                if (isXOR) {
                    g.setXORMode(XOR_COLOR);
                }
            }
        } else if (isXOR) {
            g.setXORMode(XOR_COLOR);
        }
        g.setColor(Color.blue);
        g.drawPolygon(locxarray, locyarray, icnt);
        if (editing) {
            int[] xpt = new int[4];
            int[] ypt = new int[4];
            for (int i = 0; i < icnt; ++i) {
                xpt[0] = locxarray[i] - 3;
                ypt[0] = locyarray[i];
                xpt[1] = locxarray[i];
                ypt[1] = locyarray[i] + 3;
                xpt[2] = locxarray[i] + 3;
                ypt[2] = locyarray[i];
                xpt[3] = locxarray[i];
                ypt[3] = locyarray[i] - 3;
                g.fillPolygon(xpt, ypt, 4);
            }
        }
        Reservoir reservoir = lreg;
        double halfwidth = 5.333333333333333;
        Vector<Node> nvec = reservoir.getNodeVector();
        Vector<Integer> ndirvec = reservoir.getNodeDirVector();
        int size = nvec.size();
        Vector<StreamSegment> segvec = reservoir.getStreamSegmentVector();
        if (segvec != null) {
            size = segvec.size();
            for (int i = 0; i < size; ++i) {
                int li;
                double c1;
                double c0;
                StreamElement strm;
                StreamSegment ss = segvec.elementAt(i);
                if (ss == null || (strm = alignglyph.findReach(ss.streamIndex)) == null || (c0 = ss.downstreamStation != Double.NEGATIVE_INFINITY ? strm.getCoordByStation(ss.downstreamStation) : ss.downstreamCoord) == (c1 = ss.upstreamStation != Double.NEGATIVE_INFINITY ? strm.getCoordByStation(ss.upstreamStation) : ss.upstreamCoord)) continue;
                StreamPolyLine line = strm.getLineSegment(c0, c1);
                int sizeNeeded = Math.min(line.pts.size() * 2, MapGlyph.maxPtArraySz);
                if (locxarray.length < sizeNeeded) {
                    locxarray = new int[sizeNeeded + 1];
                    locyarray = new int[sizeNeeded + 1];
                }
                if ((li = line.getLocalRegionArrays(scl, locxarray, locyarray, halfwidth)) <= 0) continue;
                g.setColor(Color.yellow);
                g.fillPolygon(locxarray, locyarray, li);
                g.setColor(this.resDPData.reachOutlineColor);
                g.drawPolygon(locxarray, locyarray, li);
            }
        } else {
            Color darkerBlue = Color.blue.darker();
            for (int i = 0; i < size; ++i) {
                int li;
                StreamElement stream;
                Node node = nvec.elementAt(i);
                if (node == null || (stream = alignglyph.findReach(node.getStreamIndex())) == null || stream == null) continue;
                double c0 = node.getStreamCoord();
                double c1 = Double.NEGATIVE_INFINITY;
                for (int j = 0; j < size; ++j) {
                    Node node1;
                    if (i == j || (node1 = nvec.elementAt(j)) == null || node1.getStreamIndex() != node.getStreamIndex()) continue;
                    c1 = node1.getStreamCoord();
                    break;
                }
                if (c1 == Double.NEGATIVE_INFINITY) {
                    Integer idir = ndirvec.elementAt(i);
                    if (idir == 1) {
                        c1 = 0.0;
                    } else {
                        c1 = c0;
                        c0 = 1.0;
                    }
                } else if (c1 >= c0) continue;
                StreamPolyLine line = stream.getLineSegment(c1, c0);
                int sizeNeeded = Math.min(line.pts.size() * 2, MapGlyph.maxPtArraySz);
                if (locxarray.length < sizeNeeded) {
                    locxarray = new int[sizeNeeded + 1];
                    locyarray = new int[sizeNeeded + 1];
                }
                if ((li = line.getLocalRegionArrays(scl, locxarray, locyarray, halfwidth)) <= 0) continue;
                g.setColor(Color.yellow);
                g.fillPolygon(locxarray, locyarray, li);
                g.setColor(darkerBlue);
                g.drawPolygon(locxarray, locyarray, li);
            }
        }
        this.drawReservoirDam(g, reservoir, true, (double)this.resDPData.minDamWidth / 1.5, alignglyph, this.resDPData.damColor);
        wpt = lreg.getReferencePt();
        int x = scl.e2x(wpt.e);
        int y = scl.n2y(wpt.n);
        if (editing) {
            g.setColor(Color.yellow);
            g.fillOval(x - 3, y - 3, 6, 6);
            g.setColor(Color.blue);
            g.drawOval(x - 3, y - 3, 6, 6);
        }
        if (this._studyDas.isAttributeShown("Names")) {
            Font f = g.getFont();
            g.setFont(this.resDPData.nameFont);
            g.setColor(Color.red);
            this.drawString(g, lreg.getName(), x + 10, y + 4, 6.0f, lreg.getLabelPosition());
            g.setFont(f);
        }
        if (isXOR) {
            g.setPaintMode();
        }
    }

    private void drawReservoirDam(Graphics g, Reservoir res, boolean editing, double halfwidth, StreamAlignmentGlyph alignglyph, Color damColor) {
        WorldPt wloc = new WorldPt();
        WorldPt slp = new WorldPt();
        Vector<Node> nvec = res.getNodeVector();
        Vector<Integer> ndirvec = res.getNodeDirVector();
        int[] locxarray = new int[MapGlyph.maxPtArraySz];
        int[] locyarray = new int[MapGlyph.maxPtArraySz];
        for (int i = 0; i < nvec.size(); ++i) {
            WorldLine line;
            Node node = nvec.elementAt(i);
            Integer idir = ndirvec.elementAt(i);
            if (node == null) continue;
            StreamElement elem = this._alignment.findReach(node.getStreamIndex());
            WorldPt wpt = elem != null ? elem.getLocationByStation(node.getStreamStation()) : node.getLocation();
            LocalPt lpt = this._mapPanel.scale().wp2lp(wpt);
            if (idir == 1) {
                if (!editing) continue;
                g.fillOval(lpt.x - 4, lpt.y - 4, 8, 8);
                continue;
            }
            StreamElement stream = alignglyph.findReach(node.getStreamIndex());
            if (stream == null || (line = stream.getLine()) == null) continue;
            double coord = node.getStreamCoord();
            if (RMAConst.isUndefinedValue((double)coord)) {
                coord = elem.getCoordByStation(node.getStreamStation());
            }
            if (RMAConst.isUndefinedValue((double)coord)) continue;
            line.getSlopeAtCoord(coord, wloc, slp);
            Color c = g.getColor();
            g.setColor(damColor);
            locxarray[0] = (int)((double)lpt.x - slp.n * halfwidth * 2.0 + slp.e * halfwidth / 2.0 + 0.5);
            locxarray[1] = (int)((double)lpt.x - slp.n * halfwidth * 2.0 - slp.e * halfwidth / 2.0 + 0.5);
            locxarray[2] = (int)((double)lpt.x + slp.n * halfwidth * 2.0 - slp.e * halfwidth / 2.0 + 0.5);
            locxarray[3] = (int)((double)lpt.x + slp.n * halfwidth * 2.0 + slp.e * halfwidth / 2.0 + 0.5);
            locyarray[0] = (int)((double)lpt.y - slp.e * halfwidth * 2.0 - slp.n * halfwidth / 2.0 + 0.5);
            locyarray[1] = (int)((double)lpt.y - slp.e * halfwidth * 2.0 + slp.n * halfwidth / 2.0 + 0.5);
            locyarray[2] = (int)((double)lpt.y + slp.e * halfwidth * 2.0 + slp.n * halfwidth / 2.0 + 0.5);
            locyarray[3] = (int)((double)lpt.y + slp.e * halfwidth * 2.0 - slp.n * halfwidth / 2.0 + 0.5);
            g.fillPolygon(locxarray, locyarray, 4);
            g.setColor(c);
            if (!editing) continue;
            g.fillOval(lpt.x - 4, lpt.y - 4, 8, 8);
        }
    }

    public boolean isSelected(Object obj) {
        if (obj == null) {
            return false;
        }
        for (int ii = 0; ii < this._selectionVector.size(); ++ii) {
            MapGlyph.Selection sel = this._selectionVector.get(ii);
            if (sel.object == null || sel.object != obj && !sel.object.equals(obj)) continue;
            return true;
        }
        return false;
    }

    public void draw(Graphics g, MapScale scl) {
        Reservoir res;
        OtherProject op;
        Condition c;
        ImpactArea iarea;
        int size;
        if (this._study == null || this._watershedMode == null) {
            return;
        }
        this._glyphLevel = this._mapPanel.getGlyphLevel((MapGlyph)this);
        if (this._studyDas.isAttributeShown("Impact Areas")) {
            Object[] iaList = this._study.getImpactAreaList();
            size = iaList.length;
            for (int i = 0; _paintOk && i < size; ++i) {
                iarea = (ImpactArea)iaList[i];
                if (iarea == null || this.isSelected(iarea)) continue;
                this.drawArea(g, scl, iarea);
            }
        }
        if ((c = this._watershedMode.getSelectedCondition()) == null) {
            return;
        }
        Vector projects = c.getProjects();
        int numProjects = projects.size();
        for (int p = 0; _paintOk && p < numProjects; ++p) {
            Project proj = (Project)projects.elementAt(p);
            if (proj == null) continue;
            if (proj instanceof ChannelMod) {
                if (!this._studyDas.isAttributeShown("Channel Modifications")) continue;
                this.drawChannelMod(g, scl, (ChannelMod)proj);
                continue;
            }
            if (proj instanceof StoragePool) {
                if (!this._studyDas.isAttributeShown("Off Channel Storage")) continue;
                this.drawStoragePool(g, scl, (StoragePool)proj);
                continue;
            }
            if (proj instanceof OtherProject) {
                if (!this._studyDas.isAttributeShown("Other Projects")) continue;
                op = (OtherProject)proj;
                this.drawOtherProject(g, scl, op);
                continue;
            }
            if (proj instanceof Reservoir) {
                if (!this._studyDas.isAttributeShown("Reservoirs")) continue;
                res = (Reservoir)proj;
                this.drawReservoir(g, scl, res);
                continue;
            }
            if (proj instanceof Diversion) {
                if (!this._studyDas.isAttributeShown("Diversions")) continue;
                this.drawDiversion(g, scl, (Diversion)proj);
                continue;
            }
            if (!(proj instanceof Levee) || !this._studyDas.isAttributeShown("Levees")) continue;
            this.drawLevee(g, scl, (Levee)proj);
        }
        if (this._stationSetData != null && this._studyDas.isAttributeShown("Stations")) {
            this.drawStations(g, scl);
        }
        if (this._compPtList != null && this._studyDas.isAttributeShown("Computation Points")) {
            int symbolNum;
            Color bgcolor;
            Color fgcolor;
            int symbolSize;
            ComputationPointLayer ccpl;
            DataObject[] cpts = this._compPtList.getObjects();
            size = cpts.length;
            int ccplSize = this._ccpVisibleLayers.size();
            ComputationPointLayer defaultLayer = null;
            for (int x = 0; x < ccplSize; ++x) {
                ccpl = this._ccpVisibleLayers.get(x);
                if (!ccpl.isDefaultLayer()) continue;
                defaultLayer = ccpl;
            }
            List<ComputationPoint> defaultCptList = null;
            if (defaultLayer != null) {
                defaultCptList = defaultLayer.getCompPts();
            }
            for (int j = 0; j < ccplSize; ++j) {
                ccpl = this._ccpVisibleLayers.get(j);
                if (ccpl == defaultLayer) continue;
                symbolSize = ccpl.getSymbolSize();
                fgcolor = ccpl.getForegroundColor();
                bgcolor = ccpl.getBackgroundColor();
                symbolNum = ccpl.getSymbolNum();
                List<ComputationPoint> cptList = ccpl.getCompPts();
                size = cptList.size();
                for (int i = 0; _paintOk && i < size; ++i) {
                    ComputationPoint cpt = cptList.get(i);
                    if (cpt == null) continue;
                    if (defaultCptList != null) {
                        defaultCptList.remove(cpt);
                    }
                    this.drawCompPt(g, scl, cpt, symbolSize, fgcolor, bgcolor, symbolNum);
                }
            }
            if (defaultLayer != null) {
                symbolSize = defaultLayer.getSymbolSize();
                bgcolor = defaultLayer.getBackgroundColor();
                fgcolor = defaultLayer.getForegroundColor();
                symbolNum = defaultLayer.getSymbolNum();
                size = defaultCptList.size();
                for (int i = 0; _paintOk && i < size; ++i) {
                    ComputationPoint cpt = defaultCptList.get(i);
                    if (cpt == null) continue;
                    this.drawCompPt(g, scl, cpt, symbolSize, fgcolor, bgcolor, symbolNum);
                }
            }
        }
        size = this._selectionVector.size();
        for (int i = 0; _paintOk && i < size; ++i) {
            MapGlyph.Selection sel = this._selectionVector.get(i);
            if (sel.object == null) continue;
            if (sel.object instanceof ImpactArea) {
                if (!this._studyDas.isAttributeShown("Impact Areas")) continue;
                iarea = (ImpactArea)sel.object;
                this.drawSelectedArea(g, scl, iarea, false, sel.editing);
                continue;
            }
            if (sel.object instanceof Station) {
                if (!this._studyDas.isAttributeShown("Stations")) continue;
                this.drawSelectedStation(g, scl, (Station)((Object)sel.object), false, sel.editing);
                continue;
            }
            if (sel.object instanceof ChannelMod) {
                if (!this._studyDas.isAttributeShown("Channel Modifications")) continue;
                ChannelMod cm = (ChannelMod)sel.object;
                this.drawSelectedChannelMod(g, scl, cm, false, sel.editing);
                continue;
            }
            if (sel.object instanceof StoragePool) {
                if (!this._studyDas.isAttributeShown("Off Channel Storage")) continue;
                StoragePool sp = (StoragePool)sel.object;
                this.drawSelectedStoragePool(g, scl, sp, false, sel.editing);
                continue;
            }
            if (sel.object instanceof ComputationPoint) {
                if (!this._studyDas.isAttributeShown("Computation Points")) continue;
                ComputationPoint cpt = (ComputationPoint)sel.object;
                this.drawSelectedCompPt(g, scl, cpt, false, sel.editing);
                continue;
            }
            if (sel.object instanceof OtherProject) {
                if (!this._studyDas.isAttributeShown("Other Projects")) continue;
                op = (OtherProject)sel.object;
                this.drawSelectedOtherProject(g, scl, op, false, sel.editing);
                continue;
            }
            if (sel.object instanceof Reservoir) {
                if (!this._studyDas.isAttributeShown("Reservoirs")) continue;
                res = (Reservoir)sel.object;
                this.drawSelectedReservoir(g, scl, res, false, sel.editing);
                continue;
            }
            if (sel.object instanceof Diversion) {
                if (!this._studyDas.isAttributeShown("Diversions") || !this._studyDas.isAttributeShown("Diversions")) continue;
                this.drawSelectedDiversion(g, scl, (Diversion)sel.object, false, sel.editing);
                continue;
            }
            if (!(sel.object instanceof Levee) || !this._studyDas.isAttributeShown("Levees") || !this._studyDas.isAttributeShown("Levees")) continue;
            this.drawSelectedLevee(g, scl, (Levee)sel.object, false, sel.editing);
        }
    }

    @Override
    public OtherProject findOtherProject(LocalPt pt) {
        if (this._study == null || pt == null) {
            return null;
        }
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        return this.findOtherProject(wpt);
    }

    public OtherProject findOtherProject(WorldPt wpt) {
        if (this._study == null || wpt == null) {
            return null;
        }
        LocalPt pt = this._mapPanel.scale().wp2lp(wpt);
        double tol = this._mapPanel.scale().x2e(pt.x + 20) - this._mapPanel.scale().x2e(pt.x);
        OtherProject op = this._study.findOtherProject(wpt, tol, true);
        Condition c = this._watershedMode.getSelectedCondition();
        if (c == null) {
            return null;
        }
        if (c.hasProject(op)) {
            return op;
        }
        return null;
    }

    @Override
    public ComputationPoint findCompPt(LocalPt pt) {
        if (this._study == null || pt == null) {
            return null;
        }
        double tol = this._mapPanel.scale().x2e(pt.x + 8) - this._mapPanel.scale().x2e(pt.x);
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        ComputationPoint cpt = this._study.findCompPt(wpt, tol);
        return cpt;
    }

    @Override
    public ComputationPoint findCompPt(int streamIndex, double upstreamCoord, double downstreamCoord) {
        return this._study.findCompPt(streamIndex, upstreamCoord, downstreamCoord);
    }

    public NamedType findObject(LocalPt pt) {
        if (this._study == null || pt == null) {
            return null;
        }
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        return this.findObject(wpt);
    }

    public NamedType findObject(WorldPt wpt) {
        Station station;
        if (this._study == null || wpt == null) {
            return null;
        }
        double tol = this._mapPanel.scale().x2e(5) - this._mapPanel.scale().x2e(0);
        if (this._lastFindwpt.isValid()) {
            this._lastFindRect.init(this._lastFindwpt.e - tol, this._lastFindwpt.n + tol, this._lastFindwpt.e + tol, this._lastFindwpt.n - tol);
            if (this._lastFindRect.contains(wpt)) {
                ++this._lastFoundObj;
                this._lastFoundObj %= this._numObjs;
            } else {
                this._lastFoundObj = 0;
            }
        }
        this._lastFindwpt.init(wpt);
        Object obj = null;
        ComputationPoint goodObj = null;
        Condition c = this._watershedMode.getSelectedCondition();
        if (c == null) {
            return null;
        }
        if (this._studyDas.isAttributeShown("Computation Points") && (obj = this._study.findCompPt(wpt, tol)) != null) {
            goodObj = obj;
            if (this._lastFoundObj == 0) {
                return obj;
            }
        }
        if (this._studyDas.isAttributeShown("Other Projects") && (obj = this.findOtherProject(wpt)) != null && c.hasProject((Project)obj)) {
            goodObj = obj;
            if (this._lastFoundObj <= 1) {
                return obj;
            }
        }
        if (this._studyDas.isAttributeShown("Impact Areas") && (obj = (NamedType)this._study.findRegion(wpt, tol, ImpactArea.class.getName())) != null) {
            goodObj = obj;
            if (this._lastFoundObj <= 2) {
                return obj;
            }
        }
        if (this._studyDas.isAttributeShown("Off Channel Storage") && (obj = (NamedType)this._study.findRegion(wpt, tol, StoragePool.class.getName())) != null) {
            if (c == null) {
                return obj;
            }
            if (c.hasProject((Project)obj)) {
                return obj;
            }
        }
        if (this._studyDas.isAttributeShown("Channel Modifications") && (obj = this.findChannelMod(wpt, tol)) != null) {
            if (c == null) {
                return obj;
            }
            if (c.hasProject((Project)obj)) {
                return obj;
            }
        }
        if (this._studyDas.isAttributeShown("Reservoirs") && (obj = this.findReservoir(wpt)) != null) {
            if (c == null) {
                return obj;
            }
            if (c.hasProject((Project)obj)) {
                return obj;
            }
        }
        if (this._studyDas.isAttributeShown("Diversions") && (obj = this.findDiversion(wpt, tol)) != null) {
            if (c == null) {
                return obj;
            }
            if (c.hasProject((Project)obj)) {
                return obj;
            }
        }
        if (this._studyDas.isAttributeShown("Levees") && (obj = this.findLevee(wpt, tol)) != null) {
            if (c == null) {
                return obj;
            }
            if (c.hasProject((Project)obj)) {
                return obj;
            }
            obj = null;
        }
        if (this._studyDas.isAttributeShown("Stations") && (station = this.findStation(this._mapPanel.scale().wp2lp(wpt))) != null) {
            obj = new StationWrapper(station);
        }
        if (obj == null && goodObj != null) {
            return goodObj;
        }
        return obj;
    }

    public boolean objectDoubleClick(LocalPt pt, int modifiers) {
        NamedType obj = this.findObject(pt);
        if (obj != null) {
            this._selectionVector.clear();
            MapGlyph.Selection sel = new MapGlyph.Selection((MapGlyph)this, (Object)obj, true);
            this._selectionVector.add(sel);
            this._mapPanel.paintMap();
            ClientMode mode = this._frame.getCurrentMode();
            return mode.objectDoubleClick(obj, pt);
        }
        Station findStation = this.findStation(pt);
        if (findStation != null) {
            ClientMode mode = this._frame.getCurrentMode();
            if (mode instanceof WatershedConfigMode) {
                ((WatershedConfigMode)mode).objectDoubleClick(findStation, pt);
            }
            return true;
        }
        return false;
    }

    public void compPtDoubleClick(LocalPt pt, ComputationPoint compPt) {
        if (compPt == null) {
            return;
        }
    }

    @Override
    public void selectObject(NamedType obj) {
        if (obj == null) {
            this._selectionVector.clear();
            return;
        }
        if (obj instanceof ChannelMod) {
            this.selectChannelMod((ChannelMod)obj, true, false);
        } else if (obj instanceof ComputationPoint) {
            this.selectCompPt((ComputationPoint)obj, true, false);
        } else if (obj instanceof Diversion) {
            this.selectDiversion((Diversion)obj, true, false);
        } else if (obj instanceof ImpactArea) {
            this.selectImpactArea((ImpactArea)obj, true, false);
        } else if (obj instanceof Levee) {
            this.selectLevee((Levee)obj, true, false);
        } else if (obj instanceof OtherProject) {
            this.selectOtherProject((OtherProject)obj, true, false);
        } else if (obj instanceof Reservoir) {
            this.selectReservoir((Reservoir)obj, true, false);
        } else if (obj instanceof StoragePool) {
            this.selectStoragePool((StoragePool)obj, true, false);
        }
    }

    @Override
    public NamedType objectSelect(LocalPt pt, int modifiers) {
        NamedType obj = this.findObject(pt);
        if (obj != null) {
            this._selectionVector.clear();
            Object selectionObj = obj;
            if (obj instanceof StationWrapper) {
                selectionObj = ((StationWrapper)obj).getStation();
            }
            MapGlyph.Selection sel = new MapGlyph.Selection((MapGlyph)this, selectionObj, false);
            this._selectionVector.add(sel);
            this._mapPanel.paintMap();
        } else {
            this.clearSelection();
        }
        this.fireGlyphSelectionChanged(obj);
        return obj;
    }

    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        NamedType obj = this.findObject(pt);
        if (obj != null) {
            this._selectionVector.clear();
            Object selectionObj = obj;
            if (obj instanceof StationWrapper) {
                selectionObj = ((StationWrapper)obj).getStation();
            }
            MapGlyph.Selection sel = new MapGlyph.Selection((MapGlyph)this, selectionObj, false);
            this._selectionVector.add(sel);
            this._mapPanel.paintMap();
            this._mapPanel.waitforPaintComplete();
            ClientMode mode = this._frame.getCurrentMode();
            mode.objectPopupMenu(obj, pt);
        }
        return true;
    }

    @Deprecated
    public void drawConformingString(Graphics g, MapScale scl, WorldLine line, String str, double coord) {
        int i;
        double cbest;
        double dn;
        double de;
        double dist;
        WorldPt lastSlope;
        WorldPt lastPt;
        double c;
        if (coord < 0.0 || coord > 1.0) {
            return;
        }
        double strmlen = line.getLength();
        WorldPt pt = (WorldPt)line.pts.elementAt(0);
        double strmlenLocal = scl.e2x(pt.e + strmlen) - scl.e2x(pt.e);
        double localScl = strmlenLocal / strmlen;
        double coordScl = 1.0 / strmlenLocal;
        FontMetrics metrics = g.getFontMetrics();
        int h = metrics.getHeight();
        int ascent = metrics.getAscent();
        int w = metrics.getMaxAdvance();
        int numchar = str.length();
        double strCoordLen = (double)(numchar * h) * coordScl;
        double step = (double)h / localScl / 2.0;
        double cstep = (double)h * coordScl / 2.0;
        double offset = 2.0 * step;
        boolean iside = true;
        WorldLine strline = new WorldLine();
        double c0 = coord - strCoordLen / 2.0;
        double c1 = coord + strCoordLen / 2.0;
        pt = new WorldPt();
        WorldPt baseSlope = new WorldPt();
        line.getSlopeAtCoord(coord, pt, baseSlope);
        WorldPt basePt = new WorldPt(pt.e - (double)iside * offset * baseSlope.n, pt.n + (double)iside * offset * baseSlope.e);
        strline.pts.addElement(basePt);
        WorldPt nextPt = basePt;
        WorldPt nextSlope = baseSlope;
        WorldPt bestPt = new WorldPt();
        int[] locxarray = new int[MapGlyph.maxPtArraySz];
        int[] locyarray = new int[MapGlyph.maxPtArraySz];
        for (c = coord - cstep; c >= c0; c -= cstep) {
            lastPt = nextPt;
            lastSlope = nextSlope;
            nextPt = new WorldPt(lastPt.e - lastSlope.e * step, lastPt.n - lastSlope.n * step);
            dist = line.getNearestLocation(nextPt, bestPt);
            de = nextPt.e - bestPt.e;
            dn = nextPt.n - bestPt.n;
            nextPt.init(bestPt.e + de * offset / dist, bestPt.n + dn * offset / dist);
            strline.pts.insertElementAt(nextPt, 0);
            cbest = line.getCoordAtLocation(bestPt);
            nextSlope = new WorldPt();
            line.getSlopeAtCoord(cbest, bestPt, nextSlope);
        }
        nextPt = basePt;
        nextSlope = baseSlope;
        for (c = coord + cstep; c <= c1; c += cstep) {
            lastPt = nextPt;
            lastSlope = nextSlope;
            nextPt = new WorldPt(lastPt.e + lastSlope.e * step, lastPt.n + lastSlope.n * step);
            dist = line.getNearestLocation(nextPt, bestPt);
            de = nextPt.e - bestPt.e;
            dn = nextPt.n - bestPt.n;
            nextPt.init(bestPt.e + de * offset / dist, bestPt.n + dn * offset / dist);
            strline.pts.addElement(nextPt);
            cbest = line.getCoordAtLocation(bestPt);
            nextSlope = new WorldPt();
            line.getSlopeAtCoord(cbest, bestPt, nextSlope);
        }
        Color fontClr = g.getColor();
        char[] strchar = new char[numchar + 1];
        str.getChars(0, numchar, strchar, 0);
        cstep = 1.0 / (double)numchar;
        int idir = 1;
        if (strline.getFirstPt().e > strline.getLastPt().e) {
            idir = -1;
        }
        nextPt = new WorldPt();
        nextSlope = new WorldPt();
        coordScl = 1.0 / (strline.getLength() * localScl);
        c = 0.0;
        if (idir < 0) {
            c = 1.0;
        }
        for (i = 0; i < numchar; ++i) {
            strline.getSlopeAtCoord(c, nextPt, nextSlope);
            locxarray[i] = scl.e2x(nextPt.e);
            locyarray[i] = scl.n2y(nextPt.n);
            w = metrics.charWidth(strchar[i]) + 1;
            if (Math.abs(nextSlope.n) / Math.abs(nextSlope.e) >= (double)h / (double)w) {
                c += (double)(idir * ascent) * coordScl;
                continue;
            }
            c += (double)idir * (double)w / Math.abs(nextSlope.e) * coordScl;
        }
        c = 0.5;
        strline.getSlopeAtCoord(c, nextPt, nextSlope);
        for (i = numchar / 2 - 1; i >= 0; --i) {
            w = metrics.charWidth(strchar[i]) + 1;
            c = Math.abs(nextSlope.n) / Math.abs(nextSlope.e) >= (double)h / (double)w ? (c -= (double)(idir * ascent) * coordScl) : (c -= (double)idir * (double)w / Math.abs(nextSlope.e) * coordScl);
            strline.getSlopeAtCoord(c, nextPt, nextSlope);
            locxarray[i] = scl.e2x(nextPt.e);
            locyarray[i] = scl.n2y(nextPt.n);
        }
        c = 0.5;
        for (i = numchar / 2; i < numchar; ++i) {
            strline.getSlopeAtCoord(c, nextPt, nextSlope);
            locxarray[i] = scl.e2x(nextPt.e);
            locyarray[i] = scl.n2y(nextPt.n);
            w = metrics.charWidth(strchar[i]);
            if (Math.abs(nextSlope.n) / Math.abs(nextSlope.e) >= (double)h / (double)w) {
                c += (double)(idir * ascent) * coordScl;
                continue;
            }
            c += (double)idir * (double)w / Math.abs(nextSlope.e) * coordScl;
        }
        g.setColor(fontClr);
        for (i = 0; i < numchar; ++i) {
            g.drawChars(strchar, i, 1, locxarray[i], locyarray[i]);
        }
    }

    @Override
    public ComputationPoint moveCompPoint(ComputationPoint compPt, WorldPt wpt, StreamElement reach, double coord, double station) {
        if (compPt == null) {
            return null;
        }
        MapScale scl = this._mapPanel.scale();
        LocalPt lpt = scl.wp2lp(wpt);
        ComputationPoint existingCompPt = this.findCompPt(lpt);
        if (existingCompPt != null && existingCompPt.getId() != compPt.getId()) {
            int opt = JOptionPane.showConfirmDialog((Component)this._mapPanel, "Connect Computation Points " + compPt.getName() + " and " + existingCompPt.getName() + "?", "Connect?", 0, 3);
            if (opt == 0) {
                Vector v = compPt.getProjects();
                compPt.setReferencePt(wpt);
                compPt.setStreamId(existingCompPt.getStreamId());
                compPt.setStreamStation(existingCompPt.getStreamStation());
                compPt.setStreamCoord(existingCompPt.getStreamCoord());
                compPt.updateProjects();
                for (int i = 0; i < v.size(); ++i) {
                    existingCompPt.addProject((DataObject)v.get(i));
                }
                CommonDataList dl = compPt.getDataList();
                dl.removeObject(compPt.getId());
                return existingCompPt;
            }
            return compPt;
        }
        compPt.setReferencePt(wpt);
        if (reach != null) {
            compPt.setStreamId(reach.getIndex());
        }
        compPt.setStreamStation(station);
        compPt.setStreamCoord(coord);
        compPt.updateProjects();
        return compPt;
    }

    @Override
    public OtherProject moveOtherProject(OtherProject proj, WorldPt wpt) {
        if (proj == null) {
            return null;
        }
        proj.setReferencePt(wpt);
        proj.updateComputationPoint();
        return proj;
    }

    private void drawString(Graphics g, String s, int x, int y, float priority) {
        if (!this._studyDas.isAttributeShown("Names")) {
            return;
        }
        this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(s, x, y, priority, g.getFont(), g.getColor(), null, g));
    }

    private void drawString(Graphics g, String s, int x, int y, float priority, int location) {
        if (!this._studyDas.isAttributeShown("Names")) {
            return;
        }
        this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(s, x, y, location, 5, priority, g.getFont(), g.getColor(), null, false, g));
    }

    @Override
    public boolean otherProjectPopupMenu(LocalPt pt) {
        if (this._study == null || pt == null) {
            return false;
        }
        OtherProject obj = null;
        obj = this.selectOtherProject(pt, false, false);
        if (obj != null) {
            HecClientFrame frame = ClientApp.frame();
            ClientMode mode = frame.getCurrentMode();
            return mode.objectPopupMenu((NamedType)obj, pt);
        }
        return false;
    }

    @Override
    public boolean reservoirPopupMenu(LocalPt pt) {
        if (this._study == null || pt == null) {
            return false;
        }
        Reservoir obj = null;
        obj = this.selectReservoir(pt, false, false);
        if (obj != null) {
            HecClientFrame frame = ClientApp.frame();
            ClientMode mode = frame.getCurrentMode();
            return mode.objectPopupMenu((NamedType)obj, pt);
        }
        return false;
    }

    public boolean stationPopupMenu(LocalPt pt) {
        HecClientFrame frame;
        ClientMode mode;
        if (this._study == null || pt == null) {
            return false;
        }
        Station obj = null;
        obj = this.selectStation(pt, false, false);
        if (obj != null && (mode = (frame = ClientApp.frame()).getCurrentMode()) instanceof WatershedConfigMode) {
            ((WatershedConfigMode)mode).objectPopupMenu(obj, pt);
        }
        return false;
    }

    @Override
    public boolean diversionPopupMenu(LocalPt pt) {
        if (this._study == null || pt == null) {
            return false;
        }
        Diversion obj = null;
        obj = this.selectDiversion(pt, false, false);
        if (obj != null) {
            HecClientFrame frame = ClientApp.frame();
            ClientMode mode = frame.getCurrentMode();
            return mode.objectPopupMenu((NamedType)obj, pt);
        }
        return false;
    }

    @Override
    public void connectDiversionElement(Diversion elem, LocalPt selectedPt) {
    }

    public void drawEndArrow(Graphics g, MapScale scl, WorldPt loc, WorldPt wslope, boolean selected, boolean connected) {
        double hlen = 15.0;
        double hoff = 6.0;
        int idir = 1;
        WorldPt slope = new WorldPt(wslope);
        slope.n *= -1.0;
        int x = scl.e2x(loc.e);
        int y = scl.n2y(loc.n);
        int x1 = x;
        int y1 = y;
        int x0 = x;
        int y0 = y;
        Polygon p = new Polygon();
        if (connected) {
            g.setColor(this._diversionData.conColor);
        } else if (selected) {
            g.setColor(Color.yellow);
        }
        if (idir > 0) {
            x0 = x1 + (int)(-slope.n * hoff - slope.e * hlen);
            y0 = y1 + (int)(slope.e * hoff - slope.n * hlen);
            p.addPoint(x0, y0);
            p.addPoint(x1, y1);
            x0 = x1 + (int)(slope.n * hoff - slope.e * hlen);
            y0 = y1 + (int)(-slope.e * hoff - slope.n * hlen);
            p.addPoint(x0, y0);
            if (!this._mapPanel.getVisibleRect().intersects(p.getBounds())) {
                return;
            }
            g.fillPolygon(p);
            if (connected && selected) {
                g.setColor(Color.black);
            } else if (connected) {
                g.setColor(Color.black);
            } else {
                g.setColor(Color.black);
            }
            g.drawPolygon(p);
        } else {
            x1 = x0 - (int)(-slope.n * hoff - slope.e * hlen);
            y1 = y0 - (int)(slope.e * hoff - slope.n * hlen);
            p.addPoint(x0, y0);
            p.addPoint(x1, y1);
            x1 = x0 - (int)(slope.n * hoff - slope.e * hlen);
            y1 = y0 - (int)(-slope.e * hoff - slope.n * hlen);
            p.addPoint(x1, y1);
            g.setColor(Color.black);
            g.drawPolygon(p);
            g.fillPolygon(p);
        }
    }

    private void drawSelectedObject(Graphics g, MapScale scl, Object obj, boolean add, boolean editing) {
        if (obj == null) {
            return;
        }
        if (obj instanceof Diversion) {
            this.drawSelectedDiversion(g, scl, (Diversion)obj, add, editing);
        } else if (obj instanceof Reservoir) {
            this.drawSelectedReservoir(g, scl, (Reservoir)obj, add, editing);
        } else if (obj instanceof ImpactArea) {
            this.drawSelectedArea(g, scl, (ImpactArea)obj, add, editing);
        } else if (obj instanceof StoragePool) {
            this.drawSelectedStoragePool(g, scl, (StoragePool)obj, add, editing);
        } else if (obj instanceof ComputationPoint) {
            this.drawSelectedCompPt(g, scl, (ComputationPoint)obj, add, editing);
        } else if (obj instanceof OtherProject) {
            this.drawSelectedOtherProject(g, scl, (OtherProject)obj, add, editing);
        } else if (obj instanceof ChannelMod) {
            this.drawSelectedChannelMod(g, scl, (ChannelMod)obj, add, editing);
        } else if (obj instanceof Levee) {
            this.drawSelectedLevee(g, scl, (Levee)obj, add, editing);
        }
    }

    public WorldLine getLeveeLine(Graphics g, MapScale scl, Levee levee) {
        if (levee == null) {
            return null;
        }
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        if (alignglyph == null) {
            return null;
        }
        List<StreamSegmentIdentifier> ssiList = levee.getStreamSegmentList();
        int size = ssiList.size();
        StreamPolyLine streamLine = null;
        int offset = levee.getAveOffset();
        int bank = levee.getBank();
        for (int i = 0; i < size; ++i) {
            StreamSegmentIdentifier ssi = ssiList.get(i);
            StreamElement streamElem = alignglyph.findReach(ssi.streamId);
            if (streamElem == null) continue;
            double startCoord = streamElem.getCoordByStation(ssi.startStation);
            double endCoord = streamElem.getCoordByStation(ssi.endStation);
            StreamPolyLine tmpLine = ((StreamPolyLine)streamElem.getLine()).getLineSegment(startCoord, endCoord);
            if (streamLine == null) {
                streamLine = tmpLine;
                continue;
            }
            streamLine.add((WorldLine)tmpLine);
        }
        if (streamLine == null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("getLeveeLine: null streamLine for" + levee.getName());
            return null;
        }
        WorldLine leveeLine = streamLine.createOffsetLine(0.0, 1.0, (double)offset, bank);
        levee.setIgnoreModifiedEvents(true);
        levee.setLine(leveeLine);
        levee.setIgnoreModifiedEvents(false);
        return levee.getLine();
    }

    @Override
    public ComputationPoint getUpstreamComputationPoint(ComputationPoint compPt, boolean isReservoir) {
        DataObject[] compPts = this._compPtList.getObjects();
        ComputationPoint retCpt = null;
        double lastStation = Double.MAX_VALUE;
        double streamStation = compPt.getStreamStation();
        int streamId = compPt.getStreamId();
        for (int i = 0; i < compPts.length; ++i) {
            ComputationPoint cpt = (ComputationPoint)compPts[i];
            if (cpt.getStreamId() != streamId || cpt == compPt || !isReservoir && !cpt.hasReservoirProject() || !(cpt.getStreamStation() > streamStation) || !(cpt.getStreamStation() < lastStation)) continue;
            retCpt = cpt;
            lastStation = retCpt.getStreamStation();
        }
        return retCpt;
    }

    @Override
    public ComputationPoint getDownstreamComputationPoint(ComputationPoint compPt, boolean isReservoir) {
        DataObject[] compPts = this._compPtList.getObjects();
        ComputationPoint retCpt = null;
        double lastStation = -1.0;
        double streamStation = compPt.getStreamStation();
        int streamId = compPt.getStreamId();
        for (int i = 0; i < compPts.length; ++i) {
            ComputationPoint cpt = (ComputationPoint)compPts[i];
            if (cpt.getStreamId() != streamId || cpt == compPt || !isReservoir && !cpt.hasReservoirProject() || !(cpt.getStreamStation() < streamStation) || !(cpt.getStreamStation() > lastStation)) continue;
            retCpt = cpt;
            lastStation = retCpt.getStreamStation();
        }
        return retCpt;
    }

    public ModelDrawingAttributeSet getAttributeSet() {
        return this._studyDas;
    }

    public String getToolTipText(WorldPt wpt, MouseEvent e) {
        if (this._study == null || wpt == null) {
            return null;
        }
        NamedType nt = this.findObject(wpt);
        if (nt == null) {
            return null;
        }
        if (nt instanceof Reservoir) {
            return "Reservoir: " + nt.getName();
        }
        if (nt instanceof ComputationPoint) {
            return "Computation Point: " + nt.getName();
        }
        if (nt instanceof ImpactArea) {
            return "Impact Area: " + nt.getName();
        }
        if (nt instanceof Diversion) {
            return "Diversion: " + nt.getName();
        }
        if (nt instanceof Levee) {
            return "Levee: " + nt.getName();
        }
        if (nt instanceof ChannelMod) {
            return "Channel Modification: " + nt.getName();
        }
        if (nt instanceof StoragePool) {
            return "Storage Pool: " + nt.getName();
        }
        if (nt instanceof OtherProject) {
            return "Project: " + nt.getName();
        }
        return null;
    }

    @Override
    public void updateReservoirDiversions(Reservoir reservoir, int streamId) {
        if (reservoir == null || streamId < 0) {
            return;
        }
        Vector<StreamSegment> v = reservoir.getStreamSegmentVector();
        if (v == null) {
            return;
        }
        StreamSegment ss = null;
        boolean found = false;
        for (int i = 0; i < v.size(); ++i) {
            ss = v.get(i);
            if (ss == null || ss.streamIndex != streamId) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        DefaultDataList wdl = (DefaultDataList)this._study.getDataList().getCommonDataListContainer().getCommonDataList(Diversion.class.getName());
        DataStruct[] dobjs = wdl.getObjectArray();
        for (int i = 0; i < dobjs.length; ++i) {
            double station;
            Node node;
            Diversion div = (Diversion)dobjs[i];
            if (div.getReservoirId() == reservoir.getId() && (node = div.getUpstreamNode()) != null && node.getStreamIndex() == streamId && (station = node.getStreamStation()) >= ss.downstreamStation && !(station <= ss.upstreamStation)) continue;
        }
    }

    @Override
    public boolean isWriteLocked() {
        ClientMode mode = ClientApp.frame().getCurrentMode();
        if (mode == null) {
            return false;
        }
        if (mode.hasWriteLock((MapGlyph)this)) {
            return true;
        }
        if (mode instanceof WatershedConfigMode) {
            WatershedConfigMode wcm = (WatershedConfigMode)mode;
            wcm.editConfiguration(true);
            return wcm.hasWriteLock(this);
        }
        return false;
    }

    public String[] getNewProjectName(String title, String projectClassType) {
        String[] info;
        NewCompPtDialog dlg;
        if (ComputationPoint.class.getName().equals(projectClassType)) {
            dlg = new NewCompPtDialog((Frame)AppDaddy.getFrame(), true);
            CommonDataList layerList = this._study.getCommonDataListContainer().getCommonDataList(ComputationPointLayer.class.getName());
            dlg.setComputationPointLayers(layerList);
            for (int i = 0; i < this._ccpVisibleLayers.size(); ++i) {
                ComputationPointLayer layer = this._ccpVisibleLayers.get(i);
                if (layer.isDefaultLayer()) continue;
                dlg.setSelectedComputationPointLayer(layer);
                break;
            }
        } else {
            dlg = new NameDialog((Frame)AppDaddy.getFrame(), true);
        }
        dlg.setName("");
        dlg.setDescription("");
        dlg.setTitle(title);
        if (projectClassType != null) {
            DefaultDataList list = (DefaultDataList)ClientApp.Workspace().getDataListContainer().getDataList(projectClassType);
            if (list == null) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("getNewProjectName: Failed to get DataList for " + projectClassType);
                return null;
            }
            Vector listOfNames = list.getNamesVector();
            dlg.setExistingNames(listOfNames);
        }
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return null;
        }
        if (dlg instanceof NewCompPtDialog) {
            info = new String[3];
            ComputationPointLayer layout = dlg.getComputationPointLayout();
            if (layout != null) {
                info[2] = layout.getName();
            }
        } else {
            info = new String[]{dlg.getName(), dlg.getDescription()};
        }
        return info;
    }

    public StreamAlignmentGlyph getStreamAlignmentGlyph() {
        return (StreamAlignmentGlyph)this._mapPanel.findGlyphOfClass(StreamAlignmentGlyph.class.getName());
    }

    protected void init() {
        this._debug = ((MarkingClassLogger.Api)MAP_PROP_LOGGER.atFine()).isEnabled();
        super.init();
    }

    public void setComputationLayerOn(ComputationPointLayer ccpl, boolean selected) {
        if (ccpl == null) {
            return;
        }
        if (selected) {
            if (this._ccpVisibleLayers.contains((Object)ccpl)) {
                return;
            }
            this._ccpVisibleLayers.add(ccpl);
        } else {
            this._ccpVisibleLayers.remove((Object)ccpl);
        }
        this._mapPanel.paintMap();
    }

    @Override
    public List<ComputationPointLayer> getComputationPointLayers() {
        return this._ccpVisibleLayers;
    }

    static {
        LayerSelectionFactory.addMapping((String)StudySystemGlyph.class.getName(), (String)StudySystemGlyphSelection.class.getName());
        MAP_PROP_LOGGER = MarkingClassLogger.forMarkingClass(MapPropLoggingMarker.class);
        LOGGER = FluentLogger.forEnclosingClass();
        _angle = new double[]{0.0, 0.7853981633974483, 1.5707963267948966, 2.356194490192345, Math.PI, 3.9269908169872414, 4.71238898038469, 5.497787143782138, Math.PI};
        _impactImage = null;
        _impactImageNS = null;
        _tsImage = null;
        _selTsImage = null;
        _otherProjImage = null;
        _selOtherProjImage = null;
        stationIconWidth = 25;
    }

    private class Diamond
    extends Path2D.Double {
        public Diamond(double width, double height) {
            this.moveTo(0.0, height / 2.0);
            this.lineTo(width / 2.0, 0.0);
            this.lineTo(width, height / 2.0);
            this.lineTo(width / 2.0, height);
            this.closePath();
        }
    }

    private class HalfDiamondLeft
    extends Path2D.Double {
        public HalfDiamondLeft(double width, double height) {
            this.moveTo(0.0, height / 2.0);
            this.lineTo(width / 2.0, 0.0);
            this.lineTo(width / 2.0, height);
            this.closePath();
        }
    }

    private class HalfDiamondRight
    extends Path2D.Double {
        public HalfDiamondRight(double width, double height) {
            this.moveTo(width / 2.0, 0.0);
            this.lineTo(width, height / 2.0);
            this.lineTo(width / 2.0, height);
            this.closePath();
        }
    }

    private class Circle
    extends Path2D.Double {
        public Circle(double radius) {
            for (int i = 0; i <= 360; ++i) {
                double x = radius * Math.cos(Math.toRadians(i));
                double y = radius * Math.sin(Math.toRadians(i));
                if (i == 0) {
                    this.moveTo(x, y);
                    continue;
                }
                this.lineTo(x, y);
            }
            this.closePath();
        }
    }
}

