/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.appInterface.AppDaddy;
import hec.client.RenameDlg;
import hec.clientapp.client.AiShapeFileSelector;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.client.HecClientFrame;
import hec.clientapp.model.DataListContainer;
import hec.clientapp.model.Manager;
import hec.clientapp.model.StreamAlignment;
import hec.clientapp.supplemental.SupplementalRmiWorkspace;
import hec.clientapp.supplemental.client.ProgramOrderJDialog;
import hec.event.DataListEvent;
import hec.event.DataListListener;
import hec.gui.AbstractEditorPanel;
import hec.io.FileLock;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.map.ButtonGifStrings;
import hec.map.LocalPt;
import hec.map.MapGlyph;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.MapToolPanel;
import hec.map.MousePanAdapter;
import hec.map.MouseZoomAdapter;
import hec.map.PointerMouseAdapter;
import hec.map.WorldPt;
import hec.map.aishape.AiShapeGlyph;
import hec.map.aishape.stream.ShapeFileSelector;
import hec.map.aishape.stream.ShapeStreamAlignmentDialog;
import hec.map.aishape.stream.StreamAlignmentToShapefile;
import hec.map.appInterface.MapApplicationFrame;
import hec.map.importer.ShapeSource;
import hec.map.streamAlignment.StreamAlignmentAdapter;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.map.streamAlignment.StreamEditor;
import hec.map.streamAlignment.StreamJunctionEditor;
import hec.map.streamAlignment.StreamModule;
import hec.map.streamAlignment.StreamNodeAdapter;
import hec.model.CommonDataList;
import hec.model.CommonDataListContainer;
import hec.model.DataList;
import hec.model.DataObject;
import hec.model.DataStruct;
import hec.model.StreamElement;
import hec.model.StreamNode;
import hec.watershed.client.CompPtLayerEditor;
import hec.watershed.client.ComputationPointPanel;
import hec.watershed.client.ComputationPointReport;
import hec.watershed.client.ConditionEditor;
import hec.watershed.client.ConditionListContainer;
import hec.watershed.client.ConditionNotesEditor;
import hec.watershed.client.ExportStudyProjectsDialog;
import hec.watershed.client.ImpactAreaEditor;
import hec.watershed.client.ImpactAreaLocationsEditor;
import hec.watershed.client.ProjectEditor;
import hec.watershed.client.ProjectEditorPanelFactory;
import hec.watershed.client.ProjectNotesJDialog;
import hec.watershed.client.ProjectsListEditor;
import hec.watershed.client.ReportsFrame;
import hec.watershed.client.StationEditorDialog;
import hec.watershed.client.StationWrapper;
import hec.watershed.client.StudyChannelModMouseAdapter;
import hec.watershed.client.StudyComputationPointMouseAdapter;
import hec.watershed.client.StudyDiversionMouseAdapter;
import hec.watershed.client.StudyImpactAreaMouseAdapter;
import hec.watershed.client.StudyLeveeMouseAdapter;
import hec.watershed.client.StudyMapSelectionEditor;
import hec.watershed.client.StudyOffChannelMouseAdapter;
import hec.watershed.client.StudyOtherProjectMouseAdapter;
import hec.watershed.client.StudyPropertiesEditor;
import hec.watershed.client.StudyResMouseAdapter;
import hec.watershed.client.StudySystemGlyph;
import hec.watershed.client.WatershedDataEditor;
import hec.watershed.client.WatershedDisplayMode;
import hec.watershed.importer.ccp.ImportCCPSDialog;
import hec.watershed.map.StationMouseTool;
import hec.watershed.map.impactArea.ImpactAreaToShapefile;
import hec.watershed.map.impactArea.ShapeImpactAreaDialog;
import hec.watershed.model.ChannelMod;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ComputationPointDataList;
import hec.watershed.model.ComputationPointHolder;
import hec.watershed.model.ComputationPointLayer;
import hec.watershed.model.ComputationPointLayerDataList;
import hec.watershed.model.Condition;
import hec.watershed.model.ConditionContainer;
import hec.watershed.model.ConditionDataList;
import hec.watershed.model.Diversion;
import hec.watershed.model.ImpactArea;
import hec.watershed.model.Levee;
import hec.watershed.model.OtherProject;
import hec.watershed.model.Project;
import hec.watershed.model.Reservoir;
import hec.watershed.model.Station;
import hec.watershed.model.StationSet;
import hec.watershed.model.StationSetDataList;
import hec.watershed.model.StationSetDataObject;
import hec.watershed.model.StoragePool;
import hec.watershed.model.Study;
import hec.watershed.model.StudyDataList;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import mil.army.usace.hec.rmi.client.FileLockInfoJDialog;
import mil.army.usace.hec.rmi.client.RmiFileDialog;
import mil.army.usace.hec.rmi.csinterface.CallBackInterface;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.io.HecFileImpl;
import mil.army.usace.hec.rmi.security.HecSecurityManager;
import mil.army.usace.hec.rmi.server.RmiFileCallBackImpl;
import rma.swing.ClosableDialog;
import rma.swing.DefaultJPanel;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJFrame;
import rma.swing.RmaJMenuLabel;
import rma.swing.RmaJObjectCheckBoxMenuItem;
import rma.swing.RmaJObjectMenuItem;
import rma.swing.RmaJPopupMenu;
import rma.swing.event.ReflectMultiListener;
import rma.swing.list.RmaListModel;
import rma.util.RMAIO;
import rma.util.RMASort;

public class WatershedConfigMode
extends ClientMode
implements ActionListener,
CallBackInterface,
WatershedDisplayMode,
DataListListener,
ConditionListContainer,
StreamModule {
    protected static final int TIME_SERIES_ICON_TOOL_BIT = 0;
    protected static final int STREAM_TOOL_BIT = 1;
    protected static final int STREAM_NODE_TOOL_BIT = 2;
    protected static final int RESERVOIR_TOOL_BIT = 3;
    protected static final int LEVEE_TOOL_BIT = 4;
    protected static final int DIVERSION_TOOL_BIT = 5;
    protected static final int CHANNEL_MOD_TOOL_BIT = 6;
    protected static final int OFF_CHANNEL_TOOL_BIT = 7;
    protected static final int OTHER_PROJ_TOOL_BIT = 8;
    protected static final int IMPACT_TOOL_BIT = 9;
    protected static final int COMP_POINT_TOOL_BIT = 10;
    protected static final int STATION_SET_TOOL_BIT = 11;
    protected StreamAlignment _alignment = null;
    protected Study _study;
    boolean _first = true;
    ConditionDataList _conditionList;
    RmaJComboBox _conditioncombo;
    ProjectsListEditor _ple;
    protected ConditionEditor _conditionEditor;
    ImpactAreaLocationsEditor _iale;
    ConditionNotesEditor _cne;
    ImpactAreaEditor _iae;
    ProjectNotesJDialog _notesDialog;
    ComputationPointReport _cpr;
    WatershedDataEditor _dataDialog;
    StreamEditor _streamEditor;
    StudyMapSelectionEditor _compPtEditor;
    Hashtable _projectEditors = new Hashtable();
    protected JCheckBoxMenuItem _editConfigMenuItem;
    protected boolean _showIconToolbarThisApp = false;
    JCheckBoxMenuItem _editStreamsMenuItem;
    ImageIcon _streamLockIcon;
    ImageIcon _streamUnlockIcon;
    JToggleButton _studyLockButton;
    JToggleButton _streamLockButton;
    JMenuItem _updateCompPtMenuItem;
    JMenuItem _saveConfigurationMenuItem;
    RmiFileCallBackImpl _studyCallBack;
    RmiFileCallBackImpl _streamCallBack;
    boolean _streamReadLocked = false;
    boolean _studyReadLocked = false;
    ReflectMultiListener _listener;
    protected RmiFileCallBackImpl[] _tsLocationCallback = new RmiFileCallBackImpl[1];
    protected JMenu _modelAltMenu;
    private JMenuItem _editCompPtLayersMenuItem;
    private CompPtLayerEditor _ccpLayerEditor;
    private JMenu _ccpLayersMenu;
    ConditionComboListener _conditionComboListener = new ConditionComboListener();
    private StreamJunctionEditor _sjeDialog;

    public WatershedConfigMode(HecClientFrame frame) {
        super(frame, "watershedConfigModule");
        this._streamUnlockIcon = RmaImage.getImageIcon((String)"Images/smallBlueUnLock.gif");
        this._streamLockIcon = RmaImage.getImageIcon((String)"Images/smallBlueLock.gif");
        this._unlockIcon = RmaImage.getImageIcon((String)"Images/smallUnLock.gif");
        this._listener = new ReflectMultiListener();
        this.createModeMenu();
        this.createModePanel();
        this.createModeToolbar();
        this.createFrameToolBar();
        frame.scriptEditor.setVisible(true);
    }

    protected void createModeMenu() {
        JMenuItem menuItem;
        this.setMenuName("Watershed Setup");
        JMenu menu = new JMenu("Watershed");
        menu.setMnemonic('w');
        BitSet bitSet = this.getAvailableOptions();
        if (this.allowProgramSetup()) {
            menuItem = new JMenuItem("Program Sequence...", 80);
            menuItem.setName("ProgramOrder");
            menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "programOrder"));
            menu.add(menuItem);
            this._modelAltMenu = new JMenu("Add-in Models");
            menu.add(this._modelAltMenu);
        }
        menuItem = new JMenuItem("Configuration Editor...", 67);
        menuItem.setName("conditionEditor");
        menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "editCondition"));
        menu.add(menuItem);
        if (bitSet.get(10)) {
            this._updateCompPtMenuItem = new JMenuItem("Update Computation Points", 85);
            this._updateCompPtMenuItem.setName("updatecomputationpoints");
            this._updateCompPtMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._updateCompPtMenuItem, "updateComputationPoints"));
            menu.add(this._updateCompPtMenuItem);
        }
        JMenu menu2 = new JMenu("Import");
        menu2.setMnemonic('I');
        if (bitSet.get(1)) {
            menuItem = new JMenuItem("Stream Alignment ...", 97);
            menuItem.setName("importstreamalignment");
            menuItem.addActionListener(this);
            menu2.add(menuItem);
        }
        if (bitSet.get(9)) {
            menuItem = new JMenuItem("Impact Areas ...", 105);
            menuItem.setName("importimpactareas");
            menuItem.addActionListener(this);
            menu2.add(menuItem);
        }
        if (bitSet.get(10)) {
            menuItem = new JMenuItem("Computation Points ...", 67);
            menuItem.setName("importcomputationpoint");
            menuItem.addActionListener(this);
            menu2.add(menuItem);
        }
        if (menu2.getMenuComponentCount() > 0) {
            menu.add(menu2);
        }
        menu2 = new JMenu("Export");
        menu2.setMnemonic('E');
        if (bitSet.get(1)) {
            menuItem = new JMenuItem("Stream Alignment ...", 97);
            menuItem.setName("exportstreamalignment");
            menuItem.addActionListener(this);
            menu2.add(menuItem);
        }
        if (bitSet.get(9) && Boolean.getBoolean("WatershedConfig.HasIAExporter")) {
            menuItem = new JMenuItem("Impact Areas ...", 105);
            menuItem.setName("exportimpactareas");
            menuItem.addActionListener(this);
            menu2.add(menuItem);
        }
        menuItem = new JMenuItem("Configuration Elements ...", 67);
        menuItem.setName("exportProjects");
        menuItem.addActionListener(this);
        menu2.add(menuItem);
        if (menu2.getMenuComponentCount() > 0) {
            menu.add(menu2);
        }
        menu.addSeparator();
        this._saveConfigurationMenuItem = new JMenuItem("Save Configuration", 83);
        this._saveConfigurationMenuItem.setName("saveConfiguration");
        this._saveConfigurationMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._saveConfigurationMenuItem, "saveConfiguration"));
        menu.add(this._saveConfigurationMenuItem);
        this.addMenu(menu);
        menu = new JMenu("Reports");
        menu.setMnemonic('R');
        menu2 = new JMenu("General Reports");
        menu2.setMnemonic('g');
        if (bitSet.get(1)) {
            menuItem = new JMenuItem("List of Streams", 115);
            menuItem.setName("listofstreams");
            menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "displayStreamList"));
            menu.add(menuItem);
        }
        if (bitSet.get(9)) {
            menuItem = new JMenuItem("List of Impact Areas", 105);
            menuItem.setName("listofimpactareas");
            menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "displayImpactAreaList"));
            menu.add(menuItem);
        }
        menuItem = new JMenuItem("List of All Configurations", 99);
        menuItem.setName("listofconditions");
        menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "displayConditionsList"));
        menu.add(menuItem);
        if (bitSet.get(10)) {
            menuItem = new JMenuItem("List of Computation Points", 105);
            menuItem.setName("listofcomputationpoints");
            menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "displayComputationPointList"));
            menu.add(menuItem);
        }
        JMenu projectsMenu = new JMenu("Projects");
        projectsMenu.setMnemonic('p');
        menu.add(projectsMenu);
        menuItem = new JMenuItem("All", 97);
        menuItem.setName("listofprojects");
        menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "displayProjectsList"));
        projectsMenu.add(menuItem);
        if (bitSet.get(4)) {
            menuItem = new JMenuItem("List of All Levees", 108);
            menuItem.setName("listofprojects");
            menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "displayLeveeList"));
            projectsMenu.add(menuItem);
        }
        if (bitSet.get(3)) {
            menuItem = new JMenuItem("List of All Reservoirs", 114);
            menuItem.setName("listofprojects");
            menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "displayReservoirList"));
            projectsMenu.add(menuItem);
        }
        if (bitSet.get(5)) {
            menuItem = new JMenuItem("List of All Diversions", 100);
            menuItem.setName("listofprojects");
            menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "displayDiversionList"));
            projectsMenu.add(menuItem);
        }
        if (bitSet.get(6)) {
            menuItem = new JMenuItem("List of All Channel Modificaitons", 99);
            menuItem.setName("listofprojects");
            menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "displayChannelModList"));
            projectsMenu.add(menuItem);
        }
        if (bitSet.get(7)) {
            menuItem = new JMenuItem("List of All Off Channel Storage Areas", 99);
            menuItem.setName("listofprojects");
            menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "displayOffChannelList"));
            projectsMenu.add(menuItem);
        }
        if (bitSet.get(8)) {
            menuItem = new JMenuItem("List of All Other Projects", 99);
            menuItem.setName("listofprojects");
            menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "displayOtherProjectList"));
            projectsMenu.add(menuItem);
        }
        menu2 = new JMenu("Data Management Reports");
        menu2.setVisible(false);
        menu2.setMnemonic('D');
        menu.add(menu2);
        menuItem = new JMenuItem("By Watershed", 119);
        menuItem.setName("watershedsummary");
        menuItem.addActionListener(this);
        menu2.add(menuItem);
        menuItem = new JMenuItem("By Configuration", 99);
        menuItem.setName("conditionsummary");
        menuItem.addActionListener(this);
        menu2.add(menuItem);
        this.addMenu(menu);
        menuItem = new JMenuItem("Watershed Properties...", 119);
        menuItem.setName("watersheddata");
        menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "editWatershedData"));
        this.addEditMenuItem(menuItem);
        if (bitSet.get(9)) {
            menuItem = new JMenuItem("Impact Areas ...");
            menuItem.setMnemonic('A');
            menuItem.setName("editimpactarea");
            menuItem.addActionListener(this);
            this.addEditMenuItem(menuItem);
        }
        menuItem = new JMenuItem("Projects...", 112);
        menuItem.setName("projectlisteditor");
        menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "editProjectList"));
        this.addEditMenuItem(menuItem);
        menuItem = new JMenuItem("Drawing Properties...", 100);
        menuItem.setName("drawingProperties");
        menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "displayDrawingPropertiesDialog"));
        this.addEditMenuItem(menuItem);
        this._editCompPtLayersMenuItem = new JMenuItem("Computation Point Layers");
        this._editCompPtLayersMenuItem.setName("editCompPtLayers");
        this._editCompPtLayersMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._editCompPtLayersMenuItem, "editCompPtLayersAction"));
        this.addEditMenuItem(this._editCompPtLayersMenuItem);
        this._editConfigMenuItem = new JCheckBoxMenuItem("Allow Editing", true);
        this._editStreamsMenuItem = new JCheckBoxMenuItem("Allow Stream Alignment Editing", true);
        if (HecSecurityManager.getSecurityManager().checkPermission("watershedConfigModule", "configure") == 4) {
            this._editConfigMenuItem.setMnemonic('e');
            this._editConfigMenuItem.setName("editconfiguration");
            this._editConfigMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._editConfigMenuItem, "editConfiguration"));
            this._editStreamsMenuItem.setMnemonic('e');
            this._editStreamsMenuItem.setName("editstreamsconfiguration");
            this._editStreamsMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._editStreamsMenuItem, "editStreamConfiguration"));
        }
        this._ccpLayersMenu = new JMenu("Computation Point Layer");
        this._ccpLayersMenu.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._ccpLayersMenu, "editCompPtLayersAction"));
        this.addViewMenuItem(this._ccpLayersMenu);
        Action[] actions = ClientApp.app().getModeToolBarActions(this.getClass().getName());
        if (actions != null) {
            for (int i = 0; i < actions.length; ++i) {
                this.addToolsMenuItem(new JMenuItem(actions[i]));
            }
        }
    }

    public void createFrameToolBar() {
        JLabel label = new JLabel("          ");
        this.addToolBarComponent(label);
        label = new JLabel("Configuration");
        this.addToolBarComponent(label);
        this._conditioncombo = new RmaJComboBox();
        this._conditioncombo.addItemListener((ItemListener)this._conditionComboListener);
        Dimension d = this._conditioncombo.getPreferredSize();
        d.width = 125;
        this._conditioncombo.setMinimumSize(d);
        this._conditioncombo.setPreferredSize(d);
        this.addToolBarComponent((JComponent)this._conditioncombo);
        this._studyLockButton = new JToggleButton((Icon)this._unlockIcon, true){

            @Override
            public String getToolTipText(MouseEvent e) {
                return WatershedConfigMode.this.getConfigToolTipText("Configuration Locked Status");
            }
        };
        Insets insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this._studyLockButton.setMargin(insets);
        this._studyLockButton.setSelectedIcon(this._lockIcon);
        this._studyLockButton.setToolTipText("Configuration Locked Status");
        this._streamLockButton = new JToggleButton(this._streamUnlockIcon);
        this._streamLockButton.setMargin(insets);
        this._streamLockButton.setSelectedIcon(this._streamLockIcon);
        this._streamLockButton.setToolTipText("Stream Configuration Locked Status");
        if (HecSecurityManager.getSecurityManager().checkPermission("watershedConfigModule", "configure") == 4) {
            // empty if block
        }
        this._streamLockButton.setModel(this._editStreamsMenuItem.getModel());
        this._studyLockButton.setModel(this._editConfigMenuItem.getModel());
    }

    protected void createModePanel() {
    }

    protected void createModeToolbar() {
        BitSet options;
        this.setMapTools(new MapToolPanel(this._frame.getMapPanel()));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 11;
        gbc.fill = 0;
        JToggleButton button = new JToggleButton();
        ButtonGifStrings bgstr = new ButtonGifStrings();
        bgstr.up = "Images/Point.gif";
        bgstr.down = "Images/Point.gif";
        bgstr.over = "Images/Point.gif";
        bgstr.on = "Images/Point.gif";
        bgstr.toolTipText = "Pointer Tool";
        bgstr.borderPainted = true;
        Class<? extends MapMouseAdapter> adapterClass = this.getPointerMouseToolClass();
        if (adapterClass != null) {
            bgstr.adapter = adapterClass.getName();
            this._mapTools.addToolButton(button, bgstr, gbc);
        }
        button = new JToggleButton();
        bgstr = new ButtonGifStrings();
        bgstr.up = "Images/ZoomUp.gif";
        bgstr.down = "Images/ZoomDown.gif";
        bgstr.over = "Images/ZoomUp.gif";
        bgstr.on = "Images/ZoomDown.gif";
        bgstr.toolTipText = "Zoom Tool";
        bgstr.borderPainted = true;
        bgstr.adapter = MouseZoomAdapter.class.getName();
        this._mapTools.addToolButton(button, bgstr, gbc);
        if (this.hasPanMouseAdapter()) {
            button = new JToggleButton();
            bgstr = MousePanAdapter.buildDefaultButtonGifStrings();
            gbc.insets = new Insets(0, 0, 0, 0);
            this._mapTools.addToolButton(button, bgstr, gbc);
        }
        if ((options = this.getAvailableOptions()).get(1)) {
            button = new JToggleButton();
            bgstr = new ButtonGifStrings();
            bgstr.up = "Images/Icons/stream.gif";
            bgstr.down = "Images/Icons/stream.gif";
            bgstr.over = "Images/Icons/stream.gif";
            bgstr.on = "Images/Icons/stream.gif";
            bgstr.adapter = StreamAlignmentAdapter.class.getName();
            bgstr.toolTipText = "Stream Alignment Tool";
            bgstr.borderPainted = true;
            if (this.noOptionsAfter(options, 1)) {
                gbc.weighty = 1.0;
            }
            gbc.insets = new Insets(10, 0, 0, 0);
            this._mapTools.addToolButton(button, bgstr, gbc);
        }
        if (options.get(2)) {
            button = new JToggleButton();
            bgstr = new ButtonGifStrings();
            bgstr.up = "Images/Icons/streamNode.gif";
            bgstr.down = "Images/Icons/streamNode.gif";
            bgstr.over = "Images/Icons/streamNode.gif";
            bgstr.on = "Images/Icons/streamNode.gif";
            bgstr.toolTipText = "Stream Node Tool";
            bgstr.adapter = StreamNodeAdapter.class.getName();
            bgstr.borderPainted = true;
            if (this.noOptionsAfter(options, 2)) {
                gbc.weighty = 1.0;
            }
            gbc.insets = new Insets(0, 0, 0, 0);
            this._mapTools.addToolButton(button, bgstr, gbc);
        }
        if (options.get(3)) {
            button = new JToggleButton();
            bgstr = new ButtonGifStrings();
            bgstr.up = "Images/Icons/rss/reservoir.gif";
            bgstr.down = "Images/Icons/rss/reservoirSel.gif";
            bgstr.over = "Images/Icons/rss/reservoir.gif";
            bgstr.on = "Images/Icons/rss/reservoirSel.gif";
            bgstr.adapter = StudyResMouseAdapter.class.getName();
            gbc.insets = new Insets(10, 0, 0, 0);
            bgstr.toolTipText = "Reservoir Tool";
            if (this.noOptionsAfter(options, 3)) {
                gbc.weighty = 1.0;
            }
            bgstr.borderPainted = true;
            this._mapTools.addToolButton(button, bgstr, gbc);
        }
        if (options.get(4)) {
            button = new JToggleButton();
            bgstr = new ButtonGifStrings();
            bgstr.up = "Images/Icons/fdaLevee.gif";
            bgstr.down = "Images/Icons/fdaLeveeSel.gif";
            bgstr.over = "Images/Icons/fdaLevee.gif";
            bgstr.on = "Images/Icons/fdaLeveeSel.gif";
            bgstr.adapter = StudyLeveeMouseAdapter.class.getName();
            gbc.insets = new Insets(0, 0, 0, 0);
            bgstr.toolTipText = "Levee Tool";
            if (this.noOptionsAfter(options, 4)) {
                gbc.weighty = 1.0;
            }
            bgstr.borderPainted = true;
            this._mapTools.addToolButton(button, bgstr, gbc);
        }
        if (options.get(5)) {
            button = new JToggleButton();
            bgstr = new ButtonGifStrings();
            bgstr.up = "Images/Icons/rss/diversion.gif";
            bgstr.down = "Images/Icons/rss/diversion.gif";
            bgstr.over = "Images/Icons/rss/diversion.gif";
            bgstr.on = "Images/Icons/rss/diversion.gif";
            bgstr.adapter = StudyDiversionMouseAdapter.class.getName();
            bgstr.toolTipText = "Diversion Tool";
            if (this.noOptionsAfter(options, 5)) {
                gbc.weighty = 1.0;
            }
            bgstr.borderPainted = true;
            this._mapTools.addToolButton(button, bgstr, gbc);
        }
        if (options.get(6)) {
            button = new JToggleButton();
            bgstr = new ButtonGifStrings();
            bgstr.up = "Images/Icons/channelMod.gif";
            bgstr.down = "Images/Icons/channelMod.gif";
            bgstr.over = "Images/Icons/channelMod.gif";
            bgstr.on = "Images/Icons/channelMod.gif";
            bgstr.adapter = StudyChannelModMouseAdapter.class.getName();
            gbc.insets = new Insets(0, 0, 0, 0);
            bgstr.toolTipText = "Channel Modification Tool";
            if (this.noOptionsAfter(options, 6)) {
                gbc.weighty = 1.0;
            }
            bgstr.borderPainted = true;
            this._mapTools.addToolButton(button, bgstr, gbc);
        }
        if (options.get(7)) {
            button = new JToggleButton();
            bgstr = new ButtonGifStrings();
            bgstr.up = "Images/Icons/offChannel.gif";
            bgstr.down = "Images/Icons/offChannelSel.gif";
            bgstr.over = "Images/Icons/offChannel.gif";
            bgstr.on = "Images/Icons/offChannelSel.gif";
            bgstr.toolTipText = "Off Channel Storage Tool";
            bgstr.adapter = StudyOffChannelMouseAdapter.class.getName();
            if (this.noOptionsAfter(options, 7)) {
                gbc.weighty = 1.0;
            }
            bgstr.borderPainted = true;
            this._mapTools.addToolButton(button, bgstr, gbc);
        }
        if (options.get(8)) {
            button = new JToggleButton();
            bgstr = new ButtonGifStrings();
            bgstr.up = "Images/Icons/otherProj.gif";
            bgstr.down = "Images/Icons/otherProj.gif";
            bgstr.over = "Images/Icons/otherProj.gif";
            bgstr.on = "Images/Icons/otherProj.gif";
            bgstr.toolTipText = "Other Project Tool";
            bgstr.adapter = StudyOtherProjectMouseAdapter.class.getName();
            if (this.noOptionsAfter(options, 8)) {
                gbc.weighty = 1.0;
            }
            bgstr.borderPainted = true;
            this._mapTools.addToolButton(button, bgstr, gbc);
        }
        if (options.get(9)) {
            button = new JToggleButton();
            bgstr = new ButtonGifStrings();
            bgstr.up = "Images/Icons/impact.gif";
            bgstr.down = "Images/Icons/impactSel.gif";
            bgstr.over = "Images/Icons/impact.gif";
            bgstr.on = "Images/Icons/impactSel.gif";
            bgstr.toolTipText = "Impact Area Tool";
            bgstr.adapter = StudyImpactAreaMouseAdapter.class.getName();
            if (this.noOptionsAfter(options, 9)) {
                gbc.weighty = 1.0;
            }
            bgstr.borderPainted = true;
            gbc.insets = new Insets(20, 0, 0, 0);
            this._mapTools.addToolButton(button, bgstr, gbc);
        }
        if (options.get(10)) {
            button = new JToggleButton();
            bgstr = new ButtonGifStrings();
            bgstr.up = "Images/Icons/compPoint.gif";
            bgstr.down = "Images/Icons/compPoint.gif";
            bgstr.over = "Images/Icons/compPoint.gif";
            bgstr.on = "Images/Icons/compPoint.gif";
            bgstr.toolTipText = "Computation Point Tool";
            bgstr.adapter = StudyComputationPointMouseAdapter.class.getName();
            if (this.noOptionsAfter(options, 10)) {
                gbc.weighty = 1.0;
            }
            bgstr.borderPainted = true;
            gbc.insets = new Insets(10, 0, 0, 0);
            this._mapTools.addToolButton(button, bgstr, gbc);
        }
        if (options.get(11)) {
            button = new JToggleButton();
            bgstr = new StationMouseTool();
            gbc.weighty = 0.0;
            bgstr.borderPainted = true;
            gbc.insets = new Insets(10, 0, 0, 0);
            gbc.weighty = 1.0;
            this._mapTools.addToolButton(button, bgstr, gbc);
        }
        this._mapTools.forceSelectButton(0);
    }

    protected boolean hasPanMouseAdapter() {
        return true;
    }

    protected Class<? extends MapMouseAdapter> getPointerMouseToolClass() {
        return PointerMouseAdapter.class;
    }

    protected BitSet getAvailableOptions() {
        BitSet bitSet = new BitSet(12);
        int start = 1;
        if (Boolean.getBoolean("WatershedSetupModule.HasTsIcons")) {
            start = 0;
        }
        for (int i = start; i < 12; ++i) {
            bitSet.set(i);
        }
        return bitSet;
    }

    protected boolean noOptionsAfter(BitSet options, int opt) {
        for (int i = opt + 1; i < options.size(); ++i) {
            if (!options.get(i)) continue;
            return false;
        }
        return true;
    }

    public String getScriptableName() {
        return "Watershed Setup";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof RmaJObjectMenuItem) {
            RmaJObjectMenuItem item = (RmaJObjectMenuItem)obj;
            Object mObj = item.getObject();
            String label = item.getText();
            if (mObj instanceof StreamElement) {
                StreamElement elem = (StreamElement)mObj;
                if (label.startsWith("Edit") || label.startsWith("View")) {
                    this.editStreamElement(elem);
                } else if (label.startsWith("Delete")) {
                    this.deleteStreamElement(elem);
                } else if (label.startsWith("Rename")) {
                    this.renameStreamElement(elem);
                } else if (label.startsWith("Insert Stream Node")) {
                    this.insertStreamNode(elem, this.getPopupPoint());
                } else if (label.equals("Disconnect Upstream")) {
                    this.disconnectUpstream(elem);
                } else if (label.equals("Disconnect Downstream")) {
                    this.disconnectDownstream(elem);
                } else if (label.equals("Reverse Direction")) {
                    this.reverseStreamElement(elem);
                }
            } else if (mObj instanceof DataObject) {
                DataObject dobj = (DataObject)mObj;
                if (label.startsWith("Configuration Notes") && mObj instanceof ImpactArea) {
                    this.editConditionNotes(dobj);
                } else if (label.startsWith("Rename")) {
                    this.renameObject(label, dobj);
                } else if (label.startsWith("Delete")) {
                    this.deleteObject(dobj, label);
                } else if (label.startsWith("Edit") || label.startsWith("View")) {
                    if (label.indexOf("Impact Area") > -1) {
                        this.editImpactArea(dobj, false);
                    } else if (label.indexOf("Computation Point") > -1) {
                        this.editComputationPoint(dobj);
                    } else {
                        this.editProject(dobj);
                    }
                } else if (label.startsWith("Configuration Notes") && mObj instanceof Project) {
                    this.editProjectNotes(dobj);
                } else if (label.equals("Disconnect Outflow")) {
                    this.disconnectOutFlow((Diversion)dobj);
                } else if (label.equals("Remove from Configuration")) {
                    this.removeProjectFromCondition((NamedType)dobj);
                }
            }
        } else if (obj instanceof JMenuItem) {
            JMenuItem item = (JMenuItem)obj;
            String name = item.getName();
            String cls = item.getActionCommand();
            String label = item.getText();
            if (name.equals("editimpactarea")) {
                this.editImpactAreas();
            } else if (name.equals("importstreamalignment")) {
                this.importStreamAlignment();
            } else if (name.equals("exportstreamalignment")) {
                this.exportStreamAlignment();
            } else if (name.equals("importimpactareas")) {
                this.importImpactAreas();
            } else if (name.equals("importcomputationpoint")) {
                this.importComputationPoints();
            } else if (name.equals("exportimpactareas")) {
                this.exportImpactAreas();
            } else if ("editJunction".equals(cls)) {
                this.editStreamJunction();
            } else if ("editNode".equals(cls)) {
                this.editStreamNode();
            } else if ("deleteNode".equals(cls)) {
                this.deleteStreamNode();
            } else if ("exportProjects".equals(name)) {
                this.exportStudyProjects();
            }
        }
    }

    private void exportStudyProjects() {
        ExportStudyProjectsDialog dlg = new ExportStudyProjectsDialog((Frame)this._frame, true);
        dlg.setVisible(true);
    }

    private void deleteStreamNode() {
        MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
        StreamAlignmentGlyph glyph = (StreamAlignmentGlyph)frame.getMapPanel().findGlyphOfClass(StreamAlignmentGlyph.class.getName());
        if (glyph == null) {
            return;
        }
        StreamNode node = (StreamNode)this.getPopupObject();
        glyph.deleteNode(node, true);
    }

    private void editStreamJunction() {
        MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
        StreamAlignmentGlyph glyph = (StreamAlignmentGlyph)frame.getMapPanel().findGlyphOfClass(StreamAlignmentGlyph.class.getName());
        if (glyph == null) {
            return;
        }
        StreamNode node = (StreamNode)this.getPopupObject();
        glyph.creatingJunctionEditingDialog(node.getJunction());
    }

    private void editStreamNode() {
        MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
        StreamAlignmentGlyph glyph = (StreamAlignmentGlyph)frame.getMapPanel().findGlyphOfClass(StreamAlignmentGlyph.class.getName());
        if (glyph == null) {
            return;
        }
        glyph.createNodeEditDialog((StreamNode)this.getPopupObject());
    }

    protected Vector<ShapeSource> getImportShapeSourceList(String msg, int ... validShapetypes) {
        AiShapeGlyph shapeGlyph = null;
        MapPanel mapPanel = this.getFrame().getMapPanel();
        Vector<ShapeSource> sourceList = new Vector<ShapeSource>();
        if (mapPanel == null) {
            return null;
        }
        List glyphVector = mapPanel.glyphList();
        for (int ii = glyphVector.size() - 1; ii >= 0; --ii) {
            Object o = glyphVector.get(ii);
            if (!(o instanceof AiShapeGlyph) || !(shapeGlyph = (AiShapeGlyph)o).isShown() || !this.isValidShapeGlyph(shapeGlyph, validShapetypes)) continue;
            sourceList.add((ShapeSource)shapeGlyph);
        }
        if (sourceList.size() > 0) {
            shapeGlyph = (AiShapeGlyph)sourceList.get(0);
        }
        if (shapeGlyph == null) {
            RMAIO.postError((Component)this.getFrame(), (String)msg);
            return null;
        }
        return sourceList;
    }

    private boolean isValidShapeGlyph(AiShapeGlyph shapeGlyph, int ... validShapeTypes) {
        int type = shapeGlyph.getMapType();
        for (int i = 0; i < validShapeTypes.length; ++i) {
            if (type != validShapeTypes[i]) continue;
            return true;
        }
        return false;
    }

    protected StreamAlignmentGlyph getStreamAlignmentGlyph() {
        MapPanel mapPanel = this.getFrame().getMapPanel();
        if (mapPanel == null) {
            return null;
        }
        List managerGlyphVector = mapPanel.managerGlyphList();
        StreamAlignmentGlyph streamGlyph = null;
        for (int ii = managerGlyphVector.size() - 1; ii >= 0; --ii) {
            Object o = managerGlyphVector.get(ii);
            if (!(o instanceof StreamAlignmentGlyph)) continue;
            streamGlyph = (StreamAlignmentGlyph)o;
            return streamGlyph;
        }
        RMAIO.postError((Component)this.getFrame(), (String)"Unable to locate Stream Alignment Glyph, cannot import.");
        return null;
    }

    private void importStreamAlignment() {
        StreamAlignmentGlyph streamGlyph;
        this.editConfiguration(true);
        AiShapeGlyph shapeGlyph = null;
        Vector<ShapeSource> sourceList = this.getImportShapeSourceList("There are no visible arc line shapefile layers, cannot import.", 3, 13);
        if (sourceList == null) {
            return;
        }
        if (sourceList.size() > 0) {
            shapeGlyph = (AiShapeGlyph)sourceList.get(0);
        }
        if (this.hasWriteLock((MapGlyph)(streamGlyph = this.getStreamAlignmentGlyph()))) {
            ShapeStreamAlignmentDialog shapeStreamAlignmentDialog = new ShapeStreamAlignmentDialog((Frame)this._frame, true, sourceList, (ShapeSource)shapeGlyph, streamGlyph, (ShapeFileSelector)new AiShapeFileSelector(new int[]{3, 13}));
            shapeStreamAlignmentDialog.setLocationRelativeTo((Component)this._frame);
            shapeStreamAlignmentDialog.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importComputationPoints() {
        AiShapeGlyph shapeGlyph = null;
        MapPanel mapPanel = this._frame.getMapPanel();
        if (mapPanel == null) {
            return;
        }
        List glyphVector = mapPanel.glyphList();
        ArrayList<ShapeSource> sourceGlyphs = new ArrayList<ShapeSource>();
        for (int ii = glyphVector.size() - 1; ii >= 0; --ii) {
            Object o = glyphVector.get(ii);
            if (!(o instanceof AiShapeGlyph) || !(shapeGlyph = (AiShapeGlyph)o).isShown() || shapeGlyph.getMapType() != 1 && shapeGlyph.getMapType() != 8 && shapeGlyph.getMapType() != 11) continue;
            sourceGlyphs.add((ShapeSource)shapeGlyph);
        }
        shapeGlyph = sourceGlyphs.size() > 0 ? (AiShapeGlyph)sourceGlyphs.get(0) : null;
        StreamAlignmentGlyph streamGlyph = null;
        List managerGlyphVector = mapPanel.managerGlyphList();
        for (int ii = managerGlyphVector.size() - 1; ii >= 0; --ii) {
            Object o = managerGlyphVector.get(ii);
            if (!(o instanceof StreamAlignmentGlyph)) continue;
            streamGlyph = (StreamAlignmentGlyph)o;
            break;
        }
        if (streamGlyph == null) {
            this._frame.setAlwaysOnTop(true);
            try {
                JOptionPane.showMessageDialog((Component)this._frame, "Unable to locate Stream Alignment Glyph, cannot import.");
            }
            finally {
                this._frame.setAlwaysOnTop(false);
            }
            return;
        }
        ComputationPointDataList cpdl = (ComputationPointDataList)ClientApp.Workspace().getDataListContainer().getDataList(ComputationPoint.class.getName());
        ImportCCPSDialog importCcpsDialog = new ImportCCPSDialog((Frame)this._frame, true, sourceGlyphs, (ShapeSource)shapeGlyph, streamGlyph, cpdl, (ShapeFileSelector)new AiShapeFileSelector(new int[]{1, 8, 11}));
        importCcpsDialog.setLocationRelativeTo((Component)this._frame);
        importCcpsDialog.setVisible(true);
    }

    private void importImpactAreas() {
        Vector<ShapeSource> sourceList;
        this.editConfiguration(true);
        AiShapeGlyph shapeGlyph = null;
        MapPanel mapPanel = this.getFrame().getMapPanel();
        if (mapPanel == null) {
            return;
        }
        StudySystemGlyph studySystemGlyph = null;
        List managerGlyphVector = mapPanel.managerGlyphList();
        for (int ii = managerGlyphVector.size() - 1; ii >= 0; --ii) {
            Object o = managerGlyphVector.get(ii);
            if (!(o instanceof StudySystemGlyph)) continue;
            studySystemGlyph = (StudySystemGlyph)o;
            break;
        }
        if ((sourceList = this.getImportShapeSourceList("There are no visible polygon shapefile layers, cannot import.", 5)) == null) {
            return;
        }
        if (sourceList.size() > 0) {
            shapeGlyph = (AiShapeGlyph)sourceList.get(0);
        }
        StreamAlignmentGlyph streamAlignmentGlyph = this.getStreamAlignmentGlyph();
        if (studySystemGlyph == null) {
            RMAIO.postError((Component)this.getFrame(), (String)"Unable to locate Study System Glyph, cannot import.");
            return;
        }
        if (this.hasWriteLock(studySystemGlyph)) {
            DataList dataList = ClientApp.Workspace().getDataListContainer().getDataList(ImpactArea.class.getName());
            ShapeImpactAreaDialog dialog = new ShapeImpactAreaDialog((JFrame)this._frame, sourceList, (CommonDataList)dataList, (ShapeSource)shapeGlyph, studySystemGlyph, streamAlignmentGlyph, (ShapeFileSelector)new AiShapeFileSelector(new int[]{3, 13}));
            dialog.setLocationRelativeTo((Component)this._frame);
            dialog.setVisible(true);
        }
    }

    private void exportStreamAlignment() {
        StreamAlignment streamAlignment;
        Identifier fileId;
        RmiFileDialog dialog = new RmiFileDialog((Frame)this.getFrame(), true);
        dialog.setSaveTitle();
        Vector<String> fileMaskVector = new Vector<String>(1);
        fileMaskVector.add("*.shp");
        dialog.setFileMask(fileMaskVector);
        dialog.setStartDir(ClientApp.Workspace().getWorkspacePath() + "/maps");
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        Identifier saveAsId = dialog.getIdentifier();
        if (saveAsId == null) {
            return;
        }
        if (saveAsId.getPath().indexOf(".shp") == -1) {
            saveAsId.setPath(saveAsId.getPath() + ".shp");
        }
        if ((fileId = ClientApp.Workspace().openRemoteFileID(saveAsId)) == null) {
            fileId = ClientApp.Workspace().newRemoteFileID(saveAsId);
        }
        if (StreamAlignmentToShapefile.exportToShapefile((StreamAlignmentIfc)(streamAlignment = this.getAlignment()), (Identifier)fileId)) {
            RMAIO.postInfo((Component)this.getFrame(), (String)("Stream Alignment exported to: " + fileId.getPath()));
        }
    }

    private void exportImpactAreas() {
        Identifier fileId;
        DataList dataList = ClientApp.Workspace().getDataListContainer().getDataList(ImpactArea.class.getName());
        if (dataList.getObjectCount() < 1) {
            RMAIO.postError((Component)this.getFrame(), (String)"There are no impact areas to export. Aborting export.");
            return;
        }
        RmiFileDialog dialog = new RmiFileDialog((Frame)this.getFrame(), true);
        dialog.setSaveTitle();
        Vector<String> fileMaskVector = new Vector<String>(1);
        fileMaskVector.add("*.shp");
        dialog.setFileMask(fileMaskVector);
        dialog.setStartDir(ClientApp.Workspace().getWorkspacePath() + "/maps");
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        Identifier saveAsId = dialog.getIdentifier();
        if (saveAsId == null) {
            return;
        }
        if (saveAsId.getPath().indexOf(".shp") == -1) {
            saveAsId.setPath(saveAsId.getPath() + ".shp");
        }
        if ((fileId = ClientApp.Workspace().openRemoteFileID(saveAsId)) == null) {
            fileId = ClientApp.Workspace().newRemoteFileID(saveAsId);
        }
        StreamAlignment streamAlignment = this.getAlignment();
        if (ImpactAreaToShapefile.exportToShapefile((Component)this.getFrame(), dataList, (StreamAlignmentIfc)streamAlignment, fileId)) {
            RMAIO.postInfo((Component)this.getFrame(), (String)("Impact Areas exported to: " + fileId.getPath()));
        }
    }

    public void resetWorkspace() {
        super.resetWorkspace();
        ClientWorkspace wksp = ClientApp.Workspace();
        if (wksp == null) {
            return;
        }
        this._alignment = null;
        if (!this.openStreamAlignment(false)) {
            return;
        }
        if (this._frame.getCurrentMode() == this && this._first) {
            this._mapTools.forceSelectButton(0);
            this._first = false;
        }
        this.openStudy(false);
        this.updateGUIState(this._editConfigMenuItem.isSelected());
        this.fillModelAltMenu();
        this.fillCompPtLayersMenu(true);
    }

    protected void fillCompPtLayersMenu(boolean resetToDefault) {
        RmaJObjectCheckBoxMenuItem menuItem;
        if (this._ccpLayersMenu == null) {
            return;
        }
        if (ClientApp.Workspace() == null) {
            return;
        }
        ComputationPointLayerDataList dl = (ComputationPointLayerDataList)ClientApp.Workspace().getCommonDataList(ComputationPointLayer.class.getName(), "");
        if (dl == null) {
            return;
        }
        boolean firstTime = this._ccpLayersMenu.getMenuComponentCount() == 0;
        ArrayList<ComputationPointLayer> selected = new ArrayList<ComputationPointLayer>();
        if (!resetToDefault) {
            for (int i = 0; i < this._ccpLayersMenu.getMenuComponentCount(); ++i) {
                menuItem = (RmaJObjectCheckBoxMenuItem)this._ccpLayersMenu.getMenuComponent(i);
                if (!menuItem.isSelected()) continue;
                selected.add((ComputationPointLayer)((Object)menuItem.getObject()));
            }
        }
        this._ccpLayersMenu.removeAll();
        List<ComputationPointLayer> layers = dl.getCompPointLayers(false);
        RMASort.quickSort(layers);
        ComputationPointLayer defaultLayer = dl.getDefaultLayer();
        layers.add(0, defaultLayer);
        ButtonGroup bg = new ButtonGroup();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = e.getSource();
                if (obj instanceof RmaJObjectCheckBoxMenuItem) {
                    RmaJObjectCheckBoxMenuItem mi = (RmaJObjectCheckBoxMenuItem)obj;
                    WatershedConfigMode.this.compPtLayerMenuAction((ComputationPointLayer)((Object)mi.getObject()), mi.isSelected());
                }
            }
        };
        for (int i = 0; i < layers.size(); ++i) {
            boolean on;
            ComputationPointLayer cpl = layers.get(i);
            boolean bl = on = selected.indexOf((Object)cpl) > -1;
            if (firstTime) {
                menuItem = new RmaJObjectCheckBoxMenuItem((Object)cpl, cpl.isDefaultLayer());
                if (cpl.isDefaultLayer() && resetToDefault) {
                    menuItem.setSelected(true);
                }
            } else {
                menuItem = new RmaJObjectCheckBoxMenuItem((Object)cpl, on);
            }
            menuItem.addActionListener(al);
            this._ccpLayersMenu.add((JMenuItem)menuItem);
        }
    }

    public void resetComputationPointLayers() {
        if (this._ccpLayersMenu == null) {
            return;
        }
        this.fillCompPtLayersMenu(false);
        int cnt = this._ccpLayersMenu.getMenuComponentCount();
        for (int i = 0; i < cnt; ++i) {
            RmaJObjectCheckBoxMenuItem menuItem;
            Object obj = this._ccpLayersMenu.getMenuComponent(i);
            if (!(obj instanceof RmaJObjectCheckBoxMenuItem) || !((obj = (menuItem = (RmaJObjectCheckBoxMenuItem)obj).getObject()) instanceof ComputationPointLayer)) continue;
            ComputationPointLayer ccpl = (ComputationPointLayer)((Object)obj);
            this.compPtLayerMenuAction(ccpl, menuItem.isSelected());
        }
    }

    protected void compPtLayerMenuAction(ComputationPointLayer ccpl, boolean selected) {
        StudySystemGlyph glyph = (StudySystemGlyph)this._frame.getMapPanel().findGlyphOfClass(StudySystemGlyph.class.getName());
        if (glyph == null) {
            return;
        }
        glyph.setComputationLayerOn(ccpl, selected);
    }

    public void updateManagerMaps() {
        Vector<Object> vec = new Vector<Object>();
        if (this._frame.getCurrentMode() == this) {
            if (this._alignment != null) {
                vec.addElement(this._alignment);
            }
            if (this._study != null) {
                vec.addElement(this._study);
            }
            this._frame.getMapPanel().resetManagerMaps(vec);
            this._frame.getMapPanel().paintMap();
            this._frame.getMapPanel().waitforPaintComplete();
            this._frame.repaint();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WatershedConfigMode.this.resetComputationPointLayers();
                }
            });
        }
    }

    public void editWatershedData() {
        try {
            DefaultJPanel accPanel;
            this._frame.setWaitCursor();
            if (this._dataDialog == null || !this._dataDialog.isVisible()) {
                this._dataDialog = new WatershedDataEditor((Frame)this._frame, true);
            }
            if ((accPanel = ClientApp.frame().getWatershedDataAccessoryPanel()) != null) {
                this._dataDialog.addAccessoryPanel(accPanel);
            }
            this._dataDialog.fillForm();
            this._dataDialog.setEditable(this._editConfigMenuItem.isSelected());
            this._dataDialog.setVisible(true);
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void editCondition() {
        try {
            this._frame.setWaitCursor();
            if (this._conditionEditor == null) {
                this._conditionEditor = new ConditionEditor((Frame)this._frame, true, this.allowProgramSetup(), true);
            }
            this._conditionEditor.setConditionList((ConditionContainer)ClientApp.Workspace().getDataListContainer().getDataList(Condition.class.getName()));
            this._conditionEditor.setEditable(this._editConfigMenuItem.isSelected());
            this._conditionEditor.fillForm();
            Condition c = this.getSelectedCondition();
            if (c != null && !c.isStudyCondition()) {
                this._conditionEditor.fillForm((NamedType)this.getSelectedCondition());
            }
            this._conditionEditor.setVisible(true);
            this.updateConditionList();
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    protected void updateConditionList() {
        if (this._conditionList == null) {
            return;
        }
        Object o = this._conditioncombo.getSelectedItem();
        Object[] objs = this._conditionList.getObjects();
        this._conditioncombo.setModel((ComboBoxModel)new RmaListModel(true, objs));
        if (o != null) {
            this._conditioncombo.setSelectedItem(o);
        } else if (this._conditioncombo.getItemCount() > 0) {
            this._conditioncombo.setSelectedIndex(0);
        }
        this._frame.getMapPanel().paintMap();
    }

    public void setSelectedCondition(Condition c) {
        if (c == null) {
            Condition study = this._conditionList.getStudyCondition();
            this._conditioncombo.setSelectedItem((Object)study);
        } else {
            this._conditioncombo.setSelectedItem((Object)c);
        }
    }

    @Override
    public Condition getSelectedCondition() {
        return (Condition)this._conditioncombo.getSelectedItem();
    }

    @Override
    public void addConditionListListener(ItemListener il) {
        this._conditioncombo.addItemListener(il);
    }

    public void removeConditionListListener(ItemListener il) {
        this._conditioncombo.removeItemListener(il);
    }

    public boolean objectDoubleClick(NamedType obj, LocalPt pt) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ImpactArea) {
            this.editImpactArea((DataObject)((ImpactArea)obj), false);
            return true;
        }
        if (obj instanceof ComputationPoint) {
            this.editComputationPoint((DataObject)((ComputationPoint)obj));
            return true;
        }
        if (obj instanceof Project) {
            this.editProject((DataObject)((Project)obj));
            return true;
        }
        return false;
    }

    public boolean objectDoubleClick(Station station, LocalPt pt) {
        if (station == null) {
            return false;
        }
        this.editStation(station);
        return true;
    }

    public boolean objectPopupMenu(NamedType obj, LocalPt pt) {
        this.setPopupPoint(pt);
        if (obj instanceof ImpactArea) {
            return this.objectPopupMenu((ImpactArea)obj, pt);
        }
        if (obj instanceof ChannelMod) {
            return this.objectPopupMenu((ChannelMod)obj, pt);
        }
        if (obj instanceof StoragePool) {
            return this.objectPopupMenu((StoragePool)obj, pt);
        }
        if (obj instanceof ComputationPoint) {
            return this.objectPopupMenu((ComputationPoint)obj, pt);
        }
        if (obj instanceof OtherProject) {
            return this.objectPopupMenu((OtherProject)obj, pt);
        }
        if (obj instanceof Reservoir) {
            return this.objectPopupMenu((Reservoir)obj, pt);
        }
        if (obj instanceof Diversion) {
            return this.objectPopupMenu((Diversion)obj, pt);
        }
        if (obj instanceof StreamElement) {
            return this.objectPopupMenu((StreamElement)obj, pt);
        }
        if (obj instanceof StreamNode) {
            return this.objectPopupMenu((StreamNode)obj, pt);
        }
        if (obj instanceof Levee) {
            return this.objectPopupMenu((Levee)obj, pt);
        }
        if (obj instanceof StationWrapper) {
            return this.objectPopupMenu(((StationWrapper)obj).getStation(), pt);
        }
        return false;
    }

    public boolean objectPopupMenu(StreamNode node, LocalPt pt) {
        if (this._alignment == null || pt == null || node == null) {
            return false;
        }
        this.setPopupObject(node);
        String station = RMAIO.setPrecision2((double)node.getStation(), (int)3);
        String stationName = "Station: " + station;
        RmaJPopupMenu menu = new RmaJPopupMenu("SN");
        JMenuItem mitem = new JMenuItem(stationName);
        mitem.setName(stationName);
        menu.add(mitem);
        menu.addSeparator();
        boolean locked = this._editStreamsMenuItem.isSelected();
        mitem = new JMenuItem(locked ? "Edit Node..." : "View Node...");
        mitem.setName(stationName);
        mitem.setActionCommand(node.getJunction() != null ? "editJunction" : "editNode");
        mitem.addActionListener(this);
        menu.add(mitem);
        mitem = new JMenuItem("Delete Node");
        if (!locked || node.getStreamCoord() < 1.0E-4 || node.getStreamCoord() > 0.9999) {
            mitem.setEnabled(false);
        }
        mitem.setName(stationName);
        mitem.setActionCommand("deleteNode");
        mitem.addActionListener(this);
        menu.add(mitem);
        this.setPopupPoint(pt);
        menu.show((Component)this._frame.getMapPanel().viewport(), pt.x, pt.y);
        return true;
    }

    public boolean objectPopupMenu(StreamElement elem, LocalPt pt) {
        if (elem == null) {
            return false;
        }
        String element = "Stream Element";
        RmaJPopupMenu menu = new RmaJPopupMenu(elem.getName());
        RmaJObjectMenuItem mitem = new RmaJObjectMenuItem(elem.getName(), (Object)elem);
        menu.add((JMenuItem)mitem);
        menu.addSeparator();
        boolean locked = this._editStreamsMenuItem.isSelected();
        mitem = new RmaJObjectMenuItem((locked ? "Edit " : "View ") + element + "...", (Object)elem);
        mitem.setName(elem.getName());
        mitem.addActionListener((ActionListener)this);
        menu.add((JMenuItem)mitem);
        mitem = new RmaJObjectMenuItem("Rename " + element + "...", (Object)elem);
        mitem.setName(elem.getName());
        mitem.setEnabled(locked);
        mitem.addActionListener((ActionListener)this);
        menu.add((JMenuItem)mitem);
        mitem = new RmaJObjectMenuItem("Delete " + element, (Object)elem);
        mitem.setName(elem.getName());
        mitem.setEnabled(locked);
        mitem.addActionListener((ActionListener)this);
        menu.add((JMenuItem)mitem);
        menu.addSeparator();
        mitem = new RmaJObjectMenuItem("Disconnect Upstream", (Object)elem);
        mitem.setName(elem.getName());
        mitem.addActionListener((ActionListener)this);
        menu.add((JMenuItem)mitem);
        StreamNode node = elem.getUpstreamNode();
        if (node == null || node.getJunction() == null || !locked) {
            mitem.setEnabled(false);
        }
        mitem = new RmaJObjectMenuItem("Disconnect Downstream", (Object)elem);
        mitem.setName(elem.getName());
        mitem.addActionListener((ActionListener)this);
        menu.add((JMenuItem)mitem);
        node = elem.getDownstreamNode();
        if (node == null || node.getJunction() == null || !locked) {
            mitem.setEnabled(false);
        }
        this.setPopupPoint(pt);
        mitem = new RmaJObjectMenuItem("Reverse Direction", (Object)elem);
        mitem.setName(elem.getName());
        mitem.addActionListener((ActionListener)this);
        mitem.setEnabled(locked);
        menu.add((JMenuItem)mitem);
        menu.show((Component)this._frame.getMapPanel().viewport(), pt.x, pt.y);
        return true;
    }

    public boolean objectPopupMenu(Levee levee, LocalPt pt) {
        JPopupMenu popup = this.getPopupMenu("Levee", (NamedType)levee);
        popup.show((Component)this._frame.getMapPanel().viewport(), pt.x, pt.y);
        return false;
    }

    public boolean objectPopupMenu(Reservoir op, LocalPt pt) {
        JPopupMenu popup = this.getPopupMenu("Reservoir", (NamedType)op);
        popup.show((Component)this._frame.getMapPanel().viewport(), pt.x, pt.y);
        return false;
    }

    public boolean objectPopupMenu(OtherProject op, LocalPt pt) {
        JPopupMenu popup = this.getPopupMenu("Other Project", (NamedType)op);
        popup.show((Component)this._frame.getMapPanel().viewport(), pt.x, pt.y);
        return false;
    }

    public boolean objectPopupMenu(ImpactArea ia, LocalPt pt) {
        JPopupMenu popup = this.getPopupMenu("Impact Area", (NamedType)ia);
        RmaJObjectMenuItem menuItem = new RmaJObjectMenuItem("Configuration Notes...", (Object)ia);
        menuItem.setName(ia.getName());
        menuItem.addActionListener((ActionListener)this);
        popup.add((JMenuItem)menuItem);
        popup.show((Component)this._frame.getMapPanel().viewport(), pt.x, pt.y);
        return false;
    }

    public boolean objectPopupMenu(Station station, LocalPt pt) {
        JPopupMenu menu = new JPopupMenu();
        boolean locked = this._editConfigMenuItem.isSelected();
        RmaJMenuLabel label = new RmaJMenuLabel(station.getName());
        menu.add((JMenuItem)label);
        menu.addSeparator();
        JMenuItem menuItem = new JMenuItem(new EditStationAction(station));
        Font f = menuItem.getFont();
        menuItem.setFont(new Font(f.getName(), 1, f.getSize()));
        menu.add(menuItem);
        menu.add(new RenameStationAction(station));
        menu.addSeparator();
        menu.add(new DeleteStationAction(station));
        menu.show((Component)this._frame.getMapPanel().viewport(), pt.x, pt.y);
        return true;
    }

    public boolean objectPopupMenu(ChannelMod cm, LocalPt pt) {
        JPopupMenu popup = this.getPopupMenu("Channel Modification", (NamedType)cm);
        popup.show((Component)this._frame.getMapPanel().viewport(), pt.x, pt.y);
        return false;
    }

    public boolean objectPopupMenu(StoragePool sp, LocalPt pt) {
        JPopupMenu popup = this.getPopupMenu("Off Channel Storage Area", (NamedType)sp);
        popup.show((Component)this._frame.getMapPanel().viewport(), pt.x, pt.y);
        return false;
    }

    public boolean objectPopupMenu(ComputationPoint cp, LocalPt pt) {
        JPopupMenu popup = this.getPopupMenu("Computation Point", (NamedType)cp);
        popup.show((Component)this._frame.getMapPanel().viewport(), pt.x, pt.y);
        return true;
    }

    public boolean objectPopupMenu(Diversion div, LocalPt pt) {
        JPopupMenu popup = this.getPopupMenu("Diversion", (NamedType)div);
        if (div.getDownstreamNode() != null) {
            popup.addSeparator();
            RmaJObjectMenuItem menuItem = new RmaJObjectMenuItem("Disconnect Outflow", (Object)div);
            menuItem.setName(div.getName());
            menuItem.setEnabled(this._editConfigMenuItem.isSelected());
            menuItem.addActionListener((ActionListener)this);
            popup.add((JMenuItem)menuItem);
        }
        popup.show((Component)this._frame.getMapPanel().viewport(), pt.x, pt.y);
        return true;
    }

    protected JPopupMenu getPopupMenu(String type, NamedType obj) {
        ComputationPoint cp;
        String name = obj.getName();
        String cls = obj.getClass().getName();
        RmaJPopupMenu popup = new RmaJPopupMenu(type);
        RmaJMenuLabel label = new RmaJMenuLabel(obj.getName());
        popup.add((JMenuItem)label);
        popup.addSeparator();
        boolean locked = this._editConfigMenuItem.isSelected();
        RmaJObjectMenuItem menuItem = new RmaJObjectMenuItem((locked ? "Edit " : "View ") + type + "...", (Object)obj);
        Font f = menuItem.getFont();
        menuItem.setFont(new Font(f.getName(), 1, f.getSize()));
        menuItem.setActionCommand(cls);
        menuItem.setName(name);
        menuItem.addActionListener((ActionListener)this);
        popup.add((JMenuItem)menuItem);
        menuItem = new RmaJObjectMenuItem("Rename " + type + "...", (Object)obj);
        menuItem.setActionCommand(cls);
        menuItem.setName(name);
        menuItem.setEnabled(locked);
        menuItem.addActionListener((ActionListener)this);
        popup.add((JMenuItem)menuItem);
        Condition c = this.getSelectedCondition();
        popup.addSeparator();
        if (obj instanceof Project && c != null && !c.isStudyCondition()) {
            menuItem = new RmaJObjectMenuItem("Remove from Configuration", (Object)obj);
            menuItem.setActionCommand(cls);
            menuItem.setName(name);
            menuItem.setEnabled(locked);
            menuItem.addActionListener((ActionListener)this);
            popup.add((JMenuItem)menuItem);
        }
        boolean addDeleteMenu = true;
        if (obj instanceof ComputationPoint && ((cp = (ComputationPoint)obj).isAutoGenerated() || cp.getProjects().size() > 0)) {
            addDeleteMenu = false;
        }
        if (addDeleteMenu) {
            menuItem = new RmaJObjectMenuItem("Delete " + type, (Object)obj);
            menuItem.setActionCommand(cls);
            menuItem.setName(name);
            menuItem.setEnabled(locked);
            menuItem.addActionListener((ActionListener)this);
        }
        popup.add((JMenuItem)menuItem);
        if (obj instanceof Project && (c == null || !c.isStudyCondition())) {
            popup.addSeparator();
            menuItem = new RmaJObjectMenuItem("Configuration Notes...", (Object)obj);
            menuItem.setActionCommand(cls);
            menuItem.setName(name);
            menuItem.addActionListener((ActionListener)this);
            popup.add((JMenuItem)menuItem);
        }
        return popup;
    }

    private void deleteStation(Station selectedStation) {
        int opt = JOptionPane.showConfirmDialog((Component)this._frame, "<html>Are you sure you want to delete <b>" + selectedStation.getName() + "</b> from the watershed?</html>", "Confirm Deletion", 0);
        if (opt == 1) {
            this._frame.repaint();
            return;
        }
        ClientWorkspace wksp = ClientApp.Workspace();
        if (wksp == null) {
            return;
        }
        StudySystemGlyph glyph = (StudySystemGlyph)this._frame.getMapPanel().findGlyphOfClass(StudySystemGlyph.class.getName());
        if (glyph != null) {
            glyph.clearSelectionObject((Object)selectedStation);
        }
        StationSetDataList sdl = (StationSetDataList)wksp.getDataListContainer().getDataList(StationSet.class.getName());
        DataStruct[] objectArray = sdl.getObjectArray();
        StationSet stationset = null;
        if (objectArray != null && objectArray.length > 0) {
            stationset = ((StationSetDataObject)objectArray[0]).getStationSet();
        }
        if (stationset != null) {
            stationset.removeFeature(selectedStation);
        }
        this._frame.getMapPanel().paintMap();
    }

    private void renameStation(Station selectedStation) {
        ClientWorkspace wksp = ClientApp.Workspace();
        if (wksp == null) {
            return;
        }
        StationSetDataList sdl = (StationSetDataList)wksp.getDataListContainer().getDataList(StationSet.class.getName());
        DataStruct[] objectArray = sdl.getObjectArray();
        StationSet stationset = null;
        if (objectArray != null && objectArray.length > 0) {
            stationset = ((StationSetDataObject)objectArray[0]).getStationSet();
        }
        hec.gui.RenameDlg dlg = new hec.gui.RenameDlg((Frame)this._frame, true);
        dlg.setFileNameVisible(false);
        dlg.setTitle("Rename Station");
        boolean found = false;
        do {
            dlg.setName(selectedStation.getName());
            dlg.setDescription(selectedStation.getDescription());
            dlg.setVisible(true);
            if (dlg.getCanceled()) {
                return;
            }
            String newName = dlg.getName();
            if (newName.equals(selectedStation.getName())) continue;
            Predicate<Station> p = s -> s.getName().equals(newName);
            List stations = stationset.getFeatures(p);
            if (!stations.isEmpty()) {
                JOptionPane.showMessageDialog((Component)this._frame, "Station " + newName + " already exists.\nPlease enter a different name", "Duplicate Name", 1);
                found = true;
                continue;
            }
            found = false;
        } while (found);
        selectedStation.setName(dlg.getName());
        selectedStation.setDescription(dlg.getDescription());
        sdl.setModified(true);
        this._frame.getMapPanel().paintMap();
    }

    private void editStation(Station selectedStation) {
        ClientWorkspace wksp = ClientApp.Workspace();
        if (wksp == null) {
            return;
        }
        StationSetDataList sdl = (StationSetDataList)wksp.getDataListContainer().getDataList(StationSet.class.getName());
        DataStruct[] objectArray = sdl.getObjectArray();
        StationSet stationset = null;
        if (objectArray != null && objectArray.length > 0) {
            stationset = ((StationSetDataObject)objectArray[0]).getStationSet();
        }
        Predicate<Station> p = s -> true;
        List stations = stationset.getFeatures(p);
        StationEditorDialog dialog = new StationEditorDialog((Window)this._frame, Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setStreamCoordinateProvider(new StationEditorDialog.StreamCoordinateProvider(){

            @Override
            public Object[] computeStreamInformation(WorldPt pt) {
                WorldPt best = new WorldPt();
                StreamElement findNearestReach = WatershedConfigMode.this._alignment.findNearestReach(pt, best);
                if (findNearestReach == null) {
                    return null;
                }
                double stationByLocation = findNearestReach.getStationByLocation(best);
                Object[] obj = new Object[]{stationByLocation, findNearestReach.getName(), best};
                return obj;
            }
        });
        dialog.setEditable(this._editConfigMenuItem.isSelected());
        dialog.fillPanel(stations, selectedStation, wksp.getUnitSystem());
        dialog.setTitle("Station Properties Editor");
        dialog.pack();
        dialog.setMinimumSize(dialog.getPreferredSize());
        dialog.setLocationRelativeTo((Component)this._frame);
        dialog.setVisible(true);
        this._frame.getMapPanel().paintMap();
    }

    public void editImpactAreas() {
        this._frame.setWaitCursor();
        try {
            if (this._iale == null) {
                DataList cdl = ClientApp.Workspace().getDataListContainer().getDataList(ImpactArea.class.getName());
                this._iale = new ImpactAreaLocationsEditor((Frame)this._frame, false, (CommonDataList)cdl);
            }
            this._iale.setAlignment((StreamAlignmentIfc)this._alignment);
            this._iale.fillForm();
            this._iale.setEditable(this._editConfigMenuItem.isSelected());
            this._iale.setVisible(true);
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void editConditionNotes(DataObject dobj) {
        if (dobj instanceof ImpactArea) {
            this._frame.setWaitCursor();
            try {
                if (this._cne == null) {
                    this._cne = new ConditionNotesEditor((Frame)this._frame, true);
                }
                this._cne.setImactAreaDataList((CommonDataList)ClientApp.Workspace().getDataListContainer().getDataList(ImpactArea.class.getName()));
                this._cne.setCurrentCondition(this.getSelectedCondition());
                this._cne.fillForm();
                this._cne.setEditable(this._editConfigMenuItem.isSelected());
                this._cne.setSelectedImpactArea((ImpactArea)dobj);
                this._cne.setVisible(true);
                this._frame.repaint();
            }
            finally {
                this._frame.setDefaultCursor();
            }
        }
    }

    public void editImpactArea(DataObject obj, boolean showAllTabs) {
        if (obj instanceof ImpactArea) {
            try {
                this._frame.setWaitCursor();
                if (this._iae == null) {
                    this._iae = new ImpactAreaEditor((Frame)this._frame, false);
                }
                this._iae.setCommonDataListContainer((CommonDataListContainer)ClientApp.Workspace().getDataListContainer());
                this._iae.setStudyGlyph((StudySystemGlyph)this._frame.getMapPanel().findGlyphOfClass(StudySystemGlyph.class.getName()));
                this._iae.fillForm();
                this._iae.setEditable(this._editConfigMenuItem.isSelected());
                this._iae.setSelectedImpactArea((ImpactArea)obj);
                this._iae.setVisible(true);
                this._frame.repaint();
            }
            finally {
                this._frame.setDefaultCursor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editComputationPoint(DataObject obj) {
        if (obj instanceof ComputationPoint) {
            try {
                this._frame.setWaitCursor();
                if (this._compPtEditor == null) {
                    this._compPtEditor = new StudyMapSelectionEditor((Frame)this._frame, false);
                    this._compPtEditor.addPanel(new ComputationPointPanel((JDialog)((Object)this._compPtEditor)));
                }
                this._compPtEditor.setTitle("Computation Point Properties Editor");
                this._compPtEditor.setStreamAlignment((StreamAlignmentIfc)this._alignment);
                DataList dl = ClientApp.Workspace().getDataListContainer().getDataList(ComputationPoint.class.getName());
                if (dl == null) {
                    return;
                }
                this._compPtEditor.setCommonDataListContainer((CommonDataListContainer)ClientApp.Workspace().getDataListContainer());
                this._compPtEditor.setStudyGlyph((StudySystemGlyph)this._frame.getMapPanel().findGlyphOfClass(StudySystemGlyph.class.getName()));
                Object[] cpList = dl.getObjects();
                this._compPtEditor.setSelectionList(cpList);
                this._compPtEditor.fillForm((NamedType)obj);
                this._compPtEditor.setEditable(this._editConfigMenuItem.isSelected());
                this._compPtEditor.pack();
                this._compPtEditor.setVisible(true);
                this._frame.repaint();
            }
            finally {
                this._frame.setDefaultCursor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editProject(DataObject dobj) {
        if (dobj instanceof Project) {
            try {
                this._frame.setWaitCursor();
                Project proj = (Project)dobj;
                ProjectEditor pe = (ProjectEditor)this._projectEditors.get(proj.getType());
                if (pe == null) {
                    pe = new ProjectEditor((Frame)this._frame, false);
                    AbstractEditorPanel panel = ProjectEditorPanelFactory.getPanelForObject(dobj, pe);
                    pe.addPanel(panel);
                    if (panel != null) {
                        panel.setBorder((Border)BorderFactory.createTitledBorder(proj.getLabelName() + " Information:"));
                    }
                    pe.getSelectorPanel().setNameLabel(proj.getLabelName() + " Name:");
                    this._projectEditors.put(proj.getType(), pe);
                }
                pe.setCommonDataListContainer((CommonDataListContainer)ClientApp.Workspace().getDataListContainer());
                pe.setStudyGlyph((StudySystemGlyph)this._frame.getMapPanel().findGlyphOfClass(StudySystemGlyph.class.getName()));
                Condition c = this.getSelectedCondition();
                String title = proj.getLabelName() + " Properties Editor";
                pe.setTitle(title);
                pe.setStreamAlignment((StreamAlignmentIfc)this._alignment);
                Vector v = c.getProjects(proj.getType());
                pe.setSelectionList(v);
                pe.fillForm((NamedType)dobj);
                pe.setEditable(this._editConfigMenuItem.isSelected());
                pe.pack();
                pe.setVisible(true);
                this._frame.repaint();
            }
            finally {
                this._frame.setDefaultCursor();
            }
        }
    }

    public void editProjectNotes(DataObject dobj) {
        if (!(dobj instanceof Project)) {
            return;
        }
        try {
            this._frame.setWaitCursor();
            if (this._notesDialog == null) {
                this._notesDialog = new ProjectNotesJDialog((Frame)this._frame, true);
            }
            Condition c = this.getSelectedCondition();
            this._notesDialog.setEditable(this._editConfigMenuItem.isSelected());
            this._notesDialog.fillForm(c);
            if (c == null || c.isStudyCondition()) {
                this._notesDialog.setNotesVisible(false);
            } else {
                this._notesDialog.setNotesVisible(true);
            }
            this._notesDialog.setSelectedProject((Project)dobj);
            this._notesDialog.setVisible(true);
            this._frame.repaint();
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    StreamAlignment getAlignment() {
        return this._alignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateComputationPoints() {
        try {
            Condition c;
            this._frame.setWaitCursor();
            DataList impactAreaList = ClientApp.Workspace().getDataListContainer().getDataList(ImpactArea.class.getName());
            if (impactAreaList != null) {
                DataObject[] objs = impactAreaList.getObjects();
                for (int i = 0; i < objs.length; ++i) {
                    ImpactArea area = (ImpactArea)objs[i];
                    if (area == null) continue;
                    area.updateComputationPoint();
                }
            }
            if ((c = this.getSelectedCondition()) == null) {
                return;
            }
            Vector projects = c.getProjects();
            if (projects == null) {
                return;
            }
            int size = projects.size();
            for (int i = 0; i < size; ++i) {
                Project proj = (Project)projects.elementAt(i);
                if (proj == null || !(proj instanceof ComputationPointHolder)) continue;
                ((ComputationPointHolder)((Object)proj)).updateComputationPoint();
            }
            ComputationPointDataList cpdl = (ComputationPointDataList)ClientApp.Workspace().getDataListContainer().getDataList(ComputationPoint.class.getName());
            if (cpdl == null) {
                return;
            }
            cpdl.cleanComputationPoints();
            this._frame.getMapPanel().paintMap();
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void displayComputationPointList() {
        try {
            this._frame.setWaitCursor();
            if (this._cpr == null) {
                this._cpr = new ComputationPointReport((Frame)this._frame, true);
            }
            this._cpr.setAlignment((StreamAlignmentIfc)this._alignment);
            this._cpr.fillForm();
            this._cpr.setVisible(true);
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void displayStreamList() {
        try {
            this._frame.setWaitCursor();
            ReportsFrame rf = new ReportsFrame((Frame)this._frame);
            rf.makeStreamReport((StreamAlignmentIfc)this._alignment);
            rf.setVisible(true);
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void displayImpactAreaList() {
        try {
            this._frame.setWaitCursor();
            ReportsFrame rf = new ReportsFrame((Frame)this._frame);
            rf.reportTable.setSelectionMode(2);
            rf.makeImpactAreaReport();
            rf.setVisible(true);
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void displayChannelModList() {
        try {
            this._frame.setWaitCursor();
            ReportsFrame rf = new ReportsFrame((Frame)this._frame);
            rf.makeChannelModificationReport();
            rf.setVisible(true);
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void displayDiversionList() {
        try {
            this._frame.setWaitCursor();
            ReportsFrame rf = new ReportsFrame((Frame)this._frame);
            rf.makeDiversionReport();
            rf.setVisible(true);
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void displayOffChannelList() {
        try {
            this._frame.setWaitCursor();
            ReportsFrame rf = new ReportsFrame((Frame)this._frame);
            rf.makeOffChannelStorageReport();
            rf.setVisible(true);
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void displayOtherProjectList() {
        try {
            this._frame.setWaitCursor();
            ReportsFrame rf = new ReportsFrame((Frame)this._frame);
            rf.makeOtherProjectReport();
            rf.setVisible(true);
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void displayReservoirList() {
        try {
            this._frame.setWaitCursor();
            ReportsFrame rf = new ReportsFrame((Frame)this._frame);
            rf.makeReserviorReport();
            rf.setVisible(true);
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void displayLeveeList() {
        try {
            this._frame.setWaitCursor();
            ReportsFrame rf = new ReportsFrame((Frame)this._frame);
            rf.makeLeveeReport();
            rf.setVisible(true);
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void displayProjectsList() {
        try {
            this._frame.setWaitCursor();
            ReportsFrame rf = new ReportsFrame((Frame)this._frame);
            rf.makeProjectsReport();
            rf.setVisible(true);
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void displayConditionsList() {
        try {
            this._frame.setWaitCursor();
            ReportsFrame rf = new ReportsFrame((Frame)this._frame);
            rf.makeConditionReport();
            rf.setVisible(true);
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void editProjectList() {
        try {
            this._frame.setWaitCursor();
            if (this._ple == null) {
                this._ple = new ProjectsListEditor((Frame)this._frame, true);
            }
            this._ple.setAlignment((StreamAlignmentIfc)this._alignment);
            this._ple.fillForm();
            this._ple.setEditable(this._editConfigMenuItem.isSelected());
            this._ple.setVisible(true);
            this._frame.repaint();
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public boolean validateManagers() {
        ClientWorkspace wksp = ClientApp.Workspace();
        if (wksp == null) {
            return true;
        }
        return true;
    }

    public void displayDrawingPropertiesDialog() {
        try {
            this._frame.setWaitCursor();
            StudyPropertiesEditor spe = new StudyPropertiesEditor((Frame)this._frame, true, null);
            spe.setLocationRelativeTo((Component)this._frame);
            spe.pack();
            spe.setMinimumSize(spe.getPreferredSize());
            spe.fillForm();
            spe.setVisible(true);
            this._frame.repaint();
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void renameStreamElement(StreamElement res) {
        if (res == null || this._alignment == null) {
            return;
        }
        boolean found = false;
        RenameDlg dlg = new RenameDlg((Frame)this._frame, true);
        dlg.setFileNameVisible(false);
        dlg.setTitle("Rename Stream");
        do {
            dlg.setName(res.getName());
            dlg.setDescription(res.getDescription());
            dlg.setVisible(true);
            this._frame.repaint();
            if (dlg.getCanceled()) {
                return;
            }
            String newName = dlg.getName();
            StreamElement existingStream = this._alignment.findReach(newName);
            if (existingStream != null && existingStream != res) {
                JOptionPane.showMessageDialog((Component)this._frame, "Stream " + newName + " already exists.\nPlease enter a different name", "Duplicate Name", 1);
                found = true;
                continue;
            }
            found = false;
        } while (found);
        res.setName(dlg.getName());
        res.setDescription(dlg.getDescription());
        this._alignment.setModified(true);
        res.setModified(true);
        this._frame.getMapPanel().paintMap();
    }

    public void editStreamElement(StreamElement elem) {
        try {
            this._frame.setWaitCursor();
            if (this._streamEditor == null) {
                this._streamEditor = new StreamEditor((Frame)this._frame, true);
                this._streamEditor.setStationText(this.getStationText());
            }
            this._streamEditor.setSelectionList((Collection)this._alignment.getElementVector());
            this._streamEditor.setEditable(this._editConfigMenuItem.isSelected());
            this._streamEditor.fillForm((NamedType)elem);
            this._streamEditor.pack();
            this._streamEditor.setVisible(true);
            this._frame.repaint();
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    protected String getStationText() {
        return "Station";
    }

    public void deleteStreamElement(StreamElement elem) {
        if (this._alignment == null) {
            return;
        }
        if (elem == null) {
            return;
        }
        String regionName = elem.getName();
        int i = JOptionPane.showConfirmDialog((Component)this._frame, "Warning: do not delete a stream that is used by any model configuration.  Are you sure you want to delete Stream " + regionName + "?", "Confirm Delete", 0, 3);
        if (i == 0) {
            StreamAlignmentGlyph glyph = (StreamAlignmentGlyph)this._frame.getMapPanel().findGlyphOfClass(StreamAlignmentGlyph.class.getName());
            if (glyph != null) {
                glyph.clearSelection(regionName);
            }
            this._alignment.deleteReach(elem.getIndex());
            this._alignment.setModified(true);
        }
        this._frame.getMapPanel().paintMap();
        this._frame.getMapPanel().waitforPaintComplete();
        this._frame.repaint();
    }

    public void insertStreamNode(StreamElement stream, LocalPt pt) {
        if (this._alignment == null) {
            return;
        }
        if (stream == null) {
            return;
        }
        StreamNode node = this._alignment.newStreamNode(stream);
        MapPanel mapPanel = this._frame.getMapPanel();
        WorldPt wpt = mapPanel.scale().lp2wp(pt);
        node.setLocation(wpt);
        double coord = stream.getCoordByLocation(wpt);
        node.setStreamCoord(coord);
        stream.addNode(node);
        this._alignment.setModified(true);
        this._frame.getMapPanel().paintMap();
        this._frame.getMapPanel().waitforPaintComplete();
        this._frame.repaint();
    }

    public void disconnectUpstream(StreamElement elem) {
        if (this._alignment == null || elem == null) {
            return;
        }
        this._alignment.removeReachFromJunction(elem.getName(), true);
        this._frame.getMapPanel().paintMap();
    }

    public void disconnectDownstream(StreamElement elem) {
        if (this._alignment == null || elem == null) {
            return;
        }
        this._alignment.removeReachFromJunction(elem.getName(), false);
        this._frame.getMapPanel().paintMap();
    }

    public void reverseStreamElement(StreamElement elem) {
        if (elem == null) {
            return;
        }
        String regionName = elem.getName();
        int i = JOptionPane.showConfirmDialog((Component)this._frame, "Warning: reversing the steam direction will reverse default stationing of the stream,\n which may cause problems with other model data relying on the Stream Alignment.\nAre you sure you want to reverse the direction of Stream " + regionName + "?", "Confirm Reverse Direction", 0, 3);
        if (i == 0) {
            elem.reverseDirection();
            if (this._alignment != null) {
                this._alignment.setModified(true);
            }
        }
        this._frame.getMapPanel().paintMap();
        this._frame.getMapPanel().waitforPaintComplete();
        this._frame.repaint();
    }

    public void disconnectOutFlow(Diversion div) {
        if (div == null) {
            return;
        }
        div.disconnectDownstream(10.0, 10.0);
        this._frame.getMapPanel().paintMap();
    }

    public void removeProjectFromCondition(NamedType nt) {
        Condition c = this.getSelectedCondition();
        if (c == null) {
            return;
        }
        if (nt instanceof Project && !c.isStudyCondition()) {
            int opt = JOptionPane.showConfirmDialog((Component)this._frame, "Are you sure you want to remove " + ((Project)nt).getUserDisplayedType() + " " + nt.getName() + " from Configuration " + c.getName() + "?", "Confirm Removal", 0);
            if (opt == 1) {
                this._frame.repaint();
                return;
            }
            c.removeProject((Project)nt);
            StudySystemGlyph glyph = (StudySystemGlyph)this._frame.getMapPanel().findGlyphOfClass(StudySystemGlyph.class.getName());
            if (glyph != null) {
                glyph.clearSelection();
            }
            this._frame.getMapPanel().paintMap();
        }
    }

    public void deleteObject(DataObject dobj, String label) {
        ConditionDataList cdl;
        CommonDataList dl = dobj.getDataList();
        if (dl == null) {
            return;
        }
        int opt = JOptionPane.showConfirmDialog((Component)this._frame, "<html>Are you sure you want to delete <b>" + dobj.getName() + "</b> from the watershed?</html>", "Confirm Deletion", 0);
        if (opt == 1) {
            this._frame.repaint();
            return;
        }
        if (!dl.removeObject(dobj.getId())) {
            JOptionPane.showMessageDialog((Component)this._frame, "Failed to remove " + dobj.getName());
            return;
        }
        dl.setModified(true);
        StudySystemGlyph glyph = (StudySystemGlyph)this._frame.getMapPanel().findGlyphOfClass(StudySystemGlyph.class.getName());
        if (glyph != null) {
            glyph.clearSelection((NamedType)dobj);
        }
        if (dobj instanceof Project && (cdl = (ConditionDataList)ClientApp.Workspace().getDataListContainer().getDataList(Condition.class.getName())) != null) {
            cdl.deleteProject((Project)dobj);
        }
        this._frame.getMapPanel().paintMap();
    }

    public void modeOpening() {
        if (this.checkModePermission(3)) {
            this._frame.setNewWatershedMenuVisible(true);
        }
        if (this._alignment == null) {
            if (!this.openStreamAlignment(true)) {
                return;
            }
        } else if (!this._streamReadLocked && this._alignment.setLocked(3)) {
            this._streamReadLocked = true;
        }
        if (this._study == null) {
            this.openStudy(true);
        } else {
            Identifier id = this._study.getLockIdentifier();
            FileLock fLock = new FileLock(ClientApp.app().getUser(), 3);
            if (!this.lockStudy(this._study, "openStudy:Failed to lock Study", fLock)) {
                this._study = null;
                return;
            }
        }
        super.modeOpening();
    }

    public boolean switchModeOk() {
        return this.checkSaveConfiguration();
    }

    public void modeClosing() {
        this._frame.setNewWatershedMenuVisible(false);
        if (this._study != null) {
            Identifier id = this._study.getLockIdentifier();
            FileLock fLock = new FileLock(ClientApp.app().getUser(), 1);
            this.unlockStudy(this._study, "Failed to unlock Study", fLock);
        }
        if (this._alignment != null) {
            this._alignment.setLocked(1);
            this._streamReadLocked = false;
        }
        Vector v = RmaJDialog.getOpenWindows();
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            RmaJDialog dialog = (RmaJDialog)v.get(i);
            if (dialog == null || !dialog.isVisible()) continue;
            if (dialog.isModified() && dialog instanceof ClosableDialog) {
                ((ClosableDialog)dialog).closeDialog();
                continue;
            }
            if (!dialog.isSystemClosable()) continue;
            dialog.setVisible(false);
        }
        v = RmaJFrame.getOpenWindows();
        size = v.size();
        for (int i = 0; i < size; ++i) {
            RmaJFrame frame = (RmaJFrame)v.get(i);
            if (frame == null || !frame.isVisible() || !frame.isSystemClosable()) continue;
            frame.setVisible(false);
        }
        this._projectEditors.clear();
        this._ple = null;
        this._conditionEditor = null;
        this._iale = null;
        this._cne = null;
        this._iae = null;
        this._notesDialog = null;
        this._cpr = null;
        this._dataDialog = null;
        this._streamEditor = null;
        this._compPtEditor = null;
    }

    public void renameObject(String title, DataObject dobj) {
        String newName;
        if (dobj == null) {
            return;
        }
        int index = -1;
        if (title != null && (index = title.indexOf("...")) >= 0) {
            title = title.substring(0, index).trim();
        }
        hec.gui.RenameDlg dlg = new hec.gui.RenameDlg((Frame)this._frame, title, true);
        boolean found = false;
        do {
            dlg.setName(dobj.getName());
            dlg.setDescription(dobj.getDescription());
            dlg.setFileNameVisible(false);
            dlg.setVisible(true);
            this._frame.getMapPanel().paintMap();
            if (dlg.getCanceled()) {
                return;
            }
            newName = dlg.getName();
            DataObject existingObj = dobj.getDataList().getObject(newName);
            if (existingObj != null && existingObj != dobj) {
                JOptionPane.showMessageDialog((Component)this._frame, "Element " + newName + " already exists.\nPlease enter a different name", "Duplicate Name", 1);
                found = true;
                continue;
            }
            found = false;
        } while (found);
        newName = dlg.getName();
        dobj.setName(newName);
        dobj.setDescription(dlg.getDescription());
        this._frame.getMapPanel().paintMap();
    }

    public void editStreamConfiguration() {
        boolean selected = this._editStreamsMenuItem.isSelected();
        this.lockStreamConfiguration(selected);
    }

    public boolean lockStreamConfiguration(boolean lockit) {
        return true;
    }

    public void editConfiguration(boolean lockit) {
        if (HecSecurityManager.getSecurityManager().checkPermission("watershedConfigModule", "configure") != 4) {
            return;
        }
        if (this._editConfigMenuItem.isSelected() != lockit) {
            this._editConfigMenuItem.doClick();
        }
    }

    public void editConfiguration() {
        boolean selected = this._editConfigMenuItem.isSelected();
        this.lockConfiguration(selected);
        if (this._editStreamsMenuItem.isSelected() != selected) {
            this._editStreamsMenuItem.doClick();
        }
    }

    public boolean lockConfiguration(boolean lockit) {
        return true;
    }

    protected boolean checkSaveConfiguration() {
        if (this.isConfigurationModified()) {
            this._frame.setAlwaysOnTop(true);
            int opt = 1;
            try {
                opt = JOptionPane.showConfirmDialog((Component)this._frame, "Configuration has changed. Save Changes?", "Save", 1);
            }
            finally {
                this._frame.setAlwaysOnTop(false);
            }
            if (opt == 0) {
                this.saveConfiguration();
            } else if (opt == 1) {
                this.reloadConfiguration();
            } else {
                return false;
            }
        }
        return true;
    }

    boolean isConfigurationModified() {
        DataList dl;
        if (ClientApp.Workspace() == null) {
            return false;
        }
        if (this._study != null && this._study.isModified()) {
            System.out.println("isConfigurationModified: Study");
            return true;
        }
        DataListContainer dlc = ClientApp.Workspace().getDataListContainer();
        for (int i = 0; i < Project.KNOWN_PROJECT_TYPES.length; ++i) {
            dl = dlc.getDataList(Project.KNOWN_PROJECT_TYPES[i]);
            if (dl == null || !dl.isModified()) continue;
            System.out.println("isConfigurationModified: " + Project.KNOWN_PROJECT_TYPES[i]);
            return true;
        }
        dl = dlc.getDataList(Condition.class.getName());
        if (dl != null && dl.isModified()) {
            System.out.println("isConfigurationModified: Condition");
            return true;
        }
        dl = dlc.getDataList(ImpactArea.class.getName());
        if (dl != null && dl.isModified()) {
            System.out.println("isConfigurationModified: ImpactArea");
            return true;
        }
        dl = dlc.getDataList(ComputationPoint.class.getName());
        if (dl != null && dl.isModified()) {
            System.out.println("isConfigurationModified:  ComputationPoint");
            return true;
        }
        return this._alignment != null && this._alignment.isModified();
    }

    void reloadConfiguration() {
        DataList dl;
        DataListContainer dlc = ClientApp.Workspace().getDataListContainer();
        String user = ClientApp.app().getUser();
        for (int i = 0; i < Project.KNOWN_PROJECT_TYPES.length; ++i) {
            dl = dlc.getDataList(Project.KNOWN_PROJECT_TYPES[i]);
            if (dl != null) {
                System.out.println("reloadConfiguration: reloading " + Project.KNOWN_PROJECT_TYPES[i]);
                dl.reload(user);
                continue;
            }
            System.out.println("reloadConfiguration: failed to find DataList for " + Project.KNOWN_PROJECT_TYPES[i]);
        }
        dl = dlc.getDataList(Condition.class.getName());
        if (dl != null) {
            dl.reload(user);
        }
        if ((dl = dlc.getDataList(ImpactArea.class.getName())) != null) {
            dl.reload(user);
        }
        if ((dl = dlc.getDataList(ComputationPoint.class.getName())) != null) {
            dl.reload(user);
        }
        if ((dl = dlc.getDataList(StationSet.class.getName())) != null) {
            dl.reload(user);
        }
        if ((dl = dlc.getDataList(Study.class.getName())) != null) {
            dl.reload(user);
        }
        this.initStudy();
    }

    void initStudy() {
        DataListContainer dlc = ClientApp.Workspace().getDataListContainer();
        dlc.getDataList(Study.class.getName());
        StudySystemGlyph glyph = (StudySystemGlyph)this._frame.getMapPanel().findGlyphOfClass(StudySystemGlyph.class.getName());
        if (glyph != null) {
            glyph.clearSelection();
        }
        this.resetConditionList(true);
        this._frame.getMapPanel().paintMap();
        this._frame.getMapPanel().waitforPaintComplete();
    }

    public void saveConfiguration() {
        if (ClientApp.Workspace() == null) {
            return;
        }
        DataListContainer dlc = ClientApp.Workspace().getDataListContainer();
        String user = ClientApp.app().getUser();
        DataList dl = dlc.getDataList(Study.class.getName());
        if (dl != null) {
            dl.saveAll(user);
        }
        if ((dl = dlc.getDataList(ComputationPoint.class.getName())) != null) {
            dl.saveAll(user);
        }
        for (int i = 0; i < Project.KNOWN_PROJECT_TYPES.length; ++i) {
            dl = dlc.getDataList(Project.KNOWN_PROJECT_TYPES[i]);
            if (dl == null) continue;
            dl.saveAll(user);
        }
        dl = dlc.getDataList(Condition.class.getName());
        if (dl != null) {
            dl.saveAll(user);
        }
        if ((dl = dlc.getDataList(ImpactArea.class.getName())) != null) {
            dl.saveAll(user);
        }
        if (this._alignment != null && this._alignment.isModified() && this._streamLockButton.isSelected()) {
            ClientApp.Workspace().saveManager((Manager)this._alignment);
        }
    }

    private boolean lockStudy(Study study, String errString, FileLock fLock) {
        RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        if (study == null) {
            return false;
        }
        if (this._studyReadLocked && fLock.getLockType() == 3) {
            return true;
        }
        try {
            Identifier id = study.getLockIdentifier();
            boolean b = fm.lockFile(id, fLock);
            if (!b) {
                System.out.println(errString + study.getName());
                this._editConfigMenuItem.setSelected(false);
                int opt = JOptionPane.showOptionDialog((Component)this._frame, errString + study.getName(), "Lock Failed", 0, 2, null, new Object[]{"OK", "More Info"}, "OK");
                if (opt == 0) {
                    return false;
                }
                FileLockInfoJDialog dialog = new FileLockInfoJDialog((Frame)this._frame);
                dialog.setFileManager((RmiFileManager)ClientApp.app().getFileManager().getRemote());
                dialog.setUserId(ClientApp.app().getUser());
                Vector v = null;
                try {
                    v = fm.getLockers(id);
                }
                catch (RemoteException re) {
                    System.out.println("Failed to get Lock info for Study " + re);
                }
                dialog.fillForm(id, v);
                dialog.pack();
                dialog.setVisible(true);
                return false;
            }
            if (fLock.getLockType() == 3) {
                this._studyReadLocked = true;
            }
            if (fLock.getLockType() == 4) {
                this._studyCallBack = this.setCallback(study);
            }
            return true;
        }
        catch (RemoteException re) {
            System.out.println("RMI Error with FileManager locking Study " + re);
            this._editConfigMenuItem.setSelected(false);
            return false;
        }
    }

    private boolean unlockStudy(Study study, String errString, FileLock fLock) {
        if (study == null) {
            return false;
        }
        RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        try {
            Identifier id = study.getLockIdentifier();
            if (!fm.unlockFile(id, fLock)) {
                System.out.println(errString + study.getName());
                this._editConfigMenuItem.setSelected(true);
                return false;
            }
            this.removeCallback(this._studyCallBack, id);
            if (fLock.getLockType() == 1 || fLock.getLockType() == 2) {
                this._studyReadLocked = false;
            }
            return true;
        }
        catch (RemoteException re) {
            System.out.println("RMI Error with FileManager unlocking " + study.getName() + " " + re);
            this._editConfigMenuItem.setSelected(true);
            return false;
        }
    }

    private RmiFileCallBackImpl setCallback(Study study) {
        Identifier id = study.getLockIdentifier();
        if (id == null || id.getFile() == null) {
            return null;
        }
        HecFile file = id.getFile();
        if (file instanceof HecFileImpl) {
            RmiFileCallBackImpl callBack;
            System.out.println("setCallback: adding callback for " + id.getPath());
            try {
                callBack = new RmiFileCallBackImpl((CallBackInterface)this);
            }
            catch (RemoteException e) {
                System.out.println("Error creating callback exception: " + e);
                e.printStackTrace();
                return null;
            }
            ((HecFileImpl)file).setCallBack(callBack.getRemoteReference());
            return callBack;
        }
        return null;
    }

    public void notify(String msg) {
        if (!this._editConfigMenuItem.isSelected() && !this._editStreamsMenuItem.isSelected()) {
            return;
        }
        System.out.println("WatershedConfigMode.notify:" + msg);
        StringTokenizer tokenizer = new StringTokenizer(msg, "|");
        if (tokenizer.countTokens() < 3) {
            return;
        }
        String fileName = tokenizer.nextToken().replace('\\', '/');
        String cmd = tokenizer.nextToken();
        final String userId = tokenizer.nextToken();
        if (!cmd.equalsIgnoreCase("Unlocked") || userId.equals(ClientApp.app().getUser())) {
            return;
        }
        System.out.println(fileName + " " + cmd + " " + userId);
        Runnable run = null;
        if (this._study != null && this._study.getLockIdentifier().getPath().replace('\\', '/').equals(fileName)) {
            System.out.println("Configuration has been unlocked");
            run = new Runnable(){

                @Override
                public void run() {
                    WatershedConfigMode.this._editConfigMenuItem.setSelected(false);
                    JOptionPane.showMessageDialog((Component)WatershedConfigMode.this._frame, "Study Configuration has been unlocked by (" + userId + ")", "Warning", 2);
                    WatershedConfigMode.this.updateGUIState(false);
                }
            };
        } else if (this._alignment != null && this._alignment.getIdentifier().getPath().replace('\\', '/').equals(fileName)) {
            System.out.println("Stream Alignment unlocked");
            run = new Runnable(){

                @Override
                public void run() {
                    WatershedConfigMode.this._editStreamsMenuItem.setSelected(false);
                    JOptionPane.showMessageDialog((Component)WatershedConfigMode.this._frame, "Stream Configuration has been unlocked by (" + userId + ")", "Warning", 2);
                    WatershedConfigMode.this.updateGUIState(false);
                }
            };
        }
        if (run != null) {
            SwingUtilities.invokeLater(run);
        }
    }

    public void updateGUIState(boolean editable) {
        this.checkEditor((Window)((Object)this._ple), editable);
        this.checkEditor((Window)((Object)this._conditionEditor), editable);
        this.checkEditor((Window)((Object)this._iale), editable);
        this.checkEditor((Window)((Object)this._cne), editable);
        this.checkEditor((Window)((Object)this._iae), editable);
        this.checkEditor((Window)((Object)this._notesDialog), editable);
        this.checkEditor((Window)((Object)this._dataDialog), editable);
        this.checkEditor((Window)this._streamEditor, editable);
        this.checkEditor((Window)((Object)this._compPtEditor), editable);
        Enumeration e = this._projectEditors.elements();
        while (e.hasMoreElements()) {
            this.checkEditor((Window)((RmaJDialog)e.nextElement()), editable);
        }
        if (this._updateCompPtMenuItem != null) {
            this._updateCompPtMenuItem.setEnabled(editable);
        }
        this._saveConfigurationMenuItem.setEnabled(editable);
    }

    public void checkEditor(Window dialog, boolean editable) {
        if (dialog != null && dialog.isVisible()) {
            if (dialog instanceof RmaJFrame) {
                ((RmaJFrame)dialog).setEditable(editable);
            } else if (dialog instanceof RmaJDialog) {
                ((RmaJDialog)dialog).setEditable(editable);
            }
        }
    }

    public boolean hasWriteLock(MapGlyph g) {
        if (g == null) {
            return false;
        }
        if (g instanceof StreamAlignmentGlyph) {
            return this._editStreamsMenuItem.isSelected();
        }
        if (g instanceof StudySystemGlyph) {
            return this._editConfigMenuItem.isSelected();
        }
        return false;
    }

    public boolean workspaceClosing() {
        super.workspaceClosing();
        this._ccpLayersMenu.removeAll();
        if (this.switchModeOk()) {
            this.modeClosing();
            if (this._conditioncombo.getItemCount() > 0) {
                this._conditioncombo.removeAllItems();
            }
            return true;
        }
        return false;
    }

    public boolean canOpen() {
        ClientWorkspace wksp = ClientApp.Workspace();
        if (wksp == null) {
            return true;
        }
        if (this._alignment == null) {
            return false;
        }
        if (!this._streamReadLocked) {
            if (!this._alignment.setLocked(3)) {
                JOptionPane.showMessageDialog((Component)this._frame, "Unable to display Stream Alignment.\nCurrently being edited.");
                wksp.unloadManager("main", this._alignment.getIdentifier());
                return false;
            }
            this._streamReadLocked = true;
        }
        if (this._study == null) {
            this.openStudy(true);
        } else {
            Identifier id = this._study.getLockIdentifier();
            FileLock fLock = new FileLock(ClientApp.app().getUser(), 3);
            if (!this.lockStudy(this._study, "openStudy:Failed to lock Study", fLock)) {
                this._study = null;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openStreamAlignment(boolean lockit) {
        ClientWorkspace wksp = ClientApp.Workspace();
        if (wksp == null) {
            return false;
        }
        Vector idlist = wksp.getManagerIDList(StreamAlignment.class.getName());
        if (idlist.size() <= 0) {
            this._alignment = (StreamAlignment)wksp.newManager(StreamAlignment.class.getName());
            this._alignment.setName("Stream Alignment");
            Identifier id = this._alignment.getIdentifier();
            id.setName("Stream Alignment");
            id.setPath(wksp.getWorkspacePath() + "/stream.align");
            try {
                RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
                if (fm.fileExists(id.getPath())) {
                    System.out.println("found existing stream.align file.  reading...");
                    Identifier newId = fm.openFile(ClientApp.app().getUser(), id);
                    if (newId != null) {
                        this._alignment.readFile(newId);
                    }
                }
            }
            catch (RemoteException re) {
                System.out.println("openStreamAlignment: error reading stream.align file " + re);
            }
            wksp.saveManager((Manager)this._alignment);
        } else {
            Identifier id = (Identifier)idlist.elementAt(0);
            if (id != null) {
                this._alignment = (StreamAlignment)wksp.openManager(id);
                if (this._alignment == null) {
                    this._frame.setAlwaysOnTop(true);
                    try {
                        JOptionPane.showMessageDialog((Component)this._frame, "Failed to Open Stream Alignment");
                    }
                    finally {
                        this._frame.setAlwaysOnTop(false);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private void openStudy(boolean lockit) {
        ClientWorkspace wksp = ClientApp.Workspace();
        if (wksp == null) {
            return;
        }
        StudyDataList sdl = (StudyDataList)wksp.getDataListContainer().getDataList(Study.class.getName());
        if (sdl != null) {
            this._study = (Study)sdl.getOpenStudy();
            sdl.addDataListListener(this);
        } else {
            System.out.println("openStudy: Failed to find StudyDataList");
        }
        if (this._study == null) {
            return;
        }
        if (lockit) {
            Identifier id = this._study.getLockIdentifier();
            FileLock fLock = new FileLock(ClientApp.app().getUser(), 3);
            if (!this.lockStudy(this._study, "openStudy:Failed to lock Study", fLock)) {
                this._study = null;
                return;
            }
        }
        this.resetConditionList(false);
        this._conditionList = (ConditionDataList)wksp.getDataListContainer().getDataList(Condition.class.getName());
        if (this._conditionList != null) {
            Object[] objs = this._conditionList.getObjects();
            this._conditioncombo.removeItemListener((ItemListener)this._conditionComboListener);
            this._conditioncombo.setModel((ComboBoxModel)new RmaListModel(true, objs));
            if (this._conditioncombo.getItemCount() > 0) {
                this._conditioncombo.setSelectedIndex(0);
            }
            this._conditioncombo.addItemListener((ItemListener)this._conditionComboListener);
            this._conditionList.setCurrentCondition((Condition)this._conditioncombo.getSelectedItem());
        }
    }

    void resetConditionList(boolean restoreSelection) {
        Object obj;
        ClientWorkspace wksp = ClientApp.Workspace();
        this._conditionList = (ConditionDataList)wksp.getDataListContainer().getDataList(Condition.class.getName());
        this._conditionList.removeDataListListener(this);
        this._conditionList.addDataListListener(this);
        String name = null;
        if (restoreSelection && (obj = this._conditioncombo.getSelectedItem()) != null) {
            name = obj.toString();
        }
        if (this._conditionList != null) {
            Condition c;
            this._conditionList.init(this._study);
            Object[] objs = this._conditionList.getObjects();
            this._conditioncombo.setModel((ComboBoxModel)new RmaListModel(true, objs));
            if (name != null && (c = (Condition)this._conditionList.getObject(name)) != null) {
                this._conditioncombo.setSelectedItem((Object)c);
            }
            this._conditionList.setCurrentCondition((Condition)this._conditioncombo.getSelectedItem());
        }
    }

    public void programOrder() {
        ProgramOrderJDialog pod = new ProgramOrderJDialog((Frame)this._frame, true);
        try {
            SupplementalRmiWorkspace smWksp = (SupplementalRmiWorkspace)ClientApp.Workspace().getChildWorkspace("supplemental");
            if (smWksp != null) {
                Vector modelOrder = smWksp.getOrderedModels(ClientApp.app().getAppType());
                pod.fillForm(modelOrder);
            }
        }
        catch (RemoteException re) {
            System.out.println("programOrder: failed to get model execution order from Suppplemental RmiWorkspace " + re);
        }
        pod.setVisible(true);
        this.fillModelAltMenu();
    }

    String getConfigToolTipText(String baseString) {
        StringBuffer buf = new StringBuffer("<html>");
        buf.append(baseString);
        buf.append("<BR>");
        buf.append("Config: " + (this._editConfigMenuItem.isSelected() ? "Locked" : "Unlocked"));
        buf.append("<BR>");
        buf.append("Icons : " + (this._tsLocationCallback[0] != null ? "Locked" : "Unlocked"));
        buf.append("<BR>");
        if (this._streamLockButton != null) {
            buf.append("Stream Alignment: " + (this._streamLockButton.isSelected() ? "Locked" : "Unlocked"));
        }
        buf.append("</html>");
        return buf.toString();
    }

    public void dataListChanged(DataListEvent event) {
        System.out.println("dataListChanged: " + event);
        if (event.getDataList() == this._conditionList) {
            if (event.getType() == 4) {
                this.resetConditionList(true);
                this._frame.getMapPanel().paintMap();
                this._frame.getMapPanel().waitforPaintComplete();
            }
        } else if (event.getType() == 4) {
            this.initStudy();
        }
    }

    protected boolean allowProgramSetup() {
        return false;
    }

    protected void fillModelAltMenu() {
    }

    public void editScriptList() {
    }

    public void editCompPtLayersAction() {
        if (this._ccpLayerEditor != null && this._ccpLayerEditor.isVisible()) {
            this._ccpLayerEditor.requestFocusInWindow();
            return;
        }
        DataList dataList = ClientApp.Workspace().getDataListContainer().getDataList(ComputationPointLayer.class.getName());
        this._ccpLayerEditor = new CompPtLayerEditor((Frame)this._frame, true);
        boolean locked = this._editConfigMenuItem.isSelected();
        this._ccpLayerEditor.setEditable(locked);
        this._ccpLayerEditor.fillForm((CommonDataList)dataList);
        dataList.addDataListListener(new DataListListener(){

            public void dataListChanged(DataListEvent event) {
                WatershedConfigMode.this.resetComputationPointLayers();
            }
        });
        this._ccpLayerEditor.setVisible(true);
    }

    private class ConditionComboListener
    implements ItemListener {
        private ConditionComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                return;
            }
            StudySystemGlyph glyph = (StudySystemGlyph)WatershedConfigMode.this._frame.getMapPanel().findGlyphOfClass(StudySystemGlyph.class.getName());
            if (glyph != null) {
                glyph.clearSelection();
            }
            WatershedConfigMode.this._frame.getMapPanel().paintMap();
            if (WatershedConfigMode.this._conditionList != null) {
                WatershedConfigMode.this._conditionList.setCurrentCondition((Condition)WatershedConfigMode.this._conditioncombo.getSelectedItem());
            }
        }
    }

    private class EditStationAction
    extends AbstractAction {
        private final Station station;

        public EditStationAction(Station station) {
            this.station = station;
            boolean locked = WatershedConfigMode.this._editConfigMenuItem.isSelected();
            this.putValue("Name", (locked ? "Edit" : "View") + " Station...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    WatershedConfigMode.this.editStation(EditStationAction.this.station);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    private class RenameStationAction
    extends AbstractAction {
        private final Station station;

        public RenameStationAction(Station station) {
            this.station = station;
            this.putValue("Name", "Rename Station...");
            boolean locked = WatershedConfigMode.this._editConfigMenuItem.isSelected();
            this.setEnabled(locked);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    WatershedConfigMode.this.renameStation(RenameStationAction.this.station);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    public class DeleteStationAction
    extends AbstractAction {
        private final Station station;

        public DeleteStationAction(Station station) {
            this.station = station;
            this.putValue("Name", "Delete Station");
            boolean locked = WatershedConfigMode.this._editConfigMenuItem.isSelected();
            this.setEnabled(locked);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    WatershedConfigMode.this.deleteStation(DeleteStationAction.this.station);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }
}

