/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.watershed.client.WatershedInfoPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTabbedPane;

public class WatershedDataEditor
extends RmaJDialog {
    ButtonCmdPanel cmdPanel;
    RmaJTabbedPane tabbedPane;
    WatershedInfoPanel watershedInfoTab;
    Color _cbDisabledColor;
    private JPanel _accessoriesPanel;
    private boolean _accessoryPanelAdded;
    private List<DefaultJPanel> _accPanels = new ArrayList<DefaultJPanel>();

    public WatershedDataEditor(Frame parent, boolean modal) {
        super(parent, modal);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(400, 300);
        this.setTitle("Watershed Data Editor");
        this.setLocation();
        this.watershedInfoTab = new WatershedInfoPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 1.0;
        gbc.weighty = 2.0;
        this.getContentPane().add((Component)((Object)this.watershedInfoTab), gbc);
        this._accessoriesPanel = new JPanel(new GridBagLayout());
        this.cmdPanel = new ButtonCmdPanel(14);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        WatershedDataEditor.this.saveForm();
                        WatershedDataEditor.this.setVisible(false);
                        break;
                    }
                    case 2: {
                        WatershedDataEditor.this.saveForm();
                        break;
                    }
                    case 4: {
                        WatershedDataEditor.this.windowClosing();
                        WatershedDataEditor.this.setVisible(false);
                    }
                }
            }
        });
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WatershedDataEditor.this.windowClosing();
            }
        });
        this.pack();
        Dimension d = this.getSize();
        this.setDefaultSize(d.width, d.height);
    }

    protected void buildMenus() {
        JMenuBar mb = new JMenuBar();
        JMenu menu = new JMenu("Watershed");
        menu.setMnemonic('w');
        mb.add(menu);
        JMenuItem menuitem = new JMenuItem("Close", 99);
        menuitem.setAccelerator(KeyStroke.getKeyStroke(87, 2, false));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WatershedDataEditor.this.windowClosing();
                WatershedDataEditor.this.setVisible(false);
            }
        });
        menu.add(menuitem);
        this.setJMenuBar(mb);
    }

    public void addAccessoryPanel(DefaultJPanel accessoryPanel) {
        if (accessoryPanel == null) {
            return;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        if (!this._accessoryPanelAdded) {
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.insets = RmaInsets.INSETS0000;
            this.getContentPane().add((Component)this._accessoriesPanel, gbc);
            this._accessoryPanelAdded = true;
        }
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS0000;
        this._accessoriesPanel.add((Component)accessoryPanel, gbc);
        this._accPanels.add(accessoryPanel);
        this.pack();
        Dimension d = this.getSize();
        this.setDefaultSize(d.width, d.height);
    }

    public void fillForm() {
        this.watershedInfoTab.fillPanel();
        for (int i = 0; i < this._accPanels.size(); ++i) {
            this._accPanels.get(i).fillPanel();
        }
        this.setModified(false);
    }

    public void saveForm() {
        this.watershedInfoTab.savePanel();
        for (int i = 0; i < this._accPanels.size(); ++i) {
            this._accPanels.get(i).savePanel();
        }
        this.setModified(false);
    }

    public void windowClosing() {
        int opt;
        if (this.isModified() && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Data has changed. Save Changes?", "Confirm Changes", 0)) == 0) {
            this.saveForm();
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this._cbDisabledColor = UIManager.getColor("ComboBox.disabledForeground");
            UIManager.put("ComboBox.disabledForeground", Color.black);
        } else if (this._cbDisabledColor != null) {
            UIManager.put("ComboBox.disabledForeground", this._cbDisabledColor);
        }
        super.setVisible(b);
    }
}

